/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.utils.tictactoe;

import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u001b\u0018\u0000 >2\u00020\u0001:\u0002>?B\t\b\u0000\u00a2\u0006\u0004\b=\u0010\u000fJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0017\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\r\u0010\u0006J\u000f\u0010\u000e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0014J%\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u000fJ\u001b\u0010\u001b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u001a0\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR\"\u0010 \u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010\u0006R0\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020%8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R\"\u0010+\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u001a0\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0011\u0010/\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R$\u00100\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u00118\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b0\u00102R\u0016\u00103\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u0010!R\"\u00104\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b4\u00105\u001a\u0004\b6\u00107\"\u0004\b8\u00109R$\u0010:\u001a\u0004\u0018\u00010\u00158F@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u00105\u001a\u0004\b;\u00107\"\u0004\b<\u00109\u00a8\u0006@"}, d2={"Lgg/skytils/skytilsmod/utils/tictactoe/Board;", "", "", "column", "", "checkColumn", "(I)V", "x", "y", "checkDiagonalFromTopLeft", "(II)V", "checkDiagonalFromTopRight", "row", "checkRow", "initialize", "()V", "index", "", "move", "(I)Z", "(II)Z", "Lgg/skytils/skytilsmod/utils/tictactoe/Board$State;", "player", "place", "(IILgg/skytils/skytilsmod/utils/tictactoe/Board$State;)Z", "reset", "", "toArray", "()[[Lgg/skytils/skytilsmod/utils/tictactoe/Board$State;", "", "toString", "()Ljava/lang/String;", "algorithmBestMove", "I", "getAlgorithmBestMove", "()I", "setAlgorithmBestMove", "Ljava/util/HashSet;", "<set-?>", "availableMoves", "Ljava/util/HashSet;", "getAvailableMoves", "()Ljava/util/HashSet;", "board", "[[Lgg/skytils/skytilsmod/utils/tictactoe/Board$State;", "getDeepCopy", "()Lgg/skytils/skytilsmod/utils/tictactoe/Board;", "deepCopy", "isGameOver", "Z", "()Z", "moveCount", "turn", "Lgg/skytils/skytilsmod/utils/tictactoe/Board$State;", "getTurn", "()Lgg/skytils/skytilsmod/utils/tictactoe/Board$State;", "setTurn", "(Lgg/skytils/skytilsmod/utils/tictactoe/Board$State;)V", "winner", "getWinner", "setWinner", "<init>", "Companion", "State", "SkytilsMod"})
@SourceDebugExtension(value={"SMAP\nBoard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Board.kt\ngg/skytils/skytilsmod/utils/tictactoe/Board\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,294:1\n1#2:295\n*E\n"})
public final class Board {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final State[][] board;
    @NotNull
    private State turn;
    @Nullable
    private State winner;
    @NotNull
    private HashSet<Integer> availableMoves;
    private int moveCount;
    private boolean isGameOver;
    private int algorithmBestMove;
    public static final int BOARD_WIDTH = 3;

    public Board() {
        int n = 0;
        State[][] stateArrayArray = new State[3][];
        Board board = this;
        while (n < 3) {
            int n2 = n++;
            stateArrayArray[n2] = new State[3];
        }
        board.board = stateArrayArray;
        this.turn = State.X;
        this.algorithmBestMove = -1;
        this.availableMoves = new HashSet();
        this.reset();
    }

    @NotNull
    public final State getTurn() {
        return this.turn;
    }

    public final void setTurn(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.turn = state;
    }

    @Nullable
    public final State getWinner() {
        return this.winner;
    }

    public final void setWinner(@Nullable State state) {
        this.winner = state;
    }

    @NotNull
    public final HashSet<Integer> getAvailableMoves() {
        return this.availableMoves;
    }

    public final boolean isGameOver() {
        return this.isGameOver;
    }

    public final int getAlgorithmBestMove() {
        return this.algorithmBestMove;
    }

    public final void setAlgorithmBestMove(int n) {
        this.algorithmBestMove = n;
    }

    private final void initialize() {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.board[row][col] = State.Blank;
            }
        }
        this.availableMoves.clear();
        for (int i2 = 0; i2 < 9; ++i2) {
            this.availableMoves.add(i2);
        }
    }

    public final void reset() {
        this.moveCount = 0;
        this.isGameOver = false;
        this.turn = State.X;
        this.winner = State.Blank;
        this.initialize();
    }

    public final boolean move(int index) {
        return this.move(index % 3, index / 3);
    }

    public final boolean move(int x, int y) {
        if (!(!this.isGameOver)) {
            boolean bl = false;
            String string = "TicTacToe is over. No moves can be played.";
            throw new IllegalStateException(string.toString());
        }
        if (this.board[y][x] != State.Blank) {
            return false;
        }
        this.board[y][x] = this.turn;
        int n = this.moveCount;
        this.moveCount = n + 1;
        this.availableMoves.remove(y * 3 + x);
        if (this.moveCount == 9) {
            this.winner = State.Blank;
            this.isGameOver = true;
        }
        this.checkRow(y);
        this.checkColumn(x);
        this.checkDiagonalFromTopLeft(x, y);
        this.checkDiagonalFromTopRight(x, y);
        this.turn = this.turn == State.X ? State.O : State.X;
        return true;
    }

    public final boolean place(int x, int y, @NotNull State player) {
        Intrinsics.checkNotNullParameter((Object)((Object)player), (String)"player");
        if (!(!this.isGameOver)) {
            boolean bl = false;
            String string = "TicTacToe is over. No moves can be played.";
            throw new IllegalStateException(string.toString());
        }
        if (this.board[y][x] != State.Blank) {
            return false;
        }
        this.board[y][x] = player;
        int n = this.moveCount;
        this.moveCount = n + 1;
        this.availableMoves.remove(y * 3 + x);
        if (this.moveCount == 9) {
            this.winner = State.Blank;
            this.isGameOver = true;
        }
        this.checkRow(y);
        this.checkColumn(x);
        this.checkDiagonalFromTopLeft(x, y);
        this.checkDiagonalFromTopRight(x, y);
        this.turn = this.turn == State.X ? State.O : State.X;
        return true;
    }

    @NotNull
    public final State[][] toArray() {
        return (State[][])((Object[])this.board).clone();
    }

    private final void checkRow(int row) {
        for (int i2 = 1; i2 < 3 && this.board[row][i2] == this.board[row][i2 - 1]; ++i2) {
            if (i2 != 2) continue;
            this.winner = this.turn;
            this.isGameOver = true;
        }
    }

    private final void checkColumn(int column) {
        for (int i2 = 1; i2 < 3 && this.board[i2][column] == this.board[i2 - 1][column]; ++i2) {
            if (i2 != 2) continue;
            this.winner = this.turn;
            this.isGameOver = true;
        }
    }

    private final void checkDiagonalFromTopLeft(int x, int y) {
        if (x == y) {
            for (int i2 = 1; i2 < 3 && this.board[i2][i2] == this.board[i2 - 1][i2 - 1]; ++i2) {
                if (i2 != 2) continue;
                this.winner = this.turn;
                this.isGameOver = true;
            }
        }
    }

    private final void checkDiagonalFromTopRight(int x, int y) {
        if (2 - x == y) {
            for (int i2 = 1; i2 < 3 && this.board[2 - i2][i2] == this.board[3 - i2][i2 - 1]; ++i2) {
                if (i2 != 2) continue;
                this.winner = this.turn;
                this.isGameOver = true;
            }
        }
    }

    @NotNull
    public final Board getDeepCopy() {
        Board board = new Board();
        int n = ((Object[])board.board).length;
        for (int i2 = 0; i2 < n; ++i2) {
            board.board[i2] = this.board[i2].clone();
        }
        board.turn = this.turn;
        board.winner = this.getWinner();
        board.availableMoves = new HashSet();
        board.availableMoves.addAll((Collection<Integer>)this.availableMoves);
        board.moveCount = this.moveCount;
        board.isGameOver = this.isGameOver;
        return board;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                if (this.board[y][x] == State.Blank) {
                    sb.append("-");
                } else {
                    State state = this.board[y][x];
                    Intrinsics.checkNotNull((Object)((Object)state));
                    sb.append(state.name());
                }
                sb.append(" ");
            }
            if (y == 2) continue;
            sb.append("\n");
        }
        return new String(sb);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lgg/skytils/skytilsmod/utils/tictactoe/Board$Companion;", "", "", "BOARD_WIDTH", "I", "<init>", "()V", "SkytilsMod"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lgg/skytils/skytilsmod/utils/tictactoe/Board$State;", "", "<init>", "(Ljava/lang/String;I)V", "Blank", "X", "O", "SkytilsMod"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State Blank = new State();
        public static final /* enum */ State X = new State();
        public static final /* enum */ State O = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.Blank, State.X, State.O};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

