/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.vigilance.impl.nightconfig.core.file;

import gg.skytils.vigilance.impl.nightconfig.core.CommentedConfig;
import gg.skytils.vigilance.impl.nightconfig.core.ConfigFormat;
import gg.skytils.vigilance.impl.nightconfig.core.file.CheckedCommentedFileConfig;
import gg.skytils.vigilance.impl.nightconfig.core.file.CommentedFileConfigBuilder;
import gg.skytils.vigilance.impl.nightconfig.core.file.FileConfig;
import gg.skytils.vigilance.impl.nightconfig.core.file.FormatDetector;
import gg.skytils.vigilance.impl.nightconfig.core.file.NoFormatFoundException;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public interface CommentedFileConfig
extends CommentedConfig,
FileConfig {
    @Override
    default public CommentedFileConfig checked() {
        return new CheckedCommentedFileConfig(this);
    }

    public static CommentedFileConfig of(File file2) {
        return CommentedFileConfig.of(file2.toPath());
    }

    public static CommentedFileConfig of(File file2, ConfigFormat<? extends CommentedConfig> format) {
        return CommentedFileConfig.of(file2.toPath(), format);
    }

    public static CommentedFileConfig of(Path file2) {
        ConfigFormat<?> format = FormatDetector.detect(file2);
        if (format == null || !format.supportsComments()) {
            throw new NoFormatFoundException("No suitable format for " + file2.getFileName());
        }
        return CommentedFileConfig.of(file2, format);
    }

    public static CommentedFileConfig of(Path file2, ConfigFormat<? extends CommentedConfig> format) {
        return (CommentedFileConfig)CommentedFileConfig.builder(file2, format).build();
    }

    public static CommentedFileConfig of(String filePath) {
        return CommentedFileConfig.of(Paths.get(filePath, new String[0]));
    }

    public static CommentedFileConfig of(String filePath, ConfigFormat<? extends CommentedConfig> format) {
        return CommentedFileConfig.of(Paths.get(filePath, new String[0]), format);
    }

    public static CommentedFileConfig ofConcurrent(File file2) {
        return CommentedFileConfig.ofConcurrent(file2.toPath());
    }

    public static CommentedFileConfig ofConcurrent(File file2, ConfigFormat<? extends CommentedConfig> format) {
        return CommentedFileConfig.ofConcurrent(file2.toPath(), format);
    }

    public static CommentedFileConfig ofConcurrent(Path file2) {
        return (CommentedFileConfig)CommentedFileConfig.builder(file2).concurrent().build();
    }

    public static CommentedFileConfig ofConcurrent(Path file2, ConfigFormat<? extends CommentedConfig> format) {
        return (CommentedFileConfig)CommentedFileConfig.builder(file2, format).concurrent().build();
    }

    public static CommentedFileConfig ofConcurrent(String filePath, ConfigFormat<? extends CommentedConfig> format) {
        return CommentedFileConfig.ofConcurrent(Paths.get(filePath, new String[0]), format);
    }

    public static CommentedFileConfig ofConcurrent(String filePath) {
        return CommentedFileConfig.ofConcurrent(Paths.get(filePath, new String[0]));
    }

    public static CommentedFileConfigBuilder builder(File file2, ConfigFormat<? extends CommentedConfig> format) {
        return CommentedFileConfig.builder(file2.toPath(), format);
    }

    public static CommentedFileConfigBuilder builder(File file2) {
        return CommentedFileConfig.builder(file2.toPath());
    }

    public static CommentedFileConfigBuilder builder(Path file2, ConfigFormat<? extends CommentedConfig> format) {
        return new CommentedFileConfigBuilder(file2, format);
    }

    public static CommentedFileConfigBuilder builder(Path file2) {
        ConfigFormat<?> format = FormatDetector.detect(file2);
        if (format == null) {
            throw new NoFormatFoundException("No suitable format for " + file2.getFileName());
        }
        if (!format.supportsComments()) {
            throw new NoFormatFoundException("The available format doesn't support comments for " + file2.getFileName());
        }
        return CommentedFileConfig.builder(file2, format);
    }

    public static CommentedFileConfigBuilder builder(String filePath) {
        return CommentedFileConfig.builder(Paths.get(filePath, new String[0]));
    }

    public static CommentedFileConfigBuilder builder(String filePath, ConfigFormat<? extends CommentedConfig> format) {
        return CommentedFileConfig.builder(Paths.get(filePath, new String[0]), format);
    }
}

