/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.vigilance.impl.nightconfig.core.io;

import gg.skytils.vigilance.impl.nightconfig.core.Config;
import gg.skytils.vigilance.impl.nightconfig.core.ConfigFormat;
import gg.skytils.vigilance.impl.nightconfig.core.file.FileNotFoundAction;
import gg.skytils.vigilance.impl.nightconfig.core.io.ParsingMode;
import gg.skytils.vigilance.impl.nightconfig.core.io.WritingException;
import gg.skytils.vigilance.impl.nightconfig.core.utils.FastStringReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public interface ConfigParser<C extends Config> {
    public ConfigFormat<C> getFormat();

    public C parse(Reader var1);

    public void parse(Reader var1, Config var2, ParsingMode var3);

    default public C parse(String input2) {
        return this.parse(new FastStringReader(input2));
    }

    default public void parse(String input2, Config destination, ParsingMode parsingMode) {
        this.parse(new StringReader(input2), destination, parsingMode);
    }

    default public C parse(InputStream input2) {
        return this.parse(input2, StandardCharsets.UTF_8);
    }

    default public C parse(InputStream input2, Charset charset) {
        return this.parse(new BufferedReader(new InputStreamReader(input2, charset)));
    }

    default public void parse(InputStream input2, Config destination, ParsingMode parsingMode) {
        this.parse(input2, destination, parsingMode, StandardCharsets.UTF_8);
    }

    default public void parse(InputStream input2, Config destination, ParsingMode parsingMode, Charset charset) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input2, charset));
        this.parse(reader, destination, parsingMode);
    }

    default public C parse(File file2, FileNotFoundAction nefAction) {
        return this.parse(file2, nefAction, StandardCharsets.UTF_8);
    }

    default public C parse(File file2, FileNotFoundAction nefAction, Charset charset) {
        return this.parse(file2.toPath(), nefAction, charset);
    }

    default public void parse(File file2, Config destination, ParsingMode parsingMode, FileNotFoundAction nefAction) {
        this.parse(file2, destination, parsingMode, nefAction, StandardCharsets.UTF_8);
    }

    default public void parse(File file2, Config destination, ParsingMode parsingMode, FileNotFoundAction nefAction, Charset charset) {
        this.parse(file2.toPath(), destination, parsingMode, nefAction, charset);
    }

    default public C parse(Path file2, FileNotFoundAction nefAction) {
        return this.parse(file2, nefAction, StandardCharsets.UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public C parse(Path file2, FileNotFoundAction nefAction, Charset charset) {
        try {
            if (Files.notExists(file2, new LinkOption[0]) && !nefAction.run(file2, this.getFormat())) {
                return this.getFormat().createConfig();
            }
            try (InputStream input2 = Files.newInputStream(file2, new OpenOption[0]);){
                C c = this.parse(input2, charset);
                return c;
            }
        }
        catch (IOException e) {
            throw new WritingException("An I/O error occured", e);
        }
    }

    default public void parse(Path file2, Config destination, ParsingMode parsingMode, FileNotFoundAction nefAction) {
        this.parse(file2, destination, parsingMode, nefAction, StandardCharsets.UTF_8);
    }

    default public void parse(Path file2, Config destination, ParsingMode parsingMode, FileNotFoundAction nefAction, Charset charset) {
        try {
            if (Files.notExists(file2, new LinkOption[0]) && !nefAction.run(file2, this.getFormat())) {
                return;
            }
            try (InputStream input2 = Files.newInputStream(file2, new OpenOption[0]);){
                this.parse(input2, destination, parsingMode, charset);
            }
        }
        catch (IOException e) {
            throw new WritingException("An I/O error occured", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public C parse(URL url2) {
        URLConnection connection;
        try {
            connection = url2.openConnection();
        }
        catch (IOException e) {
            throw new WritingException("Unable to connect to the URL", e);
        }
        String encoding = connection.getContentEncoding();
        Charset charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url2.openStream(), charset));){
            C c = this.parse(reader);
            return c;
        }
        catch (IOException e) {
            throw new WritingException("An I/O error occured", e);
        }
    }

    default public void parse(URL url2, Config destination, ParsingMode parsingMode) {
        URLConnection connection;
        try {
            connection = url2.openConnection();
        }
        catch (IOException e) {
            throw new WritingException("Unable to connect to the URL", e);
        }
        String encoding = connection.getContentEncoding();
        Charset charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url2.openStream(), charset));){
            this.parse(reader, destination, parsingMode);
        }
        catch (IOException e) {
            throw new WritingException("An I/O error occured", e);
        }
    }
}

