/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.vigilance.impl.nightconfig.core.utils;

import gg.skytils.vigilance.impl.nightconfig.core.utils.AbstractObserved;
import gg.skytils.vigilance.impl.nightconfig.core.utils.ObservedEntry;
import gg.skytils.vigilance.impl.nightconfig.core.utils.ObservedSet;
import gg.skytils.vigilance.impl.nightconfig.core.utils.TransformingSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class ObservedMap<K, V>
extends AbstractObserved
implements Map<K, V> {
    private final Map<K, V> map;

    public ObservedMap(Map<K, V> map2, Runnable callback) {
        super(callback);
        this.map = map2;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.map.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key2) {
        return this.map.get(key2);
    }

    @Override
    public V put(K key2, V value) {
        V result2 = this.map.put(key2, value);
        this.callback.run();
        return result2;
    }

    @Override
    public V remove(Object key2) {
        V result2 = this.map.remove(key2);
        this.callback.run();
        return result2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m4) {
        this.map.putAll(m4);
        this.callback.run();
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.map.replaceAll(function);
        this.callback.run();
    }

    @Override
    public V putIfAbsent(K key2, V value) {
        V result2 = this.map.putIfAbsent(key2, value);
        if (result2 != value) {
            this.callback.run();
        }
        return result2;
    }

    @Override
    public boolean remove(Object key2, Object value) {
        boolean removed2 = this.map.remove(key2, value);
        if (removed2) {
            this.callback.run();
        }
        return removed2;
    }

    @Override
    public boolean replace(K key2, V oldValue, V newValue) {
        boolean replaced = this.map.replace(key2, oldValue, newValue);
        if (replaced) {
            this.callback.run();
        }
        return replaced;
    }

    @Override
    public V replace(K key2, V value) {
        V result2 = this.map.replace(key2, value);
        if (result2 != value) {
            this.callback.run();
        }
        return result2;
    }

    @Override
    public V computeIfAbsent(K key2, Function<? super K, ? extends V> mappingFunction) {
        V result2 = this.map.computeIfAbsent((K)key2, mappingFunction);
        if (result2 != null) {
            this.callback.run();
        }
        return result2;
    }

    @Override
    public V computeIfPresent(K key2, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V result2 = this.map.computeIfPresent((K)key2, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
        this.callback.run();
        return result2;
    }

    @Override
    public V compute(K key2, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V result2 = this.map.compute((K)key2, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
        this.callback.run();
        return result2;
    }

    @Override
    public V merge(K key2, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V result2 = this.map.merge(key2, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
        this.callback.run();
        return result2;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.callback.run();
    }

    @Override
    public Set<K> keySet() {
        return new ObservedSet<K>(this.map.keySet(), this.callback);
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Function<Map.Entry, ObservedEntry> readT = e -> new ObservedEntry(e, this.callback);
        Function<ObservedEntry, Map.Entry> writeT = oe -> oe.entry;
        Function<Object, Object> searchT = o -> {
            if (o instanceof ObservedEntry) {
                ObservedEntry observedEntry = (ObservedEntry)o;
                return observedEntry.entry;
            }
            return o;
        };
        TransformingSet<Map.Entry, ObservedEntry> tset = new TransformingSet<Map.Entry, ObservedEntry>(this.map.entrySet(), readT, writeT, searchT);
        return new ObservedSet<Map.Entry<K, V>>(this.map.entrySet(), this.callback);
    }

    @Override
    public boolean equals(Object obj) {
        return this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

