/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.vigilance.impl.nightconfig.toml;

import gg.skytils.vigilance.impl.nightconfig.core.io.CharacterOutput;
import gg.skytils.vigilance.impl.nightconfig.toml.TomlWriter;
import gg.skytils.vigilance.impl.nightconfig.toml.ValueWriter;
import java.util.Iterator;
import java.util.List;

final class ArrayWriter {
    private static final char[] EMPTY_ARRAY = new char[]{'[', ']'};
    static final char[] ELEMENT_SEPARATOR = new char[]{',', ' '};

    static void write(List<?> values2, CharacterOutput output2, TomlWriter writer) {
        if (values2.isEmpty()) {
            output2.write(EMPTY_ARRAY);
            return;
        }
        output2.write('[');
        boolean indent = writer.writesIndented(values2);
        if (indent) {
            writer.increaseIndentLevel();
        }
        Iterator<?> iterator2 = values2.iterator();
        boolean hasNext = iterator2.hasNext();
        while (hasNext) {
            if (indent) {
                writer.writeNewline(output2);
                writer.writeIndent(output2);
            }
            Object value = iterator2.next();
            ValueWriter.write(value, output2, writer);
            hasNext = iterator2.hasNext();
            if (!hasNext) continue;
            if (indent) {
                output2.write(',');
                continue;
            }
            output2.write(ELEMENT_SEPARATOR);
        }
        if (indent) {
            writer.decreaseIndentLevel();
            writer.writeNewline(output2);
        }
        output2.write(']');
    }

    private ArrayWriter() {
    }
}

