/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.vigilance.impl.nightconfig.toml;

import gg.skytils.vigilance.impl.nightconfig.core.Config;
import gg.skytils.vigilance.impl.nightconfig.core.NullObject;
import gg.skytils.vigilance.impl.nightconfig.core.io.CharacterOutput;
import gg.skytils.vigilance.impl.nightconfig.core.io.WritingException;
import gg.skytils.vigilance.impl.nightconfig.toml.ArrayWriter;
import gg.skytils.vigilance.impl.nightconfig.toml.StringWriter;
import gg.skytils.vigilance.impl.nightconfig.toml.TableWriter;
import gg.skytils.vigilance.impl.nightconfig.toml.TemporalWriter;
import gg.skytils.vigilance.impl.nightconfig.toml.TomlWriter;
import java.time.temporal.Temporal;
import java.util.List;

final class ValueWriter {
    private static void writeString(String string, CharacterOutput output2, TomlWriter writer) {
        if (writer.writesLiteral(string)) {
            StringWriter.writeLiteral(string, output2);
        } else {
            StringWriter.writeBasic(string, output2);
        }
    }

    static void write(Object value, CharacterOutput output2, TomlWriter writer) {
        if (value instanceof Config) {
            TableWriter.writeInline((Config)value, output2, writer);
        } else if (value instanceof List) {
            List list = (List)value;
            if (!list.isEmpty() && list.get(0) instanceof Config) {
                for (Object table : list) {
                    TableWriter.writeInline((Config)table, output2, writer);
                }
            } else {
                ArrayWriter.write((List)value, output2, writer);
            }
        } else if (value instanceof CharSequence) {
            ValueWriter.writeString(value.toString(), output2, writer);
        } else if (value instanceof Enum) {
            ValueWriter.writeString(((Enum)value).name(), output2, writer);
        } else if (value instanceof Temporal) {
            TemporalWriter.write((Temporal)value, output2);
        } else if (value instanceof Float || value instanceof Double) {
            double d = ((Number)value).doubleValue();
            if (Double.isNaN(d)) {
                output2.write("nan");
            } else if (d == Double.POSITIVE_INFINITY) {
                output2.write("+inf");
            } else if (d == Double.NEGATIVE_INFINITY) {
                output2.write("-inf");
            } else {
                output2.write(value.toString());
            }
        } else if (value instanceof Number || value instanceof Boolean) {
            output2.write(value.toString());
        } else {
            if (value == null || value == NullObject.NULL_OBJECT) {
                throw new WritingException("TOML doesn't support null values");
            }
            throw new WritingException("Unsupported value type: " + value.getClass());
        }
    }

    private ValueWriter() {
    }
}

