/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg.sig;

import org.bouncycastle.bcpg.sig.PreferredAlgorithms;

public class PreferredAEADCiphersuites
extends PreferredAlgorithms {
    private final Combination[] algorithms;
    private static final Combination AES_128_OCB = new Combination(7, 2);

    public PreferredAEADCiphersuites(boolean bl, boolean bl2, byte[] byArray) {
        super(39, bl, bl2, PreferredAEADCiphersuites.requireEven(byArray));
        this.algorithms = PreferredAEADCiphersuites.parseCombinations(byArray);
    }

    public PreferredAEADCiphersuites(boolean bl, Combination[] combinationArray) {
        this(bl, false, PreferredAEADCiphersuites.encodeCombinations(combinationArray));
    }

    private static Combination[] parseCombinations(byte[] byArray) {
        Combination[] combinationArray = new Combination[byArray.length / 2];
        for (int j = 0; j < combinationArray.length; ++j) {
            combinationArray[j] = new Combination(byArray[j * 2], byArray[j * 2 + 1]);
        }
        return combinationArray;
    }

    private static byte[] encodeCombinations(Combination[] combinationArray) {
        byte[] byArray = new byte[combinationArray.length * 2];
        for (int j = 0; j < combinationArray.length; ++j) {
            Combination combination = combinationArray[j];
            byArray[j * 2] = (byte)(combination.getSymmetricAlgorithm() & 0xFF);
            byArray[j * 2 + 1] = (byte)(combination.getAeadAlgorithm() & 0xFF);
        }
        return byArray;
    }

    public boolean isSupported(Combination combination) {
        return PreferredAEADCiphersuites.contains(combination, this.getAlgorithms());
    }

    private static boolean contains(Combination combination, Combination[] combinationArray) {
        for (int j = 0; j != combinationArray.length; ++j) {
            Combination combination2 = combinationArray[j];
            if (!combination2.equals(combination)) continue;
            return true;
        }
        return false;
    }

    public Combination[] getRawAlgorithms() {
        Combination[] combinationArray = new Combination[this.algorithms.length];
        System.arraycopy(this.algorithms, 0, combinationArray, 0, this.algorithms.length);
        return combinationArray;
    }

    public Combination[] getAlgorithms() {
        if (!PreferredAEADCiphersuites.contains(AES_128_OCB, this.algorithms)) {
            Combination[] combinationArray = new Combination[this.algorithms.length + 1];
            System.arraycopy(this.algorithms, 0, combinationArray, 0, this.algorithms.length);
            combinationArray[this.algorithms.length] = AES_128_OCB;
            return combinationArray;
        }
        return this.getRawAlgorithms();
    }

    private static byte[] requireEven(byte[] byArray) {
        if (byArray.length % 2 != 0) {
            throw new IllegalArgumentException("Even number of bytes expected.");
        }
        return byArray;
    }

    public static class Combination {
        private final int symmetricAlgorithm;
        private final int aeadAlgorithm;

        public Combination(int n, int n2) {
            this.symmetricAlgorithm = n;
            this.aeadAlgorithm = n2;
        }

        public int getSymmetricAlgorithm() {
            return this.symmetricAlgorithm;
        }

        public int getAeadAlgorithm() {
            return this.aeadAlgorithm;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (!(object instanceof Combination)) {
                return false;
            }
            Combination combination = (Combination)object;
            return this.getSymmetricAlgorithm() == combination.getSymmetricAlgorithm() && this.getAeadAlgorithm() == combination.getAeadAlgorithm();
        }

        public int hashCode() {
            return 13 * this.getSymmetricAlgorithm() + 17 * this.getAeadAlgorithm();
        }
    }
}

