/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.bcpg.ArmoredInputException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserDataPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Iterable;
import org.bouncycastle.util.Longs;

public class PGPPublicKeyRing
extends PGPKeyRing
implements Iterable<PGPPublicKey> {
    private static final Logger LOG = Logger.getLogger(PGPPublicKeyRing.class.getName());
    List<PGPPublicKey> keys;

    public PGPPublicKeyRing(byte[] byArray, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException {
        this(new ByteArrayInputStream(byArray), keyFingerPrintCalculator);
    }

    private static List<PGPPublicKey> checkKeys(List<PGPPublicKey> list) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>(list.size());
        for (int j = 0; j != list.size(); ++j) {
            PGPPublicKey pGPPublicKey = list.get(j);
            if (j == 0) {
                if (!pGPPublicKey.isMasterKey()) {
                    throw new IllegalArgumentException("key 0 must be a master key");
                }
            } else if (pGPPublicKey.isMasterKey()) {
                throw new IllegalArgumentException("key 0 can be only master key");
            }
            arrayList.add(pGPPublicKey);
        }
        return arrayList;
    }

    public PGPPublicKeyRing(List<PGPPublicKey> list) {
        this.keys = PGPPublicKeyRing.checkKeys(list);
    }

    public PGPPublicKeyRing(InputStream inputStream2, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException {
        this.keys = new ArrayList<PGPPublicKey>();
        BCPGInputStream bCPGInputStream = BCPGInputStream.wrap(inputStream2);
        int n = bCPGInputStream.skipMarkerAndPaddingPackets();
        if (n != 6 && n != 14) {
            throw new IOException("public key ring doesn't start with public key tag: tag 0x" + Integer.toHexString(n));
        }
        PublicKeyPacket publicKeyPacket = PGPPublicKeyRing.readPublicKeyPacket(bCPGInputStream);
        TrustPacket trustPacket = PGPPublicKeyRing.readOptionalTrustPacket(bCPGInputStream);
        List<PGPSignature> list = PGPPublicKeyRing.readSignaturesAndTrust(bCPGInputStream);
        ArrayList<UserDataPacket> arrayList = new ArrayList<UserDataPacket>();
        ArrayList<TrustPacket> arrayList2 = new ArrayList<TrustPacket>();
        ArrayList<List<PGPSignature>> arrayList3 = new ArrayList<List<PGPSignature>>();
        PGPPublicKeyRing.readUserIDs(bCPGInputStream, arrayList, arrayList2, arrayList3);
        try {
            this.keys.add(new PGPPublicKey(publicKeyPacket, trustPacket, list, arrayList, arrayList2, arrayList3, keyFingerPrintCalculator));
            while (bCPGInputStream.nextPacketTag() == 14) {
                PGPPublicKey pGPPublicKey = PGPPublicKeyRing.readSubkey(bCPGInputStream, keyFingerPrintCalculator);
                if (pGPPublicKey == null) continue;
                this.keys.add(pGPPublicKey);
            }
        }
        catch (PGPException pGPException) {
            throw new IOException("processing exception: " + pGPException.toString());
        }
    }

    @Override
    public PGPPublicKey getPublicKey() {
        return this.keys.get(0);
    }

    @Override
    public PGPPublicKey getPublicKey(long l) {
        for (int j = 0; j != this.keys.size(); ++j) {
            PGPPublicKey pGPPublicKey = this.keys.get(j);
            if (l != pGPPublicKey.getKeyID()) continue;
            return pGPPublicKey;
        }
        return null;
    }

    @Override
    public PGPPublicKey getPublicKey(byte[] byArray) {
        for (int j = 0; j != this.keys.size(); ++j) {
            PGPPublicKey pGPPublicKey = this.keys.get(j);
            if (!Arrays.areEqual((byte[])byArray, (byte[])pGPPublicKey.getFingerprint())) continue;
            return pGPPublicKey;
        }
        return null;
    }

    @Override
    public Iterator<PGPPublicKey> getKeysWithSignaturesBy(long l) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        for (int j = 0; j != this.keys.size(); ++j) {
            PGPPublicKey pGPPublicKey = this.keys.get(j);
            Iterator<PGPSignature> iterator2 = pGPPublicKey.getSignaturesForKeyID(l);
            if (!iterator2.hasNext()) continue;
            arrayList.add(pGPPublicKey);
        }
        return arrayList.iterator();
    }

    @Override
    public Iterator<PGPPublicKey> getPublicKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public Iterator<PGPPublicKey> iterator() {
        return this.getPublicKeys();
    }

    @Override
    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getEncoded(boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream, bl);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public void encode(OutputStream outputStream2) throws IOException {
        this.encode(outputStream2, false);
    }

    public void encode(OutputStream outputStream2, boolean bl) throws IOException {
        for (int j = 0; j != this.keys.size(); ++j) {
            PGPPublicKey pGPPublicKey = this.keys.get(j);
            pGPPublicKey.encode(outputStream2, bl);
        }
    }

    public static PGPPublicKeyRing insertPublicKey(PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKey pGPPublicKey) {
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>(pGPPublicKeyRing.keys);
        boolean bl = false;
        boolean bl2 = false;
        for (int j = 0; j != arrayList.size(); ++j) {
            PGPPublicKey pGPPublicKey2 = (PGPPublicKey)arrayList.get(j);
            if (pGPPublicKey2.getKeyID() == pGPPublicKey.getKeyID()) {
                bl = true;
                arrayList.set(j, pGPPublicKey);
            }
            if (!pGPPublicKey2.isMasterKey()) continue;
            bl2 = true;
        }
        if (!bl) {
            if (pGPPublicKey.isMasterKey()) {
                if (bl2) {
                    throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
                }
                arrayList.add(0, pGPPublicKey);
            } else {
                arrayList.add(pGPPublicKey);
            }
        }
        return new PGPPublicKeyRing(arrayList);
    }

    public static PGPPublicKeyRing removePublicKey(PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKey pGPPublicKey) {
        int n = pGPPublicKeyRing.keys.size();
        long l = pGPPublicKey.getKeyID();
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>(n);
        boolean bl = false;
        for (int j = 0; j < n; ++j) {
            PGPPublicKey pGPPublicKey2 = pGPPublicKeyRing.keys.get(j);
            if (pGPPublicKey2.getKeyID() == l) {
                bl = true;
                continue;
            }
            arrayList.add(pGPPublicKey2);
        }
        if (!bl) {
            return null;
        }
        return new PGPPublicKeyRing(arrayList);
    }

    static PublicKeyPacket readPublicKeyPacket(BCPGInputStream bCPGInputStream) throws IOException {
        Packet packet2 = bCPGInputStream.readPacket();
        if (!(packet2 instanceof PublicKeyPacket)) {
            throw new IOException("unexpected packet in stream: " + packet2);
        }
        return (PublicKeyPacket)packet2;
    }

    static PGPPublicKey readSubkey(BCPGInputStream bCPGInputStream, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        try {
            PublicKeyPacket publicKeyPacket = PGPPublicKeyRing.readPublicKeyPacket(bCPGInputStream);
            TrustPacket trustPacket = PGPPublicKeyRing.readOptionalTrustPacket(bCPGInputStream);
            List<PGPSignature> list = PGPPublicKeyRing.readSignaturesAndTrust(bCPGInputStream);
            return new PGPPublicKey(publicKeyPacket, trustPacket, list, keyFingerPrintCalculator);
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (ArmoredInputException armoredInputException) {
            throw armoredInputException;
        }
        catch (IOException iOException) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("skipping unknown subkey: " + iOException.getMessage());
            }
            return null;
        }
    }

    public static PGPPublicKeyRing join(PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKeyRing pGPPublicKeyRing2) throws PGPException {
        return PGPPublicKeyRing.join(pGPPublicKeyRing, pGPPublicKeyRing2, false, false);
    }

    public static PGPPublicKeyRing join(PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKeyRing pGPPublicKeyRing2, boolean bl, boolean bl2) throws PGPException {
        Iterator iterator2;
        if (!Arrays.areEqual((byte[])pGPPublicKeyRing.getPublicKey().getFingerprint(), (byte[])pGPPublicKeyRing2.getPublicKey().getFingerprint())) {
            throw new IllegalArgumentException("Cannot merge certificates with differing primary keys.");
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        Object object = pGPPublicKeyRing2.iterator();
        while (object.hasNext()) {
            iterator2 = object.next();
            hashSet.add(Longs.valueOf((long)((PGPPublicKey)((Object)iterator2)).getKeyID()));
        }
        object = new ArrayList();
        iterator2 = pGPPublicKeyRing.iterator();
        while (iterator2.hasNext()) {
            PGPPublicKey object2 = (PGPPublicKey)iterator2.next();
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing2.getPublicKey(object2.getKeyID());
            if (pGPPublicKey != null) {
                object.add(PGPPublicKey.join(object2, pGPPublicKey, bl, bl2));
                hashSet.remove(Longs.valueOf((long)object2.getKeyID()));
                continue;
            }
            object.add(object2);
        }
        for (Long l : hashSet) {
            object.add(pGPPublicKeyRing2.getPublicKey(l));
        }
        return new PGPPublicKeyRing((List<PGPPublicKey>)object);
    }
}

