/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import org.bouncycastle.bcpg.UserAttributeSubpacket;
import org.bouncycastle.bcpg.UserDataPacket;
import org.bouncycastle.bcpg.attr.ImageAttribute;

public class PGPUserAttributeSubpacketVector
implements UserDataPacket {
    UserAttributeSubpacket[] packets;

    public static PGPUserAttributeSubpacketVector fromSubpackets(UserAttributeSubpacket[] userAttributeSubpacketArray) {
        if (userAttributeSubpacketArray == null) {
            userAttributeSubpacketArray = new UserAttributeSubpacket[]{};
        }
        return new PGPUserAttributeSubpacketVector(userAttributeSubpacketArray);
    }

    PGPUserAttributeSubpacketVector(UserAttributeSubpacket[] userAttributeSubpacketArray) {
        this.packets = userAttributeSubpacketArray;
    }

    public UserAttributeSubpacket getSubpacket(int n) {
        for (int j = 0; j != this.packets.length; ++j) {
            if (this.packets[j].getType() != n) continue;
            return this.packets[j];
        }
        return null;
    }

    public ImageAttribute getImageAttribute() {
        UserAttributeSubpacket userAttributeSubpacket = this.getSubpacket(1);
        if (userAttributeSubpacket == null) {
            return null;
        }
        return (ImageAttribute)userAttributeSubpacket;
    }

    UserAttributeSubpacket[] toSubpacketArray() {
        return this.packets;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PGPUserAttributeSubpacketVector) {
            PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector = (PGPUserAttributeSubpacketVector)object;
            if (pGPUserAttributeSubpacketVector.packets.length != this.packets.length) {
                return false;
            }
            for (int j = 0; j != this.packets.length; ++j) {
                if (pGPUserAttributeSubpacketVector.packets[j].equals(this.packets[j])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        for (int j = 0; j != this.packets.length; ++j) {
            n ^= this.packets[j].hashCode();
        }
        return n;
    }
}

