/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal.inline;

import java.util.regex.Pattern;
import org.commonmark.internal.inline.InlineContentParser;
import org.commonmark.internal.inline.InlineParserState;
import org.commonmark.internal.inline.ParsedInline;
import org.commonmark.internal.inline.Position;
import org.commonmark.internal.inline.Scanner;
import org.commonmark.node.Link;
import org.commonmark.node.Text;
import org.commonmark.parser.SourceLines;

public class AutolinkInlineParser
implements InlineContentParser {
    private static final Pattern URI = Pattern.compile("^[a-zA-Z][a-zA-Z0-9.+-]{1,31}:[^<>\u0000- ]*$");
    private static final Pattern EMAIL = Pattern.compile("^([a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*)$");

    @Override
    public ParsedInline tryParse(InlineParserState inlineParserState) {
        Scanner scanner = inlineParserState.scanner();
        scanner.next();
        Position textStart = scanner.position();
        if (scanner.find('>') > 0) {
            SourceLines textSource = scanner.getSource(textStart, scanner.position());
            String content2 = textSource.getContent();
            scanner.next();
            String destination = null;
            if (URI.matcher(content2).matches()) {
                destination = content2;
            } else if (EMAIL.matcher(content2).matches()) {
                destination = "mailto:" + content2;
            }
            if (destination != null) {
                Link link = new Link(destination, null);
                Text text2 = new Text(content2);
                text2.setSourceSpans(textSource.getSourceSpans());
                link.appendChild(text2);
                return ParsedInline.of(link, scanner.position());
            }
        }
        return ParsedInline.none();
    }
}

