/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.parser;

import java.util.ArrayList;
import java.util.List;
import org.commonmark.node.SourceSpan;
import org.commonmark.parser.SourceLine;

public class SourceLines {
    private final List<SourceLine> lines = new ArrayList<SourceLine>();

    public static SourceLines empty() {
        return new SourceLines();
    }

    public static SourceLines of(SourceLine sourceLine) {
        SourceLines sourceLines = new SourceLines();
        sourceLines.addLine(sourceLine);
        return sourceLines;
    }

    public static SourceLines of(List<SourceLine> sourceLines) {
        SourceLines result2 = new SourceLines();
        result2.lines.addAll(sourceLines);
        return result2;
    }

    public void addLine(SourceLine sourceLine) {
        this.lines.add(sourceLine);
    }

    public List<SourceLine> getLines() {
        return this.lines;
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public String getContent() {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < this.lines.size(); ++i2) {
            if (i2 != 0) {
                sb.append('\n');
            }
            sb.append(this.lines.get(i2).getContent());
        }
        return sb.toString();
    }

    public List<SourceSpan> getSourceSpans() {
        ArrayList<SourceSpan> sourceSpans = new ArrayList<SourceSpan>();
        for (SourceLine line : this.lines) {
            SourceSpan sourceSpan = line.getSourceSpan();
            if (sourceSpan == null) continue;
            sourceSpans.add(sourceSpan);
        }
        return sourceSpans;
    }
}

