/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.annotations.assembler;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.annotation.specifier.Completions;
import org.incendo.cloud.annotations.AnnotationParser;
import org.incendo.cloud.annotations.ArgumentMode;
import org.incendo.cloud.annotations.PreprocessorMapper;
import org.incendo.cloud.annotations.SyntaxFragment;
import org.incendo.cloud.annotations.assembler.ArgumentAssembler;
import org.incendo.cloud.annotations.descriptor.ArgumentDescriptor;
import org.incendo.cloud.component.CommandComponent;
import org.incendo.cloud.component.preprocessor.ComponentPreprocessor;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;
import org.incendo.cloud.parser.ParserParameters;
import org.incendo.cloud.parser.standard.EitherParser;
import org.incendo.cloud.suggestion.Suggestion;
import org.incendo.cloud.suggestion.SuggestionProvider;
import org.incendo.cloud.type.Either;

@API(status=API.Status.INTERNAL, consumers={"org.incendo.cloud.annotations.*"})
public final class ArgumentAssemblerImpl<C>
implements ArgumentAssembler<C> {
    private final AnnotationParser<C> annotationParser;

    public ArgumentAssemblerImpl(@NonNull AnnotationParser<C> annotationParser) {
        this.annotationParser = annotationParser;
    }

    @Override
    public @NonNull CommandComponent<C> assembleArgument(@NonNull SyntaxFragment syntaxFragment, @NonNull ArgumentDescriptor descriptor2) {
        ArgumentParser<C, Object> parser;
        Parameter parameter = descriptor2.parameter();
        List<Annotation> annotations = Arrays.asList(parameter.getAnnotations());
        TypeToken<?> token2 = TypeToken.get(parameter.getParameterizedType());
        ParserParameters parameters2 = this.annotationParser.manager().parserRegistry().parseAnnotations(token2, annotations);
        if (GenericTypeReflector.isSuperType(Either.class, token2.getType())) {
            TypeToken<?> primaryType = TypeToken.get(GenericTypeReflector.getTypeParameter(parameter.getParameterizedType(), Either.class.getTypeParameters()[0]));
            TypeToken<?> fallbackType = TypeToken.get(GenericTypeReflector.getTypeParameter(parameter.getParameterizedType(), Either.class.getTypeParameters()[1]));
            ParserDescriptor primary = this.annotationParser.manager().parserRegistry().createParser(primaryType, parameters2).map(primaryParser -> ParserDescriptor.of(primaryParser, primaryType)).orElseThrow(() -> new IllegalArgumentException(String.format("Parameter '%s' has parser 'Either<%s, ?>' but no parser exists for that type", parameter.getName(), token2.getType().getTypeName())));
            ParserDescriptor fallback = this.annotationParser.manager().parserRegistry().createParser(fallbackType, parameters2).map(fallbackParser -> ParserDescriptor.of(fallbackParser, fallbackType)).orElseThrow(() -> new IllegalArgumentException(String.format("Parameter '%s' has parser 'Either<?, %s>' but no parser exists for that type", parameter.getName(), token2.getType().getTypeName())));
            parser = EitherParser.eitherParser(primary, fallback).parser();
        } else {
            parser = descriptor2.parserName() == null ? this.annotationParser.manager().parserRegistry().createParser(token2, parameters2).orElseThrow(() -> new IllegalArgumentException(String.format("Parameter '%s' has parser '%s' but no parser exists for that type", parameter.getName(), token2.getType().getTypeName()))) : this.annotationParser.manager().parserRegistry().createParser(this.annotationParser.processString(descriptor2.parserName()), parameters2).orElseThrow(() -> new IllegalArgumentException(String.format("Parameter '%s' has parser '%s' but no parser exists for that type", parameter.getName(), token2.getType().getTypeName())));
        }
        String argumentName = this.annotationParser.processString(descriptor2.name());
        if (syntaxFragment.argumentMode() == ArgumentMode.LITERAL) {
            throw new IllegalArgumentException(String.format("Invalid command argument '%s': Missing syntax mapping", argumentName));
        }
        CommandComponent.Builder<Object, ?> componentBuilder = CommandComponent.builder();
        componentBuilder.commandManager(this.annotationParser.manager()).valueType(parameter.getType()).name(argumentName).parser(parser).required(syntaxFragment.argumentMode() == ArgumentMode.REQUIRED);
        Completions completions = parameter.getDeclaredAnnotation(Completions.class);
        if (completions != null) {
            List suggestions = Arrays.stream(completions.value().replace(" ", "").split(",")).map(Suggestion::suggestion).collect(Collectors.toList());
            componentBuilder.suggestionProvider(SuggestionProvider.suggesting(suggestions));
        } else if (descriptor2.suggestions() != null) {
            String suggestionProviderName = this.annotationParser.processString(descriptor2.suggestions());
            Optional<SuggestionProvider<C>> suggestionsFunction = this.annotationParser.manager().parserRegistry().getSuggestionProvider(suggestionProviderName);
            componentBuilder.suggestionProvider(suggestionsFunction.orElseThrow(() -> new IllegalArgumentException(String.format("There is no suggestion provider with name '%s'. Did you forget to register it?", suggestionProviderName))));
        }
        if (descriptor2.description() != null) {
            componentBuilder.description(descriptor2.description());
        }
        if (syntaxFragment.argumentMode() == ArgumentMode.OPTIONAL && descriptor2.defaultValue() != null) {
            componentBuilder.defaultValue(descriptor2.defaultValue());
        }
        for (Annotation annotation : annotations) {
            PreprocessorMapper<?, C> preprocessorMapper = this.annotationParser.preprocessorMappers().get(annotation.annotationType());
            if (preprocessorMapper == null) continue;
            ComponentPreprocessor<C> preprocessor = preprocessorMapper.mapAnnotation(annotation);
            componentBuilder.preprocessor(preprocessor);
        }
        return componentBuilder.build();
    }
}

