/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.execution.CommandExecutionHandler;

@API(status=API.Status.INTERNAL)
final class MulticastDelegateFutureCommandExecutionHandler<C>
implements CommandExecutionHandler.FutureCommandExecutionHandler<C> {
    private final List<CommandExecutionHandler<C>> handlers;

    MulticastDelegateFutureCommandExecutionHandler(@NonNull List<@NonNull CommandExecutionHandler<C>> handlers) {
        ArrayList<CommandExecutionHandler<C>> unwrappedHandlers = new ArrayList<CommandExecutionHandler<C>>();
        for (CommandExecutionHandler<C> handler2 : handlers) {
            if (handler2 instanceof MulticastDelegateFutureCommandExecutionHandler) {
                unwrappedHandlers.addAll(((MulticastDelegateFutureCommandExecutionHandler)handler2).handlers);
                continue;
            }
            unwrappedHandlers.add(handler2);
        }
        this.handlers = Collections.unmodifiableList(unwrappedHandlers);
    }

    @Override
    public CompletableFuture<@Nullable Void> executeFuture(@NonNull CommandContext<C> commandContext) {
        @MonotonicNonNull CompletionStage<@Nullable Object> composedHandler = null;
        if (this.handlers.isEmpty()) {
            composedHandler = CompletableFuture.completedFuture(null);
        } else {
            for (CommandExecutionHandler handler2 : this.handlers) {
                if (composedHandler == null) {
                    composedHandler = handler2.executeFuture(commandContext);
                    continue;
                }
                composedHandler = composedHandler.thenCompose(ignore -> handler2.executeFuture(commandContext));
            }
        }
        return composedHandler;
    }
}

