/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.help;

import io.leangen.geantyref.GenericTypeReflector;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.component.CommandComponent;
import org.incendo.cloud.help.CommandPredicate;
import org.incendo.cloud.help.HelpHandler;
import org.incendo.cloud.help.HelpQuery;
import org.incendo.cloud.help.result.CommandEntry;
import org.incendo.cloud.help.result.HelpQueryResult;
import org.incendo.cloud.help.result.IndexCommandResult;
import org.incendo.cloud.help.result.MultipleCommandResult;
import org.incendo.cloud.help.result.VerboseCommandResult;
import org.incendo.cloud.internal.CommandInputTokenizer;
import org.incendo.cloud.internal.CommandNode;

@API(status=API.Status.STABLE)
public class StandardHelpHandler<C>
implements HelpHandler<C> {
    private final CommandManager<C> commandManager;
    private final CommandPredicate<C> commandFilter;

    public StandardHelpHandler(@NonNull CommandManager<C> commandManager, @NonNull CommandPredicate<C> commandPredicate) {
        this.commandManager = commandManager;
        this.commandFilter = commandPredicate;
    }

    @Override
    public @NonNull HelpQueryResult<C> query(@NonNull HelpQuery<C> query) {
        List<CommandEntry<C>> commands = this.commands(query.sender());
        if (query.query().replace(" ", "").isEmpty()) {
            return IndexCommandResult.of(query, commands);
        }
        LinkedList<String> queryFragments = new CommandInputTokenizer(query.query()).tokenize();
        String rootFragment = (String)queryFragments.get(0);
        LinkedList<Command<C>> availableCommands = new LinkedList<Command<C>>();
        HashSet<String> availableCommandLabels = new HashSet<String>();
        boolean exactMatch = false;
        for (CommandEntry<C> entry2 : commands) {
            Command<C> command3 = entry2.command();
            CommandComponent<C> component = command3.rootComponent();
            for (String string : component.aliases()) {
                if (!string.toLowerCase(Locale.ENGLISH).startsWith(rootFragment.toLowerCase(Locale.ENGLISH))) continue;
                availableCommands.add(command3);
                availableCommandLabels.add(component.name());
                break;
            }
            for (String string : component.aliases()) {
                if (!string.equalsIgnoreCase(rootFragment)) continue;
                exactMatch = true;
                break;
            }
            if (!rootFragment.equalsIgnoreCase(component.name())) continue;
            availableCommandLabels.clear();
            availableCommands.clear();
            availableCommandLabels.add(component.name());
            availableCommands.add(command3);
            break;
        }
        if (availableCommands.isEmpty()) {
            return IndexCommandResult.of(query, Collections.emptyList());
        }
        if (!exactMatch || availableCommandLabels.size() > 1) {
            return IndexCommandResult.of(query, availableCommands.stream().map(command2 -> CommandEntry.of(command2, this.commandManager.commandSyntaxFormatter().apply(query.sender(), command2.components(), null))).sorted().filter(entry -> this.isAllowed(query.sender(), entry.command())).collect(Collectors.toList()));
        }
        CommandNode<C> node = this.commandManager.commandTree().getNamedNode((String)availableCommandLabels.iterator().next());
        LinkedList traversedNodes = new LinkedList();
        CommandNode<C> head2 = node;
        int index = 0;
        block3: while (head2 != null && this.isNodeVisible(head2)) {
            traversedNodes.add(head2.component());
            if (head2.component() != null && head2.command() != null && (head2.isLeaf() || ++index == queryFragments.size()) && this.isAllowed(query.sender(), head2.command())) {
                return VerboseCommandResult.of(query, CommandEntry.of(head2.command(), this.commandManager.commandSyntaxFormatter().apply(query.sender(), head2.command().components(), null)));
            }
            if (head2.children().size() == 1) {
                head2 = head2.children().get(0);
                continue;
            }
            if (index < queryFragments.size()) {
                CommandNode<C> potentialVariable = null;
                for (CommandNode<C> commandNode : head2.children()) {
                    if (commandNode.component() == null || commandNode.component().type() != CommandComponent.ComponentType.LITERAL) {
                        if (commandNode.component() == null) continue;
                        potentialVariable = commandNode;
                        continue;
                    }
                    for (String childAlias : commandNode.component().aliases()) {
                        if (!childAlias.equalsIgnoreCase((String)queryFragments.get(index))) continue;
                        head2 = commandNode;
                        continue block3;
                    }
                }
                if (potentialVariable != null) {
                    head2 = potentialVariable;
                    continue;
                }
            }
            String currentDescription = this.commandManager.commandSyntaxFormatter().apply(query.sender(), traversedNodes, null);
            LinkedList<String> linkedList = new LinkedList<String>();
            for (CommandNode<C> child3 : head2.children()) {
                if (!this.isNodeVisible(child3)) continue;
                LinkedList traversedNodesSub = new LinkedList(traversedNodes);
                if (child3.component() != null && child3.command() != null && !this.isAllowed(query.sender(), child3.command())) continue;
                traversedNodesSub.add(child3.component());
                linkedList.add(this.commandManager.commandSyntaxFormatter().apply(query.sender(), traversedNodesSub, child3));
            }
            return MultipleCommandResult.of(query, currentDescription, linkedList);
        }
        return IndexCommandResult.of(query, Collections.emptyList());
    }

    protected @NonNull List<@NonNull CommandEntry<C>> commands(@NonNull C sender) {
        return this.commandManager.commands().stream().filter(this.commandFilter).filter(command2 -> this.isAllowed(sender, (Command<C>)command2)).map(command2 -> CommandEntry.of(command2, this.commandManager.commandSyntaxFormatter().apply(sender, command2.components(), null))).sorted().collect(Collectors.toList());
    }

    private boolean isAllowed(C sender, Command<C> command2) {
        if (command2.senderType().isPresent() && !GenericTypeReflector.isSuperType(command2.senderType().get().getType(), sender.getClass())) {
            return false;
        }
        return this.commandManager.testPermission(sender, command2.commandPermission()).allowed();
    }

    protected boolean isNodeVisible(@NonNull CommandNode<C> node) {
        Command<C> owningCommand;
        CommandComponent<C> component = node.component();
        if (component != null && (owningCommand = node.command()) != null && this.commandFilter.test(owningCommand)) {
            return true;
        }
        for (CommandNode<C> childNode : node.children()) {
            if (!this.isNodeVisible(childNode)) continue;
            return true;
        }
        return false;
    }
}

