/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.parser.aggregate;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.component.CommandComponent;
import org.incendo.cloud.key.CloudKey;
import org.incendo.cloud.parser.aggregate.AggregateParser;
import org.incendo.cloud.parser.aggregate.AggregateParsingContext;

final class AggregateParsingContextImpl<C>
implements AggregateParsingContext<C> {
    private final Map<CloudKey<?>, Object> storage = new HashMap();
    private final Collection<@NonNull String> validKeys;

    AggregateParsingContextImpl(@NonNull AggregateParser<C, ?> parser) {
        this.validKeys = parser.components().stream().map(CommandComponent::name).collect(Collectors.toList());
    }

    @Override
    public <V> void store(@NonNull CloudKey<V> key2, @NonNull V value) {
        this.storage.put(key2, value);
    }

    @Override
    public <V> void store(@NonNull String key2, @NonNull V value) {
        this.storage.put(CloudKey.of(key2), value);
    }

    @Override
    public void remove(@NonNull CloudKey<?> key2) {
        this.storage.remove(key2);
    }

    @Override
    public <V> V computeIfAbsent(@NonNull CloudKey<V> key2, @NonNull Function<@NonNull CloudKey<V>, V> defaultFunction) {
        return (V)this.storage.computeIfAbsent(key2, (? super K k) -> defaultFunction.apply((CloudKey)k));
    }

    @Override
    public <V> @NonNull Optional<V> optional(@NonNull CloudKey<V> key2) {
        Object value = this.storage.get(key2);
        if (value != null) {
            Object castedValue = value;
            return Optional.of(castedValue);
        }
        return Optional.empty();
    }

    @Override
    public <V> @NonNull Optional<V> optional(@NonNull String key2) {
        Object value = this.storage.get(CloudKey.of(key2));
        if (value != null) {
            Object castedValue = value;
            return Optional.of(castedValue);
        }
        return Optional.empty();
    }

    @Override
    public <V> @NonNull V get(@NonNull CloudKey<V> key2) {
        if (!this.validKeys.contains(key2.name())) {
            throw new NullPointerException("No value with the given key has been stored in the context");
        }
        Object value = Objects.requireNonNull(this.storage.get(key2));
        return (V)value;
    }

    @Override
    public <V> @NonNull V get(@NonNull String key2) {
        if (!this.validKeys.contains(key2)) {
            throw new NullPointerException("No value with the given key has been stored in the context");
        }
        Object value = Objects.requireNonNull(this.storage.get(CloudKey.of(key2)));
        return (V)value;
    }

    @Override
    public boolean contains(@NonNull CloudKey<?> key2) {
        return this.storage.containsKey(key2);
    }

    @Override
    public boolean contains(@NonNull String key2) {
        return this.storage.containsKey(CloudKey.of(key2));
    }

    @Override
    public @NonNull Map<CloudKey<?>, ? extends @NonNull Object> all() {
        return this.storage;
    }
}

