/*
 * Decompiled with CFR 0.152.
 */
package io.github.quantizr.dungeonrooms.dungeons.catacombs;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.github.quantizr.dungeonrooms.DungeonRooms;
import io.github.quantizr.dungeonrooms.dungeons.catacombs.RoomDetection;
import io.github.quantizr.dungeonrooms.events.PacketEvent;
import io.github.quantizr.dungeonrooms.utils.MapUtils;
import io.github.quantizr.dungeonrooms.utils.Utils;
import io.github.quantizr.dungeonrooms.utils.WaypointUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.network.play.server.S0DPacketCollectItem;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;

public class Waypoints {
    public static boolean enabled = true;
    public static boolean showEntrance = true;
    public static boolean showSuperboom = true;
    public static boolean showSecrets = true;
    public static boolean showFairySouls = true;
    public static boolean showStonk = true;
    public static boolean sneakToDisable = true;
    public static boolean disableWhenAllFound = true;
    public static boolean allFound = false;
    public static boolean showWaypointText = true;
    public static boolean showBoundingBox = true;
    public static boolean showBeacon = true;
    public static boolean practiceModeOn = false;
    public static int secretNum = 0;
    public static int completedSecrets = 0;
    public static Map<String, List<Boolean>> allSecretsMap = new HashMap<String, List<Boolean>>();
    public static List<Boolean> secretsList = new ArrayList<Boolean>(Arrays.asList(new Boolean[10]));
    static long lastSneakTime = 0L;
    Frustum frustum = new Frustum();

    @SubscribeEvent
    public void onWorldRender(RenderWorldLastEvent event) {
        if (!enabled) {
            return;
        }
        if (practiceModeOn && !DungeonRooms.keyBindings[2].func_151470_d()) {
            return;
        }
        String roomName = RoomDetection.roomName;
        if (roomName.equals("undefined") || DungeonRooms.roomsJson.get(roomName) == null || secretsList == null) {
            return;
        }
        if (DungeonRooms.waypointsJson.get(roomName) != null) {
            JsonArray secretsArray = DungeonRooms.waypointsJson.get(roomName).getAsJsonArray();
            int arraySize = secretsArray.size();
            block22: for (int i = 0; i < arraySize; ++i) {
                Color color;
                JsonObject secretsObject = secretsArray.get(i).getAsJsonObject();
                boolean display = true;
                for (int j = 1; j <= secretNum; ++j) {
                    if (secretsList.get(j - 1).booleanValue() || !secretsObject.get("secretName").getAsString().substring(0, 2).replaceAll("[\\D]", "").equals(String.valueOf(j))) continue;
                    display = false;
                    break;
                }
                if (!display || disableWhenAllFound && allFound && !secretsObject.get("category").getAsString().equals("fairysoul")) continue;
                BlockPos relative = new BlockPos(secretsObject.get("x").getAsInt(), secretsObject.get("y").getAsInt(), secretsObject.get("z").getAsInt());
                BlockPos pos = MapUtils.relativeToActual(relative, RoomDetection.roomDirection, RoomDetection.roomCorner);
                Entity viewer = Minecraft.func_71410_x().func_175606_aa();
                this.frustum.func_78547_a(viewer.field_70165_t, viewer.field_70163_u, viewer.field_70161_v);
                if (!this.frustum.func_78548_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), 255.0, (double)(pos.func_177952_p() + 1))) continue;
                switch (secretsObject.get("category").getAsString()) {
                    case "entrance": {
                        if (!showEntrance) continue block22;
                        color = new Color(0, 255, 0);
                        break;
                    }
                    case "superboom": {
                        if (!showSuperboom) continue block22;
                        color = new Color(255, 0, 0);
                        break;
                    }
                    case "chest": {
                        if (!showSecrets) continue block22;
                        color = new Color(2, 213, 250);
                        break;
                    }
                    case "item": {
                        if (!showSecrets) continue block22;
                        color = new Color(2, 64, 250);
                        break;
                    }
                    case "bat": {
                        if (!showSecrets) continue block22;
                        color = new Color(142, 66, 0);
                        break;
                    }
                    case "wither": {
                        if (!showSecrets) continue block22;
                        color = new Color(30, 30, 30);
                        break;
                    }
                    case "lever": {
                        if (!showSecrets) continue block22;
                        color = new Color(250, 217, 2);
                        break;
                    }
                    case "fairysoul": {
                        if (!showFairySouls) continue block22;
                        color = new Color(255, 85, 255);
                        break;
                    }
                    case "stonk": {
                        if (!showStonk) continue block22;
                        color = new Color(146, 52, 235);
                        break;
                    }
                    default: {
                        color = new Color(190, 255, 252);
                    }
                }
                double viewerX = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)event.partialTicks;
                double viewerY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)event.partialTicks;
                double viewerZ = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)event.partialTicks;
                double x = (double)pos.func_177958_n() - viewerX;
                double y = (double)pos.func_177956_o() - viewerY;
                double z = (double)pos.func_177952_p() - viewerZ;
                double distSq = x * x + y * y + z * z;
                GlStateManager.func_179097_i();
                GlStateManager.func_179129_p();
                if (showBoundingBox && this.frustum.func_78548_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1))) {
                    WaypointUtils.drawFilledBoundingBox(new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0), color, 0.4f);
                }
                GlStateManager.func_179090_x();
                if (showBeacon && distSq > 25.0) {
                    WaypointUtils.renderBeaconBeam(x, y + 1.0, z, color.getRGB(), 0.25f, event.partialTicks);
                }
                if (showWaypointText) {
                    WaypointUtils.renderWaypointText(secretsObject.get("secretName").getAsString(), pos.func_177981_b(2), event.partialTicks);
                }
                GlStateManager.func_179140_f();
                GlStateManager.func_179098_w();
                GlStateManager.func_179126_j();
                GlStateManager.func_179089_o();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChat(ClientChatReceivedEvent event) {
        if (!Utils.inCatacombs || !enabled) {
            return;
        }
        if (event.type == 2) {
            String[] actionBarSections;
            for (String section : actionBarSections = event.message.func_150260_c().split(" {3,}")) {
                if (!section.contains("Secrets") || !section.contains("/")) continue;
                String cleanedSection = StringUtils.func_76338_a((String)section);
                String[] splitSecrets = cleanedSection.split("/");
                completedSecrets = Integer.parseInt(splitSecrets[0].replaceAll("[^0-9]", ""));
                int totalSecrets = Integer.parseInt(splitSecrets[1].replaceAll("[^0-9]", ""));
                allFound = totalSecrets == secretNum && completedSecrets == secretNum;
                break;
            }
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent event) {
        if (!Utils.inCatacombs || !enabled) {
            return;
        }
        if (disableWhenAllFound && allFound) {
            return;
        }
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            Block block = event.world.func_180495_p(event.pos).func_177230_c();
            if (block != Blocks.field_150486_ae && block != Blocks.field_150465_bP) {
                return;
            }
            String roomName = RoomDetection.roomName;
            if (roomName.equals("undefined") || DungeonRooms.roomsJson.get(roomName) == null || secretsList == null) {
                return;
            }
            if (DungeonRooms.waypointsJson.get(roomName) != null) {
                JsonArray secretsArray = DungeonRooms.waypointsJson.get(roomName).getAsJsonArray();
                int arraySize = secretsArray.size();
                block0: for (int i = 0; i < arraySize; ++i) {
                    BlockPos relative;
                    BlockPos pos;
                    JsonObject secretsObject = secretsArray.get(i).getAsJsonObject();
                    if (!secretsObject.get("category").getAsString().equals("chest") && !secretsObject.get("category").getAsString().equals("wither") || !(pos = MapUtils.relativeToActual(relative = new BlockPos(secretsObject.get("x").getAsInt(), secretsObject.get("y").getAsInt(), secretsObject.get("z").getAsInt()), RoomDetection.roomDirection, RoomDetection.roomCorner)).equals((Object)event.pos)) continue;
                    for (int j = 1; j <= secretNum; ++j) {
                        if (!secretsObject.get("secretName").getAsString().substring(0, 2).replaceAll("[\\D]", "").equals(String.valueOf(j))) continue;
                        secretsList.set(j - 1, false);
                        allSecretsMap.replace(roomName, secretsList);
                        DungeonRooms.logger.info("DungeonRooms: Detected " + secretsObject.get("category").getAsString() + " click, turning off waypoint for secret #" + j);
                        continue block0;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onReceivePacket(PacketEvent.ReceiveEvent event) {
        S0DPacketCollectItem packet;
        Entity entity;
        if (!Utils.inCatacombs || !enabled) {
            return;
        }
        if (disableWhenAllFound && allFound) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (event.packet instanceof S0DPacketCollectItem && (entity = mc.field_71441_e.func_73045_a((packet = (S0DPacketCollectItem)event.packet).func_149354_c())) instanceof EntityItem) {
            EntityItem item = (EntityItem)entity;
            entity = mc.field_71441_e.func_73045_a(packet.func_149353_d());
            if (entity == null) {
                return;
            }
            String name = item.func_92059_d().func_82833_r();
            if (name.contains("Decoy") || name.contains("Defuse Kit") || name.contains("Dungeon Chest Key") || name.contains("Healing VIII") || name.contains("Inflatable Jerry") || name.contains("Spirit Leap") || name.contains("Training Weights") || name.contains("Trap") || name.contains("Treasure Talisman")) {
                if (!entity.func_174793_f().func_70005_c_().equals(mc.field_71439_g.func_70005_c_())) {
                    return;
                }
                String roomName = RoomDetection.roomName;
                if (roomName.equals("undefined") || DungeonRooms.roomsJson.get(roomName) == null || secretsList == null) {
                    return;
                }
                if (DungeonRooms.waypointsJson.get(roomName) != null) {
                    JsonArray secretsArray = DungeonRooms.waypointsJson.get(roomName).getAsJsonArray();
                    int arraySize = secretsArray.size();
                    for (int i = 0; i < arraySize; ++i) {
                        BlockPos relative;
                        BlockPos pos;
                        JsonObject secretsObject = secretsArray.get(i).getAsJsonObject();
                        if (!secretsObject.get("category").getAsString().equals("item") && !secretsObject.get("category").getAsString().equals("bat") || !(entity.func_174818_b(pos = MapUtils.relativeToActual(relative = new BlockPos(secretsObject.get("x").getAsInt(), secretsObject.get("y").getAsInt(), secretsObject.get("z").getAsInt()), RoomDetection.roomDirection, RoomDetection.roomCorner)) <= 36.0)) continue;
                        for (int j = 1; j <= secretNum; ++j) {
                            if (!secretsObject.get("secretName").getAsString().substring(0, 2).replaceAll("[\\D]", "").equals(String.valueOf(j)) || !secretsList.get(j - 1).booleanValue()) continue;
                            secretsList.set(j - 1, false);
                            allSecretsMap.replace(roomName, secretsList);
                            DungeonRooms.logger.info("DungeonRooms: " + entity.func_174793_f().func_70005_c_() + " picked up " + StringUtils.func_76338_a((String)name) + " from a " + secretsObject.get("category").getAsString() + " secret, turning off waypoint for secret #" + j);
                            return;
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        if (!(Utils.inCatacombs && enabled && sneakToDisable)) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (FMLClientHandler.instance().getClient().field_71474_y.field_74311_E.func_151468_f()) {
            if (System.currentTimeMillis() - lastSneakTime < 500L) {
                String roomName = RoomDetection.roomName;
                if (roomName.equals("undefined") || DungeonRooms.roomsJson.get(roomName) == null || secretsList == null) {
                    return;
                }
                if (DungeonRooms.waypointsJson.get(roomName) != null) {
                    JsonArray secretsArray = DungeonRooms.waypointsJson.get(roomName).getAsJsonArray();
                    int arraySize = secretsArray.size();
                    for (int i = 0; i < arraySize; ++i) {
                        BlockPos relative;
                        BlockPos pos;
                        JsonObject secretsObject = secretsArray.get(i).getAsJsonObject();
                        if (!secretsObject.get("category").getAsString().equals("chest") && !secretsObject.get("category").getAsString().equals("wither") && !secretsObject.get("category").getAsString().equals("item") && !secretsObject.get("category").getAsString().equals("bat") || !(player.func_174818_b(pos = MapUtils.relativeToActual(relative = new BlockPos(secretsObject.get("x").getAsInt(), secretsObject.get("y").getAsInt(), secretsObject.get("z").getAsInt()), RoomDetection.roomDirection, RoomDetection.roomCorner)) <= 16.0)) continue;
                        for (int j = 1; j <= secretNum; ++j) {
                            if (!secretsObject.get("secretName").getAsString().substring(0, 2).replaceAll("[\\D]", "").equals(String.valueOf(j)) || !secretsList.get(j - 1).booleanValue()) continue;
                            secretsList.set(j - 1, false);
                            allSecretsMap.replace(roomName, secretsList);
                            DungeonRooms.logger.info("DungeonRooms: Player sneaked near " + secretsObject.get("category").getAsString() + " secret, turning off waypoint for secret #" + j);
                            return;
                        }
                    }
                }
            }
            lastSneakTime = System.currentTimeMillis();
        }
    }
}

