/*
 * Decompiled with CFR 0.152.
 */
package io.github.quantizr.dungeonrooms.gui;

import io.github.quantizr.dungeonrooms.DungeonRooms;
import io.github.quantizr.dungeonrooms.dungeons.catacombs.RoomDetection;
import io.github.quantizr.dungeonrooms.dungeons.catacombs.Waypoints;
import io.github.quantizr.dungeonrooms.handlers.ConfigHandler;
import io.github.quantizr.dungeonrooms.handlers.TextRenderer;
import io.github.quantizr.dungeonrooms.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class WaypointsGUI
extends GuiScreen {
    private GuiButton waypointsEnabled;
    private GuiButton practiceModeEnabled;
    private GuiButton showEntrance;
    private GuiButton showSuperboom;
    private GuiButton showSecrets;
    private GuiButton showFairySouls;
    private GuiButton showStonk;
    private GuiButton disableWhenAllFound;
    private GuiButton sneakToDisable;
    private GuiButton close;
    public static List<GuiButton> secretButtonList = new ArrayList<GuiButton>(Arrays.asList(new GuiButton[10]));
    private static boolean waypointGuiOpened = false;

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        block5: {
            super.func_73866_w_();
            waypointGuiOpened = true;
            ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
            int height = sr.func_78328_b();
            int width = sr.func_78326_a();
            this.waypointsEnabled = new GuiButton(0, width / 2 - 100 + 0, height / 6 - 5, 200, 20, WaypointsGUI.waypointBtnText());
            this.practiceModeEnabled = new GuiButton(1, width / 2 - 100 - 110, height / 6 + 25, 200, 20, "Practice Mode: " + WaypointsGUI.getOnOff(Waypoints.practiceModeOn));
            this.showEntrance = new GuiButton(2, width / 2 - 100 + 110, height / 6 + 25, 200, 20, "Show Entrance Waypoints: " + WaypointsGUI.getOnOff(Waypoints.showEntrance));
            this.showSuperboom = new GuiButton(3, width / 2 - 100 - 110, height / 6 + 55, 200, 20, "Show Superboom Waypoints: " + WaypointsGUI.getOnOff(Waypoints.showSuperboom));
            this.showSecrets = new GuiButton(4, width / 2 - 100 + 110, height / 6 + 55, 200, 20, "Show Secret Waypoints: " + WaypointsGUI.getOnOff(Waypoints.showSecrets));
            this.showFairySouls = new GuiButton(5, width / 2 - 100 - 110, height / 6 + 85, 200, 20, "Show Fairy Soul Waypoints: " + WaypointsGUI.getOnOff(Waypoints.showFairySouls));
            this.showStonk = new GuiButton(6, width / 2 - 100 + 110, height / 6 + 85, 200, 20, "Show Stonk Waypoints: " + WaypointsGUI.getOnOff(Waypoints.showStonk));
            this.sneakToDisable = new GuiButton(7, width / 2 - 100 - 110, height / 6 + 115, 200, 20, "Double-Tap Sneak to Hide Nearby: " + WaypointsGUI.getOnOff(Waypoints.sneakToDisable));
            this.disableWhenAllFound = new GuiButton(8, width / 2 - 100 + 110, height / 6 + 115, 200, 20, "Disable when all secrets found: " + WaypointsGUI.getOnOff(Waypoints.disableWhenAllFound));
            this.close = new GuiButton(9, width / 2 - 100, height / 6 * 5, 200, 20, "Close");
            this.field_146292_n.add(this.waypointsEnabled);
            this.field_146292_n.add(this.practiceModeEnabled);
            this.field_146292_n.add(this.showEntrance);
            this.field_146292_n.add(this.showSuperboom);
            this.field_146292_n.add(this.showSecrets);
            this.field_146292_n.add(this.showFairySouls);
            this.field_146292_n.add(this.showStonk);
            this.field_146292_n.add(this.sneakToDisable);
            this.field_146292_n.add(this.disableWhenAllFound);
            this.field_146292_n.add(this.close);
            if (!Utils.inCatacombs || Waypoints.secretNum <= 0) break block5;
            if (Waypoints.secretNum <= 5) {
                for (int i = 1; i <= Waypoints.secretNum; ++i) {
                    int adjustPos = -40 * Waypoints.secretNum - 70 + 80 * i;
                    secretButtonList.set(i - 1, new GuiButton(10 + i, width / 2 + adjustPos, height / 6 + 170, 60, 20, i + ": " + WaypointsGUI.getOnOff(Waypoints.secretsList.get(i - 1))));
                    this.field_146292_n.add(secretButtonList.get(i - 1));
                }
            } else {
                int adjustPos;
                int i;
                for (i = 1; i <= (int)Math.ceil((double)Waypoints.secretNum / 2.0); ++i) {
                    adjustPos = -40 * (int)Math.ceil((double)Waypoints.secretNum / 2.0) - 70 + 80 * i;
                    secretButtonList.set(i - 1, new GuiButton(10 + i, width / 2 + adjustPos, height / 6 + 170, 60, 20, i + ": " + WaypointsGUI.getOnOff(Waypoints.secretsList.get(i - 1))));
                    this.field_146292_n.add(secretButtonList.get(i - 1));
                }
                for (i = (int)Math.ceil((double)Waypoints.secretNum / 2.0) + 1; i <= Waypoints.secretNum; ++i) {
                    adjustPos = -40 * (Waypoints.secretNum - (int)Math.ceil((double)Waypoints.secretNum / 2.0)) - 70 + 80 * (i - (int)Math.ceil((double)Waypoints.secretNum / 2.0));
                    secretButtonList.set(i - 1, new GuiButton(10 + i, width / 2 + adjustPos, height / 6 + 200, 60, 20, i + ": " + WaypointsGUI.getOnOff(Waypoints.secretsList.get(i - 1))));
                    this.field_146292_n.add(secretButtonList.get(i - 1));
                }
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        Minecraft mc = Minecraft.func_71410_x();
        String text1 = "\u00a7lDungeon Room Waypoints:";
        int text1Width = mc.field_71466_p.func_78256_a(text1);
        TextRenderer.drawText(mc, text1, this.field_146294_l / 2 - text1Width / 2, this.field_146295_m / 6 - 25, 1.0, false);
        String text2 = "(Use at your own risk)";
        int text2Width = mc.field_71466_p.func_78256_a(text2);
        TextRenderer.drawText(mc, EnumChatFormatting.GRAY + text2, this.field_146294_l / 2 - text2Width / 2, this.field_146295_m / 6 - 15, 1.0, false);
        String text3 = "Toggle Room Specific Waypoints:";
        int text3Width = mc.field_71466_p.func_78256_a(text3);
        TextRenderer.drawText(mc, text3, this.field_146294_l / 2 - text3Width / 2, this.field_146295_m / 6 + 140, 1.0, false);
        String text4 = "(You can also press the # key matching the secret instead)";
        int text4Width = mc.field_71466_p.func_78256_a(text4);
        TextRenderer.drawText(mc, EnumChatFormatting.GRAY + text4, this.field_146294_l / 2 - text4Width / 2, this.field_146295_m / 6 + 150, 1.0, false);
        if (!Utils.inCatacombs) {
            String errorText = "Not in dungeons";
            int errorTextWidth = mc.field_71466_p.func_78256_a(errorText);
            TextRenderer.drawText(mc, EnumChatFormatting.RED + errorText, this.field_146294_l / 2 - errorTextWidth / 2, this.field_146295_m / 6 + 170, 1.0, false);
        } else if (Waypoints.secretNum == 0) {
            String errorText = "No secrets in this room";
            int errorTextWidth = mc.field_71466_p.func_78256_a(errorText);
            TextRenderer.drawText(mc, EnumChatFormatting.RED + errorText, this.field_146294_l / 2 - errorTextWidth / 2, this.field_146295_m / 6 + 170, 1.0, false);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_146284_a(GuiButton button) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (button == this.waypointsEnabled) {
            Waypoints.enabled = !Waypoints.enabled;
            ConfigHandler.writeBooleanConfig("toggles", "waypointsToggled", Waypoints.enabled);
            this.waypointsEnabled.field_146126_j = WaypointsGUI.waypointBtnText();
            if (Waypoints.enabled) {
                player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7eDungeon Rooms: Waypoints will now automatically show up when you enter a new dungeon room."));
            }
        } else if (button == this.practiceModeEnabled) {
            Waypoints.practiceModeOn = !Waypoints.practiceModeOn;
            ConfigHandler.writeBooleanConfig("waypoint", "practiceModeOn", Waypoints.practiceModeOn);
            this.practiceModeEnabled.field_146126_j = "Practice Mode: " + WaypointsGUI.getOnOff(Waypoints.practiceModeOn);
            if (Waypoints.practiceModeOn) {
                player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7eDungeon Rooms: Practice Mode has been enabled.\n\u00a7e Waypoints will ONLY show up while you are pressing \"" + GameSettings.func_74298_c((int)DungeonRooms.keyBindings[2].func_151463_i()) + "\".\n\u00a7r (Hotkey is configurable in Minecraft Controls menu)"));
            }
        } else if (button == this.showEntrance) {
            Waypoints.showEntrance = !Waypoints.showEntrance;
            ConfigHandler.writeBooleanConfig("waypoint", "showEntrance", Waypoints.showEntrance);
            this.showEntrance.field_146126_j = "Show Entrance Waypoints: " + WaypointsGUI.getOnOff(Waypoints.showEntrance);
        } else if (button == this.showSuperboom) {
            Waypoints.showSuperboom = !Waypoints.showSuperboom;
            ConfigHandler.writeBooleanConfig("waypoint", "showSuperboom", Waypoints.showSuperboom);
            this.showSuperboom.field_146126_j = "Show Superboom Waypoints: " + WaypointsGUI.getOnOff(Waypoints.showSuperboom);
        } else if (button == this.showSecrets) {
            Waypoints.showSecrets = !Waypoints.showSecrets;
            ConfigHandler.writeBooleanConfig("waypoint", "showSecrets", Waypoints.showSecrets);
            this.showSecrets.field_146126_j = "Show Secret Waypoints: " + WaypointsGUI.getOnOff(Waypoints.showSecrets);
        } else if (button == this.showFairySouls) {
            Waypoints.showFairySouls = !Waypoints.showFairySouls;
            ConfigHandler.writeBooleanConfig("waypoint", "showFairySouls", Waypoints.showFairySouls);
            this.showFairySouls.field_146126_j = "Show Fairy Soul Waypoints: " + WaypointsGUI.getOnOff(Waypoints.showFairySouls);
        } else if (button == this.showStonk) {
            Waypoints.showStonk = !Waypoints.showStonk;
            ConfigHandler.writeBooleanConfig("waypoint", "showStonk", Waypoints.showStonk);
            this.showStonk.field_146126_j = "Show Stonk Waypoints: " + WaypointsGUI.getOnOff(Waypoints.showStonk);
        } else if (button == this.sneakToDisable) {
            Waypoints.sneakToDisable = !Waypoints.sneakToDisable;
            ConfigHandler.writeBooleanConfig("waypoint", "sneakToDisable", Waypoints.sneakToDisable);
            this.sneakToDisable.field_146126_j = "Double-Tap Sneak to Hide Nearby: " + WaypointsGUI.getOnOff(Waypoints.sneakToDisable);
        } else if (button == this.disableWhenAllFound) {
            Waypoints.disableWhenAllFound = !Waypoints.disableWhenAllFound;
            ConfigHandler.writeBooleanConfig("waypoint", "disableWhenAllFound", Waypoints.disableWhenAllFound);
            this.disableWhenAllFound.field_146126_j = "Disable when all secrets found: " + WaypointsGUI.getOnOff(Waypoints.disableWhenAllFound);
        } else if (button == this.close) {
            player.func_71053_j();
        }
        if (Utils.inCatacombs && Waypoints.secretNum > 0) {
            for (int i = 1; i <= Waypoints.secretNum; ++i) {
                if (button != secretButtonList.get(i - 1)) continue;
                Waypoints.secretsList.set(i - 1, Waypoints.secretsList.get(i - 1) == false);
                if (!RoomDetection.roomName.equals("undefined")) {
                    Waypoints.allSecretsMap.replace(RoomDetection.roomName, Waypoints.secretsList);
                }
                WaypointsGUI.secretButtonList.get((int)(i - 1)).field_146126_j = i + ": " + WaypointsGUI.getOnOff(Waypoints.secretsList.get(i - 1));
                break;
            }
        }
    }

    public void func_146281_b() {
        waypointGuiOpened = false;
    }

    protected void func_73869_a(char c, int keyCode) throws IOException {
        super.func_73869_a(c, keyCode);
        if (waypointGuiOpened && Utils.inCatacombs && Waypoints.secretNum > 0) {
            for (int i = 1; i <= Waypoints.secretNum; ++i) {
                if (keyCode - 1 != i) continue;
                Waypoints.secretsList.set(i - 1, Waypoints.secretsList.get(i - 1) == false);
                if (!RoomDetection.roomName.equals("undefined")) {
                    Waypoints.allSecretsMap.replace(RoomDetection.roomName, Waypoints.secretsList);
                }
                WaypointsGUI.secretButtonList.get((int)(i - 1)).field_146126_j = i + ": " + WaypointsGUI.getOnOff(Waypoints.secretsList.get(i - 1));
                break;
            }
        }
    }

    private static String waypointBtnText() {
        if (Waypoints.enabled) {
            return EnumChatFormatting.GREEN + "\u00a7lWaypoints Enabled";
        }
        return EnumChatFormatting.RED + "\u00a7lWaypoints Disabled";
    }

    private static String getOnOff(boolean bool) {
        if (bool) {
            return EnumChatFormatting.GREEN + "On";
        }
        return EnumChatFormatting.RED + "Off";
    }
}

