/*
 * Decompiled with CFR 0.152.
 */
package io.github.quantizr.dungeonrooms.handlers;

import com.google.gson.JsonObject;
import io.github.quantizr.dungeonrooms.DungeonRooms;
import io.github.quantizr.dungeonrooms.dungeons.catacombs.RoomDetection;
import io.github.quantizr.dungeonrooms.gui.LinkGUI;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.client.FMLClientHandler;

public class OpenLink {
    public static void checkForLink(String type) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (RoomDetection.roomName.equals("undefined") || DungeonRooms.roomsJson.get(RoomDetection.roomName) == null) {
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: You do not appear to be in a detected Dungeon room right now."));
            return;
        }
        JsonObject roomJson = DungeonRooms.roomsJson.get(RoomDetection.roomName).getAsJsonObject();
        if (roomJson.get("dsg").getAsString().equals("null") && roomJson.get("sbp") == null) {
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: There are no channels/images for this room."));
            return;
        }
        switch (type) {
            case "gui": {
                mc.func_152344_a(() -> mc.func_147108_a((GuiScreen)new LinkGUI()));
                break;
            }
            case "dsg": {
                OpenLink.openDiscord("client");
                break;
            }
            case "sbp": {
                if (DungeonRooms.usingSBPSecrets) {
                    OpenLink.openSBPSecrets();
                    break;
                }
                String sbpURL = "https://discord.gg/2UjaFqfPwJ";
                ChatComponentText sbp = new ChatComponentText(EnumChatFormatting.YELLOW + "" + EnumChatFormatting.UNDERLINE + sbpURL);
                sbp.func_150255_a(sbp.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, sbpURL)));
                player.func_145747_a(new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: You need the Skyblock Personalized (SBP) Mod for this feature, get it from ").func_150257_a((IChatComponent)sbp));
            }
        }
    }

    public static void openDiscord(String type) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (RoomDetection.roomName.equals("undefined") || DungeonRooms.roomsJson.get(RoomDetection.roomName) == null) {
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: You do not appear to be in a detected Dungeon room right now."));
            return;
        }
        JsonObject roomJson = DungeonRooms.roomsJson.get(RoomDetection.roomName).getAsJsonObject();
        if (roomJson.get("dsg").getAsString().equals("null")) {
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: There is no DSG channel for this room."));
            return;
        }
        try {
            if (type.equals("client")) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Dungeon Rooms: Opening DSG Discord in Client..."));
                Desktop.getDesktop().browse(new URI("discord://" + roomJson.get("dsg").getAsString()));
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText("Dungeon Rooms: Opening DSG Discord in Browser..."));
                Desktop.getDesktop().browse(new URI("https://discord.com" + roomJson.get("dsg").getAsString()));
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public static void openSBPSecrets() {
        String category;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (RoomDetection.roomName.equals("undefined") || DungeonRooms.roomsJson.get(RoomDetection.roomName) == null) {
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: You do not appear to be in a detected Dungeon room right now."));
            return;
        }
        JsonObject roomJson = DungeonRooms.roomsJson.get(RoomDetection.roomName).getAsJsonObject();
        if (roomJson.get("sbp") == null) {
            player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Dungeon Rooms: There are no SBP images for this room."));
            return;
        }
        String name = roomJson.get("sbp").getAsString();
        switch (category = roomJson.get("category").getAsString()) {
            case "Puzzle": 
            case "Trap": {
                category = "puzzles";
                break;
            }
            case "L-shape": {
                category = "L";
            }
        }
        ClientCommandHandler.instance.func_71556_a((ICommandSender)FMLClientHandler.instance().getClientPlayerEntity(), "/secretoverride " + category + " " + name);
    }
}

