/*
 * Decompiled with CFR 0.152.
 */
package io.github.quantizr.dungeonrooms.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class RoomDetectionUtils {
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;
    public static HashSet<Integer> whitelistedBlocks = new HashSet<Integer>(Arrays.asList(100, 103, 104, 105, 106, 200, 300, 301, 400, 700, 1800, 3507, 4300, 4800, 8200, 9800, 9801, 9803, 15907, 15909, 15915));

    public static Vec3 getVectorFromRotation(float yaw, float pitch) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static List<Vec3> vectorsToRaytrace(int vectorQuantity) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        ArrayList<Vec3> vectorList = new ArrayList<Vec3>();
        Vec3 eyes = new Vec3(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        float aspectRatio = (float)mc.field_71443_c / (float)mc.field_71440_d;
        double fovV = mc.field_71474_y.field_74334_X * mc.field_71439_g.func_175156_o();
        double fovH = Math.atan((double)aspectRatio * Math.tan(fovV * (Math.PI / 180) / 2.0)) * 2.0 * 57.29577951308232;
        float verticalSpacing = (float)(fovV * 0.8 / (double)vectorQuantity);
        float horizontalSpacing = (float)(fovH * 0.9 / (double)vectorQuantity);
        float playerYaw = player.field_70177_z;
        float playerPitch = player.field_70125_A;
        if (mc.field_71474_y.field_74320_O == 2) {
            playerYaw += 180.0f;
            playerPitch = -playerPitch;
        }
        for (float h = (float)(-(vectorQuantity - 1)) / 2.0f; h <= (float)(vectorQuantity - 1) / 2.0f; h += 1.0f) {
            for (float v = (float)(-(vectorQuantity - 1)) / 2.0f; v <= (float)(vectorQuantity - 1) / 2.0f; v += 1.0f) {
                float yaw = h * horizontalSpacing;
                float pitch = v * verticalSpacing;
                float yawScaled = yaw * (playerPitch * playerPitch / 8100.0f + 1.0f) / (Math.abs(v / (float)vectorQuantity) + 1.0f);
                Vec3 direction = RoomDetectionUtils.getVectorFromRotation(yawScaled + playerYaw, pitch + playerPitch);
                vectorList.add(eyes.func_72441_c(direction.field_72450_a * 64.0, direction.field_72448_b * 64.0, direction.field_72449_c * 64.0));
            }
        }
        return vectorList;
    }

    public static boolean blockPartOfDoorway(BlockPos blockToCheck) {
        if (blockToCheck.func_177956_o() < 66 || blockToCheck.func_177956_o() > 73) {
            return false;
        }
        int relX = Math.floorMod(blockToCheck.func_177958_n() - 8, 32);
        int relZ = Math.floorMod(blockToCheck.func_177952_p() - 8, 32);
        if (relX >= 13 && relX <= 17) {
            if (relZ <= 2) {
                return true;
            }
            if (relZ >= 28) {
                return true;
            }
        }
        if (relZ >= 13 && relZ <= 17) {
            if (relX <= 2) {
                return true;
            }
            if (relX >= 28) {
                return true;
            }
        }
        return false;
    }
}

