/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.api.query;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class RequestBuilder {
    Map<String, String> fQueryMap = new TreeMap<String, String>();

    public void clear() {
        this.fQueryMap.clear();
    }

    public boolean containsKey(String arg0) {
        return this.fQueryMap.containsKey(arg0);
    }

    public boolean containsValue(String arg0) {
        return this.fQueryMap.containsValue(arg0);
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.fQueryMap.entrySet();
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof RequestBuilder) {
            return this.fQueryMap.equals(arg0);
        }
        return false;
    }

    public String get(String arg0) {
        return this.fQueryMap.get(arg0);
    }

    public int hashCode() {
        return this.fQueryMap.hashCode();
    }

    public boolean isEmpty() {
        return this.fQueryMap.isEmpty();
    }

    public Set<String> keySet() {
        return this.fQueryMap.keySet();
    }

    public String put(String arg0, String arg1) {
        return this.fQueryMap.put(arg0, arg1);
    }

    public void putAll(Map<? extends String, ? extends String> arg0) {
        this.fQueryMap.putAll(arg0);
    }

    public String remove(String arg0) {
        return this.fQueryMap.remove(arg0);
    }

    public int size() {
        return this.fQueryMap.size();
    }

    public Collection<String> values() {
        return this.fQueryMap.values();
    }

    public RequestBuilder() {
        this.format("xml");
        this.action("query");
    }

    public static RequestBuilder create() {
        return new RequestBuilder();
    }

    public RequestBuilder format(String format2) {
        this.put("format", format2);
        return this;
    }

    public RequestBuilder action(String action) {
        this.put("action", action);
        return this;
    }

    public RequestBuilder version(String version) {
        this.put("version", version);
        return this;
    }

    public RequestBuilder maxlag(int maxlag) {
        this.put("maxlag", Integer.toString(maxlag));
        return this;
    }

    public RequestBuilder smaxage(int smaxage) {
        this.put("smaxage", Integer.toString(smaxage));
        return this;
    }

    public RequestBuilder maxage(int maxage) {
        this.put("maxage", Integer.toString(maxage));
        return this;
    }

    public RequestBuilder requestid() {
        this.put("requestid", null);
        return this;
    }

    public RequestBuilder putPipedString(String parameter, String ... pipedValues) {
        this.put(parameter, RequestBuilder.toPipedString(pipedValues));
        return this;
    }

    public RequestBuilder putPipedString(String parameter, int ... pipedValues) {
        this.put(parameter, RequestBuilder.toPipedString(pipedValues));
        return this;
    }

    public static String toPipedString(String ... pipedValues) {
        int len2 = 0;
        int max2 = -1;
        for (int i = 0; i < pipedValues.length; ++i) {
            if (pipedValues[i] == null) continue;
            ++max2;
            len2 += pipedValues[i].length() + 1;
        }
        StringBuilder buff = new StringBuilder(len2);
        for (int i = 0; i < pipedValues.length; ++i) {
            if (pipedValues[i] == null) continue;
            buff.append(pipedValues[i]);
            if (i >= max2) continue;
            buff.append('|');
        }
        return buff.toString();
    }

    public static String toPipedString(int ... pipedValues) {
        int len2 = 0;
        int max2 = -1;
        for (int i = 0; i < pipedValues.length; ++i) {
            if (pipedValues[i] < 0) continue;
            ++max2;
            len2 += pipedValues[i] / 10 + 1;
        }
        StringBuilder buff = new StringBuilder(len2);
        for (int i = 0; i < pipedValues.length; ++i) {
            if (pipedValues[i] < 0) continue;
            buff.append(Integer.toString(pipedValues[i]));
            if (i >= max2) continue;
            buff.append('|');
        }
        return buff.toString();
    }

    public String toString() {
        StringBuilder buff = new StringBuilder(256);
        int i = 0;
        for (Map.Entry<String, String> entry : this.fQueryMap.entrySet()) {
            if (i > 0) {
                buff.append("&amp;");
            }
            ++i;
            buff.append(entry.getKey());
            if (entry.getValue() == null || entry.getValue().length() <= 0) continue;
            buff.append("=");
            buff.append(entry.getValue());
        }
        return buff.toString();
    }

    public NameValuePair[] getParameters() {
        Set<Map.Entry<String, String>> set = this.fQueryMap.entrySet();
        NameValuePair[] nameValuePairs = new NameValuePair[set.size()];
        int count = 0;
        for (Map.Entry<String, String> entry : set) {
            if (entry.getValue() != null && entry.getValue().length() > 0) {
                nameValuePairs[count++] = new BasicNameValuePair(entry.getKey(), entry.getValue());
                continue;
            }
            nameValuePairs[count++] = new BasicNameValuePair(entry.getKey(), "");
        }
        return nameValuePairs;
    }
}

