/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.extensions.scribunto.engine.lua;

import info.bliki.extensions.scribunto.ScribuntoException;
import info.bliki.extensions.scribunto.engine.ScribuntoEngineBase;
import info.bliki.extensions.scribunto.engine.ScribuntoModule;
import info.bliki.extensions.scribunto.engine.lua.CompiledScriptCache;
import info.bliki.extensions.scribunto.engine.lua.ScribuntoLuaModule;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwHtml;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwInit;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwInterface;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwLanguage;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwMessage;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwSite;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwText;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwTitle;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwUri;
import info.bliki.extensions.scribunto.engine.lua.interfaces.MwUstring;
import info.bliki.extensions.scribunto.template.Frame;
import info.bliki.wiki.filter.ParsedPageName;
import info.bliki.wiki.model.IWikiModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Map;
import javax.annotation.Nonnull;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ResourceFinder;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;
import org.luaj.vm2.lib.jse.JsePlatform;

public class ScribuntoLuaEngine
extends ScribuntoEngineBase
implements MwInterface {
    private static final int MAX_EXPENSIVE_CALLS = 10;
    private static final boolean ENABLE_LUA_DEBUG_LIBRARY = false;
    private final Globals globals;
    private Frame currentFrame;
    private int expensiveFunctionCount;
    private final CompiledScriptCache compiledScriptCache;
    private final MwInterface[] interfaces;

    public ScribuntoLuaEngine(IWikiModel model, CompiledScriptCache cache) {
        this(model, cache, false);
    }

    public ScribuntoLuaEngine(IWikiModel model, CompiledScriptCache cache, boolean debug2) {
        this(model, cache, debug2 ? JsePlatform.debugGlobals() : JsePlatform.standardGlobals());
    }

    private ScribuntoLuaEngine(IWikiModel model, CompiledScriptCache compiledScriptCache, Globals globals) {
        super(model);
        this.compiledScriptCache = compiledScriptCache;
        this.globals = globals;
        this.globals.finder = new LuaResourceFinder(globals.finder);
        this.extendGlobals(globals);
        this.interfaces = new MwInterface[]{new MwSite(model), new MwUstring(), new MwTitle(model), new MwText(), new MwUri(), new MwMessage(), new MwHtml(), new MwLanguage(model)};
        try {
            this.load();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public ScribuntoModule fetchModuleFromParser(String moduleName) throws ScribuntoException {
        ParsedPageName pageName = this.pageNameForModule(moduleName);
        Prototype prototype = this.compiledScriptCache.getPrototypeForChunkname(pageName);
        if (prototype == null) {
            try (InputStream is = this.getRawWikiContentStream(pageName);){
                prototype = this.loadAndCache(is, pageName);
            }
            catch (IOException e2) {
                throw new ScribuntoException(e2);
            }
        }
        return new ScribuntoLuaModule(this, prototype, pageName);
    }

    @Override
    public String name() {
        return "mw";
    }

    protected Globals getGlobals() {
        return this.globals;
    }

    protected LuaValue loadFunction(String functionName, Prototype prototype, Frame frame) throws ScribuntoException {
        try {
            this.currentFrame = frame;
            LuaValue function = new LuaClosure(prototype, this.globals).checkfunction().call().get(functionName);
            if (function.isnil()) {
                throw new ScribuntoException("no such function '" + functionName + "'");
            }
            LuaValue luaValue = function;
            return luaValue;
        }
        catch (LuaError e2) {
            throw new ScribuntoException(e2);
        }
        finally {
            this.currentFrame = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String executeFunctionChunk(LuaValue luaFunction, Frame frame) {
        this.assertFunction(luaFunction);
        try {
            this.currentFrame = frame;
            LuaValue executeFunction = this.globals.get("mw").get("executeFunction");
            this.logger.trace("executing " + luaFunction);
            LuaString result2 = executeFunction.call(luaFunction).checkstring();
            String string = new String(result2.m_bytes, result2.m_offset, result2.m_length, UTF8);
            return string;
        }
        finally {
            this.currentFrame = null;
        }
    }

    private void assertFunction(LuaValue luaFunction) {
        if (luaFunction == null || luaFunction.isnil()) {
            throw new AssertionError((Object)"luaFunction is nil");
        }
    }

    private void load() throws IOException {
        this.load(new MwInit());
        this.load(this);
        for (MwInterface iface : this.interfaces) {
            this.load(iface);
        }
        this.stubTitleBlacklist();
        this.stubExecuteModule();
        this.stubWikiBase();
    }

    private void stubTitleBlacklist() {
        LuaValue mw = this.globals.get("mw");
        LuaValue ext = mw.get("ext");
        if (ext.isnil()) {
            ext = new LuaTable();
            mw.set("ext", ext);
        }
        LuaTable blacklist = new LuaTable();
        blacklist.set("test", (LuaValue)new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue action, LuaValue title) {
                return NIL;
            }
        });
        ext.set("TitleBlacklist", (LuaValue)blacklist);
    }

    private void stubExecuteModule() {
        LuaValue mw = this.globals.get("mw");
        mw.set("executeModule", (LuaValue)new VarArgFunction(){

            @Override
            public Varargs invoke(Varargs args) {
                LuaFunction chunk = args.arg(1).checkfunction();
                LuaValue name = args.arg(2);
                LuaValue res = chunk.call();
                if (name.isnil()) {
                    return LuaValue.varargsOf(new LuaValue[]{LuaValue.TRUE, res});
                }
                if (!res.istable()) {
                    return LuaValue.varargsOf(new LuaValue[]{FALSE, ScribuntoLuaEngine.toLuaString(res.typename())});
                }
                return LuaValue.varargsOf(new LuaValue[]{LuaValue.TRUE, res.checktable().get(name)});
            }
        });
    }

    private void stubWikiBase() {
        LuaValue mw = this.globals.get("mw");
        LuaTable wikibase = new LuaTable();
        wikibase.set("getEntity", (LuaValue)new ZeroArgFunction(){

            @Override
            public LuaValue call() {
                return NIL;
            }
        });
        wikibase.set("getEntityObject", (LuaValue)new ZeroArgFunction(){

            @Override
            public LuaValue call() {
                return NIL;
            }
        });
        mw.set("wikibase", (LuaValue)wikibase);
    }

    private void load(MwInterface luaInterface) throws IOException {
        String filename = this.fileNameForInterface(luaInterface);
        try (InputStream is = this.globals.finder.findResource(filename);){
            if (is == null) {
                throw new FileNotFoundException("could not find '" + filename + "'. Make sure it is on the classpath.");
            }
            LuaValue pkg = this.globals.load(is, "@" + filename, "bt", this.globals).call();
            LuaValue setupInterface = pkg.get("setupInterface");
            if (!setupInterface.isnil()) {
                this.globals.set("mw_interface", (LuaValue)luaInterface.getInterface());
                setupInterface.call(luaInterface.getSetupOptions());
            }
        }
    }

    @Override
    public LuaTable getInterface() {
        LuaTable table = new LuaTable();
        table.set("loadPackage", (LuaValue)this.loadPackage());
        table.set("loadPHPLibrary", (LuaValue)this.loadPHPLibrary());
        table.set("frameExists", this.frameExists());
        table.set("newChildFrame", this.newChildFrame());
        table.set("getExpandedArgument", this.getExpandedArgument());
        table.set("getAllExpandedArguments", this.getAllExpandedArguments());
        table.set("getFrameTitle", this.getFrameTitle());
        table.set("expandTemplate", this.expandTemplate());
        table.set("callParserFunction", this.callParserFunction());
        table.set("preprocess", this.preprocess());
        table.set("incrementExpensiveFunctionCount", this.incrementExpensiveFunctionCount());
        table.set("isSubsting", this.isSubsting());
        return table;
    }

    private String fileNameForInterface(MwInterface luaInterface) {
        return luaInterface.name() + (luaInterface.name().endsWith(".lua") ? "" : ".lua");
    }

    private LuaValue callParserFunction() {
        return new ThreeArgFunction(){

            @Override
            public LuaValue call(LuaValue frameId, LuaValue function, LuaValue args) {
                if ("filepath".equals(function.checkjstring())) {
                    String path = args.get(1).checkjstring();
                    return ScribuntoLuaEngine.toLuaString(path);
                }
                return LuaValue.NIL;
            }
        };
    }

    private LuaValue isSubsting() {
        return new ZeroArgFunction(){

            @Override
            public LuaValue call() {
                return LuaValue.valueOf(ScribuntoLuaEngine.this.getFrameById(ScribuntoLuaEngine.toLuaString("current")).isSubsting());
            }
        };
    }

    private LuaValue incrementExpensiveFunctionCount() {
        return new ZeroArgFunction(){

            @Override
            public LuaValue call() {
                if (++ScribuntoLuaEngine.this.expensiveFunctionCount > 10) {
                    7.error("too many expensive function calls");
                }
                return NIL;
            }
        };
    }

    private LuaValue preprocess() {
        return new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue frameId, LuaValue text) {
                try {
                    return ScribuntoLuaEngine.toLuaString(ScribuntoLuaEngine.this.model.render(text.checkjstring()));
                }
                catch (IOException e2) {
                    ScribuntoLuaEngine.this.logger.error("error rendering", e2);
                    return LuaValue.NIL;
                }
            }
        };
    }

    private LuaValue expandTemplate() {
        return new ThreeArgFunction(){

            @Override
            public LuaValue call(LuaValue frameId, LuaValue title, LuaValue args) {
                Varargs next2;
                Frame frame = ScribuntoLuaEngine.this.getFrameById(frameId);
                Map<String, String> parameterMap = frame.getTemplateParameters();
                LuaTable table = args.checktable();
                LuaValue key = LuaValue.NIL;
                while (!(key = (next2 = table.next(key)).arg1()).isnil()) {
                    LuaValue value = next2.arg(2);
                    parameterMap.put(key.checkjstring(), value.checkjstring());
                }
                StringWriter writer = new StringWriter();
                try {
                    ScribuntoLuaEngine.this.model.substituteTemplateCall(title.tojstring(), parameterMap, writer);
                    return ScribuntoLuaEngine.toLuaString(writer.toString());
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    private LuaValue getExpandedArgument() {
        return new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue frameId, LuaValue name) {
                return ScribuntoLuaEngine.this.getFrameById(frameId).getArgument(name.tojstring());
            }
        };
    }

    private Frame getFrameById(LuaValue frameId) {
        if (this.currentFrame == null) {
            throw new AssertionError((Object)("No current frame set: " + frameId));
        }
        Frame frame = frameId.tojstring().equals("parent") ? this.currentFrame.getParent() : this.currentFrame;
        if (frame == null) {
            throw new AssertionError((Object)("No frame set: " + frameId));
        }
        return frame;
    }

    private LuaValue getFrameTitle() {
        return new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue arg) {
                return ScribuntoLuaEngine.toLuaString(ScribuntoLuaEngine.this.getFrameById(arg).getTitle());
            }
        };
    }

    private LuaValue getAllExpandedArguments() {
        return new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue frameId) {
                return ScribuntoLuaEngine.this.getFrameById(frameId).getAllArguments();
            }
        };
    }

    private LuaValue newChildFrame() {
        return new ThreeArgFunction(){

            @Override
            public LuaValue call(LuaValue frameId, LuaValue title, LuaValue args) {
                return NIL;
            }
        };
    }

    private LuaValue frameExists() {
        return new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue arg) {
                return TRUE;
            }
        };
    }

    private OneArgFunction loadPackage() {
        return new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue packageName) {
                return ScribuntoLuaEngine.this.loadModule(ScribuntoLuaEngine.this.pageNameForModule(packageName.tojstring()));
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LuaValue loadModule(ParsedPageName chunkName) throws LuaError {
        Prototype prototype = this.compiledScriptCache.getPrototypeForChunkname(chunkName);
        if (prototype != null) {
            return new LuaClosure(prototype, this.globals);
        }
        try (InputStream is = this.findPackage(chunkName);){
            LuaClosure luaClosure = new LuaClosure(this.loadAndCache(is, chunkName), this.globals);
            return luaClosure;
        }
        catch (ScribuntoException | IOException e2) {
            this.logger.error("error loading '" + chunkName + "'", e2);
            throw new LuaError(e2);
        }
    }

    private Prototype loadAndCache(InputStream code, ParsedPageName chunkName) throws ScribuntoException {
        try {
            this.logger.debug("compiling " + chunkName);
            Prototype prototype = this.globals.compilePrototype(code, chunkName.fullPagename());
            this.compiledScriptCache.cachePrototype(chunkName, prototype);
            return prototype;
        }
        catch (IOException | LuaError e2) {
            throw new ScribuntoException(e2);
        }
    }

    private OneArgFunction loadPHPLibrary() {
        return new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue arg) {
                return LuaValue.NIL;
            }
        };
    }

    @Nonnull
    private InputStream findPackage(ParsedPageName name) throws IOException {
        this.logger.debug("findPackage(" + name + ")");
        InputStream is = this.globals.finder.findResource(name.pagename + ".lua");
        if (is != null) {
            return is;
        }
        return this.findModule(name);
    }

    private InputStream findModule(ParsedPageName moduleName) throws IOException {
        String name = moduleName.pagename.replaceAll("[/:]", "_");
        InputStream is = this.globals.finder.findResource(name);
        if (is != null) {
            return is;
        }
        return this.getRawWikiContentStream(moduleName);
    }

    @Override
    public LuaValue getSetupOptions() {
        return new LuaTable();
    }

    private void extendGlobals(final Globals globals) {
        globals.set("setfenv", (LuaValue)new TwoArgFunction(){

            @Override
            public LuaValue call(LuaValue f, LuaValue env) {
                return f;
            }
        });
        globals.set("gefenv", (LuaValue)new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue f) {
                return globals;
            }
        });
        globals.set("unpack", (LuaValue)new unpack());
        LuaValue math = globals.get("math");
        math.set("log10", (LuaValue)new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue luaValue) {
                return 19.valueOf(Math.log10(luaValue.checkdouble()));
            }
        });
        LuaValue table = globals.get("table");
        table.set("maxn", (LuaValue)new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue arg) {
                return arg.checktable().len();
            }
        });
        table.set("getn", (LuaValue)new OneArgFunction(){

            @Override
            public LuaValue call(LuaValue arg) {
                if (arg.isnil()) {
                    return LuaValue.error("bad argument #1 to 'getn' (table expected, got nil)");
                }
                return arg.checktable().len();
            }
        });
    }

    public static LuaString toLuaString(String string) {
        return LuaString.valueOf(string.getBytes(UTF8));
    }

    static class LuaResourceFinder
    implements ResourceFinder {
        private static final String[] LIBRARY_PATH = new String[]{"", "luabit", "ustring"};
        private final ResourceFinder delegate;

        LuaResourceFinder(ResourceFinder delegate) {
            this.delegate = delegate;
        }

        @Override
        public InputStream findResource(String filename) {
            for (String path : LIBRARY_PATH) {
                InputStream is = this.delegate.findResource(path + "/" + filename);
                if (is == null) continue;
                return is;
            }
            return null;
        }
    }

    private static class unpack
    extends VarArgFunction {
        private unpack() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaTable t = args.checktable(1);
            switch (args.narg()) {
                case 1: {
                    return t.unpack();
                }
                case 2: {
                    return t.unpack(args.checkint(2));
                }
            }
            return t.unpack(args.checkint(2), args.checkint(3));
        }
    }
}

