/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.htmlcleaner;

import info.bliki.htmlcleaner.BaseToken;
import info.bliki.htmlcleaner.CompactXmlSerializer;
import info.bliki.htmlcleaner.ContentToken;
import info.bliki.htmlcleaner.DoctypeToken;
import info.bliki.htmlcleaner.EndTagToken;
import info.bliki.htmlcleaner.HtmlTagProvider;
import info.bliki.htmlcleaner.HtmlTokenizer;
import info.bliki.htmlcleaner.ITagInfoProvider;
import info.bliki.htmlcleaner.PrettyXmlSerializer;
import info.bliki.htmlcleaner.SimpleXmlSerializer;
import info.bliki.htmlcleaner.TagInfo;
import info.bliki.htmlcleaner.TagNode;
import info.bliki.htmlcleaner.Utils;
import info.bliki.htmlcleaner.XmlSerializer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class HtmlCleaner {
    public static final String DEFAULT_CHARSET = System.getProperty("file.encoding");
    private static final int WRITE_METHOD_SIMPLE = 0;
    private static final int WRITE_METHOD_COMPACT = 1;
    private static final int WRITE_METHOD_PRETTY = 2;
    private ITagInfoProvider tagInfoProvider;
    private Reader reader;
    private transient OpenTags _openTags = new OpenTags();
    private transient DoctypeToken _docType = null;
    private Set<String> allTags = new TreeSet<String>();
    private boolean advancedXmlEscape = true;
    private boolean useCdataForScriptAndStyle = true;
    private boolean translateSpecialEntities = true;
    private boolean recognizeUnicodeChars = true;
    private boolean omitUnknownTags = false;
    private boolean omitDeprecatedTags = false;
    private boolean omitComments = false;
    private boolean omitXmlDeclaration = false;
    private boolean omitDoctypeDeclaration = true;
    private boolean omitXmlnsAttributes = false;
    private String hyphenReplacementInComment = "=";
    private TagNode htmlNode;
    private TagNode bodyNode;
    private TagNode headNode;

    public HtmlCleaner(String htmlContent, ITagInfoProvider tagInfoProvider) {
        this.reader = new StringReader(htmlContent);
        this.tagInfoProvider = tagInfoProvider == null ? HtmlTagProvider.getInstance() : tagInfoProvider;
    }

    public HtmlCleaner(String htmlContent) {
        this(htmlContent, (ITagInfoProvider)HtmlTagProvider.getInstance());
    }

    public HtmlCleaner(File file, String charset, ITagInfoProvider tagInfoProvider) throws IOException {
        FileInputStream in = new FileInputStream(file);
        this.reader = new InputStreamReader((InputStream)in, charset);
        this.tagInfoProvider = tagInfoProvider == null ? HtmlTagProvider.getInstance() : tagInfoProvider;
    }

    public HtmlCleaner(File file, String charset) throws IOException {
        this(file, charset, (ITagInfoProvider)HtmlTagProvider.getInstance());
    }

    public HtmlCleaner(File file, ITagInfoProvider tagInfoProvider) throws IOException {
        this(file, DEFAULT_CHARSET, tagInfoProvider);
    }

    public HtmlCleaner(File file) throws IOException {
        this(file, DEFAULT_CHARSET, (ITagInfoProvider)HtmlTagProvider.getInstance());
    }

    public HtmlCleaner(URL url, String charset, ITagInfoProvider tagInfoProvider) throws IOException {
        StringBuffer content = Utils.readUrl(url, charset);
        this.reader = new StringReader(content.toString());
        this.tagInfoProvider = tagInfoProvider == null ? HtmlTagProvider.getInstance() : tagInfoProvider;
    }

    public HtmlCleaner(URL url, ITagInfoProvider tagInfoProvider) throws IOException {
        this(url, DEFAULT_CHARSET, tagInfoProvider);
    }

    public HtmlCleaner(URL url, String charset) throws IOException {
        this(url, charset, (ITagInfoProvider)HtmlTagProvider.getInstance());
    }

    public HtmlCleaner(URL url) throws IOException {
        this(url, DEFAULT_CHARSET, (ITagInfoProvider)HtmlTagProvider.getInstance());
    }

    public HtmlCleaner(InputStream in, ITagInfoProvider tagInfoProvider) {
        this.reader = new InputStreamReader(in);
        this.tagInfoProvider = tagInfoProvider == null ? HtmlTagProvider.getInstance() : tagInfoProvider;
    }

    public HtmlCleaner(InputStream in) {
        this(in, (ITagInfoProvider)HtmlTagProvider.getInstance());
    }

    DoctypeToken getDoctype() {
        return this._docType;
    }

    void setDoctype(DoctypeToken type2) {
        this._docType = type2;
    }

    public HtmlCleaner(InputStream in, String charset) throws IOException {
        this.reader = new InputStreamReader(in, charset);
    }

    public void clean() throws IOException {
        this.allTags.clear();
        this.htmlNode = new TagNode("html");
        this.bodyNode = new TagNode("body");
        this.headNode = new TagNode("head");
        this.htmlNode.addChild(this.headNode);
        this.htmlNode.addChild(this.bodyNode);
        HtmlTokenizer htmlTokenizer = new HtmlTokenizer(this);
        htmlTokenizer.start();
        List<BaseToken> nodeList = htmlTokenizer.getTokenList();
        this.closeAll(nodeList);
        this.createDocumentNodes(nodeList);
    }

    public List<BaseToken> getNodeList() throws IOException {
        this.allTags.clear();
        if (this.htmlNode == null) {
            this.htmlNode = new TagNode("html");
            this.bodyNode = new TagNode("body");
            this.headNode = new TagNode("head");
            this.htmlNode.addChild(this.headNode);
            this.htmlNode.addChild(this.bodyNode);
        }
        HtmlTokenizer htmlTokenizer = new HtmlTokenizer(this);
        htmlTokenizer.start();
        List<BaseToken> nodeList = htmlTokenizer.getTokenList();
        this.closeAll(nodeList);
        return nodeList;
    }

    Reader getReader() {
        return this.reader;
    }

    private void addAttributesToTag(TagNode tag, Map<String, String> attributes) {
        if (attributes != null) {
            Map<String, String> tagAttributes = tag.getAttributes();
            for (Map.Entry<String, String> currEntry : attributes.entrySet()) {
                String attName = currEntry.getKey();
                if (tagAttributes.containsKey(attName)) continue;
                String attValue = currEntry.getValue();
                tag.addAttribute(attName, attValue, true);
            }
        }
    }

    private boolean isFatalTagSatisfied(TagInfo tag) {
        if (tag != null) {
            String fatalTagName = tag.getFatalTag();
            return fatalTagName == null ? true : this._openTags.tagExists(fatalTagName);
        }
        return true;
    }

    private boolean mustAddRequiredParent(TagInfo tag) {
        String requiredParent;
        if (tag != null && (requiredParent = tag.getRequiredParent()) != null) {
            TagPos tagPos;
            String fatalTag = tag.getFatalTag();
            int fatalTagPositon = -1;
            if (fatalTag != null && (tagPos = this._openTags.findTag(fatalTag)) != null) {
                fatalTagPositon = tagPos.position;
            }
            ListIterator it = this._openTags.list.listIterator(this._openTags.list.size());
            while (it.hasPrevious()) {
                TagPos currTagPos = (TagPos)it.previous();
                if (!tag.isHigher(currTagPos.name)) continue;
                return currTagPos.position <= fatalTagPositon;
            }
            return true;
        }
        return false;
    }

    private TagNode createTagNode(TagNode startTagToken) {
        startTagToken.setFormed();
        return startTagToken;
    }

    private boolean isAllowedInLastOpenTag(BaseToken token) {
        TagPos last = this._openTags.getLastTagPos();
        if (last != null && last.info != null) {
            return last.info.allowsItem(token);
        }
        return true;
    }

    private void saveToLastOpenTag(List<BaseToken> nodeList, BaseToken tokenToAdd) {
        TagPos last = this._openTags.getLastTagPos();
        if (last != null && last.info != null && last.info.isIgnorePermitted()) {
            return;
        }
        TagPos rubbishPos = this._openTags.findTagToPlaceRubbish();
        if (rubbishPos != null) {
            TagNode startTagToken = (TagNode)nodeList.get(rubbishPos.position);
            startTagToken.addItemForMoving(tokenToAdd);
        }
    }

    private boolean isStartToken(Object o) {
        return o instanceof TagNode && !((TagNode)o).isFormed();
    }

    void makeTree(List<BaseToken> nodeList, ListIterator<BaseToken> nodeIterator) {
        while (nodeIterator.hasNext()) {
            TagInfo tag;
            String tagName;
            BaseToken token = nodeIterator.next();
            if (token instanceof EndTagToken) {
                EndTagToken endTagToken = (EndTagToken)token;
                tagName = endTagToken.getName();
                tag = this.tagInfoProvider.getTagInfo(tagName);
                if (tag == null && this.omitUnknownTags || tag != null && tag.isDeprecated() && this.omitDeprecatedTags) {
                    nodeIterator.set(null);
                    continue;
                }
                if (tag != null && !tag.allowsBody()) {
                    nodeIterator.set(null);
                    continue;
                }
                TagPos matchingPosition = this._openTags.findTag(tagName);
                if (matchingPosition != null) {
                    this.closeSnippet(nodeList, matchingPosition, endTagToken);
                } else if (!this.isAllowedInLastOpenTag(token)) {
                    this.saveToLastOpenTag(nodeList, token);
                }
                nodeIterator.set(null);
                continue;
            }
            if (this.isStartToken(token)) {
                TagNode startTagToken = (TagNode)token;
                tagName = startTagToken.getName();
                tag = this.tagInfoProvider.getTagInfo(tagName);
                this.allTags.add(tagName);
                if ("html".equals(tagName)) {
                    this.addAttributesToTag(this.htmlNode, startTagToken.getAttributes());
                    nodeIterator.set(null);
                    continue;
                }
                if ("body".equals(tagName)) {
                    this.addAttributesToTag(this.bodyNode, startTagToken.getAttributes());
                    nodeIterator.set(null);
                    continue;
                }
                if ("head".equals(tagName)) {
                    this.addAttributesToTag(this.headNode, startTagToken.getAttributes());
                    nodeIterator.set(null);
                    continue;
                }
                if (tag == null && this.omitUnknownTags || tag != null && tag.isDeprecated() && this.omitDeprecatedTags) {
                    nodeIterator.set(null);
                    continue;
                }
                if (tag != null && tag.hasPermittedTags() && this._openTags.someAlreadyOpen(tag.getPermittedTags())) {
                    nodeIterator.set(null);
                    continue;
                }
                if (tag != null && tag.isUnique() && this._openTags.tagEncountered(tagName)) {
                    nodeIterator.set(null);
                    continue;
                }
                if (!this.isFatalTagSatisfied(tag)) {
                    nodeIterator.set(null);
                    continue;
                }
                if (this.mustAddRequiredParent(tag)) {
                    String requiredParent = tag.getRequiredParent();
                    TagNode requiredParentStartToken = new TagNode(requiredParent);
                    nodeIterator.previous();
                    nodeIterator.add(requiredParentStartToken);
                    nodeIterator.previous();
                    continue;
                }
                if (tag != null && !this._openTags.isEmpty() && tag.isMustCloseTag(this.tagInfoProvider.getTagInfo(this._openTags.getLastTagPos().name))) {
                    List<TagNode> closed = this.closeSnippet(nodeList, this._openTags.getLastTagPos(), startTagToken);
                    int closedCount = closed.size();
                    if (tag.hasCopyTags() && closedCount > 0) {
                        TagNode currStartToken;
                        ListIterator<TagNode> closedIt = closed.listIterator(closedCount);
                        ArrayList<TagNode> toBeCopied = new ArrayList<TagNode>();
                        while (closedIt.hasPrevious() && tag.isCopy((currStartToken = closedIt.previous()).getName())) {
                            toBeCopied.add(0, currStartToken);
                        }
                        if (toBeCopied.size() > 0) {
                            for (TagNode currStartToken2 : toBeCopied) {
                                nodeIterator.add(currStartToken2.makeCopy());
                            }
                            for (int i = 0; i < toBeCopied.size(); ++i) {
                                nodeIterator.previous();
                            }
                        }
                    }
                    nodeIterator.previous();
                    continue;
                }
                if (!this.isAllowedInLastOpenTag(token)) {
                    this.saveToLastOpenTag(nodeList, token);
                    nodeIterator.set(null);
                    continue;
                }
                if (tag != null && !tag.allowsBody()) {
                    TagNode newTagNode = this.createTagNode(startTagToken);
                    if (tag.isHeadTag()) {
                        this.headNode.addChild(newTagNode);
                        nodeIterator.set(null);
                        continue;
                    }
                    nodeIterator.set(newTagNode);
                    continue;
                }
                this._openTags.addTag(tagName, nodeIterator.previousIndex());
                continue;
            }
            if (this.isAllowedInLastOpenTag(token)) continue;
            this.saveToLastOpenTag(nodeList, token);
            nodeIterator.set(null);
        }
    }

    private void createDocumentNodes(List<? extends Object> listNodes) {
        for (Object object : listNodes) {
            if (object == null) continue;
            TagNode parent = this.bodyNode;
            boolean toAdd = true;
            if (object instanceof TagNode) {
                TagInfo tag = this.tagInfoProvider.getTagInfo(((TagNode)object).getName());
                if (tag != null && (tag.isHeadTag() || tag.isHeadAndBodyTag() && this.bodyNode.getChildren().isEmpty())) {
                    parent = this.headNode;
                }
            } else if (object instanceof ContentToken) {
                boolean bl = toAdd = !"".equals(((ContentToken)object).getContent());
            }
            if (!toAdd) continue;
            parent.addChild(object);
        }
    }

    private List<TagNode> closeSnippet(List<? extends Object> nodeList, TagPos tagPos, Object toNode) {
        ArrayList<TagNode> closed = new ArrayList<TagNode>();
        ListIterator<? extends Object> it = nodeList.listIterator(tagPos.position);
        TagNode tagNode = null;
        Object item = it.next();
        boolean isListEnd = false;
        while (toNode == null && !isListEnd || toNode != null && item != toNode) {
            if (this.isStartToken(item)) {
                TagNode newTagNode;
                TagInfo tag;
                TagNode startTagToken = (TagNode)item;
                closed.add(startTagToken);
                List<BaseToken> itemsToMove = startTagToken.getItemsToMove();
                if (itemsToMove != null) {
                    OpenTags prevOpenTags = this._openTags;
                    this._openTags = new OpenTags();
                    this.makeTree(itemsToMove, itemsToMove.listIterator(0));
                    this.closeAll(itemsToMove);
                    startTagToken.setItemsToMove(null);
                    this._openTags = prevOpenTags;
                }
                if ((tag = this.tagInfoProvider.getTagInfo((newTagNode = this.createTagNode(startTagToken)).getName())) != null && tag.isHeadTag()) {
                    this.headNode.addChild(newTagNode);
                    it.set(null);
                } else if (tagNode != null) {
                    tagNode.addChildren(itemsToMove);
                    tagNode.addChild(newTagNode);
                    it.set(null);
                } else if (itemsToMove != null) {
                    itemsToMove.add(newTagNode);
                    it.set(itemsToMove);
                } else {
                    it.set(newTagNode);
                }
                this._openTags.removeTag(newTagNode.getName());
                tagNode = newTagNode;
            } else if (tagNode != null) {
                it.set(null);
                if (item != null) {
                    tagNode.addChild(item);
                }
            }
            if (it.hasNext()) {
                item = it.next();
                continue;
            }
            isListEnd = true;
        }
        return closed;
    }

    private void closeAll(List<? extends Object> nodeList) {
        TagPos firstTagPos = this._openTags.findFirstTagPos();
        if (firstTagPos != null) {
            this.closeSnippet(nodeList, firstTagPos, null);
        }
    }

    public boolean isOmitUnknownTags() {
        return this.omitUnknownTags;
    }

    public void setOmitUnknownTags(boolean omitUnknownTags) {
        this.omitUnknownTags = omitUnknownTags;
    }

    public boolean isOmitDeprecatedTags() {
        return this.omitDeprecatedTags;
    }

    public void setOmitDeprecatedTags(boolean omitDeprecatedTags) {
        this.omitDeprecatedTags = omitDeprecatedTags;
    }

    public boolean isAdvancedXmlEscape() {
        return this.advancedXmlEscape;
    }

    public void setAdvancedXmlEscape(boolean advancedXmlEscape) {
        this.advancedXmlEscape = advancedXmlEscape;
    }

    public boolean isUseCdataForScriptAndStyle() {
        return this.useCdataForScriptAndStyle;
    }

    public void setUseCdataForScriptAndStyle(boolean useCdataForScriptAndStyle) {
        this.useCdataForScriptAndStyle = useCdataForScriptAndStyle;
    }

    public boolean isTranslateSpecialEntities() {
        return this.translateSpecialEntities;
    }

    public void setTranslateSpecialEntities(boolean translateSpecialEntities) {
        this.translateSpecialEntities = translateSpecialEntities;
    }

    public boolean isRecognizeUnicodeChars() {
        return this.recognizeUnicodeChars;
    }

    public void setRecognizeUnicodeChars(boolean recognizeUnicodeChars) {
        this.recognizeUnicodeChars = recognizeUnicodeChars;
    }

    public boolean isOmitComments() {
        return this.omitComments;
    }

    public void setOmitComments(boolean omitComments) {
        this.omitComments = omitComments;
    }

    public boolean isOmitXmlDeclaration() {
        return this.omitXmlDeclaration;
    }

    public void setOmitXmlDeclaration(boolean omitXmlDeclaration) {
        this.omitXmlDeclaration = omitXmlDeclaration;
    }

    public boolean isOmitDoctypeDeclaration() {
        return this.omitDoctypeDeclaration;
    }

    public void setOmitDoctypeDeclaration(boolean omitDoctypeDeclaration) {
        this.omitDoctypeDeclaration = omitDoctypeDeclaration;
    }

    public boolean isOmitXmlnsAttributes() {
        return this.omitXmlnsAttributes;
    }

    public void setOmitXmlnsAttributes(boolean omitXmlnsAttributes) {
        this.omitXmlnsAttributes = omitXmlnsAttributes;
    }

    public String getHyphenReplacementInComment() {
        return this.hyphenReplacementInComment;
    }

    public void setHyphenReplacementInComment(String hyphenReplacementInComment) {
        this.hyphenReplacementInComment = hyphenReplacementInComment;
    }

    public Set<String> getAllTags() {
        return this.allTags;
    }

    public void writeXml(XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.createXml(this.htmlNode);
    }

    private void writeXml(Writer writer, int method) throws IOException {
        XmlSerializer xmlSerializer = null;
        xmlSerializer = 1 == method ? new CompactXmlSerializer(writer, this) : (2 == method ? new PrettyXmlSerializer(writer, this) : new SimpleXmlSerializer(writer, this));
        xmlSerializer.createXml(this.htmlNode);
    }

    private void writeToStream(OutputStream out, String charset, int method) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, charset));
        this.writeXml(writer, method);
    }

    private void writeToStream(OutputStream out, int method) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        this.writeXml(writer, method);
    }

    public void writeXmlToStream(OutputStream out) throws IOException {
        this.writeToStream(out, 0);
    }

    public void writeXmlToStream(OutputStream out, String charset) throws IOException {
        this.writeToStream(out, charset, 0);
    }

    public void writeCompactXmlToStream(OutputStream out) throws IOException {
        this.writeToStream(out, 1);
    }

    public void writeCompactXmlToStream(OutputStream out, String charset) throws IOException {
        this.writeToStream(out, charset, 1);
    }

    public void writePrettyXmlToStream(OutputStream out) throws IOException {
        this.writeToStream(out, 2);
    }

    public void writePrettyXmlToStream(OutputStream out, String charset) throws IOException {
        this.writeToStream(out, charset, 2);
    }

    private void writeToFile(String fileName, String charset, int method) throws IOException {
        this.writeToStream(new FileOutputStream(fileName), charset, method);
    }

    private void writeToFile(String fileName, int method) throws IOException {
        this.writeToStream(new FileOutputStream(fileName), method);
    }

    public void writeXmlToFile(String fileName) throws IOException {
        this.writeToFile(fileName, 0);
    }

    public void writeXmlToFile(String fileName, String charset) throws IOException {
        this.writeToFile(fileName, charset, 0);
    }

    public void writeCompactXmlToFile(String fileName) throws IOException {
        this.writeToFile(fileName, 1);
    }

    public void writeCompactXmlToFile(String fileName, String charset) throws IOException {
        this.writeToFile(fileName, charset, 1);
    }

    public void writePrettyXmlToFile(String fileName) throws IOException {
        this.writeToFile(fileName, 2);
    }

    public void writePrettyXmlToFile(String fileName, String charset) throws IOException {
        this.writeToFile(fileName, charset, 2);
    }

    public String getXmlAsString() throws IOException {
        StringWriter writer = new StringWriter();
        this.writeXml(writer, 0);
        return writer.getBuffer().toString();
    }

    public String getCompactXmlAsString() throws IOException {
        StringWriter writer = new StringWriter();
        this.writeXml(writer, 1);
        return writer.getBuffer().toString();
    }

    public String getPrettyXmlAsString() throws IOException {
        StringWriter writer = new StringWriter();
        this.writeXml(writer, 2);
        return writer.getBuffer().toString();
    }

    public TagNode getBodyNode() {
        return this.bodyNode;
    }

    public void setBodyNode(TagNode bodyNode) {
        this.bodyNode = bodyNode;
    }

    private class OpenTags {
        private List<TagPos> list = new ArrayList<TagPos>();
        private TagPos last = null;
        private Set<String> set = new HashSet<String>();

        private OpenTags() {
        }

        private boolean isEmpty() {
            return this.list.isEmpty();
        }

        private void addTag(String tagName, int position) {
            this.last = new TagPos(position, tagName);
            this.list.add(this.last);
            this.set.add(tagName);
        }

        private void removeTag(String tagName) {
            ListIterator<TagPos> it = this.list.listIterator(this.list.size());
            while (it.hasPrevious()) {
                TagPos currTagPos = it.previous();
                if (!tagName.equals(currTagPos.name)) continue;
                it.remove();
                break;
            }
            this.last = this.list.isEmpty() ? null : this.list.get(this.list.size() - 1);
        }

        private TagPos findFirstTagPos() {
            return this.list.isEmpty() ? null : this.list.get(0);
        }

        private TagPos getLastTagPos() {
            return this.last;
        }

        private TagPos findTag(String tagName) {
            if (tagName != null) {
                ListIterator<TagPos> it = this.list.listIterator(this.list.size());
                while (it.hasPrevious()) {
                    TagPos currTagPos = it.previous();
                    if (!tagName.equals(currTagPos.name)) continue;
                    return currTagPos;
                }
            }
            return null;
        }

        private boolean tagExists(String tagName) {
            TagPos tagPos = this.findTag(tagName);
            return tagPos != null;
        }

        private TagPos findTagToPlaceRubbish() {
            TagPos result2 = null;
            TagPos prev = null;
            if (!this.isEmpty()) {
                ListIterator<TagPos> it = this.list.listIterator(this.list.size());
                while (it.hasPrevious()) {
                    result2 = it.previous();
                    if ((result2.info == null || result2.info.allowsAnything()) && prev != null) {
                        return prev;
                    }
                    prev = result2;
                }
            }
            return result2;
        }

        private boolean tagEncountered(String tagName) {
            return this.set.contains(tagName);
        }

        private boolean someAlreadyOpen(Set<String> tags) {
            for (TagPos curr : this.list) {
                if (!tags.contains(curr.name)) continue;
                return true;
            }
            return false;
        }
    }

    private class TagPos {
        private int position;
        private String name;
        private TagInfo info;

        TagPos(int position, String name) {
            this.position = position;
            this.name = name;
            this.info = HtmlCleaner.this.tagInfoProvider.getTagInfo(name);
        }
    }
}

