/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.wiki.filter.Util;
import info.bliki.wiki.filter.WikipediaScanner;
import info.bliki.wiki.tags.util.WikiTagNode;

public abstract class AbstractParser
extends WikipediaScanner {
    protected char fCurrentCharacter = '\u0000';
    protected int fCurrentPosition = 0;
    protected boolean fWhiteStart = false;
    protected int fWhiteStartPosition = 0;

    public AbstractParser(String stringSource) {
        super(stringSource);
    }

    protected final boolean readUntil(String untilString) {
        int index = this.fStringSource.indexOf(untilString, this.fCurrentPosition);
        if (index != -1) {
            this.fCurrentPosition = index + untilString.length();
            return true;
        }
        this.fCurrentPosition = this.fStringSource.length();
        return false;
    }

    protected final int readUntilIgnoreCase(String startString, String endString) {
        int index = Util.indexOfIgnoreCase(this.fStringSource, startString, endString, this.fCurrentPosition);
        if (index != -1) {
            this.fCurrentPosition = index + startString.length() + endString.length();
            return startString.length() + endString.length();
        }
        this.fCurrentPosition = this.fStringSource.length();
        return 0;
    }

    protected int readUntilNestedIgnoreCase(WikiTagNode node) {
        if (node.isEmptyXmlTag()) {
            this.fCurrentPosition = node.getEndPosition();
            return node.getEndPosition() - node.getStartPosition();
        }
        return this.readUntilNestedIgnoreCase(node.getTagName() + ">");
    }

    private int readUntilNestedIgnoreCase(String endString) {
        int index = Util.indexOfNestedIgnoreCase(this.fStringSource, endString, this.fCurrentPosition);
        if (index != -1) {
            this.fCurrentPosition = index + 2 + endString.length();
            return 2 + endString.length();
        }
        this.fCurrentPosition = this.fStringSource.length();
        return 0;
    }

    protected final boolean readUntilCharOrStopAtEOL(char testedChar) {
        int temp = this.fCurrentPosition;
        boolean attrMode = false;
        try {
            while ((this.fCurrentCharacter = this.fSource[this.fCurrentPosition++]) != testedChar) {
                if (attrMode) {
                    if (this.fCurrentCharacter != '\"') continue;
                    attrMode = false;
                    continue;
                }
                if (this.fCurrentCharacter == '\n' || this.fCurrentCharacter == '\r') {
                    return false;
                }
                if (this.fCurrentCharacter != '\"') continue;
                attrMode = true;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e2) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    protected boolean isEmptyLine(int diff) {
        int temp = this.fCurrentPosition - diff;
        try {
            char ch;
            do {
                if (Character.isWhitespace(ch = this.fSource[temp++])) continue;
                return false;
            } while (ch != '\n');
            return true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return true;
        }
    }

    protected int consumeWhitespace() {
        char ch;
        int temp;
        if (!Character.isWhitespace(this.fSource[this.fCurrentPosition + 1])) {
            return -1;
        }
        for (temp = this.fCurrentPosition + 1; this.fSource.length > temp && Character.isWhitespace(ch = this.fSource[temp]); ++temp) {
        }
        this.fCurrentPosition = temp - 1;
        return temp;
    }

    protected int readWhitespaceUntilEndOfLine(int diff) {
        int temp;
        for (temp = this.fCurrentPosition - diff; this.fSource.length > temp; ++temp) {
            char ch = this.fSource[temp];
            if (!Character.isWhitespace(ch)) {
                return -1;
            }
            if (ch != '\n') continue;
            this.fCurrentPosition = temp;
            return temp;
        }
        this.fCurrentPosition = temp - 1;
        return temp;
    }

    protected int readWhitespaceUntilStartOfLine(int diff) {
        int temp;
        for (temp = this.fCurrentPosition - diff; temp >= 0; --temp) {
            char ch = this.fSource[temp];
            if (!Character.isWhitespace(ch)) {
                return -1;
            }
            if (ch != '\n') continue;
            return temp;
        }
        return temp;
    }

    protected final boolean getNextChar(char testedChar) {
        int temp = this.fCurrentPosition;
        try {
            this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
            if (this.fCurrentCharacter != testedChar) {
                this.fCurrentPosition = temp;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e2) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    protected final boolean getNextCharAsWhitespace() {
        int temp = this.fCurrentPosition;
        try {
            this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
            if (!Character.isWhitespace(this.fCurrentCharacter)) {
                this.fCurrentPosition = temp;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException e2) {
            this.fCurrentPosition = temp;
            return false;
        }
    }

    protected final boolean findWikiLinkEnd() {
        int level = 1;
        int position = this.fCurrentPosition;
        boolean pipeSymbolFound = false;
        try {
            block7: {
                char ch;
                do {
                    if ((ch = this.fSource[position++]) == '|') {
                        pipeSymbolFound = true;
                        continue;
                    }
                    if (ch == '[' && this.fSource[position] == '[') {
                        if (pipeSymbolFound) {
                            ++level;
                            ++position;
                            continue;
                        }
                        return false;
                    }
                    if (ch == ']' && this.fSource[position] == ']') {
                        ++position;
                        if (--level != 0) continue;
                        break block7;
                    }
                    if (ch != '{' && ch != '}' && ch != '<' && ch != '>' || pipeSymbolFound) continue;
                    return false;
                } while (pipeSymbolFound || ch != '\n' && ch != '\r');
                return false;
            }
            this.fCurrentPosition = position;
            return true;
        }
        catch (IndexOutOfBoundsException e2) {
            return false;
        }
    }
}

