/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.wiki.filter.AbstractParser;
import info.bliki.wiki.filter.AbstractWikipediaParser;
import info.bliki.wiki.filter.Util;
import info.bliki.wiki.filter.WikipediaParser;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.util.WikiTagNode;
import info.bliki.wiki.template.ITemplateFunction;
import info.bliki.wiki.template.Safesubst;
import info.bliki.wiki.template.Subst;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateParser
extends AbstractParser {
    public static final String TEMPLATE_PARSER_ERROR = "TemplateParserError";
    private static final Pattern HTML_COMMENT_PATTERN = Pattern.compile("<!--(.*?)-->");
    private static final String SUBST = "subst:";
    private static final String SAFESUBST = "safesubst:";
    private static final int SUBST_LENGTH = "subst:".length();
    private static final int SAFESUBST_LENGTH = "safesubst:".length();
    protected static Logger logger = LoggerFactory.getLogger(TemplateParser.class);
    private final boolean fParseOnlySignature;
    private final boolean fRenderTemplate;
    private boolean fOnlyIncludeFlag;

    public TemplateParser(String stringSource) {
        this(stringSource, false, false);
    }

    public TemplateParser(String stringSource, boolean parseOnlySignature, boolean renderTemplate) {
        this(stringSource, parseOnlySignature, renderTemplate, false);
    }

    public TemplateParser(String stringSource, boolean parseOnlySignature, boolean renderTemplate, boolean onlyIncludeFlag) {
        super(stringSource);
        this.fParseOnlySignature = parseOnlySignature;
        this.fRenderTemplate = renderTemplate;
        this.fOnlyIncludeFlag = onlyIncludeFlag;
    }

    public static void parse(String rawWikitext, IWikiModel wikiModel, Appendable writer, boolean renderTemplate) throws IOException {
        TemplateParser.parse(rawWikitext, wikiModel, writer, false, renderTemplate);
    }

    public static void parse(String rawWikitext, IWikiModel wikiModel, Appendable writer, boolean parseOnlySignature, boolean renderTemplate) throws IOException {
        TemplateParser.parseRecursive(rawWikitext, wikiModel, writer, parseOnlySignature, renderTemplate);
    }

    protected static void parseRecursive(String rawWikitext, IWikiModel wikiModel, Appendable writer, boolean parseOnlySignature, boolean renderTemplate) throws IOException {
        TemplateParser.parseRecursive(rawWikitext, wikiModel, writer, parseOnlySignature, renderTemplate, null);
    }

    private boolean parsePreprocessRecursive(StringBuilder writer, int diff) throws IOException {
        StringBuilder buf = new StringBuilder(this.fCurrentPosition - this.fWhiteStartPosition);
        this.appendContent(buf, this.fWhiteStart, this.fWhiteStartPosition, diff, true);
        int startIndex = Util.indexOfTemplateParsing(buf);
        if (startIndex < 0) {
            writer.append((CharSequence)buf);
            return false;
        }
        return TemplateParser.parsePreprocessRecursive(startIndex, buf.toString(), this.fWikiModel, writer, this.fRenderTemplate, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean parsePreprocessRecursive(int startIndex, String rawWikitext, IWikiModel wikiModel, StringBuilder writer, boolean renderTemplate, boolean onlyIncludeFlag, Map<String, String> templateParameterMap) throws IOException {
        try {
            int templateLevel = wikiModel.incrementTemplateRecursionLevel();
            if (templateLevel > 256) {
                writer.append("Error - template recursion limit exceeded parsing templates.");
                boolean bl = false;
                return bl;
            }
            StringBuilder sb = new StringBuilder(rawWikitext.length());
            TemplateParser parser = new TemplateParser(rawWikitext, false, renderTemplate, onlyIncludeFlag);
            parser.setModel(wikiModel);
            parser.runPreprocessParser(0, startIndex, sb, false);
            writer.append((CharSequence)TemplateParser.substituteParameters(templateParameterMap, wikiModel, sb));
            boolean bl = parser.fOnlyIncludeFlag;
            return bl;
        }
        catch (Error | Exception e2) {
            TemplateParser.handleParserError(e2, writer);
            boolean bl = false;
            return bl;
        }
        finally {
            wikiModel.decrementTemplateRecursionLevel();
        }
    }

    private static StringBuilder substituteParameters(Map<String, String> templateParameterMap, IWikiModel wikiModel, StringBuilder writer) {
        boolean hasEmptyDefaultParams;
        boolean hasParamsToReplace = templateParameterMap != null && !templateParameterMap.isEmpty();
        boolean bl = hasEmptyDefaultParams = writer.indexOf("{{{|") != -1;
        if (hasParamsToReplace || hasEmptyDefaultParams) {
            TemplateParser scanner = new TemplateParser(writer.toString());
            scanner.setModel(wikiModel);
            StringBuilder result2 = scanner.replaceTemplateParameters(templateParameterMap, 0);
            if (result2 != null) {
                return result2;
            }
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseRecursive(String rawWikitext, IWikiModel wikiModel, Appendable writer, boolean parseOnlySignature, boolean renderTemplate, Map<String, String> templateParameterMap) throws IOException {
        int startIndex = Util.indexOfTemplateParsing(rawWikitext);
        if (startIndex < 0) {
            writer.append(rawWikitext);
            return;
        }
        StringBuilder sb = new StringBuilder(rawWikitext.length());
        TemplateParser.parsePreprocessRecursive(startIndex, rawWikitext, wikiModel, sb, renderTemplate, false, templateParameterMap);
        if (parseOnlySignature) {
            writer.append(sb);
            return;
        }
        try {
            String redirectedContent;
            String redirectedLink;
            int templateLevel = wikiModel.incrementTemplateRecursionLevel();
            if (templateLevel > 256) {
                writer.append("Error - template recursion limit exceeded parsing templates.");
                return;
            }
            TemplateParser parser = new TemplateParser(sb.toString(), false, renderTemplate);
            parser.setModel(wikiModel);
            sb = new StringBuilder(sb.length());
            parser.runPreprocessParser(sb, true);
            parser = new TemplateParser(sb.toString(), parseOnlySignature, renderTemplate);
            parser.setModel(wikiModel);
            sb = new StringBuilder(sb.length());
            parser.runParser(sb);
            if (!wikiModel.isParameterParsingMode()) {
                parser = new TemplateParser(sb.toString(), parseOnlySignature, renderTemplate);
                parser.setModel(wikiModel);
                sb = new StringBuilder(sb.length());
                parser.runParser(sb);
            }
            if (!renderTemplate && (redirectedLink = WikipediaParser.parseRedirect(sb.toString(), wikiModel)) != null && (redirectedContent = AbstractWikipediaParser.getRedirectedTemplateContent(wikiModel, redirectedLink, templateParameterMap)) != null) {
                TemplateParser.parseRecursive(redirectedContent, wikiModel, writer, parseOnlySignature, renderTemplate, templateParameterMap);
                return;
            }
            writer.append(sb);
        }
        catch (Error | Exception e2) {
            TemplateParser.handleParserError(e2, writer);
        }
        finally {
            wikiModel.decrementTemplateRecursionLevel();
        }
    }

    private static void handleParserError(Throwable e2, Appendable writer) {
        logger.error(TEMPLATE_PARSER_ERROR, e2);
        try {
            writer.append(TEMPLATE_PARSER_ERROR).append(':').append(e2.getClass().getSimpleName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void runPreprocessParser(StringBuilder writer, boolean ignoreTemplateTags) throws IOException {
        this.runPreprocessParser(this.fCurrentPosition, this.fCurrentPosition, writer, ignoreTemplateTags);
    }

    protected void runPreprocessParser(int whiteStartPosition, int currentPosition, StringBuilder writer, boolean ignoreTemplateTags) throws IOException {
        this.fWhiteStart = true;
        this.fWhiteStartPosition = whiteStartPosition;
        try {
            block11: while (true) {
                this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                switch (this.fCurrentCharacter) {
                    case '{': {
                        if (!this.isSubsOrSafesubst()) break;
                        int oldPosition = this.fCurrentPosition;
                        if (this.parseSubstOrSafesubst(writer)) {
                            this.fWhiteStart = true;
                            this.fWhiteStartPosition = this.fCurrentPosition;
                            continue block11;
                        }
                        this.fCurrentPosition = oldPosition;
                        break;
                    }
                    case '<': {
                        int htmlStartPosition = this.fCurrentPosition;
                        if (!this.fParseOnlySignature && this.parseIncludeWikiTags(writer, ignoreTemplateTags)) continue block11;
                        this.fCurrentPosition = htmlStartPosition;
                        break;
                    }
                    case '~': {
                        if (this.fSource.length <= this.fCurrentPosition + 1 || this.fSource[this.fCurrentPosition] != '~' || this.fSource[this.fCurrentPosition + 1] != '~') break;
                        int tildeCounter = 3;
                        try {
                            if (this.fSource[this.fCurrentPosition + 2] == '~') {
                                tildeCounter = 4;
                                if (this.fSource[this.fCurrentPosition + 3] == '~') {
                                    tildeCounter = 5;
                                }
                            }
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                        this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1, true);
                        this.fWikiModel.appendSignature(writer, tildeCounter);
                        this.fCurrentPosition += tildeCounter - 1;
                        this.fWhiteStart = true;
                        this.fWhiteStartPosition = this.fCurrentPosition;
                    }
                }
                if (this.fWhiteStart) continue;
                this.fWhiteStart = true;
                this.fWhiteStartPosition = this.fCurrentPosition - 1;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            try {
                if (!this.fOnlyIncludeFlag) {
                    this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1, true);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException2) {
                // empty catch block
            }
            return;
        }
    }

    private boolean isSubsOrSafesubst() {
        if (this.fSource[this.fCurrentPosition] == '{' && this.fSource.length > this.fCurrentPosition + SUBST_LENGTH) {
            for (int pos = this.fCurrentPosition + 1; pos < this.fSource.length; ++pos) {
                if (Character.isWhitespace(this.fSource[pos])) continue;
                return this.fSource[pos] == 's';
            }
            return false;
        }
        return false;
    }

    private void runParser(Appendable writer) throws IOException {
        this.fWhiteStart = true;
        this.fWhiteStartPosition = this.fCurrentPosition;
        try {
            block11: while (true) {
                this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                switch (this.fCurrentCharacter) {
                    case '{': {
                        int oldPosition = this.fCurrentPosition;
                        if (!this.fParseOnlySignature && this.parseTemplateOrTemplateParameter(writer)) {
                            this.fWhiteStart = true;
                            this.fWhiteStartPosition = this.fCurrentPosition;
                            continue block11;
                        }
                        this.fCurrentPosition = oldPosition;
                        break;
                    }
                    case '<': {
                        int htmlStartPosition = this.fCurrentPosition;
                        if (!this.fParseOnlySignature && this.parseSpecialWikiTags(writer)) continue block11;
                        this.fCurrentPosition = htmlStartPosition;
                        break;
                    }
                    case '~': {
                        int tildeCounter = 0;
                        if (this.fSource.length <= this.fCurrentPosition + 1 || this.fSource[this.fCurrentPosition] != '~' || this.fSource[this.fCurrentPosition + 1] != '~') break;
                        tildeCounter = 3;
                        try {
                            if (this.fSource[this.fCurrentPosition + 2] == '~') {
                                tildeCounter = 4;
                                if (this.fSource[this.fCurrentPosition + 3] == '~') {
                                    tildeCounter = 5;
                                }
                            }
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                        this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1, true);
                        this.fWikiModel.appendSignature(writer, tildeCounter);
                        this.fCurrentPosition += tildeCounter - 1;
                        this.fWhiteStart = true;
                        this.fWhiteStartPosition = this.fCurrentPosition;
                    }
                }
                if (this.fWhiteStart) continue;
                this.fWhiteStart = true;
                this.fWhiteStartPosition = this.fCurrentPosition - 1;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            try {
                this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1, true);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException2) {
                // empty catch block
            }
            return;
        }
    }

    private boolean parseIncludeWikiTags(StringBuilder writer, boolean ignoreTemplateTags) throws IOException {
        try {
            switch (this.fSource[this.fCurrentPosition]) {
                case '!': {
                    if (this.parseHTMLCommentTags(writer)) {
                        return true;
                    }
                    break;
                }
                default: {
                    if (this.fSource[this.fCurrentPosition] == '/') break;
                    int lessThanStart = this.fCurrentPosition - 1;
                    int startPosition = this.fCurrentPosition;
                    WikiTagNode tagNode = this.parseTag(this.fCurrentPosition);
                    if (tagNode != null && (!tagNode.isEmptyXmlTag() || "noinclude".equals(tagNode.getTagName()))) {
                        String tagName;
                        int tagStart = this.fCurrentPosition = tagNode.getEndPosition();
                        switch (tagName = tagNode.getTagName()) {
                            case "nowiki": {
                                this.readUntilIgnoreCase("</", "nowiki>");
                                return true;
                            }
                            case "source": {
                                this.readUntilIgnoreCase("</", "source>");
                                this.appendContentWithComment(writer, startPosition);
                                return true;
                            }
                            case "math": {
                                this.readUntilIgnoreCase("</", "math>");
                                return true;
                            }
                            case "pre": {
                                this.readUntilIgnoreCase("</", "pre>");
                                return true;
                            }
                        }
                        if (ignoreTemplateTags) {
                            return false;
                        }
                        if (this.fRenderTemplate) {
                            switch (tagName) {
                                case "noinclude": {
                                    int diff = this.readUntilNestedIgnoreCase(tagNode);
                                    this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart, true);
                                    this.fWhiteStart = true;
                                    this.fWhiteStartPosition = tagStart;
                                    this.parsePreprocessRecursive(writer, diff);
                                    this.fWhiteStart = true;
                                    this.fWhiteStartPosition = this.fCurrentPosition;
                                    return true;
                                }
                                case "includeonly": {
                                    this.readUntilNestedIgnoreCase(tagNode);
                                    this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart, true);
                                    this.fWhiteStart = true;
                                    this.fWhiteStartPosition = this.fCurrentPosition;
                                    return true;
                                }
                                case "onlyinclude": {
                                    int diff = this.readUntilNestedIgnoreCase(tagNode);
                                    this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart, true);
                                    this.fWhiteStart = true;
                                    this.fWhiteStartPosition = tagStart;
                                    this.parsePreprocessRecursive(writer, diff);
                                    this.fWhiteStart = true;
                                    this.fWhiteStartPosition = this.fCurrentPosition;
                                    return true;
                                }
                            }
                        } else {
                            switch (tagName) {
                                case "includeonly": {
                                    int diff = this.readUntilNestedIgnoreCase(tagNode);
                                    if (!this.fOnlyIncludeFlag) {
                                        this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart, true);
                                    }
                                    this.fWhiteStart = true;
                                    this.fWhiteStartPosition = tagStart;
                                    if (!this.fOnlyIncludeFlag) {
                                        StringBuilder tempWriter = new StringBuilder();
                                        this.fOnlyIncludeFlag = this.parsePreprocessRecursive(tempWriter, diff);
                                        if (this.fOnlyIncludeFlag) {
                                            writer.delete(0, writer.length());
                                        }
                                        writer.append((CharSequence)tempWriter);
                                    }
                                    this.fWhiteStart = true;
                                    this.fWhiteStartPosition = this.fCurrentPosition;
                                    return true;
                                }
                                case "noinclude": {
                                    int diff = this.readUntilNestedIgnoreCase(tagNode);
                                    if (!this.fOnlyIncludeFlag) {
                                        this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - lessThanStart, true);
                                    }
                                    this.fWhiteStart = true;
                                    this.fWhiteStartPosition = this.fCurrentPosition;
                                    return true;
                                }
                                case "onlyinclude": {
                                    int diff = this.readUntilNestedIgnoreCase(tagNode);
                                    if (!this.fOnlyIncludeFlag) {
                                        writer.delete(0, writer.length());
                                        this.fOnlyIncludeFlag = true;
                                    }
                                    this.fWhiteStart = true;
                                    this.fWhiteStartPosition = tagStart;
                                    this.parsePreprocessRecursive(writer, diff);
                                    this.fWhiteStart = true;
                                    this.fWhiteStartPosition = this.fCurrentPosition;
                                    return true;
                                }
                            }
                        }
                        this.fCurrentPosition = startPosition;
                    }
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseSpecialWikiTags(Appendable writer) throws IOException {
        int startPosition = this.fCurrentPosition;
        try {
            switch (this.fSource[this.fCurrentPosition]) {
                case '!': {
                    if (!this.parseHTMLCommentTags(writer)) break;
                    return true;
                }
                default: {
                    String tagName;
                    WikiTagNode tagNode;
                    if (this.fSource[this.fCurrentPosition] == '/' || (tagNode = this.parseTag(this.fCurrentPosition)) == null || tagNode.isEmptyXmlTag()) break;
                    this.fCurrentPosition = tagNode.getEndPosition();
                    switch (tagName = tagNode.getTagName()) {
                        case "nowiki": {
                            this.readUntilIgnoreCase("</", "nowiki>");
                            return true;
                        }
                        case "source": {
                            this.readUntilIgnoreCase("</", "source>");
                            this.appendContentWithComment(writer, startPosition);
                            return true;
                        }
                        case "pre": {
                            this.readUntilIgnoreCase("</", "pre>");
                            return true;
                        }
                    }
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.fCurrentPosition = startPosition;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendContent(Appendable writer, boolean whiteStart, int whiteStartPosition, int diff, boolean stripHTMLComments) throws IOException {
        if (whiteStart) {
            try {
                int whiteEndPosition = this.fCurrentPosition - diff;
                int count = whiteEndPosition - whiteStartPosition;
                if (count > 0) {
                    if (stripHTMLComments) {
                        writer.append(HTML_COMMENT_PATTERN.matcher(this.fStringSource.substring(whiteStartPosition, whiteEndPosition)).replaceAll(""));
                    } else {
                        writer.append(this.fStringSource, whiteStartPosition, whiteEndPosition);
                    }
                }
            }
            finally {
                this.fWhiteStart = false;
            }
        }
    }

    private void appendContentWithComment(Appendable writer, int startPosition) throws IOException {
        if (this.fWhiteStartPosition < startPosition - 1) {
            this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - startPosition + 1, true);
        }
        this.appendContent(writer, true, startPosition - 1, 0, false);
        this.fWhiteStart = true;
        this.fWhiteStartPosition = this.fCurrentPosition;
    }

    private boolean parseSubstOrSafesubst(Appendable writer) throws IOException {
        this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1, true);
        int pos = this.fCurrentPosition++;
        this.consumeWhitespace();
        int startTemplatePosition = this.fCurrentPosition;
        int templateEndPosition = TemplateParser.findNestedTemplateEnd(this.fSource, this.fCurrentPosition);
        if (templateEndPosition < 0) {
            this.fCurrentPosition = pos;
            return false;
        }
        return this.parseSubst(writer, startTemplatePosition, templateEndPosition);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseTemplateOrTemplateParameter(Appendable writer) throws IOException {
        if (this.fSource[this.fCurrentPosition] != '{') return false;
        this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1, true);
        int startTemplatePosition = ++this.fCurrentPosition;
        if (this.fSource[this.fCurrentPosition] == '{' && this.fSource[this.fCurrentPosition + 1] != '{') {
            int[] templateEndPosition = TemplateParser.findNestedParamEnd(this.fSource, this.fCurrentPosition + 1);
            if (templateEndPosition[0] >= 0) {
                this.parseTemplateParameter(writer, startTemplatePosition, templateEndPosition[0]);
                return true;
            }
            if (templateEndPosition[1] < 0) {
                --this.fCurrentPosition;
                return false;
            }
            writer.append('{');
            ++this.fCurrentPosition;
            return this.parseTemplate(writer, startTemplatePosition + 1, templateEndPosition[1]);
        }
        int templateEndPosition = TemplateParser.findNestedTemplateEnd(this.fSource, this.fCurrentPosition);
        if (templateEndPosition >= 0) return this.parseTemplate(writer, startTemplatePosition, templateEndPosition);
        --this.fCurrentPosition;
        return false;
    }

    private boolean parseSubst(Appendable writer, int startTemplatePosition, int templateEndPosition) throws IOException {
        int currOffset;
        ITemplateFunction templateFunction;
        int endPosition = this.fCurrentPosition = templateEndPosition;
        int endOffset = this.fCurrentPosition - 2;
        Object[] objs = TemplateParser.createParameterMap(this.fSource, startTemplatePosition, this.fCurrentPosition - startTemplatePosition - 2);
        String templateName = (String)objs[1];
        List parts = (List)objs[0];
        if (templateName.startsWith(SUBST)) {
            templateFunction = Subst.CONST;
            currOffset = SUBST_LENGTH;
        } else if (templateName.startsWith(SAFESUBST)) {
            templateFunction = Safesubst.CONST;
            currOffset = SAFESUBST_LENGTH;
        } else {
            return false;
        }
        parts.set(0, templateName.substring(currOffset));
        String plainContent = templateFunction.parseFunction(parts, this.fWikiModel, this.fSource, startTemplatePosition + currOffset, endOffset, false);
        this.fCurrentPosition = endPosition;
        if (plainContent != null) {
            writer.append(plainContent);
            return true;
        }
        return false;
    }

    private boolean parseTemplate(Appendable writer, int startTemplatePosition, int templateEndPosition) throws IOException {
        int endPosition = this.fCurrentPosition = templateEndPosition;
        int endOffset = this.fCurrentPosition - 2;
        Object[] objs = TemplateParser.createParameterMap(this.fSource, startTemplatePosition, this.fCurrentPosition - startTemplatePosition - 2);
        List parts = (List)objs[0];
        String templateName = (String)objs[1];
        StringBuilder buf = new StringBuilder(templateName.length() + templateName.length() / 10);
        TemplateParser.parse(templateName, this.fWikiModel, buf, false);
        templateName = buf.toString();
        int currOffset = TemplateParser.checkParserFunction(buf);
        if (currOffset > 0) {
            String function = templateName.substring(0, currOffset - 1).trim();
            ITemplateFunction templateFunction = this.fWikiModel.getTemplateFunction(function);
            if (templateFunction != null) {
                parts.set(0, templateName.substring(currOffset));
                String plainContent = templateFunction.parseFunction(parts, this.fWikiModel, this.fSource, startTemplatePosition + currOffset, endOffset, false);
                this.fCurrentPosition = endPosition;
                if (plainContent != null) {
                    TemplateParser.parseRecursive(plainContent, this.fWikiModel, writer, false, false);
                }
                return true;
            }
            this.fCurrentPosition = endOffset + 2;
        }
        if (Util.isInvalidTemplateName(templateName)) {
            return false;
        }
        this.fCurrentPosition = endPosition;
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        if (parts.size() > 1) {
            ArrayList<String> unnamedParameters = new ArrayList<String>();
            for (int i = 1; i < parts.size(); ++i) {
                TemplateParser.createSingleParameter((String)parts.get(i), this.fWikiModel, parameterMap, unnamedParameters);
            }
            TemplateParser.mergeParameters(parameterMap, unnamedParameters);
        }
        this.fWikiModel.substituteTemplateCall(templateName, parameterMap, writer);
        return true;
    }

    public static void mergeParameters(LinkedHashMap<String, String> parameterMap, List<String> unnamedParameters) {
        if (unnamedParameters.size() == 0) {
            return;
        }
        int unnamedParameterIndex = 1;
        for (String param : unnamedParameters) {
            String key;
            if (parameterMap.containsKey(key = Integer.toString(unnamedParameterIndex++))) continue;
            parameterMap.put(key, param);
        }
    }

    private void parseTemplateParameter(Appendable writer, int startTemplatePosition, int templateEndPosition) throws IOException {
        String plainContent = this.fStringSource.substring(startTemplatePosition - 2, templateEndPosition);
        this.fCurrentPosition = templateEndPosition;
        int indx = plainContent.indexOf("{{{");
        if (indx >= 0) {
            TemplateParser scanner = new TemplateParser(plainContent);
            scanner.setModel(this.fWikiModel);
            StringBuilder plainBuffer = scanner.replaceTemplateParameters(null, 0);
            if (plainBuffer == null) {
                writer.append(plainContent);
                return;
            }
            TemplateParser.parseRecursive(plainBuffer.toString().trim(), this.fWikiModel, writer, false, false);
        }
    }

    public static Object[] createParameterMap(char[] src, int startOffset, int len2) {
        ArrayList<String> resultList;
        Object[] objs = new Object[2];
        int currOffset = startOffset;
        int endOffset = startOffset + len2;
        objs[0] = resultList = new ArrayList<String>();
        TemplateParser.splitByPipe(src, currOffset, endOffset, resultList);
        objs[1] = resultList.size() <= 1 ? new String(src, startOffset, len2).trim() : ((String)resultList.get(0)).trim();
        return objs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSingleParameter(String srcString, IWikiModel wikiModel, Map<String, String> namedParameterMap, List<String> unnamedParams) {
        int currOffset = 0;
        char[] src = srcString.toCharArray();
        int endOffset = srcString.length();
        String parameter = null;
        boolean equalCharParsed = false;
        int lastOffset = currOffset;
        int[] temp = new int[]{-1, -1};
        try {
            while (currOffset < endOffset) {
                char ch;
                if ((ch = src[currOffset++]) == '[' && src[currOffset] == '[') {
                    temp[0] = TemplateParser.findNestedEnd(src, '[', ']', ++currOffset);
                    if (temp[0] < 0) continue;
                    currOffset = temp[0];
                    continue;
                }
                if (ch == '{' && src[currOffset] == '{') {
                    if (src[++currOffset] == '{' && src[currOffset + 1] != '{') {
                        if ((temp = TemplateParser.findNestedParamEnd(src, ++currOffset))[0] >= 0) {
                            currOffset = temp[0];
                            continue;
                        }
                        if (temp[1] < 0) continue;
                        currOffset = temp[1];
                        continue;
                    }
                    temp[0] = TemplateParser.findNestedTemplateEnd(src, currOffset);
                    if (temp[0] < 0) continue;
                    currOffset = temp[0];
                    continue;
                }
                if (ch != '=') continue;
                if (!equalCharParsed) {
                    parameter = srcString.substring(lastOffset, currOffset - 1).trim();
                    lastOffset = currOffset;
                }
                equalCharParsed = true;
            }
        }
        catch (IndexOutOfBoundsException parameterParsingMode) {
        }
        finally {
            if (currOffset >= lastOffset) {
                try {
                    String value = srcString.substring(lastOffset, currOffset);
                    boolean parameterParsingMode = wikiModel.isParameterParsingMode();
                    try {
                        wikiModel.setParameterParsingMode(true);
                        if (parameter != null) {
                            StringBuilder buf = new StringBuilder(value.length());
                            TemplateParser.parseRecursive(value, wikiModel, buf, false, false);
                            value = Util.trimNewlineRight(buf.toString());
                            namedParameterMap.put(parameter, value);
                        } else {
                            StringBuilder buf = new StringBuilder(value.length());
                            TemplateParser.parseRecursive(value, wikiModel, buf, false, false);
                            unnamedParams.add(buf.toString());
                        }
                    }
                    finally {
                        wikiModel.setParameterParsingMode(parameterParsingMode);
                    }
                }
                catch (IOException parameterParsingMode) {}
            }
        }
    }

    public static int checkParserFunction(CharSequence plainContent) {
        int currOffset = 0;
        int len2 = plainContent.length();
        while (currOffset < len2) {
            char ch;
            if (Character.isLetter(ch = plainContent.charAt(currOffset++)) || ch == '#' || ch == '$') {
                while (currOffset < len2) {
                    if ((ch = plainContent.charAt(currOffset++)) == ':') {
                        return currOffset;
                    }
                    if (Character.isLetterOrDigit(ch) || ch == '$') continue;
                    return -1;
                }
                break;
            }
            if (Character.isWhitespace(ch)) continue;
            return -1;
        }
        return -1;
    }

    protected boolean parseHTMLCommentTags(Appendable writer) throws IOException {
        if (this.fStringSource.startsWith("<!--", this.fCurrentPosition - 1)) {
            int temp = this.readWhitespaceUntilStartOfLine(2);
            if (!this.fOnlyIncludeFlag) {
                int diff = 1;
                if (temp >= 0) {
                    diff = this.fCurrentPosition - temp - 1;
                }
                this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, diff, true);
            }
            this.fCurrentPosition += 3;
            this.readUntil("-->");
            if (temp >= 0 && (temp = this.readWhitespaceUntilEndOfLine(0)) >= 0) {
                ++this.fCurrentPosition;
            }
            this.fWhiteStart = true;
            this.fWhiteStartPosition = this.fCurrentPosition;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public StringBuilder replaceTemplateParameters(@Nullable Map<String, String> templateParameters, int curlyBraceOffset) {
        StringBuilder buffer = null;
        int bufferStart = 0;
        try {
            int level = this.fWikiModel.incrementRecursionLevel();
            if (level > 256) {
                StringBuilder stringBuilder = null;
                return stringBuilder;
            }
            this.fScannerPosition += curlyBraceOffset;
            int parameterStart = -1;
            do {
                char ch;
                if ((ch = this.fSource[this.fScannerPosition++]) != '{' || this.fSource[this.fScannerPosition] != '{' || this.fSource[this.fScannerPosition + 1] != '{' || this.fSource[this.fScannerPosition + 2] == '{') continue;
                this.fScannerPosition += 2;
                parameterStart = this.fScannerPosition;
                int[] temp = TemplateParser.findNestedParamEnd(this.fSource, parameterStart);
                if (temp[0] < 0) continue;
                this.fScannerPosition = temp[0];
                List<String> list = TemplateParser.splitByPipe(this.fSource, parameterStart, this.fScannerPosition - 3, null);
                if (list.size() > 0) {
                    String parameterString = list.get(0).trim();
                    TemplateParser scanner1 = new TemplateParser(parameterString);
                    scanner1.setModel(this.fWikiModel);
                    StringBuilder recursiveResult = scanner1.replaceTemplateParameters(templateParameters, curlyBraceOffset);
                    if (recursiveResult != null) {
                        parameterString = recursiveResult.toString();
                    }
                    String value = null;
                    boolean isDefaultValue = false;
                    if (templateParameters != null) {
                        value = templateParameters.get(parameterString);
                    }
                    if (value == null && list.size() > 1) {
                        value = list.get(1);
                        isDefaultValue = true;
                    }
                    if (value != null && value.length() <= 262144) {
                        if (buffer == null) {
                            buffer = new StringBuilder(this.fSource.length + 128);
                        }
                        if (bufferStart < this.fScannerPosition) {
                            buffer.append(this.fSource, bufferStart, parameterStart - bufferStart - 3);
                        }
                        TemplateParser scanner2 = new TemplateParser(value);
                        scanner2.setModel(this.fWikiModel);
                        recursiveResult = isDefaultValue ? scanner2.replaceTemplateParameters(templateParameters, curlyBraceOffset) : scanner2.replaceTemplateParameters(null, curlyBraceOffset);
                        if (recursiveResult != null) {
                            buffer.append((CharSequence)recursiveResult);
                        } else {
                            buffer.append(value);
                        }
                        bufferStart = this.fScannerPosition;
                    }
                }
                this.fScannerPosition = temp[0];
                parameterStart = -1;
            } while (buffer == null || buffer.length() <= 524288);
            StringBuilder stringBuilder = buffer;
            return stringBuilder;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            this.fWikiModel.decrementRecursionLevel();
        }
        if (buffer != null && bufferStart < this.fScannerPosition) {
            buffer.append(this.fSource, bufferStart, this.fScannerPosition - bufferStart - 1);
        }
        return buffer;
    }
}

