/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags.code;

import info.bliki.wiki.tags.code.AbstractCPPBasedCodeFilter;
import info.bliki.wiki.tags.code.SourceCodeFormatter;
import java.util.HashMap;

public class PythonCodeFilter
extends AbstractCPPBasedCodeFilter
implements SourceCodeFormatter {
    private static HashMap<String, String> KEYWORD_SET;
    private static final String[] KEYWORDS;
    private static final String[] OBJECT_WORDS;
    private static HashMap<String, String> OBJECT_SET;

    @Override
    public String filter(String input) {
        char[] source = input.toCharArray();
        int currentPosition = 0;
        int identStart = 0;
        char currentChar = ' ';
        HashMap<String, String> keywordsSet = this.getKeywordSet();
        HashMap<String, String> objectsSet = this.getObjectSet();
        StringBuilder result2 = new StringBuilder(input.length() + input.length() / 4);
        boolean identFound = false;
        try {
            while (true) {
                if ((currentChar = source[currentPosition++]) >= 'A' && currentChar <= 'Z' || currentChar == '_' || currentChar >= 'a' && currentChar <= 'z') {
                    identStart = currentPosition - 1;
                    identFound = true;
                    while (currentChar >= 'a' && currentChar <= 'z' || currentChar >= 'A' && currentChar <= 'Z' || currentChar == '_') {
                        currentChar = source[currentPosition++];
                    }
                    currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, objectsSet, result2);
                    identFound = false;
                    continue;
                }
                if (currentChar == '\"') {
                    result2.append("<span style=\"color:#2A00FF; \">");
                    PythonCodeFilter.appendChar(result2, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        PythonCodeFilter.appendChar(result2, currentChar);
                        if (currentChar == '\\') {
                            currentChar = source[currentPosition++];
                            PythonCodeFilter.appendChar(result2, currentChar);
                            continue;
                        }
                        if (currentChar != 34) continue;
                    }
                    result2.append("</span>");
                    continue;
                }
                if (currentChar == '\'') {
                    result2.append("<span style=\"color:#2A00FF; \">");
                    PythonCodeFilter.appendChar(result2, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        PythonCodeFilter.appendChar(result2, currentChar);
                        if (currentChar == '\\') {
                            currentChar = source[currentPosition++];
                            PythonCodeFilter.appendChar(result2, currentChar);
                            continue;
                        }
                        if (currentChar != 39) continue;
                    }
                    result2.append("</span>");
                    continue;
                }
                if (currentChar == '#') {
                    result2.append("<span style=\"color:#3F7F5F; \">");
                    PythonCodeFilter.appendChar(result2, currentChar);
                    PythonCodeFilter.appendChar(result2, source[currentPosition++]);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        PythonCodeFilter.appendChar(result2, currentChar);
                        if (currentChar != 10) continue;
                    }
                    result2.append("</span>");
                    continue;
                }
                PythonCodeFilter.appendChar(result2, currentChar);
            }
        }
        catch (IndexOutOfBoundsException e2) {
            if (identFound) {
                currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, null, result2);
            }
            return result2.toString();
        }
    }

    @Override
    public HashMap<String, String> getKeywordSet() {
        return KEYWORD_SET;
    }

    public String getName() {
        return "python";
    }

    @Override
    public HashMap<String, String> getObjectSet() {
        return OBJECT_SET;
    }

    static {
        int i;
        KEYWORD_SET = new HashMap();
        KEYWORDS = new String[]{"False", "None", "True", "and", "as", "assert", "class", "break", "continue", "def", "del", "else", "elif", "except", "finally", "for", "from", "global", "is", "import", "in", "if", "lambda", "nonlocal", "not", "or", "pass", "raise", "return", "try", "with", "while", "yield"};
        OBJECT_WORDS = new String[]{"abs", "all", "any", "basestring", "bin", "bool", "callable", "chr", "classmethod", "cmp", "compile", "complex", "delattr", "dict", "dir", "divmod", "enumerate", "eval", "execfile", "file", "filter", "float", "format", "frozenset", "getattr", "globals", "hasattr", "hash", "help", "hex", "id", "input", "int", "isinstance", "issubclass", "iter", "len", "list", "locals", "long", "map", "max", "min", "next", "object", "oct", "open", "ord", "pow", "print", "property", "range", "raw", "reduce", "reload", "repr", "reversed", "round", "set", "setattr", "slice", "sorted", "staticmethod", "str", "sum", "super", "tuple", "type", "unichr", "unicode", "vars", "xrange", "zip", "__import__", "apply", "buffer", "coerce", "intern"};
        OBJECT_SET = new HashMap();
        for (i = 0; i < KEYWORDS.length; ++i) {
            PythonCodeFilter.createHashMap(KEYWORD_SET, KEYWORDS[i]);
        }
        for (i = 0; i < OBJECT_WORDS.length; ++i) {
            PythonCodeFilter.createObjectsMap(OBJECT_SET, OBJECT_WORDS[i]);
        }
    }
}

