/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.auction.APIManager;
import io.github.moulberry.notenoughupdates.core.config.KeybindHelper;
import io.github.moulberry.notenoughupdates.miscfeatures.inventory.MuseumTooltipManager;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import io.github.moulberry.notenoughupdates.util.hypixelapi.HypixelItemAPI;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Keyboard;

public class ItemPriceInformation {
    private static File file;
    private static HashSet<String> auctionableItems;
    private static Gson gson;
    private static final NumberFormat format;
    public static String STACKSIZE_OVERRIDE;
    private static final Pattern SACK_STORED_AMOUNT;
    private static final Pattern GEMSTONE_STORED_AMOUNT;
    private static final Pattern COMPOSTER_STORED_AMOUNT;
    private static final Pattern BAZAAR_STORED_AMOUNT;

    public static void addToTooltip(List<String> tooltip, String internalName, ItemStack stack) {
        ItemPriceInformation.addToTooltip(tooltip, internalName, stack, true);
    }

    public static void init(File saveLocation, Gson neuGson) {
        file = saveLocation;
        gson = neuGson;
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                auctionableItems = gson.fromJson((Reader)reader, HashSet.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void updateAuctionableItemsList() {
        Set<String> items2 = NotEnoughUpdates.INSTANCE.manager.auctionManager.getItemAuctionInfoKeySet();
        if (!items2.isEmpty()) {
            auctionableItems = (HashSet)items2;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                file.createNewFile();
                writer.write(gson.toJson(items2));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void addToTooltip(List<String> tooltip, String internalname, ItemStack stack, boolean useStackSize) {
        int shiftStackMultiplier;
        long lastUpdate;
        long currentTime;
        boolean auctionInfoErrored;
        if (stack.func_77978_p().func_74764_b("disableNeuTooltip") && stack.func_77978_p().func_74767_n("disableNeuTooltip")) {
            return;
        }
        if (NotEnoughUpdates.INSTANCE.config.tooltipTweaks.disablePriceKey && !KeybindHelper.isKeyDown(NotEnoughUpdates.INSTANCE.config.tooltipTweaks.disablePriceKeyKeybind)) {
            return;
        }
        if (internalname.equals("SKYBLOCK_MENU")) {
            return;
        }
        JsonObject auctionInfo = NotEnoughUpdates.INSTANCE.manager.auctionManager.getItemAuctionInfo(internalname);
        JsonObject bazaarInfo = NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarInfo(internalname);
        double lowestBinAvg = NotEnoughUpdates.INSTANCE.manager.auctionManager.getItemAvgBin(internalname);
        double lowestBin = NotEnoughUpdates.INSTANCE.manager.auctionManager.getLowestBin(internalname);
        APIManager.CraftInfo craftCost = NotEnoughUpdates.INSTANCE.manager.auctionManager.getCraftCost(internalname);
        boolean bazaarItem = bazaarInfo != null;
        boolean auctionItem = !bazaarItem;
        boolean bl = auctionInfoErrored = auctionInfo == null && lowestBin < 0.0;
        if (auctionItem && (currentTime = System.currentTimeMillis()) - (lastUpdate = NotEnoughUpdates.INSTANCE.manager.auctionManager.getLastLowestBinUpdateTime()) > 600000L && NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            tooltip.add(EnumChatFormatting.RED + "[NEU] Price info is outdated.");
            tooltip.add(EnumChatFormatting.RED + "It will be updated again as soon as possible.");
        }
        int n = shiftStackMultiplier = useStackSize && stack.field_77994_a > 1 ? stack.field_77994_a : stack.func_77973_b().getItemStackLimit(stack);
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(STACKSIZE_OVERRIDE)) {
            shiftStackMultiplier = stack.func_77978_p().func_74762_e(STACKSIZE_OVERRIDE);
        }
        int stackMultiplier = 1;
        boolean foundMulti = false;
        for (int i = 1; i < tooltip.size() && !foundMulti; ++i) {
            for (Pattern pattern : new Pattern[]{SACK_STORED_AMOUNT, GEMSTONE_STORED_AMOUNT, COMPOSTER_STORED_AMOUNT, BAZAAR_STORED_AMOUNT}) {
                Matcher matcher = pattern.matcher(tooltip.get(i));
                if (!matcher.matches()) continue;
                String amountString = matcher.group("amount").replace(",", "");
                try {
                    int parsedValue = Integer.parseInt(amountString);
                    if (parsedValue == 0) continue;
                    shiftStackMultiplier = parsedValue;
                    foundMulti = true;
                }
                catch (NumberFormatException e2) {
                    e2.printStackTrace();
                }
            }
        }
        boolean shiftPressed = Keyboard.isKeyDown((int)42);
        if (shiftPressed) {
            stackMultiplier = shiftStackMultiplier;
        }
        boolean added = false;
        if (bazaarItem) {
            List<Integer> lines = NotEnoughUpdates.INSTANCE.config.tooltipTweaks.priceInfoBaz;
            for (int lineId : lines) {
                switch (lineId) {
                    case 0: {
                        if (!bazaarInfo.has("avg_buy")) break;
                        if (!added) {
                            tooltip.add("");
                            if (!shiftPressed) {
                                tooltip.add(EnumChatFormatting.DARK_GRAY + "[SHIFT show x" + shiftStackMultiplier + "]");
                            }
                            added = true;
                        }
                        double bazaarBuyPrice = bazaarInfo.get("avg_buy").getAsFloat() * (float)stackMultiplier;
                        tooltip.add(ItemPriceInformation.formatPrice("Bazaar Buy: ", bazaarBuyPrice));
                        break;
                    }
                    case 1: {
                        if (!bazaarInfo.has("avg_sell")) break;
                        if (!added) {
                            tooltip.add("");
                            if (!shiftPressed) {
                                tooltip.add(EnumChatFormatting.DARK_GRAY + "[SHIFT show x" + shiftStackMultiplier + "]");
                            }
                            added = true;
                        }
                        double bazaarSellPrice = bazaarInfo.get("avg_sell").getAsDouble() * (double)stackMultiplier;
                        tooltip.add(ItemPriceInformation.formatPrice("Bazaar Sell: ", bazaarSellPrice));
                        break;
                    }
                    case 2: {
                        if (!bazaarInfo.has("curr_buy")) break;
                        if (!added) {
                            tooltip.add("");
                            if (!shiftPressed) {
                                tooltip.add(EnumChatFormatting.DARK_GRAY + "[SHIFT show x" + shiftStackMultiplier + "]");
                            }
                            added = true;
                        }
                        double bazaarInstantBuyPrice = bazaarInfo.get("curr_buy").getAsFloat() * (float)stackMultiplier;
                        tooltip.add(ItemPriceInformation.formatPrice("Bazaar Insta-Buy: ", bazaarInstantBuyPrice));
                        break;
                    }
                    case 3: {
                        if (!bazaarInfo.has("curr_sell")) break;
                        if (!added) {
                            tooltip.add("");
                            if (!shiftPressed) {
                                tooltip.add(EnumChatFormatting.DARK_GRAY + "[SHIFT show x" + shiftStackMultiplier + "]");
                            }
                            added = true;
                        }
                        double bazaarInstantSellPrice = bazaarInfo.get("curr_sell").getAsFloat() * (float)stackMultiplier;
                        tooltip.add(ItemPriceInformation.formatPrice("Bazaar Insta-Sell: ", bazaarInstantSellPrice));
                        break;
                    }
                    case 4: {
                        if (craftCost == null || !craftCost.fromRecipe || craftCost.craftCost == 0.0) break;
                        if (!added) {
                            tooltip.add("");
                            added = true;
                        }
                        double cost = craftCost.craftCost;
                        if (shiftPressed) {
                            cost *= (double)shiftStackMultiplier;
                        }
                        tooltip.add(ItemPriceInformation.formatPrice("Raw Craft Cost: ", cost));
                        break;
                    }
                    case 5: {
                        if (!bazaarInfo.has("instabuys_hourly")) break;
                        if (!added) {
                            tooltip.add("");
                            added = true;
                        }
                        tooltip.add(EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.BOLD + "Insta-Buys (Hourly): " + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + format.format(bazaarInfo.get("instabuys_hourly").getAsFloat()));
                        break;
                    }
                    case 6: {
                        if (!bazaarInfo.has("instasells_hourly")) break;
                        if (!added) {
                            tooltip.add("");
                            added = true;
                        }
                        tooltip.add(EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.BOLD + "Insta-Sells (Hourly): " + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + format.format(bazaarInfo.get("instasells_hourly").getAsFloat()));
                        break;
                    }
                    case 7: {
                        if (!bazaarInfo.has("instabuys_daily")) break;
                        if (!added) {
                            tooltip.add("");
                            added = true;
                        }
                        tooltip.add(EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.BOLD + "Insta-Buys (Daily): " + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + format.format(bazaarInfo.get("instabuys_daily").getAsFloat()));
                        break;
                    }
                    case 8: {
                        if (!bazaarInfo.has("instasells_daily")) break;
                        if (!added) {
                            tooltip.add("");
                            added = true;
                        }
                        tooltip.add(EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.BOLD + "Insta-Sells (Daily): " + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + format.format(bazaarInfo.get("instasells_daily").getAsFloat()));
                        break;
                    }
                    case 9: {
                        if (!bazaarInfo.has("instabuys_weekly")) break;
                        if (!added) {
                            tooltip.add("");
                            added = true;
                        }
                        tooltip.add(EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.BOLD + "Insta-Buys (Weekly): " + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + format.format(bazaarInfo.get("instabuys_weekly").getAsFloat()));
                        break;
                    }
                    case 10: {
                        if (!bazaarInfo.has("instasells_weekly")) break;
                        if (!added) {
                            tooltip.add("");
                            added = true;
                        }
                        tooltip.add(EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.BOLD + "Insta-Sells (Weekly): " + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + format.format(bazaarInfo.get("instasells_weekly").getAsFloat()));
                    }
                }
            }
        } else if (auctionItem && !auctionInfoErrored) {
            List<Integer> lines = NotEnoughUpdates.INSTANCE.config.tooltipTweaks.priceInfoAuc;
            for (int lineId : lines) {
                switch (lineId) {
                    case 0: {
                        if (!(lowestBin > 0.0)) break;
                        if (!added) {
                            tooltip.add("");
                            added = true;
                        }
                        tooltip.add(ItemPriceInformation.formatPrice("Lowest BIN: ", lowestBin));
                        break;
                    }
                    case 1: {
                        if (auctionInfo == null) break;
                        if (!added) {
                            tooltip.add("");
                            added = true;
                        }
                        if (auctionInfo.has("clean_price")) {
                            double cleanPrice = auctionInfo.get("clean_price").getAsDouble();
                            tooltip.add(ItemPriceInformation.formatPrice("AH Price (Clean): ", cleanPrice));
                            break;
                        }
                        double auctionPrice = auctionInfo.get("price").getAsDouble() / (double)auctionInfo.get("count").getAsFloat();
                        tooltip.add(ItemPriceInformation.formatPrice("AH Price: ", auctionPrice));
                        break;
                    }
                    case 2: {
                        if (auctionInfo == null) break;
                        if (!added) {
                            tooltip.add("");
                            added = true;
                        }
                        if (auctionInfo.has("clean_price")) {
                            tooltip.add(EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.BOLD + "AH Sales (Clean): " + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + (auctionInfo.get("clean_sales").getAsFloat() < 2.0f ? format.format(auctionInfo.get("clean_sales").getAsFloat()) + " sale/day" : format.format(auctionInfo.get("clean_sales").getAsFloat()) + " sales/day"));
                            break;
                        }
                        tooltip.add(EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.BOLD + "AH Sales: " + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + (auctionInfo.get("sales").getAsFloat() < 2.0f ? format.format(auctionInfo.get("sales").getAsFloat()) + " sale/day" : format.format(auctionInfo.get("sales").getAsFloat()) + " sales/day"));
                        break;
                    }
                    case 3: {
                        if (craftCost == null || !craftCost.fromRecipe || craftCost.craftCost == 0.0) break;
                        if (!added) {
                            tooltip.add("");
                            added = true;
                        }
                        tooltip.add(ItemPriceInformation.formatPrice("Raw Craft Cost: ", craftCost.craftCost));
                        break;
                    }
                    case 4: {
                        if (!(lowestBinAvg > 0.0)) break;
                        if (!added) {
                            tooltip.add("");
                            added = true;
                        }
                        tooltip.add(ItemPriceInformation.formatPrice("AVG Lowest BIN: ", lowestBinAvg));
                        break;
                    }
                    case 5: {
                        boolean shouldShow;
                        int dungeonItemLevel;
                        JsonObject essenceCosts;
                        if (Constants.ESSENCECOSTS == null || !(essenceCosts = Constants.ESSENCECOSTS).has(internalname)) break;
                        JsonObject itemCosts = essenceCosts.get(internalname).getAsJsonObject();
                        String essenceType = itemCosts.get("type").getAsString();
                        boolean requiresItems = false;
                        JsonObject itemsObject = null;
                        if (itemCosts.has("items")) {
                            requiresItems = true;
                            itemsObject = itemCosts.get("items").getAsJsonObject();
                        }
                        if ((dungeonItemLevel = Utils.getNumberOfStars(stack)) == -1) {
                            int dungeonizeCost = 0;
                            if (itemCosts.has("dungeonize")) {
                                dungeonizeCost = itemCosts.get("dungeonize").getAsInt();
                            }
                            if (dungeonizeCost <= 0) break;
                            tooltip.add(EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.BOLD + "Dungeonize Cost: " + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + dungeonizeCost + " " + essenceType);
                            break;
                        }
                        if (dungeonItemLevel < 0) break;
                        String nextStarLevelString = dungeonItemLevel + 1 + "";
                        int nextStarLevelInt = Integer.parseInt(nextStarLevelString);
                        if (!itemCosts.has(nextStarLevelString)) break;
                        int upgradeCost = itemCosts.get(nextStarLevelString).getAsInt();
                        String starString = Utils.getStarsString(nextStarLevelInt);
                        tooltip.add(EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.BOLD + "Upgrade to " + starString + EnumChatFormatting.YELLOW + EnumChatFormatting.BOLD + ": " + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + upgradeCost + " " + essenceType);
                        if (!requiresItems || !itemsObject.has(nextStarLevelString)) break;
                        boolean bl2 = shouldShow = Keyboard.isKeyDown((int)29) || NotEnoughUpdates.INSTANCE.config.tooltipTweaks.alwaysShowRequiredItems;
                        if (shouldShow) {
                            tooltip.add(EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.BOLD + "Required Items:");
                            for (JsonElement item : itemsObject.get(nextStarLevelString).getAsJsonArray()) {
                                JsonObject itemObject;
                                if (item.getAsString().contains("\u00a7")) {
                                    tooltip.add("  - " + item.getAsString());
                                    continue;
                                }
                                String itemString = item.getAsString();
                                int colon = itemString.indexOf(58);
                                if (colon == -1) continue;
                                String amount = itemString.substring(colon + 1);
                                String requiredItem = itemString.substring(0, colon);
                                if (requiredItem.equals("SKYBLOCK_COIN")) {
                                    tooltip.add("  - " + EnumChatFormatting.GOLD + amount + " Coins");
                                }
                                if (!NotEnoughUpdates.INSTANCE.manager.isValidInternalName(requiredItem) || (itemObject = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withKnownInternalName(requiredItem).resolveToItemListJson()) == null || !itemObject.has("displayname")) continue;
                                String displayName = itemObject.get("displayname").getAsString();
                                tooltip.add("  - " + displayName + EnumChatFormatting.DARK_GRAY + " x" + amount);
                            }
                            break;
                        }
                        tooltip.add(EnumChatFormatting.DARK_GRAY + "[CTRL to show required items]");
                    }
                }
            }
        } else if (NotEnoughUpdates.INSTANCE.config.tooltipTweaks.rawCraft && craftCost != null && craftCost.fromRecipe) {
            if (craftCost.craftCost != 0.0) {
                double cost = craftCost.craftCost;
                added = true;
                tooltip.add("");
                tooltip.add(ItemPriceInformation.formatPrice("Raw Craft Cost: ", cost *= (double)stackMultiplier));
            }
        } else if (auctionInfoErrored && NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            String message = EnumChatFormatting.RED.toString() + EnumChatFormatting.BOLD + "[NEU] API is down";
            if (auctionableItems != null && !auctionableItems.isEmpty()) {
                if (auctionableItems.contains(internalname)) {
                    tooltip.add(message);
                }
            } else {
                tooltip.add(message + " and no item data is cached");
            }
        }
        Double npcSellPrice = HypixelItemAPI.getNPCSellPrice(internalname);
        if (NotEnoughUpdates.INSTANCE.config.tooltipTweaks.npcSellPrice && npcSellPrice != null && npcSellPrice != 0.0) {
            if (!added) {
                tooltip.add("");
            }
            tooltip.add(ItemPriceInformation.formatPrice("NPC Sell Price: ", npcSellPrice * (double)stackMultiplier));
        }
        if (NotEnoughUpdates.INSTANCE.config.tooltipTweaks.museumDonationStatus) {
            if (!MuseumTooltipManager.INSTANCE.hasPlayerVisitedMuseum()) {
                tooltip.add(EnumChatFormatting.RED + EnumChatFormatting.BOLD.toString() + "[NEU] Visit your Museum to display donation status");
            }
            if (MuseumTooltipManager.INSTANCE.isItemDonated(internalname)) {
                tooltip.add(EnumChatFormatting.YELLOW + "Item already donated to museum");
            } else if (MuseumTooltipManager.INSTANCE.canItemBeDonated(internalname)) {
                tooltip.add(EnumChatFormatting.RED + "Item not donated to museum");
            }
        }
    }

    private static String formatPrice(String label, double price) {
        boolean shortNumber = NotEnoughUpdates.INSTANCE.config.tooltipTweaks.shortNumberFormatPrices;
        String number2 = shortNumber && price > 1000.0 ? Utils.shortNumberFormat(price, 0) : (price > 5.0 && 2.147483647E9 > price ? format.format((int)price) : format.format(price));
        return "\u00a7e\u00a7l" + label + "\u00a76\u00a7l" + number2 + " coins";
    }

    static {
        format = new DecimalFormat("#,##0.#", new DecimalFormatSymbols(Locale.US));
        STACKSIZE_OVERRIDE = "NEU_STACKSIZE_OVERRIDE";
        SACK_STORED_AMOUNT = Pattern.compile(".*Stored: \u00a7.(?<amount>[\\d,]+)\u00a7.\\/.*");
        GEMSTONE_STORED_AMOUNT = Pattern.compile(".*Amount: \u00a7.(?<amount>[\\d,]+)");
        COMPOSTER_STORED_AMOUNT = Pattern.compile(".*Compost Available: \u00a7.(?<amount>[\\d,]+)");
        BAZAAR_STORED_AMOUNT = Pattern.compile(".*(?:Offer|Order) amount: \u00a7.(?<amount>[\\d,]+)\u00a7.x");
    }
}

