/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.core.config;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.Position;
import io.github.moulberry.notenoughupdates.overlays.OverlayManager;
import io.github.moulberry.notenoughupdates.overlays.TextOverlay;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiPositionEditor
extends GuiScreen {
    private final ArrayList<Position> positions;
    private final ArrayList<Position> originalPositions;
    private final ArrayList<Integer> elementWidths;
    private final ArrayList<Integer> elementHeights;
    private final ArrayList<Supplier<Boolean>> shouldRenderSupplier = new ArrayList();
    private final Runnable positionChangedCallback;
    private final Runnable closedCallback;
    private int grabbedX = 0;
    private int grabbedY = 0;
    private int clickedPos = -1;
    private int oldGuiScale = -1;
    public static boolean renderDrill = false;

    public GuiPositionEditor(LinkedHashMap<TextOverlay, Position> overlayPositions, Runnable positionChangedCallback, Runnable closedCallback) {
        ArrayList<Position> pos = new ArrayList<Position>();
        ArrayList<Position> ogPos = new ArrayList<Position>();
        ArrayList<Integer> width = new ArrayList<Integer>();
        ArrayList<Integer> height = new ArrayList<Integer>();
        for (int i = 0; i < overlayPositions.size(); ++i) {
            TextOverlay overlay = new ArrayList<TextOverlay>(overlayPositions.keySet()).get(i);
            pos.add(overlayPositions.get(overlay));
            ogPos.add(((Position)pos.get(i)).clone());
            width.add((int)overlay.getDummySize().x);
            height.add((int)overlay.getDummySize().y);
            this.shouldRenderSupplier.add(() -> {
                if (overlay.isEnabled()) {
                    overlay.renderDummy();
                    OverlayManager.dontRenderOverlay.add(overlay.getClass());
                    return true;
                }
                return false;
            });
        }
        this.positions = pos;
        this.originalPositions = ogPos;
        this.elementWidths = width;
        this.elementHeights = height;
        this.positionChangedCallback = positionChangedCallback;
        this.closedCallback = closedCallback;
        int newGuiScale = NotEnoughUpdates.INSTANCE.config.locationedit.guiScale;
        if (newGuiScale != 0) {
            this.oldGuiScale = Minecraft.func_71410_x().field_71474_y.field_74335_Z != 0 ? Minecraft.func_71410_x().field_71474_y.field_74335_Z : 4;
            Minecraft.func_71410_x().field_71474_y.field_74335_Z = newGuiScale == 4 ? 0 : NotEnoughUpdates.INSTANCE.config.locationedit.guiScale;
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.closedCallback.run();
        renderDrill = false;
        this.clickedPos = -1;
        if (this.oldGuiScale != -1) {
            Minecraft.func_71410_x().field_71474_y.field_74335_Z = this.oldGuiScale;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179094_E();
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        this.field_146294_l = scaledResolution.func_78326_a();
        this.field_146295_m = scaledResolution.func_78328_b();
        mouseX = Mouse.getX() * this.field_146294_l / Minecraft.func_71410_x().field_71443_c;
        mouseY = this.field_146295_m - Mouse.getY() * this.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1;
        this.func_146276_q_();
        renderDrill = true;
        for (Position position : this.positions) {
            if (!this.shouldRenderSupplier.get(this.positions.indexOf(position)).get().booleanValue()) continue;
            int elementHeight = this.elementHeights.get(this.positions.indexOf(position));
            int elementWidth = this.elementWidths.get(this.positions.indexOf(position));
            if (position.getClicked()) {
                this.grabbedX += position.moveX(mouseX - this.grabbedX, elementWidth, scaledResolution);
                this.grabbedY += position.moveY(mouseY - this.grabbedY, elementHeight, scaledResolution);
            }
            int x = position.getAbsX(scaledResolution, elementWidth);
            int y = position.getAbsY(scaledResolution, elementHeight);
            if (position.isCenterX()) {
                x -= elementWidth / 2;
            }
            if (position.isCenterY()) {
                y -= elementHeight / 2;
            }
            Gui.func_73734_a((int)x, (int)y, (int)(x + elementWidth), (int)(y + elementHeight), (int)-2143272896);
        }
        Utils.drawStringCentered("Position Editor", scaledResolution.func_78326_a() / 2, 8, true, 0xFFFFFF);
        Utils.drawStringCentered("R to Reset - Arrow keys/mouse to move", scaledResolution.func_78326_a() / 2, 18, true, 0xFFFFFF);
        GlStateManager.func_179121_F();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
            mouseX = Mouse.getX() * this.field_146294_l / Minecraft.func_71410_x().field_71443_c;
            mouseY = this.field_146295_m - Mouse.getY() * this.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1;
            for (int i = this.positions.size() - 1; i >= 0; --i) {
                Position position = this.positions.get(i);
                int elementHeight = this.elementHeights.get(this.positions.indexOf(position));
                int elementWidth = this.elementWidths.get(this.positions.indexOf(position));
                int x = position.getAbsX(scaledResolution, elementWidth);
                int y = position.getAbsY(scaledResolution, elementHeight);
                if (position.isCenterX()) {
                    x -= elementWidth / 2;
                }
                if (position.isCenterY()) {
                    y -= elementHeight / 2;
                }
                if (position.getClicked() || mouseX < x || mouseY < y || mouseX > x + elementWidth || mouseY > y + elementHeight) continue;
                this.clickedPos = i;
                position.setClicked(true);
                this.grabbedX = mouseX;
                this.grabbedY = mouseY;
                break;
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.clickedPos != -1) {
            Position position = this.positions.get(this.clickedPos);
            int elementHeight = this.elementHeights.get(this.positions.indexOf(position));
            int elementWidth = this.elementWidths.get(this.positions.indexOf(position));
            if (keyCode == 19) {
                position.set(this.originalPositions.get(this.positions.indexOf(position)));
            } else if (!position.getClicked()) {
                int dist;
                boolean shiftHeld = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
                int n = dist = shiftHeld ? 10 : 1;
                if (keyCode == 208) {
                    position.moveY(dist, elementHeight, new ScaledResolution(Minecraft.func_71410_x()));
                } else if (keyCode == 200) {
                    position.moveY(-dist, elementHeight, new ScaledResolution(Minecraft.func_71410_x()));
                } else if (keyCode == 203) {
                    position.moveX(-dist, elementWidth, new ScaledResolution(Minecraft.func_71410_x()));
                } else if (keyCode == 205) {
                    position.moveX(dist, elementWidth, new ScaledResolution(Minecraft.func_71410_x()));
                }
            }
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        for (Position position : this.positions) {
            position.setClicked(false);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        for (Position position : this.positions) {
            int elementHeight = this.elementHeights.get(this.positions.indexOf(position));
            int elementWidth = this.elementWidths.get(this.positions.indexOf(position));
            if (!position.getClicked()) continue;
            ScaledResolution scaledResolution = Utils.pushGuiScale(-1);
            mouseX = Mouse.getX() * this.field_146294_l / Minecraft.func_71410_x().field_71443_c;
            mouseY = this.field_146295_m - Mouse.getY() * this.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1;
            this.grabbedX += position.moveX(mouseX - this.grabbedX, elementWidth, scaledResolution);
            this.grabbedY += position.moveY(mouseY - this.grabbedY, elementHeight, scaledResolution);
            this.positionChangedCallback.run();
            Utils.pushGuiScale(-1);
        }
    }
}

