/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui;

import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.common.IMinecraft;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.GuiContext;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.GuiImmediateContext;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.KeyboardEvent;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.MouseEvent;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public abstract class GuiComponent {
    protected final IMinecraft mc = IMinecraft.instance;
    GuiContext context;

    protected GuiComponent() {
    }

    public void setContext(GuiContext context) {
        this.context = context;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public void requestFocus() {
        this.context.setFocusedElement(this);
    }

    public boolean isFocused() {
        return this.context.getFocusedElement() == this;
    }

    public boolean isInFocus() {
        return this.foldRecursive(false, (element, isFocused) -> isFocused != false || element.isFocused());
    }

    public void onLostFocus() {
    }

    public final <T> T foldRecursive(T initial, @NotNull @NotNull BiFunction<@NotNull GuiComponent, T, T> visitor) {
        return (T)this.foldChildren(visitor.apply(this, (GuiComponent)initial), (element, state) -> element.foldRecursive(state, visitor));
    }

    public <T> T foldChildren(T initial, @NotNull @NotNull BiFunction<@NotNull GuiComponent, T, T> visitor) {
        return initial;
    }

    public abstract void render(@NotNull GuiImmediateContext var1);

    public void mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context) {
    }

    public void keyboardEvent(@NotNull KeyboardEvent event, @NotNull GuiImmediateContext context) {
    }

    public GuiContext getContext() {
        return this.context;
    }
}

