/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui;

import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.Config;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.GuiTextures;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.Social;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.common.IMinecraft;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.GuiElement;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.GuiOptionEditor;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.HorizontalAlign;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.editors.GuiOptionEditorAccordion;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.elements.GuiElementTextField;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.ContextAware;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.GlScissorStack;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.LerpUtils;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.LerpingInteger;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.RenderUtils;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.TextRenderUtils;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.processor.MoulConfigProcessor;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.processor.ProcessedCategory;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.processor.ProcessedOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class MoulConfigEditor<T extends Config>
extends GuiElement {
    private final long openedMillis;
    private final LerpingInteger optionsScroll = new LerpingInteger(0, 150);
    private final LerpingInteger categoryScroll = new LerpingInteger(0, 150);
    private final MoulConfigProcessor<T> processedConfig;
    private final LerpingInteger minimumSearchSize = new LerpingInteger(0, 150);
    private final GuiElementTextField searchField = new GuiElementTextField("", 0, 20, 0);
    private String selectedCategory = null;
    private float optionsBarStart;
    private float optionsBarend;
    private int lastMouseX = 0;
    private int keyboardScrollXCutoff = 0;
    private boolean showSubcategories = true;
    private LinkedHashMap<String, ProcessedCategory> currentlyVisibleCategories;
    private Set<ProcessedOption> currentlyVisibleOptions;
    private Map<String, Set<String>> childCategoryLookup = new HashMap<String, Set<String>>();
    private List<ProcessedOption> allOptions = new ArrayList<ProcessedOption>();

    public MoulConfigEditor(MoulConfigProcessor<T> processedConfig) {
        this.openedMillis = System.currentTimeMillis();
        this.processedConfig = processedConfig;
        for (Map.Entry<String, ProcessedCategory> category : processedConfig.getAllCategories().entrySet()) {
            this.allOptions.addAll(category.getValue().options);
            if (category.getValue().parent == null) continue;
            this.childCategoryLookup.computeIfAbsent(category.getValue().parent, ignored -> new HashSet()).add(category.getKey());
        }
        this.updateSearchResults();
    }

    private List<ProcessedOption> getOptionsInCategory(ProcessedCategory cat) {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>(cat.options);
        options.removeIf(it -> !this.currentlyVisibleOptions.contains(it));
        return options;
    }

    public String getSelectedCategory() {
        return this.selectedCategory;
    }

    private void setSelectedCategory(String category) {
        this.selectedCategory = category;
        this.optionsScroll.setValue(0);
    }

    public void search(String searchText) {
        this.searchField.setText(searchText);
        this.updateSearchResults();
    }

    private void propagateSearchinessForAccordions(Set<ProcessedOption> options, Set<ProcessedOption> lastRound, boolean upwards) {
        if (lastRound.isEmpty()) {
            return;
        }
        options.addAll(lastRound);
        HashSet<ProcessedOption> nextRound = new HashSet<ProcessedOption>();
        for (ProcessedOption option : lastRound) {
            if (option.accordionId >= 0 && upwards) {
                for (ProcessedOption accordion : option.category.options) {
                    if (accordion == option || !(accordion.editor instanceof GuiOptionEditorAccordion) || ((GuiOptionEditorAccordion)accordion.editor).getAccordionId() != option.accordionId) continue;
                    nextRound.add(accordion);
                }
            }
            if (!(option.editor instanceof GuiOptionEditorAccordion) || upwards) continue;
            int parentId = ((GuiOptionEditorAccordion)option.editor).getAccordionId();
            for (ProcessedOption potentialChild : option.category.options) {
                if (potentialChild.accordionId != parentId) continue;
                nextRound.add(potentialChild);
            }
        }
        nextRound.removeAll(options);
        this.propagateSearchinessForAccordions(options, nextRound, upwards);
    }

    public void updateSearchResults() {
        this.updateSearchResults(false);
    }

    public void updateSearchResults(boolean recalculateOptionUniverse) {
        String toSearch;
        this.showSubcategories = true;
        if (recalculateOptionUniverse) {
            this.allOptions.clear();
            for (ProcessedCategory category : this.processedConfig.getAllCategories().values()) {
                this.allOptions.addAll(category.options);
            }
        }
        if (!(toSearch = this.searchField.getText().trim().toLowerCase(Locale.ROOT)).isEmpty()) {
            HashSet<ProcessedOption> matchingOptions = new HashSet<ProcessedOption>(this.allOptions);
            for (String word : toSearch.split(" +")) {
                matchingOptions.removeIf(it -> ContextAware.wrapErrorWithContext(it.editor, () -> !it.editor.fulfillsSearch(word)));
            }
            HashSet<ProcessedCategory> directlyMatchedCategories = new HashSet<ProcessedCategory>(this.processedConfig.getAllCategories().values());
            if (!((Config)this.processedConfig.getConfigObject()).shouldSearchCategoryNames()) {
                directlyMatchedCategories.clear();
            }
            for (String word : toSearch.split(" +")) {
                directlyMatchedCategories.removeIf(it -> ContextAware.wrapErrorWithContext(it.reflectField, () -> !it.name.toLowerCase(Locale.ROOT).contains(word) && !it.desc.toLowerCase(Locale.ROOT).contains(word)));
            }
            HashSet<ProcessedOption> matchingOptionsAndDependencies = new HashSet<ProcessedOption>();
            List childCategoriesOfDirectlyMatched = directlyMatchedCategories.stream().flatMap(it -> this.childCategoryLookup.getOrDefault(it.name, Collections.emptySet()).stream()).map(this.processedConfig.getAllCategories()::get).filter(Objects::nonNull).collect(Collectors.toList());
            directlyMatchedCategories.addAll(childCategoriesOfDirectlyMatched);
            for (ProcessedCategory directCategory : directlyMatchedCategories) {
                matchingOptionsAndDependencies.addAll(directCategory.options);
                directCategory.options.forEach(matchingOptions::remove);
            }
            this.propagateSearchinessForAccordions(matchingOptionsAndDependencies, matchingOptions, true);
            this.propagateSearchinessForAccordions(matchingOptionsAndDependencies, matchingOptions, false);
            this.currentlyVisibleOptions = matchingOptionsAndDependencies;
            Set visibleCategories = matchingOptionsAndDependencies.stream().map(it -> it.category).collect(Collectors.toSet());
            Set parentCategories = visibleCategories.stream().filter(it -> it.parent != null).map(it -> this.processedConfig.getAllCategories().get(it.parent)).filter(Objects::nonNull).collect(Collectors.toSet());
            visibleCategories.addAll(parentCategories);
            LinkedHashMap<String, ProcessedCategory> matchingCategories = new LinkedHashMap<String, ProcessedCategory>(this.processedConfig.getAllCategories());
            matchingCategories.entrySet().removeIf(stringProcessedCategoryEntry -> !visibleCategories.contains(stringProcessedCategoryEntry.getValue()));
            this.currentlyVisibleCategories = matchingCategories;
        } else {
            this.currentlyVisibleCategories = this.processedConfig.getAllCategories();
            this.currentlyVisibleOptions = new HashSet<ProcessedOption>(this.allOptions);
        }
    }

    public LinkedHashMap<String, ProcessedCategory> getCurrentlyVisibleCategories() {
        LinkedHashMap<String, ProcessedCategory> newHashes = new LinkedHashMap<String, ProcessedCategory>(this.currentlyVisibleCategories);
        newHashes.entrySet().removeIf(it -> {
            if (((ProcessedCategory)it.getValue()).parent == null) {
                return false;
            }
            if (!this.showSubcategories) {
                return true;
            }
            if (((ProcessedCategory)it.getValue()).parent.equals(this.getSelectedCategory())) {
                return false;
            }
            ProcessedCategory processedCategory = this.currentlyVisibleCategories.get(this.getSelectedCategory());
            if (processedCategory == null) {
                return true;
            }
            return !((ProcessedCategory)it.getValue()).parent.equals(processedCategory.parent);
        });
        return newHashes;
    }

    public LinkedHashMap<String, ProcessedCategory> getCurrentlySearchedCategories() {
        return this.currentlyVisibleCategories;
    }

    @Override
    public void render() {
        int finalOptionWidth;
        int finalY;
        int finalX;
        int optionHeight;
        int accordionDepth;
        int accordionDepth2;
        int optionWidth;
        boolean shouldShow;
        this.optionsScroll.tick();
        this.categoryScroll.tick();
        this.handleKeyboardPresses();
        List<String> tooltipToDisplay = null;
        long currentTime = System.currentTimeMillis();
        long delta = currentTime - this.openedMillis;
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
        int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
        float opacityFactor = LerpUtils.sigmoidZeroOne((float)delta / 500.0f);
        RenderUtils.drawGradientRect(0, 0, 0, width, height, (int)(128.0f * opacityFactor) << 24 | 0x101010, (int)(144.0f * opacityFactor) << 24 | 0x101010);
        int xSize = Math.min(scaledResolution.func_78326_a() - 100 / scaledResolution.func_78325_e(), 500);
        int ySize = Math.min(scaledResolution.func_78328_b() - 100 / scaledResolution.func_78325_e(), 400);
        int x = (scaledResolution.func_78326_a() - xSize) / 2;
        int y = (scaledResolution.func_78328_b() - ySize) / 2;
        int adjScaleFactor = Math.max(2, scaledResolution.func_78325_e());
        int openingXSize = xSize;
        int openingYSize = ySize;
        if (delta < 150L) {
            openingXSize = (int)(delta * (long)xSize / 150L);
            openingYSize = 5;
        } else if (delta < 300L) {
            openingYSize = 5 + (int)(delta - 150L) * (ySize - 5) / 150;
        }
        RenderUtils.drawFloatingRectDark((scaledResolution.func_78326_a() - openingXSize) / 2, (scaledResolution.func_78328_b() - openingYSize) / 2, openingXSize, openingYSize);
        GlScissorStack.clear();
        GlScissorStack.push((scaledResolution.func_78326_a() - openingXSize) / 2, (scaledResolution.func_78328_b() - openingYSize) / 2, (scaledResolution.func_78326_a() + openingXSize) / 2, (scaledResolution.func_78328_b() + openingYSize) / 2, scaledResolution);
        RenderUtils.drawFloatingRectDark(x + 5, y + 5, xSize - 10, 20, false);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        TextRenderUtils.drawStringCenteredScaledMaxWidth(((Config)this.processedConfig.getConfigObject()).getTitle(), fr, x + xSize / 2, y + 15, false, xSize - ((Config)this.processedConfig.getConfigObject()).getSocials().size() * 18 * 2 - 25, 0xA0A0A0);
        RenderUtils.drawFloatingRectDark(x + 4, y + 49 - 20, 140, ySize - 54 + 20, false);
        int innerPadding = 20 / adjScaleFactor;
        int innerLeft = x + 4 + innerPadding;
        int innerRight = x + 144 - innerPadding;
        int innerTop = y + 49 + innerPadding;
        int innerBottom = y + ySize - 5 - innerPadding;
        Gui.func_73734_a((int)innerLeft, (int)innerTop, (int)(innerLeft + 1), (int)innerBottom, (int)-16250866);
        Gui.func_73734_a((int)(innerLeft + 1), (int)innerTop, (int)innerRight, (int)(innerTop + 1), (int)-16250866);
        Gui.func_73734_a((int)(innerRight - 1), (int)(innerTop + 1), (int)innerRight, (int)innerBottom, (int)-14145490);
        Gui.func_73734_a((int)(innerLeft + 1), (int)(innerBottom - 1), (int)(innerRight - 1), (int)innerBottom, (int)-14145490);
        Gui.func_73734_a((int)(innerLeft + 1), (int)(innerTop + 1), (int)(innerRight - 1), (int)(innerBottom - 1), (int)1611139086);
        GlScissorStack.push(0, innerTop + 1, scaledResolution.func_78326_a(), innerBottom - 1, scaledResolution);
        float catBarSize = 1.0f;
        int catY = -this.categoryScroll.getValue();
        LinkedHashMap<String, ProcessedCategory> currentConfigEditing = this.getCurrentlyVisibleCategories();
        for (Map.Entry<String, ProcessedCategory> entry : currentConfigEditing.entrySet()) {
            boolean isIndented;
            String selectedCategory = this.getSelectedCategory();
            if (selectedCategory == null || !currentConfigEditing.containsKey(selectedCategory)) {
                this.setSelectedCategory(entry.getKey());
            }
            boolean isSelected = entry.getKey().equals(this.getSelectedCategory());
            Set<String> childCategories = this.childCategoryLookup.get(entry.getKey());
            String catName = ((Config)this.processedConfig.getConfigObject()).formatCategoryName(entry.getValue(), isSelected);
            HorizontalAlign align = ((Config)this.processedConfig.getConfigObject()).alignCategory(entry.getValue(), isSelected);
            int textLength = fr.func_78256_a(catName);
            if (textLength > ((isIndented = childCategories != null || entry.getValue().parent != null) ? 90 : 100)) {
                TextRenderUtils.drawStringCenteredScaledMaxWidth(catName, fr, x + 75 + (isIndented ? 5 : 0), y + 70 + catY, false, isIndented ? 90 : 100, -1);
            } else if (align == HorizontalAlign.CENTER) {
                TextRenderUtils.drawStringCenteredScaledMaxWidth(catName, fr, x + 75, y + 70 + catY, false, isIndented ? 90 : 100, -1);
            } else if (align == HorizontalAlign.RIGHT) {
                fr.func_175065_a(catName, (float)(x + 75 + 50 - textLength), (float)(y + 70 + catY - fr.field_78288_b / 2), -1, false);
            } else {
                fr.func_175065_a(catName, (float)(x + 75 - 50 + (isIndented ? 10 : 0)), (float)(y + 70 + catY - fr.field_78288_b / 2), -1, false);
            }
            if (childCategories != null) {
                boolean isExpanded = this.showSubcategories && (isSelected || childCategories.contains(this.getSelectedCategory()));
                RenderUtils.drawOpenCloseTriangle(isExpanded, (double)x + 24.5, y + 67 + catY, 6.0, 6.0);
                if (isExpanded) {
                    this.func_73728_b(x + 27, y + catY + 76, y + catY + 76 + (int)childCategories.stream().filter(currentConfigEditing::containsKey).count() * 15, -12303292);
                }
            }
            if ((catY += 15) <= 0) continue;
            catBarSize = LerpUtils.clampZeroOne((float)(innerBottom - innerTop - 2) / (float)(catY + 5 + this.categoryScroll.getValue()));
        }
        float catBarStart = (float)this.categoryScroll.getValue() / (float)(catY + this.categoryScroll.getValue());
        float catBarEnd = catBarStart + catBarSize;
        if (catBarEnd > 1.0f) {
            catBarEnd = 1.0f;
            if ((float)this.categoryScroll.getTarget() / (float)(catY + this.categoryScroll.getValue()) + catBarSize < 1.0f) {
                int target = this.optionsScroll.getTarget();
                this.categoryScroll.setValue((int)Math.ceil((float)(catY + 5 + this.categoryScroll.getValue()) - catBarSize * (float)(catY + 5 + this.categoryScroll.getValue())));
                this.categoryScroll.setTarget(target);
            } else {
                this.categoryScroll.setValue((int)Math.ceil((float)(catY + 5 + this.categoryScroll.getValue()) - catBarSize * (float)(catY + 5 + this.categoryScroll.getValue())));
            }
        }
        int catDist = innerBottom - innerTop - 12;
        Gui.func_73734_a((int)(innerLeft + 2), (int)(innerTop + 5), (int)(innerLeft + 7), (int)(innerBottom - 5), (int)-15724528);
        Gui.func_73734_a((int)(innerLeft + 3), (int)(innerTop + 6 + (int)((float)catDist * catBarStart)), (int)(innerLeft + 6), (int)(innerTop + 6 + (int)((float)catDist * catBarEnd)), (int)-13619152);
        GlScissorStack.pop(scaledResolution);
        TextRenderUtils.drawStringCenteredScaledMaxWidth("Categories", fr, x + 75, y + 44, false, 120, 10709231);
        RenderUtils.drawFloatingRectDark(x + 149, y + 29, xSize - 154, ySize - 34, false);
        innerLeft = x + 149 + innerPadding;
        innerRight = x + xSize - 5 - innerPadding;
        innerBottom = y + ySize - 5 - innerPadding;
        IMinecraft.instance.bindTexture(GuiTextures.SEARCH);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.drawTexturedRect(innerRight - 20, innerTop - (20 + innerPadding) / 2 - 9, 18.0f, 18.0f, 9728);
        this.minimumSearchSize.tick();
        boolean bl = shouldShow = !this.searchField.getText().trim().isEmpty() || this.searchField.getFocus();
        if (shouldShow && this.minimumSearchSize.getTarget() < 30) {
            this.minimumSearchSize.setTarget(30);
            this.minimumSearchSize.resetTimer();
        } else if (!shouldShow && this.minimumSearchSize.getTarget() > 0) {
            this.minimumSearchSize.setTarget(0);
            this.minimumSearchSize.resetTimer();
        }
        int rightStuffLen = 20;
        if (this.minimumSearchSize.getValue() > 1) {
            int strLen = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.searchField.getText()) + 10;
            if (!shouldShow) {
                strLen = 0;
            }
            int len2 = Math.max(strLen, this.minimumSearchSize.getValue());
            this.searchField.setSize(len2, 18);
            this.searchField.render(innerRight - 25 - len2, innerTop - (20 + innerPadding) / 2 - 9);
            rightStuffLen += 5 + len2;
        }
        if (this.getSelectedCategory() != null && currentConfigEditing.containsKey(this.getSelectedCategory())) {
            ProcessedCategory cat = currentConfigEditing.get(this.getSelectedCategory());
            TextRenderUtils.drawStringScaledMaxWidth(cat.desc, fr, innerLeft + 5, y + 40, true, innerRight - innerLeft - rightStuffLen - 10, 0xB0B0B0);
        }
        Gui.func_73734_a((int)innerLeft, (int)innerTop, (int)(innerLeft + 1), (int)innerBottom, (int)-16250866);
        Gui.func_73734_a((int)(innerLeft + 1), (int)innerTop, (int)innerRight, (int)(innerTop + 1), (int)-16250866);
        Gui.func_73734_a((int)(innerRight - 1), (int)(innerTop + 1), (int)innerRight, (int)innerBottom, (int)-13619146);
        Gui.func_73734_a((int)(innerLeft + 1), (int)(innerBottom - 1), (int)(innerRight - 1), (int)innerBottom, (int)-13619146);
        Gui.func_73734_a((int)(innerLeft + 1), (int)(innerTop + 1), (int)(innerRight - 1), (int)(innerBottom - 1), (int)1611139086);
        GlScissorStack.push(innerLeft + 1, innerTop + 1, innerRight - 1, innerBottom - 1, scaledResolution);
        float barSize = 1.0f;
        int optionY = -this.optionsScroll.getValue();
        if (this.getSelectedCategory() != null && currentConfigEditing.containsKey(this.getSelectedCategory())) {
            ProcessedCategory cat = currentConfigEditing.get(this.getSelectedCategory());
            int optionWidthDefault = innerRight - innerLeft - 20;
            GlStateManager.func_179126_j();
            HashMap<Integer, Integer> activeAccordions = new HashMap<Integer, Integer>();
            List<ProcessedOption> options = this.getOptionsInCategory(cat);
            if (options.isEmpty()) {
                int titlePositionX = (innerLeft + innerRight) / 2;
                int titlePositionY = (innerTop + innerBottom) / 3;
                int innerSize = innerRight - innerLeft - 40;
                int titleScale = 2;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)titlePositionX, (float)titlePositionY, (float)0.0f);
                TextRenderUtils.drawStringCenteredScaledMaxWidth("\u00a77Seems like your search is found in a subcategory.", fr, 0.0f, titleScale * fr.field_78288_b, true, innerSize, -1);
                TextRenderUtils.drawStringCenteredScaledMaxWidth("\u00a77Check out the subcategories on the left.", fr, 0.0f, (titleScale + 1) * fr.field_78288_b, true, innerSize, -1);
                GlStateManager.func_179152_a((float)titleScale, (float)titleScale, (float)1.0f);
                TextRenderUtils.drawStringCenteredScaledMaxWidth("\u00a77No options found.", fr, 0.0f, 0.0f, true, innerSize / titleScale, -1);
                GlStateManager.func_179121_F();
            }
            for (ProcessedOption option : options) {
                GuiOptionEditorAccordion accordion;
                GuiOptionEditor editor;
                optionWidth = optionWidthDefault;
                if (option.accordionId >= 0) {
                    if (!activeAccordions.containsKey(option.accordionId)) continue;
                    accordionDepth2 = (Integer)activeAccordions.get(option.accordionId);
                    optionWidth = optionWidthDefault - 2 * innerPadding * (accordionDepth2 + 1);
                }
                if ((editor = option.editor) == null) continue;
                if (editor instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor).getToggled()) {
                    accordionDepth = 0;
                    if (option.accordionId >= 0) {
                        accordionDepth = (Integer)activeAccordions.get(option.accordionId) + 1;
                    }
                    activeAccordions.put(accordion.getAccordionId(), accordionDepth);
                }
                optionHeight = ContextAware.wrapErrorWithContext(editor, editor::getHeight);
                if (innerTop + 5 + optionY + optionHeight > innerTop + 1 && innerTop + 5 + optionY < innerBottom - 1) {
                    finalX = (innerLeft + innerRight - optionWidth) / 2 - 5;
                    finalY = innerTop + 5 + optionY;
                    finalOptionWidth = optionWidth;
                    ContextAware.wrapErrorWithContext(editor, () -> {
                        editor.render(finalX, finalY, finalOptionWidth);
                        return null;
                    });
                }
                optionY += optionHeight + 5;
            }
            GlStateManager.func_179097_i();
            if (optionY > 0) {
                barSize = LerpUtils.clampZeroOne((float)(innerBottom - innerTop - 2) / (float)(optionY + 5 + this.optionsScroll.getValue()));
            }
        }
        GlScissorStack.pop(scaledResolution);
        GL11.glDisable((int)3089);
        if (this.getSelectedCategory() != null && currentConfigEditing.containsKey(this.getSelectedCategory())) {
            int optionYOverlay = -this.optionsScroll.getValue();
            ProcessedCategory cat = currentConfigEditing.get(this.getSelectedCategory());
            int optionWidthDefault = innerRight - innerLeft - 20;
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)10.0f);
            GlStateManager.func_179126_j();
            HashMap<Integer, Integer> activeAccordions = new HashMap<Integer, Integer>();
            for (ProcessedOption option : this.getOptionsInCategory(cat)) {
                GuiOptionEditorAccordion accordion;
                GuiOptionEditor editor;
                optionWidth = optionWidthDefault;
                if (option.accordionId >= 0) {
                    if (!activeAccordions.containsKey(option.accordionId)) continue;
                    accordionDepth2 = (Integer)activeAccordions.get(option.accordionId);
                    optionWidth = optionWidthDefault - 2 * innerPadding * (accordionDepth2 + 1);
                }
                if ((editor = option.editor) == null) continue;
                if (editor instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor).getToggled()) {
                    accordionDepth = 0;
                    if (option.accordionId >= 0) {
                        accordionDepth = (Integer)activeAccordions.get(option.accordionId) + 1;
                    }
                    activeAccordions.put(accordion.getAccordionId(), accordionDepth);
                }
                optionHeight = ContextAware.wrapErrorWithContext(editor, editor::getHeight);
                if (innerTop + 5 + optionYOverlay + optionHeight > innerTop + 1 && innerTop + 5 + optionYOverlay < innerBottom - 1) {
                    finalX = (innerLeft + innerRight - optionWidth) / 2 - 5;
                    finalY = innerTop + 5 + optionYOverlay;
                    finalOptionWidth = optionWidth;
                    ContextAware.wrapErrorWithContext(editor, () -> {
                        editor.renderOverlay(finalX, finalY, finalOptionWidth);
                        return null;
                    });
                }
                optionYOverlay += optionHeight + 5;
            }
            GlStateManager.func_179097_i();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-10.0f);
        }
        GL11.glEnable((int)3089);
        this.optionsBarStart = (float)this.optionsScroll.getValue() / (float)(optionY + this.optionsScroll.getValue());
        this.optionsBarend = this.optionsBarStart + barSize;
        if (this.optionsBarend > 1.0f) {
            this.optionsBarend = 1.0f;
            if ((float)this.optionsScroll.getTarget() / (float)(optionY + this.optionsScroll.getValue()) + barSize < 1.0f) {
                int target = this.optionsScroll.getTarget();
                this.optionsScroll.setValue((int)Math.ceil((float)(optionY + 5 + this.optionsScroll.getValue()) - barSize * (float)(optionY + 5 + this.optionsScroll.getValue())));
                this.optionsScroll.setTarget(target);
            } else {
                this.optionsScroll.setValue((int)Math.ceil((float)(optionY + 5 + this.optionsScroll.getValue()) - barSize * (float)(optionY + 5 + this.optionsScroll.getValue())));
            }
        }
        int dist = innerBottom - innerTop - 12;
        Gui.func_73734_a((int)(innerRight - 10), (int)(innerTop + 5), (int)(innerRight - 5), (int)(innerBottom - 5), (int)-15724528);
        Gui.func_73734_a((int)(innerRight - 9), (int)(innerTop + 6 + (int)((float)dist * this.optionsBarStart)), (int)(innerRight - 6), (int)(innerTop + 6 + (int)((float)dist * this.optionsBarend)), (int)-13619152);
        List<Social> socials = ((Config)this.processedConfig.getConfigObject()).getSocials();
        for (int socialIndex = 0; socialIndex < socials.size(); ++socialIndex) {
            Social social = socials.get(socialIndex);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(social.getIcon());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int socialLeft = x + xSize - 23 - 18 * socialIndex;
            RenderUtils.drawTexturedRect(socialLeft, y + 7, 16.0f, 16.0f, 9729);
            if (mouseX < socialLeft || mouseX > socialLeft + 16 || mouseY < y + 6 || mouseY > y + 23) continue;
            tooltipToDisplay = social.getTooltip();
        }
        GlScissorStack.clear();
        if (tooltipToDisplay != null) {
            TextRenderUtils.drawHoveringText(tooltipToDisplay, mouseX, mouseY, width, height, -1, fr);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2.0f);
    }

    @Override
    public boolean mouseInput(int mouseX, int mouseY) {
        int finalWidth;
        int finalY;
        int accordionDepth;
        GuiOptionEditor editor;
        this.lastMouseX = mouseX;
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int xSize = Math.min(width - 100 / scaledResolution.func_78325_e(), 500);
        int ySize = Math.min(height - 100 / scaledResolution.func_78325_e(), 400);
        int x = (scaledResolution.func_78326_a() - xSize) / 2;
        int y = (scaledResolution.func_78328_b() - ySize) / 2;
        int adjScaleFactor = Math.max(2, scaledResolution.func_78325_e());
        int innerPadding = 20 / adjScaleFactor;
        int innerTop = y + 49 + innerPadding;
        int innerBottom = y + ySize - 5 - innerPadding;
        int innerLeft = x + 149 + innerPadding;
        int innerRight = x + xSize - 5 - innerPadding;
        int dist = innerBottom - innerTop - 12;
        int optionsBarStartY = innerTop + 6 + (int)((float)dist * this.optionsBarStart);
        int optionsBarEndY = innerTop + 6 + (int)((float)dist * this.optionsBarend);
        int optionsBarStartX = innerRight - 12;
        int optionsBarEndX = innerRight - 3;
        int categoryY = -this.categoryScroll.getValue();
        int catDist = innerBottom - innerTop - 12;
        float catBarStart = (float)this.categoryScroll.getValue() / (float)((categoryY += 15 * this.getCurrentlyVisibleCategories().size()) + this.categoryScroll.getValue());
        float categoryBarSize = LerpUtils.clampZeroOne((float)(innerBottom - innerTop - 2) / (float)(categoryY + 5 + this.categoryScroll.getValue()));
        float catBarEnd = catBarStart + categoryBarSize;
        int categoryBarStartY = innerTop + 6 + (int)((float)catDist * catBarStart);
        int categoryBarEndY = innerTop + 6 + (int)((float)catDist * catBarEnd);
        int categoryBarStartX = x + innerPadding + 7;
        int categoryBarEndX = x + innerPadding + 12;
        this.keyboardScrollXCutoff = innerLeft - 10;
        if (Mouse.getEventButtonState()) {
            int strLen;
            int len2;
            if ((mouseY < optionsBarStartY || mouseY > optionsBarEndY) && mouseX >= optionsBarStartX && mouseX <= optionsBarEndX && mouseY > innerTop + 6 && mouseY < innerBottom - 6) {
                this.optionsScroll.setTimeToReachTarget(200);
                this.optionsScroll.resetTimer();
                this.optionsScroll.setTarget(mouseY - innerTop);
                return true;
            }
            if ((mouseY < categoryBarStartY || mouseY > categoryBarEndY) && mouseX >= categoryBarStartX && mouseX <= categoryBarEndX && mouseY > innerTop + 6 && mouseY < innerBottom - 6) {
                this.categoryScroll.setTimeToReachTarget(200);
                this.categoryScroll.resetTimer();
                this.categoryScroll.setTarget(mouseY - innerTop);
                return true;
            }
            this.searchField.setFocus(mouseX >= innerRight - 20 && mouseX <= innerRight - 2 && mouseY >= innerTop - (20 + innerPadding) / 2 - 9 && mouseY <= innerTop - (20 + innerPadding) / 2 + 9);
            if (this.minimumSearchSize.getValue() > 1 && mouseX >= innerRight - 25 - (len2 = Math.max(strLen = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.searchField.getText()) + 10, this.minimumSearchSize.getValue())) && mouseX <= innerRight - 25 && mouseY >= innerTop - (20 + innerPadding) / 2 - 9 && mouseY <= innerTop - (20 + innerPadding) / 2 + 9) {
                String old = this.searchField.getText();
                this.searchField.mouseClicked(mouseX, mouseY, Mouse.getEventButton());
                if (!this.searchField.getText().equals(old)) {
                    this.updateSearchResults();
                }
            }
        }
        int dWheel = Mouse.getEventDWheel();
        if (mouseY > innerTop && mouseY < innerBottom && dWheel != 0) {
            int barMax;
            int newTarget;
            if (dWheel < 0) {
                dWheel = -1;
            }
            if (dWheel > 0) {
                dWheel = 1;
            }
            if (mouseX < innerLeft) {
                newTarget = this.categoryScroll.getTarget() - dWheel * 30;
                if (newTarget < 0) {
                    newTarget = 0;
                }
                float catBarSize = 1.0f;
                int catY = -newTarget;
                for (Map.Entry<String, ProcessedCategory> entry : this.getCurrentlyVisibleCategories().entrySet()) {
                    if (this.getSelectedCategory() == null) {
                        this.setSelectedCategory(entry.getKey());
                    }
                    if ((catY += 15) <= 0) continue;
                    catBarSize = LerpUtils.clampZeroOne((float)(innerBottom - innerTop - 2) / (float)(catY + 5 + newTarget));
                }
                barMax = (int)Math.floor((float)(catY + 5 + newTarget) - catBarSize * (float)(catY + 5 + newTarget));
                if (newTarget > barMax) {
                    newTarget = barMax;
                }
                this.categoryScroll.resetTimer();
                this.categoryScroll.setTarget(newTarget);
            } else {
                newTarget = this.optionsScroll.getTarget() - dWheel * 30;
                if (newTarget < 0) {
                    newTarget = 0;
                }
                float barSize = 1.0f;
                int optionY = -newTarget;
                if (this.getSelectedCategory() != null && this.getCurrentlyVisibleCategories() != null && this.getCurrentlyVisibleCategories().containsKey(this.getSelectedCategory())) {
                    ProcessedCategory cat = this.getCurrentlyVisibleCategories().get(this.getSelectedCategory());
                    HashMap<Integer, Integer> activeAccordions = new HashMap<Integer, Integer>();
                    for (ProcessedOption option : this.getOptionsInCategory(cat)) {
                        GuiOptionEditorAccordion accordion;
                        if (option.accordionId >= 0 && !activeAccordions.containsKey(option.accordionId) || (editor = option.editor) == null) continue;
                        if (editor instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor).getToggled()) {
                            accordionDepth = 0;
                            if (option.accordionId >= 0) {
                                accordionDepth = (Integer)activeAccordions.get(option.accordionId) + 1;
                            }
                            activeAccordions.put(accordion.getAccordionId(), accordionDepth);
                        }
                        if ((optionY += ContextAware.wrapErrorWithContext(editor, editor::getHeight) + 5) <= 0) continue;
                        barSize = LerpUtils.clampZeroOne((float)(innerBottom - innerTop - 2) / (float)(optionY + 5 + newTarget));
                    }
                }
                if (newTarget > (barMax = (int)Math.floor((float)(optionY + 5 + newTarget) - barSize * (float)(optionY + 5 + newTarget)))) {
                    newTarget = barMax;
                }
                this.optionsScroll.setTimeToReachTarget(Math.min(150, Math.max(10, 5 * Math.abs(newTarget - this.optionsScroll.getValue()))));
                this.optionsScroll.resetTimer();
                this.optionsScroll.setTarget(newTarget);
            }
        } else if (Mouse.getEventButtonState() && Mouse.getEventButton() == 0) {
            if (this.getCurrentlyVisibleCategories() != null) {
                int catY = -this.categoryScroll.getValue();
                for (Map.Entry<String, ProcessedCategory> entry : this.getCurrentlyVisibleCategories().entrySet()) {
                    if (this.getSelectedCategory() == null) {
                        this.setSelectedCategory(entry.getKey());
                    }
                    if (mouseX >= x + 5 && mouseX <= x + 145 && mouseY >= y + 70 + catY - 7 && mouseY <= y + 70 + catY + 7) {
                        if (entry.getKey().equals(this.getSelectedCategory())) {
                            if (entry.getValue().parent == null) {
                                this.showSubcategories = !this.showSubcategories;
                            }
                        } else {
                            this.showSubcategories = true;
                            this.setSelectedCategory(entry.getKey());
                        }
                        return true;
                    }
                    catY += 15;
                }
            }
            List<Social> socials = ((Config)this.processedConfig.getConfigObject()).getSocials();
            for (int socialIndex = 0; socialIndex < socials.size(); ++socialIndex) {
                int socialLeft = x + xSize - 23 - 18 * socialIndex;
                if (mouseX < socialLeft || mouseX > socialLeft + 16 || mouseY < y + 6 || mouseY > y + 23) continue;
                socials.get(socialIndex).onClick();
                return true;
            }
        }
        int optionY = -this.optionsScroll.getValue();
        if (this.getSelectedCategory() != null && this.getCurrentlyVisibleCategories() != null && this.getCurrentlyVisibleCategories().containsKey(this.getSelectedCategory())) {
            int optionWidthDefault = innerRight - innerLeft - 20;
            ProcessedCategory cat = this.getCurrentlyVisibleCategories().get(this.getSelectedCategory());
            HashMap<Integer, Integer> activeAccordions = new HashMap<Integer, Integer>();
            for (ProcessedOption option : this.getOptionsInCategory(cat)) {
                int finalX;
                GuiOptionEditorAccordion accordion;
                int optionWidth = optionWidthDefault;
                if (option.accordionId >= 0) {
                    if (!activeAccordions.containsKey(option.accordionId)) continue;
                    int accordionDepth2 = (Integer)activeAccordions.get(option.accordionId);
                    optionWidth = optionWidthDefault - 2 * innerPadding * (accordionDepth2 + 1);
                }
                if ((editor = option.editor) == null) continue;
                if (editor instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor).getToggled()) {
                    accordionDepth = 0;
                    if (option.accordionId >= 0) {
                        accordionDepth = (Integer)activeAccordions.get(option.accordionId) + 1;
                    }
                    activeAccordions.put(accordion.getAccordionId(), accordionDepth);
                }
                if (ContextAware.wrapErrorWithContext(editor, () -> MoulConfigEditor.lambda$mouseInput$14(editor, finalX = (innerLeft + innerRight - optionWidth) / 2 - 5, finalY = innerTop + 5 + optionY, finalWidth = optionWidth, mouseX, mouseY)).booleanValue()) {
                    return true;
                }
                optionY += ContextAware.wrapErrorWithContext(editor, editor::getHeight) + 5;
            }
        }
        if (mouseX > innerLeft && mouseX < innerRight && mouseY > innerTop && mouseY < innerBottom) {
            optionY = -this.optionsScroll.getValue();
            if (this.getSelectedCategory() != null && this.getCurrentlyVisibleCategories() != null && this.getCurrentlyVisibleCategories().containsKey(this.getSelectedCategory())) {
                int optionWidthDefault = innerRight - innerLeft - 20;
                ProcessedCategory cat = this.getCurrentlyVisibleCategories().get(this.getSelectedCategory());
                HashMap<Integer, Integer> activeAccordions = new HashMap<Integer, Integer>();
                for (ProcessedOption option : this.getOptionsInCategory(cat)) {
                    int finalX;
                    GuiOptionEditorAccordion accordion;
                    int optionWidth = optionWidthDefault;
                    if (option.accordionId >= 0) {
                        if (!activeAccordions.containsKey(option.accordionId)) continue;
                        int accordionDepth3 = (Integer)activeAccordions.get(option.accordionId);
                        optionWidth = optionWidthDefault - 2 * innerPadding * (accordionDepth3 + 1);
                    }
                    if ((editor = option.editor) == null) continue;
                    if (editor instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor).getToggled()) {
                        accordionDepth = 0;
                        if (option.accordionId >= 0) {
                            accordionDepth = (Integer)activeAccordions.get(option.accordionId) + 1;
                        }
                        activeAccordions.put(accordion.getAccordionId(), accordionDepth);
                    }
                    if (ContextAware.wrapErrorWithContext(editor, () -> MoulConfigEditor.lambda$mouseInput$15(editor, finalX = (innerLeft + innerRight - optionWidth) / 2 - 5, finalY = innerTop + 5 + optionY, finalWidth = optionWidth, mouseX, mouseY)).booleanValue()) {
                        return true;
                    }
                    optionY += ContextAware.wrapErrorWithContext(editor, editor::getHeight) + 5;
                }
            }
        }
        return true;
    }

    @Override
    public boolean keyboardInput() {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int xSize = Math.min(width - 100 / scaledResolution.func_78325_e(), 500);
        int adjScaleFactor = Math.max(2, scaledResolution.func_78325_e());
        int innerPadding = 20 / adjScaleFactor;
        int innerWidth = xSize - 154 - innerPadding * 2;
        if (this.getSelectedCategory() != null && this.getCurrentlyVisibleCategories() != null && this.getCurrentlyVisibleCategories().containsKey(this.getSelectedCategory())) {
            ProcessedCategory cat = this.getCurrentlyVisibleCategories().get(this.getSelectedCategory());
            HashMap<Integer, Integer> activeAccordions = new HashMap<Integer, Integer>();
            for (ProcessedOption option : this.getOptionsInCategory(cat)) {
                GuiOptionEditorAccordion accordion;
                GuiOptionEditor editor;
                if (option.accordionId >= 0 && !activeAccordions.containsKey(option.accordionId) || (editor = option.editor) == null) continue;
                if (editor instanceof GuiOptionEditorAccordion && (accordion = (GuiOptionEditorAccordion)editor).getToggled()) {
                    int accordionDepth = 0;
                    if (option.accordionId >= 0) {
                        accordionDepth = (Integer)activeAccordions.get(option.accordionId) + 1;
                    }
                    activeAccordions.put(accordion.getAccordionId(), accordionDepth);
                }
                if (!ContextAware.wrapErrorWithContext(editor, editor::keyboardInput).booleanValue()) continue;
                return true;
            }
        }
        if (Keyboard.getEventKeyState()) {
            if (Keyboard.isKeyDown((int)29) && Keyboard.isKeyDown((int)33)) {
                this.searchField.setFocus(!this.searchField.getFocus());
                return true;
            }
            if (!this.searchField.getFocus() && !Character.isISOControl(Keyboard.getEventCharacter()) && ((Config)this.processedConfig.getConfigObject()).shouldAutoFocusSearchbar()) {
                this.searchField.setFocus(true);
            }
            String old = this.searchField.getText();
            this.searchField.keyTyped(Keyboard.getEventCharacter(), Keyboard.getEventKey());
            if (!this.searchField.getText().equals(old)) {
                this.searchField.setText(Minecraft.func_71410_x().field_71466_p.func_78269_a(this.searchField.getText(), innerWidth / 2 - 20));
                this.updateSearchResults();
                return true;
            }
        }
        return false;
    }

    private void handleKeyboardPresses() {
        LerpingInteger target;
        LerpingInteger lerpingInteger = target = this.lastMouseX < this.keyboardScrollXCutoff ? this.categoryScroll : this.optionsScroll;
        if (Keyboard.isKeyDown((int)208)) {
            target.setTimeToReachTarget(50);
            target.resetTimer();
            target.setTarget(target.getTarget() + 5);
        } else if (Keyboard.isKeyDown((int)200)) {
            target.setTimeToReachTarget(50);
            target.resetTimer();
            if (target.getTarget() >= 0) {
                target.setTarget(target.getTarget() - 5);
            }
        } else if (Keyboard.isKeyDown((int)1)) {
            ((Config)this.processedConfig.getConfigObject()).saveNow();
        }
    }

    private static /* synthetic */ Boolean lambda$mouseInput$15(GuiOptionEditor editor, int finalX, int finalY, int finalWidth, int mouseX, int mouseY) throws Exception {
        return editor.mouseInput(finalX, finalY, finalWidth, mouseX, mouseY);
    }

    private static /* synthetic */ Boolean lambda$mouseInput$14(GuiOptionEditor editor, int finalX, int finalY, int finalWidth, int mouseX, int mouseY) throws Exception {
        return editor.mouseInputOverlay(finalX, finalY, finalWidth, mouseX, mouseY);
    }
}

