/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.editors;

import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.GuiOptionEditor;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.RenderUtils;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.TextRenderUtils;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.processor.ProcessedOption;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiOptionEditorDropdown
extends GuiOptionEditor {
    private String[] values;
    private boolean useOrdinal;
    private boolean open = false;
    private Enum<?>[] constants;
    private String valuesForSearch;

    public GuiOptionEditorDropdown(ProcessedOption option, String[] values) {
        super(option);
        Class clazz = (Class)option.getType();
        if (Enum.class.isAssignableFrom(clazz)) {
            this.constants = (Enum[])clazz.getEnumConstants();
            this.values = new String[this.constants.length];
            for (int i = 0; i < this.constants.length; ++i) {
                this.values[i] = this.constants[i].toString();
            }
        } else {
            this.values = values;
            assert (values.length > 0);
        }
        this.useOrdinal = clazz == Integer.TYPE || clazz == Integer.class;
    }

    @Override
    public void render(int x, int y, int width) {
        super.render(x, y, width);
        if (!this.open) {
            int height = this.getHeight();
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            int dropdownWidth = Math.min(width / 3 - 10, 80);
            int left = x + width / 6 - dropdownWidth / 2;
            int top = y + height - 7 - 14;
            int selected = this.getSelectedIndex();
            if (selected >= this.values.length) {
                selected = this.values.length;
            }
            String selectedString = " - Select - ";
            if (selected >= 0 && selected < this.values.length) {
                selectedString = this.values[selected];
            }
            RenderUtils.drawFloatingRectDark(left, top, dropdownWidth, 14, false);
            TextRenderUtils.drawStringScaled("\u25bc", fr, left + dropdownWidth - 10, y + height - 7 - 15, false, -6250336, 2.0f);
            TextRenderUtils.drawStringScaledMaxWidth(selectedString, fr, left + 3, top + 3, false, dropdownWidth - 16, -6250336);
        }
    }

    private int getSelectedIndex() {
        Object selectedObject = this.option.get();
        if (selectedObject == null) {
            return -1;
        }
        if (this.useOrdinal) {
            return (Integer)selectedObject;
        }
        if (this.constants != null) {
            return ((Enum)selectedObject).ordinal();
        }
        return Arrays.asList(this.values).indexOf(selectedObject);
    }

    @Override
    public void renderOverlay(int x, int y, int width) {
        if (this.open) {
            int selected = this.getSelectedIndex();
            String selectedString = " - Select - ";
            if (selected >= 0 && selected < this.values.length) {
                selectedString = this.values[selected];
            }
            int height = this.getHeight();
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            int dropdownWidth = Math.min(width / 3 - 10, 80);
            int left = x + width / 6 - dropdownWidth / 2;
            int top = y + height - 7 - 14;
            int dropdownHeight = 13 + 12 * this.values.length;
            int main = -14671834;
            int blue = -14461523;
            GlStateManager.func_179094_E();
            GL11.glTranslated((double)0.0, (double)0.0, (double)100.0);
            Gui.func_73734_a((int)left, (int)top, (int)(left + 1), (int)(top + dropdownHeight), (int)blue);
            Gui.func_73734_a((int)(left + 1), (int)top, (int)(left + dropdownWidth), (int)(top + 1), (int)blue);
            Gui.func_73734_a((int)(left + dropdownWidth - 1), (int)(top + 1), (int)(left + dropdownWidth), (int)(top + dropdownHeight), (int)blue);
            Gui.func_73734_a((int)(left + 1), (int)(top + dropdownHeight - 1), (int)(left + dropdownWidth - 1), (int)(top + dropdownHeight), (int)blue);
            Gui.func_73734_a((int)(left + 1), (int)(top + 1), (int)(left + dropdownWidth - 1), (int)(top + dropdownHeight - 1), (int)main);
            Gui.func_73734_a((int)(left + 1), (int)(top + 14 - 1), (int)(left + dropdownWidth - 1), (int)(top + 14), (int)blue);
            int dropdownY = 13;
            for (String option : this.values) {
                if (option.isEmpty()) {
                    option = "<NONE>";
                }
                TextRenderUtils.drawStringScaledMaxWidth(option, fr, left + 3, top + 3 + dropdownY, false, dropdownWidth - 6, -6250336);
                dropdownY += 12;
            }
            TextRenderUtils.drawStringScaled("\u25b2", fr, left + dropdownWidth - 10, y + height - 7 - 15, false, -6250336, 2.0f);
            TextRenderUtils.drawStringScaledMaxWidth(selectedString, fr, left + 3, top + 3, false, dropdownWidth - 16, -6250336);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public boolean mouseInput(int x, int y, int width, int mouseX, int mouseY) {
        int height = this.getHeight();
        int left = x + width / 6 - 40;
        int top = y + height - 7 - 14;
        if (Mouse.getEventButtonState() && Mouse.getEventButton() == 0 && mouseX >= left && mouseX <= left + 80 && mouseY >= top && mouseY <= top + 14) {
            this.open = !this.open;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseInputOverlay(int x, int y, int width, int mouseX, int mouseY) {
        int height = this.getHeight();
        int left = x + width / 6 - 40;
        int top = y + height - 7 - 14;
        if (Mouse.getEventButtonState() && Mouse.getEventButton() == 0 && (mouseX < left || mouseX > left + 80 || mouseY < top || mouseY > top + 14) && this.open) {
            this.open = false;
            if (mouseX >= left && mouseX <= left + 80) {
                int dropdownY = 13;
                for (int ordinal = 0; ordinal < this.values.length; ++ordinal) {
                    if (mouseY >= top + 3 + dropdownY && mouseY <= top + 3 + dropdownY + 12) {
                        int selected = ordinal;
                        if (this.constants != null) {
                            this.option.set(this.constants[selected]);
                        } else if (this.useOrdinal) {
                            this.option.set(selected);
                        } else {
                            this.option.set(this.values[selected]);
                        }
                        return true;
                    }
                    dropdownY += 12;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean fulfillsSearch(String word) {
        if (this.valuesForSearch == null) {
            this.valuesForSearch = String.join((CharSequence)"", this.values).toLowerCase(Locale.ROOT);
        }
        return super.fulfillsSearch(word) || this.valuesForSearch.contains(word);
    }

    @Override
    public boolean keyboardInput() {
        return false;
    }
}

