/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.processor;

import com.google.gson.annotations.Expose;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.Config;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.Accordion;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.Category;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.ConfigAccordionId;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.ConfigEditorAccordion;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.ConfigEditorButton;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.ConfigEditorInfoText;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.ConfigOption;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.annotations.ConfigOverlay;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.BoundField;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.Warnings;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.processor.ConfigStructureReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;

public class ConfigProcessorDriver {
    private static final List<Class<? extends Annotation>> nonStoredConfigOptions = Arrays.asList(ConfigEditorAccordion.class, ConfigEditorInfoText.class, ConfigEditorButton.class);
    static int nextAnnotation = 1000000000;

    private static List<Field> getAllFields(Class<?> type2) {
        if (type2 == null) {
            return new ArrayList<Field>();
        }
        List<Field> fields = ConfigProcessorDriver.getAllFields(type2.getSuperclass());
        fields.addAll(Arrays.asList(type2.getDeclaredFields()));
        return fields;
    }

    public static void processCategory(Object categoryObject, Class<?> categoryClass, ConfigStructureReader reader, List<BoundField> deferredSubCategories) {
        Stack<Integer> accordionStack = new Stack<Integer>();
        HashSet<Integer> usedAccordionIds = new HashSet<Integer>();
        for (Field field : ConfigProcessorDriver.getAllFields(categoryClass)) {
            Accordion accordionClassAnnotation;
            ConfigAccordionId parentAccordion;
            ConfigOverlay annotation;
            ConfigOption optionAnnotation;
            if (field.getAnnotation(Category.class) != null) {
                deferredSubCategories.add(new BoundField(field, categoryObject));
            }
            if ((optionAnnotation = field.getAnnotation(ConfigOption.class)) == null) continue;
            if (field.getAnnotation(Expose.class) == null && (field.getModifiers() & 0x80) == 0) {
                if (nonStoredConfigOptions.stream().noneMatch(field::isAnnotationPresent)) {
                    Warnings.warn("Non transient @ConfigOption without @Expose in " + categoryClass + " on field " + field);
                }
            }
            if ((annotation = field.getAnnotation(ConfigOverlay.class)) != null) {
                reader.emitGuiOverlay(categoryObject, field, optionAnnotation);
                if (!annotation.displayInline()) continue;
            }
            if ((parentAccordion = field.getAnnotation(ConfigAccordionId.class)) == null) {
                while (!accordionStack.isEmpty()) {
                    reader.endAccordion();
                    accordionStack.pop();
                }
            } else {
                while (!accordionStack.isEmpty() && ((Integer)accordionStack.peek()).intValue() != parentAccordion.id()) {
                    accordionStack.pop();
                    reader.endAccordion();
                }
                if (accordionStack.isEmpty()) {
                    Warnings.warn("Invalid @ConfigAccordionId in " + categoryClass + " on field " + field);
                }
            }
            if ((accordionClassAnnotation = field.getAnnotation(Accordion.class)) != null) {
                if (!usedAccordionIds.isEmpty()) {
                    Warnings.warn("Cannot mix @ConfigEditorAccordion and @ConfigAccordionId with @Accordion in class " + categoryClass);
                }
                reader.beginAccordion(categoryObject, field, optionAnnotation, ++nextAnnotation);
                try {
                    reader.pushPath(field.getName());
                    ArrayList<BoundField> subCategory = new ArrayList<BoundField>();
                    ConfigProcessorDriver.processCategory(field.get(categoryObject), field.getType(), reader, subCategory);
                    if (!subCategory.isEmpty()) {
                        Warnings.warn("Cannot define sub categories inside of an accordion: " + subCategory.get(0));
                    }
                    reader.popPath();
                }
                catch (IllegalAccessException e2) {
                    throw new RuntimeException(e2);
                }
                reader.endAccordion();
                continue;
            }
            ConfigEditorAccordion selfAccordion = field.getAnnotation(ConfigEditorAccordion.class);
            if (selfAccordion != null) {
                if (usedAccordionIds.contains(selfAccordion.id())) {
                    Warnings.warn("Reusing of config accordion id " + selfAccordion.id() + " in " + categoryClass + " on field " + field);
                }
                usedAccordionIds.add(selfAccordion.id());
                accordionStack.push(selfAccordion.id());
                reader.beginAccordion(categoryObject, field, optionAnnotation, selfAccordion.id());
                continue;
            }
            reader.emitOption(categoryObject, field, optionAnnotation);
        }
        while (!accordionStack.isEmpty()) {
            reader.endAccordion();
            accordionStack.pop();
        }
    }

    private static void processCategoryMeta(ConfigStructureReader reader, Object parent, Field categoryField, Field parentField) {
        Category categoryAnnotation = categoryField.getAnnotation(Category.class);
        if (categoryAnnotation == null) {
            return;
        }
        if (categoryField.getAnnotation(Expose.class) == null) {
            Warnings.warn("@Category without @Expose in " + parent.getClass() + " on field " + categoryField);
        }
        if ((categoryField.getModifiers() & 1) != 1) {
            Warnings.warn("@Category on non public field " + categoryField + " in " + parent.getClass());
            return;
        }
        ArrayList<BoundField> deferredSubCategories = new ArrayList<BoundField>();
        reader.beginCategory(parent, categoryField, categoryAnnotation.name(), categoryAnnotation.desc());
        if (parentField != null) {
            reader.setCategoryParent(parentField);
        }
        try {
            reader.pushPath(categoryField.getName());
            ConfigProcessorDriver.processCategory(categoryField.get(parent), categoryField.getType(), reader, deferredSubCategories);
            reader.popPath();
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
        reader.endCategory();
        for (BoundField subCategory : deferredSubCategories) {
            if (parentField == null) {
                ConfigProcessorDriver.processCategoryMeta(reader, subCategory.getBoundTo(), subCategory.getField(), categoryField);
                continue;
            }
            Warnings.warn("Found double recursive usb category at " + subCategory);
        }
    }

    public static void processConfig(Class<? extends Config> configClass, Config configObject, ConfigStructureReader reader) {
        reader.beginConfig(configClass, configObject);
        for (Field categoryField : ConfigProcessorDriver.getAllFields(configClass)) {
            ConfigProcessorDriver.processCategoryMeta(reader, configObject, categoryField, null);
        }
        reader.endConfig();
    }
}

