/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.dungeons;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class DungeonWin {
    public static ResourceLocation CONFETTI = new ResourceLocation("notenoughupdates:dungeon_win/confetti.png");
    public static ResourceLocation SPLUS = new ResourceLocation("notenoughupdates:dungeon_win/splus.png");
    public static ResourceLocation S = new ResourceLocation("notenoughupdates:dungeon_win/s.png");
    public static ResourceLocation A = new ResourceLocation("notenoughupdates:dungeon_win/a.png");
    public static ResourceLocation B = new ResourceLocation("notenoughupdates:dungeon_win/b.png");
    public static ResourceLocation C = new ResourceLocation("notenoughupdates:dungeon_win/c.png");
    public static ResourceLocation D = new ResourceLocation("notenoughupdates:dungeon_win/d.png");
    public static ResourceLocation TEAM_SCORE = SPLUS;
    private static final int SCALE_FACTOR = 3;
    private static final int WIDTH = 96;
    private static final int HEIGHT = 48;
    private static boolean hideChat = false;
    private static long lastDungeonFinish = 0L;
    private static final Pattern TEAM_SCORE_REGEX = Pattern.compile("Team Score: [0-9]+ \\((S\\+|S|A|B|C|D)\\)");
    private static final ScheduledExecutorService SES = Executors.newScheduledThreadPool(1);
    public static Random rand = new Random();
    public static List<Confetti> confetti = new ArrayList<Confetti>();
    public static List<String> text = new ArrayList<String>();
    public static long startTime = 0L;
    private static boolean seenDungeonWinOverlayThisRun = false;

    public static void displayWin() {
        if (NotEnoughUpdates.INSTANCE.config.dungeons.dungeonWinMillis < 100 || !NotEnoughUpdates.INSTANCE.config.dungeons.enableDungeonWin) {
            return;
        }
        startTime = System.currentTimeMillis();
        confetti.clear();
    }

    public static void tick() {
        if (NotEnoughUpdates.INSTANCE.config.dungeons.dungeonWinMillis < 100 || !NotEnoughUpdates.INSTANCE.config.dungeons.enableDungeonWin) {
            return;
        }
        if (System.currentTimeMillis() - startTime > 5000L) {
            return;
        }
        int deltaTime = (int)(System.currentTimeMillis() - startTime);
        if (deltaTime < 1000) {
            ScaledResolution sr = Utils.pushGuiScale(2);
            int cap = 0;
            switch (TEAM_SCORE.func_110623_a()) {
                case "dungeon_win/splus.png": {
                    cap = 200;
                    break;
                }
                case "dungeon_win/s.png": {
                    cap = 100;
                    break;
                }
                case "dungeon_win/a.png": {
                    cap = 50;
                }
            }
            int maxConfetti = Math.min(cap, deltaTime / 5);
            while (confetti.size() < maxConfetti) {
                int y = deltaTime < 500 ? sr.func_78328_b() / 2 - (int)(Math.sin((double)((float)deltaTime / 1000.0f) * Math.PI) * (double)sr.func_78328_b() / 9.0) : sr.func_78328_b() / 6 + (int)(Math.sin((double)((float)deltaTime / 1000.0f) * Math.PI) * (double)sr.func_78328_b() * 4.0 / 18.0);
                int xOffset = -48 + rand.nextInt(96);
                int x = sr.func_78326_a() / 2 + xOffset;
                int xVel = xOffset / 2;
                int yVel = -25 - rand.nextInt(10) + Math.abs(xVel) / 2;
                confetti.add(new Confetti(x, y, xVel, yVel));
            }
        } else {
            HashSet<Confetti> toRemove = new HashSet<Confetti>();
            for (Confetti c : confetti) {
                if (c.life > 0) continue;
                toRemove.add(c);
            }
            try {
                confetti.removeAll(toRemove);
            }
            catch (ConcurrentModificationException cap) {
                // empty catch block
            }
        }
        Utils.pushGuiScale(-1);
        Iterator<Confetti> iterator = confetti.iterator();
        while (iterator.hasNext()) {
            Confetti c;
            Confetti confetti = c = iterator.next();
            confetti.yVel = confetti.yVel + 1.0f;
            confetti = c;
            confetti.xVel = confetti.xVel / 1.1f;
            confetti = c;
            confetti.yVel = confetti.yVel / 1.1f;
            c.xLast = c.x;
            c.yLast = c.y;
            confetti = c;
            confetti.x = confetti.x + c.xVel;
            confetti = c;
            confetti.y = confetti.y + c.yVel;
            c.life--;
        }
    }

    public static void onChatMessage(ClientChatReceivedEvent e2) {
        Matcher matcher;
        if (e2.type == 2) {
            return;
        }
        if (NotEnoughUpdates.INSTANCE.config.dungeons.dungeonWinMillis < 100 || !NotEnoughUpdates.INSTANCE.config.dungeons.enableDungeonWin) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        String unformatted = Utils.cleanColour(e2.message.func_150260_c());
        if (unformatted.trim().startsWith("Team Score:") && currentTime - lastDungeonFinish > 30000L && (matcher = TEAM_SCORE_REGEX.matcher(unformatted)).find()) {
            lastDungeonFinish = currentTime;
            String score = matcher.group(1);
            switch (score.toUpperCase(Locale.ROOT)) {
                case "S+": {
                    TEAM_SCORE = SPLUS;
                    break;
                }
                case "S": {
                    TEAM_SCORE = S;
                    break;
                }
                case "A": {
                    TEAM_SCORE = A;
                    break;
                }
                case "B": {
                    TEAM_SCORE = B;
                    break;
                }
                case "C": {
                    TEAM_SCORE = C;
                    break;
                }
                default: {
                    TEAM_SCORE = D;
                }
            }
            SES.schedule(() -> NotEnoughUpdates.INSTANCE.sendChatMessage("/showextrastats"), 100L, TimeUnit.MILLISECONDS);
            seenDungeonWinOverlayThisRun = false;
        }
        if (currentTime - lastDungeonFinish > 100L && currentTime - lastDungeonFinish < 10000L) {
            if (hideChat) {
                if (text.size() > 50) {
                    text.clear();
                }
                if (unformatted.contains("\u25ac")) {
                    e2.setCanceled(true);
                    hideChat = false;
                    DungeonWin.displayWin();
                    seenDungeonWinOverlayThisRun = true;
                } else if (unformatted.trim().length() > 0 && !seenDungeonWinOverlayThisRun) {
                    if (unformatted.contains("The Catacombs") || unformatted.contains("Master Mode The Catacombs") || unformatted.contains("Team Score") || unformatted.contains("Defeated") || unformatted.contains("Total Damage") || unformatted.contains("Ally Healing") || unformatted.contains("Enemies Killed") || unformatted.contains("Deaths") || unformatted.contains("Secrets Found")) {
                        e2.setCanceled(true);
                        text.add(e2.message.func_150254_d().substring(6).trim());
                    } else if (unformatted.trim().length() > 6) {
                        System.out.println("These messages would of showed on neu dungeon overlay but didnt, They are either bugged or i missed them: \"" + e2.message.func_150254_d().substring(6).trim() + "\"");
                    }
                } else {
                    e2.setCanceled(true);
                }
            } else if (unformatted.contains("\u25ac") && !seenDungeonWinOverlayThisRun) {
                hideChat = true;
                text.clear();
                e2.setCanceled(true);
            }
        }
    }

    public static void render(float partialTicks) {
        if (NotEnoughUpdates.INSTANCE.config.dungeons.dungeonWinMillis < 100 || !NotEnoughUpdates.INSTANCE.config.dungeons.enableDungeonWin) {
            return;
        }
        int maxTime = Math.min(30000, NotEnoughUpdates.INSTANCE.config.dungeons.dungeonWinMillis);
        if (System.currentTimeMillis() - startTime > (long)maxTime) {
            return;
        }
        int deltaTime = (int)(System.currentTimeMillis() - startTime);
        float alpha = Math.max(0.0f, Math.min(1.0f, 1.0f - (float)(deltaTime - maxTime + 150) / 150.0f));
        ScaledResolution sr = Utils.pushGuiScale(2);
        if (deltaTime > 600) {
            float bottom = deltaTime < 1000 ? (float)sr.func_78328_b() / 6.0f + (float)Math.sin((double)((float)deltaTime / 1000.0f) * Math.PI) * (float)sr.func_78328_b() * 4.0f / 18.0f + 24.0f : (float)sr.func_78328_b() / 6.0f + 24.0f;
            for (int i = 0; i < text.size(); ++i) {
                String line = text.get(i);
                float textCenterY = (float)sr.func_78328_b() / 6.0f + 24.0f + 7.0f + (float)(i * 10);
                if (!(textCenterY > bottom)) continue;
                int textAlpha = (int)(alpha * (deltaTime > 1000 ? 255.0f : Math.min(255.0f, (textCenterY - bottom) / 30.0f * 255.0f)));
                GlStateManager.func_179147_l();
                if (textAlpha > 150) {
                    for (int xOff = -2; xOff <= 2; ++xOff) {
                        for (int yOff = -2; yOff <= 2; ++yOff) {
                            if (Math.abs(xOff) == Math.abs(yOff)) continue;
                            Utils.drawStringCentered(Utils.cleanColourNotModifiers(line), (float)(sr.func_78326_a() / 2) + (float)xOff / 2.0f, textCenterY + (float)yOff / 2.0f, false, textAlpha / Math.max(Math.abs(xOff), Math.abs(yOff)) << 24);
                        }
                    }
                }
                Utils.drawStringCentered(line, (float)(sr.func_78326_a() / 2), textCenterY, false, textAlpha << 24 | 0xFFFFFF);
            }
        }
        for (Confetti c : confetti) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(CONFETTI);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (c.life < 15) continue;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, (float)c.life / 4.0f));
            Utils.drawTexturedRect(c.xLast + (c.x - c.xLast) * partialTicks - 4.0f, c.yLast + (c.y - c.yLast) * partialTicks - 4.0f, 8.0f, 8.0f, (float)(c.id % 4) / 4.0f, (float)(c.id % 4 + 1) / 4.0f, (float)(c.id / 4) / 4.0f, (float)(c.id / 4 + 1) / 4.0f, 9728);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEAM_SCORE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GlStateManager.func_179094_E();
        if (deltaTime < 1600) {
            GlStateManager.func_179109_b((float)(sr.func_78326_a() / 2), (float)0.0f, (float)0.0f);
            if (deltaTime < 500) {
                GlStateManager.func_179137_b((double)0.0, (double)((double)((float)sr.func_78328_b() / 2.0f) - Math.sin((double)((float)deltaTime / 1000.0f) * Math.PI) * (double)sr.func_78328_b() / 9.0), (double)0.0);
            } else if (deltaTime < 1000) {
                GlStateManager.func_179137_b((double)0.0, (double)((double)((float)sr.func_78328_b() / 6.0f) + Math.sin((double)((float)deltaTime / 1000.0f) * Math.PI) * (double)sr.func_78328_b() * 4.0 / 18.0), (double)0.0);
            } else {
                GlStateManager.func_179109_b((float)0.0f, (float)((float)sr.func_78328_b() / 6.0f), (float)0.0f);
            }
            if (deltaTime < 200) {
                float scale = (float)deltaTime / 200.0f;
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            } else if (deltaTime < 1000) {
                float scale = 1.0f + (float)Math.sin((double)((float)(deltaTime - 200) / 800.0f) * Math.PI) * 0.8f;
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            } else if (deltaTime < 1100) {
                float scale = 1.0f + (float)Math.sin((double)((float)(deltaTime - 1000) / 100.0f) * Math.PI) * 0.15f;
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            }
            if (deltaTime < 600) {
                GlStateManager.func_179114_b((float)(180.0f + (float)deltaTime / 600.0f * 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(180.0f - (float)deltaTime / 600.0f * 180.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(-180.0f - (float)deltaTime / 600.0f * 165.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            } else if (deltaTime < 1000) {
                GlStateManager.func_179114_b((float)(15.0f - (float)(deltaTime - 600) / 400.0f * 11.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            } else {
                float logFac = 1.0f - (float)Math.log((float)(deltaTime - 1000) / 600.0f * 1.7f + 1.0f);
                logFac *= logFac;
                GlStateManager.func_179114_b((float)(4.0f * logFac), (float)0.0f, (float)0.0f, (float)1.0f);
                float x = (float)(deltaTime - 1000) / 300.0f;
                GlStateManager.func_179114_b((float)((float)(40.0 * (1.0 - Math.log(x * 0.85f + 1.0f)) * Math.sin(10.0f * x * x))), (float)0.0f, (float)1.0f, (float)0.0f);
            }
        } else {
            GlStateManager.func_179109_b((float)(sr.func_78326_a() / 2), (float)((float)sr.func_78328_b() / 6.0f), (float)0.0f);
        }
        GlStateManager.func_179129_p();
        Utils.drawTexturedRect(-48.0f, -24.0f, 96.0f, 48.0f, 9728);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-6.0f);
        Utils.drawTexturedRect(-48.0f, -24.0f, 96.0f, 48.0f, 9728);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)6.0f);
        if (deltaTime < 1600) {
            float epsilon = 0.01f;
            for (int xIndex = 0; xIndex < 32; ++xIndex) {
                for (int yIndex = 0; yIndex < 16; ++yIndex) {
                    float uMin = (float)xIndex / 32.0f;
                    float uMax = (float)(xIndex + 1) / 32.0f;
                    float vMin = (float)yIndex / 16.0f;
                    float vMax = (float)(yIndex + 1) / 16.0f;
                    int x = -48 + xIndex * 3;
                    int y = -24 + yIndex * 3;
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179147_l();
                    GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    Tessellator tessellator = Tessellator.func_178181_a();
                    WorldRenderer worldrenderer = tessellator.func_178180_c();
                    worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    worldrenderer.func_181662_b((double)((float)x + epsilon), (double)(y + 3), 0.0 + (double)epsilon).func_181673_a((double)uMin, (double)vMax).func_181675_d();
                    worldrenderer.func_181662_b((double)((float)x + epsilon), (double)y, 0.0 + (double)epsilon).func_181673_a((double)uMax, (double)vMax).func_181675_d();
                    worldrenderer.func_181662_b((double)((float)x + epsilon), (double)y, (double)(-6.0f - epsilon)).func_181673_a((double)uMax, (double)vMin).func_181675_d();
                    worldrenderer.func_181662_b((double)((float)x + epsilon), (double)(y + 3), (double)(-6.0f - epsilon)).func_181673_a((double)uMin, (double)vMin).func_181675_d();
                    tessellator.func_78381_a();
                    worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    worldrenderer.func_181662_b((double)((float)(x + 3) - epsilon), (double)(y + 3), 0.0 + (double)epsilon).func_181673_a((double)uMin, (double)vMax).func_181675_d();
                    worldrenderer.func_181662_b((double)((float)(x + 3) - epsilon), (double)y, 0.0 + (double)epsilon).func_181673_a((double)uMax, (double)vMax).func_181675_d();
                    worldrenderer.func_181662_b((double)((float)(x + 3) - epsilon), (double)y, (double)(-6.0f - epsilon)).func_181673_a((double)uMax, (double)vMin).func_181675_d();
                    worldrenderer.func_181662_b((double)((float)(x + 3) - epsilon), (double)(y + 3), (double)(-6.0f - epsilon)).func_181673_a((double)uMin, (double)vMin).func_181675_d();
                    tessellator.func_78381_a();
                    worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    worldrenderer.func_181662_b((double)(x + 3), (double)((float)y + epsilon), 0.0 + (double)epsilon).func_181673_a((double)uMin, (double)vMax).func_181675_d();
                    worldrenderer.func_181662_b((double)x, (double)((float)y + epsilon), 0.0 + (double)epsilon).func_181673_a((double)uMax, (double)vMax).func_181675_d();
                    worldrenderer.func_181662_b((double)x, (double)((float)y + epsilon), (double)(-6.0f - epsilon)).func_181673_a((double)uMax, (double)vMin).func_181675_d();
                    worldrenderer.func_181662_b((double)(x + 3), (double)((float)y + epsilon), (double)(-6.0f - epsilon)).func_181673_a((double)uMin, (double)vMin).func_181675_d();
                    tessellator.func_78381_a();
                    worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    worldrenderer.func_181662_b((double)(x + 3), (double)((float)(y + 3) - epsilon), 0.0 + (double)epsilon).func_181673_a((double)uMin, (double)vMax).func_181675_d();
                    worldrenderer.func_181662_b((double)x, (double)((float)(y + 3) - epsilon), 0.0 + (double)epsilon).func_181673_a((double)uMax, (double)vMax).func_181675_d();
                    worldrenderer.func_181662_b((double)x, (double)((float)(y + 3) - epsilon), (double)(-6.0f - epsilon)).func_181673_a((double)uMax, (double)vMin).func_181675_d();
                    worldrenderer.func_181662_b((double)(x + 3), (double)((float)(y + 3) - epsilon), (double)(-6.0f - epsilon)).func_181673_a((double)uMin, (double)vMin).func_181675_d();
                    tessellator.func_78381_a();
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    GlStateManager.func_179084_k();
                }
            }
        }
        GlStateManager.func_179121_F();
        for (Confetti c : confetti) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(CONFETTI);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (c.life <= 0 || c.life >= 15) continue;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, (float)c.life / 4.0f));
            Utils.drawTexturedRect(c.xLast + (c.x - c.xLast) * partialTicks - 4.0f, c.yLast + (c.y - c.yLast) * partialTicks - 4.0f, 8.0f, 8.0f, (float)(c.id % 4) / 4.0f, (float)(c.id % 4 + 1) / 4.0f, (float)(c.id / 4) / 4.0f, (float)(c.id / 4 + 1) / 4.0f, 9728);
        }
        Utils.pushGuiScale(-1);
        GlStateManager.func_179147_l();
    }

    static {
        for (int i = 0; i < 10; ++i) {
            text.add("{PLACEHOLDER DUNGEON STAT #" + i + "}");
        }
    }

    private static class Confetti {
        private float x;
        private float y;
        private float xLast;
        private float yLast;
        private int life = 0;
        private float xVel;
        private float yVel;
        private final int id;

        public Confetti(float x, float y, float xVel, float yVel) {
            this.x = x;
            this.xLast = x;
            this.y = y;
            this.yLast = y;
            this.xVel = xVel;
            this.yVel = yVel;
            this.id = rand.nextInt(16);
            this.life = 20 + rand.nextInt(10);
        }
    }
}

