/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.infopanes;

import info.bliki.htmlcleaner.TagNode;
import info.bliki.wiki.filter.Encoder;
import info.bliki.wiki.model.Configuration;
import info.bliki.wiki.model.ImageFormat;
import info.bliki.wiki.model.WikiModel;
import info.bliki.wiki.tags.HTMLBlockTag;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.IgnoreTag;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NEUOverlay;
import io.github.moulberry.notenoughupdates.infopanes.TextInfoPane;
import io.github.moulberry.notenoughupdates.util.AllowEmptyHTMLTag;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;

public class HTMLInfoPane
extends TextInfoPane {
    private static final WikiModel wikiModel;
    private final int ZOOM_FACTOR = 2;
    private final int IMAGE_WIDTH = 400;
    private final int EXT_WIDTH = 100;
    private ResourceLocation imageTexture = null;
    private BufferedImage imageTemp = null;
    private int imageHeight = 0;
    private int imageWidth = 0;
    private float xMin = 0.0f;
    private int mouseOffset = 0;
    private boolean selected = false;
    private static boolean hasAttemptedDownload;
    private static final Pattern replacePattern;
    private static final ExecutorService wkDownloadES;
    private static final ExecutorService rendererES;

    public static CompletableFuture<HTMLInfoPane> createFromWikiUrl(NEUOverlay overlay, NEUManager manager, String name, String wikiUrl) {
        return manager.getWebFile(wikiUrl).thenApply(f -> {
            if (f == null) {
                return new HTMLInfoPane(overlay, manager, "error", "error", "Failed to load wiki url: " + wikiUrl, false);
            }
            StringBuilder sb = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)f), StandardCharsets.UTF_8));){
                String l;
                while ((l = br.readLine()) != null) {
                    sb.append(l).append("\n");
                }
            }
            catch (IOException e2) {
                return new HTMLInfoPane(overlay, manager, "error", "error", "Failed to load wiki url: " + wikiUrl, false);
            }
            return HTMLInfoPane.createFromWikiText(overlay, manager, name, f.getName(), sb.toString(), wikiUrl.startsWith("https://wiki.hypixel.net/"));
        });
    }

    public static HTMLInfoPane createFromWikiText(NEUOverlay overlay, NEUManager manager, String name, String filename, String wiki, boolean isOfficialWiki) {
        String html;
        if (isOfficialWiki) {
            wiki = wiki.split("<main id=\"content\" class=\"mw-body\">")[1].split("</main>")[0];
            wiki = wiki.split("<div class=\"container-navbox\">")[0];
            wiki = wiki.split("<div class=\"categoryboxcontainer\">")[0];
            wiki = replacePattern.matcher(wiki).replaceAll("");
            wiki = wiki.replaceAll("<div id=\"siteNotice\"></div><div id=\"mw-dismissablenotice-anonplace\"></div><script>.*</script>", "");
            wiki = wiki.replaceAll("<h1 id=\"section_0\">.*</h1>", "");
            wiki = wiki.replace("src=\"/", "src=\"https://wiki.hypixel.net/");
            wiki = wiki.replace("\ud83d\uddf8", "\u2713");
            wiki = wiki.replace("\ud83e\udc10", "\u27f5");
            wiki = wiki.replace("\ud83e\udc12", "\u27f6");
        } else {
            String[] split = wiki.split("</infobox>");
            wiki = split[split.length - 1];
            wiki = wiki.split("<span class=\"navbox-vde\">")[0];
            wiki = wiki.split("<table class=\"navbox mw-collapsible\"")[0];
            wiki = "__NOTOC__\n" + wiki;
        }
        try (PrintWriter out2 = new PrintWriter(new File(manager.configLocation, "debug/parsed.txt"));){
            out2.println(wiki);
        }
        catch (IOException out2) {
            // empty catch block
        }
        try {
            html = isOfficialWiki ? wiki : wikiModel.render(wiki);
        }
        catch (Exception e2) {
            return new HTMLInfoPane(overlay, manager, "error", "error", "Could not render wiki.", false);
        }
        try (PrintWriter out = new PrintWriter(new File(manager.configLocation, "debug/html.txt"));){
            out.println(html);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new HTMLInfoPane(overlay, manager, name, filename, html, isOfficialWiki);
    }

    private String spaceEscape(String str) {
        return str.replace(" ", "\\ ");
    }

    public HTMLInfoPane(NEUOverlay overlay, NEUManager manager, String name, String filename, String html, boolean isOfficial) {
        super(overlay, manager, name, "");
        String osId;
        this.title = name;
        if (SystemUtils.IS_OS_WINDOWS) {
            osId = "win";
        } else if (SystemUtils.IS_OS_MAC) {
            osId = "mac";
        } else if (SystemUtils.IS_OS_LINUX) {
            osId = "linux";
        } else {
            this.text = EnumChatFormatting.RED + "Unsupported operating system.";
            return;
        }
        File cssFile = new File(manager.configLocation, isOfficial ? "official-wiki.css" : "wikia.css");
        File wkHtmlToImage = new File(manager.configLocation, "wkhtmltox-" + osId + "/bin/wkhtmltoimage");
        if (new File(manager.configLocation, "wkhtmltox/bin/wkhtmltoimage").exists() && SystemUtils.IS_OS_WINDOWS) {
            wkHtmlToImage = new File(manager.configLocation, "wkhtmltox/bin/wkhtmltoimage");
        }
        Runtime runtime = Runtime.getRuntime();
        String[] chmodCommand = new String[]{"chmod", "-R", "777", new File(manager.configLocation, "wkhtmltox-" + osId).getAbsolutePath()};
        try {
            Process p = runtime.exec(chmodCommand);
            p.waitFor();
        }
        catch (IOException | InterruptedException p) {
            // empty catch block
        }
        if (!wkHtmlToImage.exists()) {
            if (hasAttemptedDownload) {
                this.text = EnumChatFormatting.RED + "Downloading web renderer failed? Or still downloading? Not sure what to do";
            } else {
                hasAttemptedDownload = true;
                Utils.recursiveDelete(new File(manager.configLocation, "wkhtmltox-" + osId));
                wkDownloadES.submit(() -> {
                    try {
                        File itemsZip = new File(manager.configLocation, "wkhtmltox-" + osId + ".zip");
                        if (!itemsZip.exists()) {
                            URL url = new URL("https://moulberry.codes/wkhtmltox/wkhtmltox-" + osId + ".zip");
                            URLConnection urlConnection = url.openConnection();
                            urlConnection.setConnectTimeout(15000);
                            urlConnection.setReadTimeout(60000);
                            FileUtils.copyInputStreamToFile((InputStream)urlConnection.getInputStream(), (File)itemsZip);
                        }
                        try (FileInputStream is = new FileInputStream(itemsZip);){
                            NEUManager.unzip(is, manager.configLocation);
                        }
                        itemsZip.delete();
                        itemsZip.deleteOnExit();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                });
                this.text = EnumChatFormatting.YELLOW + "Downloading web renderer... try again soon";
            }
            return;
        }
        if (!cssFile.exists() && isOfficial) {
            try {
                Files.copy(((Object)((Object)this)).getClass().getResourceAsStream("/assets/notenoughupdates/official-wiki.css"), cssFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return;
            }
        }
        File input = new File(manager.configLocation, "tmp/input.html");
        String outputFileName = filename.replaceAll("(?i)\\u00A7.", "").replaceAll("[^a-zA-Z0-9_\\-]", "_");
        File output = new File(manager.configLocation, "tmp/" + outputFileName + ".png");
        input.deleteOnExit();
        output.deleteOnExit();
        File tmp = new File(manager.configLocation, "tmp");
        if (!tmp.exists()) {
            tmp.mkdir();
        }
        if (output.exists()) {
            try {
                this.imageTemp = ImageIO.read(output);
                this.text = EnumChatFormatting.RED + "Creating dynamic texture.";
            }
            catch (IOException e3) {
                e3.printStackTrace();
                this.text = EnumChatFormatting.RED + "Failed to read image.";
                return;
            }
        }
        html = "<div id=\"mw-content-text\" lang=\"en\" dir=\"ltr\" class=\"mw-content-ltr mw-content-text\">" + html + "</div>";
        html = "<div id=\"WikiaArticle\" class=\"WikiaArticle\">" + html + "</div>";
        html = "<link rel=\"stylesheet\" href=\"file:///" + cssFile.getAbsolutePath().replaceAll("^/", "") + "\">\n" + html;
        try (PrintWriter out2 = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(input), StandardCharsets.UTF_8)), false);){
            out2.println(this.encodeNonAscii(html));
        }
        catch (IOException out2) {
            // empty catch block
        }
        try {
            this.text = EnumChatFormatting.GRAY + "Rendering webpage (" + name + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + "), please wait...";
            String[] wkCommand = new String[]{wkHtmlToImage.getAbsolutePath(), "--width", "800", "--transparent", "--allow", manager.configLocation.getAbsolutePath(), "--zoom", "2", input.getAbsolutePath(), output.getAbsolutePath()};
            Process p = runtime.exec(wkCommand);
            rendererES.submit(() -> {
                block7: {
                    try {
                        if (p.waitFor(15L, TimeUnit.SECONDS)) {
                            if (overlay.getActiveInfoPane() != this) {
                                return;
                            }
                            try {
                                this.imageTemp = ImageIO.read(output);
                                this.text = EnumChatFormatting.RED + "Creating dynamic texture.";
                                break block7;
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                                this.text = EnumChatFormatting.RED + "Failed to read image.";
                                return;
                            }
                        }
                        if (overlay.getActiveInfoPane() != this) {
                            return;
                        }
                        this.text = EnumChatFormatting.RED + "Webpage render timed out (>15sec). Maybe it's too large?";
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                }
            });
        }
        catch (IOException e4) {
            e4.printStackTrace();
            this.text = EnumChatFormatting.RED + "Failed to exec webpage renderer.";
        }
    }

    @Override
    public void render(int width, int height, Color bg, Color fg, ScaledResolution scaledresolution, int mouseX, int mouseY) {
        if (this.imageTemp != null && this.imageTexture == null) {
            DynamicTexture tex = new DynamicTexture(this.imageTemp);
            this.imageTexture = Minecraft.func_71410_x().func_110434_K().func_110578_a("notenoughupdates/informationPaneImage", tex);
            this.imageHeight = this.imageTemp.getHeight();
            this.imageWidth = this.imageTemp.getWidth();
        }
        if (this.imageTexture == null) {
            super.render(width, height, bg, fg, scaledresolution, mouseX, mouseY);
            return;
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int paneWidth = (int)((float)(width / 3) * this.overlay.getWidthMult());
        int rightSide = (int)((float)width * this.overlay.getInfoPaneOffsetFactor());
        int leftSide = rightSide - paneWidth;
        int titleLen = fr.func_78256_a(this.title);
        fr.func_78276_b(this.title, (leftSide + rightSide - titleLen) / 2, this.overlay.getBoxPadding() + 5, Color.WHITE.getRGB());
        HTMLInfoPane.func_73734_a((int)(leftSide + this.overlay.getBoxPadding() - 5), (int)(this.overlay.getBoxPadding() - 5), (int)(rightSide - this.overlay.getBoxPadding() + 5), (int)(height - this.overlay.getBoxPadding() + 5), (int)bg.getRGB());
        int imageW = paneWidth - this.overlay.getBoxPadding() * 2;
        float scaleF = 800.0f / (float)imageW;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.imageTexture);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if ((float)(height - this.overlay.getBoxPadding() * 3) < (float)this.imageHeight / scaleF) {
            if ((float)this.scrollHeight.getValue() > (float)this.imageHeight / scaleF - (float)height + (float)(this.overlay.getBoxPadding() * 3)) {
                this.scrollHeight.setValue((int)((float)this.imageHeight / scaleF - (float)height + (float)(this.overlay.getBoxPadding() * 3)));
            }
            int yScroll = this.scrollHeight.getValue();
            float xSize = Math.min(((float)paneWidth - (float)this.overlay.getBoxPadding() * 2.0f) / (float)this.imageWidth * scaleF, 1.0f);
            float xMax = this.xMin + xSize;
            float vMin = (float)yScroll / ((float)this.imageHeight / scaleF);
            float vMax = (float)(yScroll + height - this.overlay.getBoxPadding() * 3) / ((float)this.imageHeight / scaleF);
            Utils.drawTexturedRect(leftSide + this.overlay.getBoxPadding(), this.overlay.getBoxPadding() * 2, imageW, height - this.overlay.getBoxPadding() * 3, this.xMin, xMax, vMin, vMax);
            if (xSize < 1.0f) {
                int barX = (int)(this.xMin * (float)imageW) + leftSide + this.overlay.getBoxPadding();
                int barY = height - this.overlay.getBoxPadding() - 10;
                int barWidth = (int)(xMax * (float)imageW) + leftSide + this.overlay.getBoxPadding();
                int barHeight = height - this.overlay.getBoxPadding() - 5;
                boolean isHovered = mouseX >= barX && mouseX <= barWidth && mouseY >= barY && mouseY <= barHeight || this.selected;
                Gui.func_73734_a((int)barX, (int)barY, (int)barWidth, (int)barHeight, (int)new Color(255, 255, 255, isHovered ? 150 : 100).getRGB());
            }
        } else {
            this.scrollHeight.setValue(0);
            Utils.drawTexturedRect(leftSide + this.overlay.getBoxPadding(), this.overlay.getBoxPadding() * 2, imageW, (int)((float)this.imageHeight / scaleF));
        }
        GlStateManager.func_179144_i((int)0);
    }

    @Override
    public boolean keyboardInput() {
        return false;
    }

    @Override
    public void mouseInput(int width, int height, int mouseX, int mouseY, boolean mouseDown) {
        int paneWidth = (int)((float)(width / 3) * this.overlay.getWidthMult());
        int rightSide = (int)((float)width * this.overlay.getInfoPaneOffsetFactor());
        int leftSide = rightSide - paneWidth;
        int imageW = paneWidth - this.overlay.getBoxPadding() * 2;
        float scaleF = 800.0f / (float)imageW;
        float xSize = Math.min(((float)paneWidth - (float)this.overlay.getBoxPadding() * 2.0f) / (float)this.imageWidth * scaleF, 1.0f);
        float xMax = this.xMin + xSize;
        int barX = (int)(this.xMin * (float)imageW) + leftSide + this.overlay.getBoxPadding();
        int barY = height - this.overlay.getBoxPadding() - 10;
        int barWidth = (int)(xMax * (float)imageW) + leftSide + this.overlay.getBoxPadding();
        int barHeight = height - this.overlay.getBoxPadding() - 5;
        if (!mouseDown) {
            this.selected = false;
        }
        if (mouseX >= barX && mouseX <= barWidth && mouseY >= barY && mouseY <= barHeight && mouseDown || this.selected) {
            if (!this.selected) {
                this.mouseOffset = mouseX - barX;
            }
            this.xMin = ((float)(mouseX - leftSide) - (float)this.overlay.getBoxPadding() / 2.0f - (float)this.mouseOffset) / (float)this.imageWidth * scaleF;
            this.xMin = Math.max(0.0f, this.xMin);
            this.xMin = Math.min(this.xMin, 1.0f - xSize);
            this.selected = true;
        }
        super.mouseInput(width, height, mouseX, mouseY, mouseDown);
    }

    public String encodeNonAscii(String c) {
        StringBuilder buf = new StringBuilder(c.length());
        CharsetEncoder enc = StandardCharsets.US_ASCII.newEncoder();
        for (int idx = 0; idx < c.length(); ++idx) {
            char ch = c.charAt(idx);
            if (enc.canEncode(ch)) {
                buf.append(ch);
                continue;
            }
            buf.append("&#");
            buf.append((int)ch);
            buf.append(';');
        }
        return buf.toString();
    }

    static {
        hasAttemptedDownload = false;
        Configuration conf = new Configuration();
        conf.addTokenTag("img", new HTMLTag("img"));
        conf.addTokenTag("code", new HTMLTag("code"));
        conf.addTokenTag("span", new AllowEmptyHTMLTag("span"));
        conf.addTokenTag("table", new HTMLBlockTag("table", "|applet|snippet|blockquote|body|button|center|dd|del|div|fieldset|form|iframe|ins|li|map|noframes|noscript|object|td|th|span|"));
        conf.addTokenTag("infobox", new IgnoreTag("infobox"));
        conf.addTokenTag("tabber", new IgnoreTag("tabber"));
        conf.addTokenTag("kbd", new HTMLTag("kbd"));
        conf.addTokenTag("td", new AllowEmptyHTMLTag("td"));
        conf.addTokenTag("tbody", new AllowEmptyHTMLTag("tbody"));
        conf.addTokenTag("style", new AllowEmptyHTMLTag("style"));
        conf.addTokenTag("article", new AllowEmptyHTMLTag("article"));
        conf.addTokenTag("section", new AllowEmptyHTMLTag("section"));
        conf.addTokenTag("link", new AllowEmptyHTMLTag("link"));
        conf.addTokenTag("wbr", new AllowEmptyHTMLTag("wbr"));
        conf.addTokenTag("dl", new AllowEmptyHTMLTag("dl"));
        conf.addTokenTag("dd", new AllowEmptyHTMLTag("dd"));
        conf.addTokenTag("dt", new AllowEmptyHTMLTag("dt"));
        wikiModel = new WikiModel(conf, "https://hypixel-skyblock.fandom.com/wiki/Special:Filepath/${image}", "https://hypixel-skyblock.fandom.com/wiki/${title}"){
            {
                TagNode.addAllowedAttribute("style");
                TagNode.addAllowedAttribute("src");
            }

            @Override
            protected String createImageName(ImageFormat imageFormat) {
                String imageName = imageFormat.getFilename();
                if (imageName.endsWith(".svg")) {
                    imageName = imageName + ".png";
                }
                imageName = Encoder.encodeUrl(imageName);
                if (this.replaceColon()) {
                    imageName = imageName.replace(':', '/');
                }
                return imageName;
            }

            @Override
            public void parseInternalImageLink(String imageNamespace, String rawImageLink) {
                if (!(rawImageLink = rawImageLink.replaceFirst("\\|x([0-9]+)px", "\\|$1x$1px")).split("\\|")[0].toLowerCase(Locale.ROOT).endsWith(".jpg")) {
                    super.parseInternalImageLink(imageNamespace, rawImageLink);
                }
            }
        };
        replacePattern = Pattern.compile("<nav class=\"page-actions-menu\">.*</nav>|", 32);
        wkDownloadES = Executors.newSingleThreadExecutor();
        rendererES = Executors.newCachedThreadPool();
    }
}

