/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.events.SlotClickEvent;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;

public class AbiphoneContactHelper {
    private static final AbiphoneContactHelper INSTANCE = new AbiphoneContactHelper();
    private String selectedWaypointName = "";
    private long lastClick = 0L;

    public static AbiphoneContactHelper getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        JsonArray requirements;
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return;
        }
        if (!Utils.getOpenChestName().equals("Contacts Directory")) {
            return;
        }
        List list = event.toolTip;
        if (list == null) {
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        String rawNpcName = event.itemStack.func_82833_r();
        String npcName = StringUtils.cleanColour(rawNpcName);
        JsonObject data = this.getJsonData(npcName);
        if (data == null) {
            return;
        }
        if (NotEnoughUpdates.INSTANCE.config.tooltipTweaks.abiphoneContactRequirements && data.has("requirement") && (requirements = data.get("requirement").getAsJsonArray()).size() > 0) {
            list.add(" ");
            list.add("\u00a7e\u00a7lRequirements:");
            for (JsonElement requirementObject : requirements) {
                String requirement = requirementObject.getAsString();
                list.add(requirement);
            }
        }
        if (NotEnoughUpdates.INSTANCE.config.tooltipTweaks.abiphoneContactMarker && data.has("x")) {
            if (this.selectedWaypointName.equals(npcName)) {
                list.set(0, npcName + " \u00a7f- \u00a7aMarker set!");
            }
            list.add(" ");
            if (this.selectedWaypointName.equals(npcName)) {
                list.add("\u00a7eClick to remove the marker!");
            } else {
                list.add("\u00a7eClick to set a marker!");
            }
            list.add("\u00a7eShift-Click to teleport to the nearest waypoint!");
        }
    }

    @SubscribeEvent
    public void onStackClick(SlotClickEvent event) {
        boolean shiftPressed;
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.config.tooltipTweaks.abiphoneContactMarker) {
            return;
        }
        if (!Utils.getOpenChestName().equals("Contacts Directory")) {
            return;
        }
        ItemStack stack = event.slot.func_75211_c();
        if (stack == null || stack.func_82833_r() == null) {
            return;
        }
        String rawNpcName = stack.func_82833_r();
        String npcName = StringUtils.cleanColour(rawNpcName);
        JsonObject data = this.getJsonData(npcName);
        if (data == null) {
            return;
        }
        if (!data.has("x")) {
            return;
        }
        int x = data.get("x").getAsInt();
        int y = data.get("y").getAsInt();
        int z = data.get("z").getAsInt();
        String rawIslandName = data.get("island").getAsString();
        if (rawIslandName == null) {
            return;
        }
        if (this.lastClick + 500L > System.currentTimeMillis()) {
            return;
        }
        this.lastClick = System.currentTimeMillis();
        boolean bl = shiftPressed = Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
        if (this.selectedWaypointName.equals(npcName) && !shiftPressed) {
            NotEnoughUpdates.INSTANCE.navigation.untrackWaypoint();
            this.selectedWaypointName = "";
        } else {
            AbiphoneContactHelper.trackWaypoint(rawNpcName, x, y, z, rawIslandName);
            if (shiftPressed) {
                NotEnoughUpdates.INSTANCE.navigation.useWarpCommand();
            }
            this.selectedWaypointName = npcName;
        }
        Utils.playPressSound();
    }

    private static void trackWaypoint(String rawNpcName, int x, int y, int z, String rawIslandName) {
        JsonObject waypoint = new JsonObject();
        waypoint.add("x", new JsonPrimitive(x));
        waypoint.add("y", new JsonPrimitive(y));
        waypoint.add("z", new JsonPrimitive(z));
        waypoint.add("displayname", new JsonPrimitive(rawNpcName));
        waypoint.add("island", new JsonPrimitive(rawIslandName));
        waypoint.add("internalname", new JsonPrimitive("abiphone-contact-" + rawNpcName));
        NotEnoughUpdates.INSTANCE.navigation.trackWaypoint(waypoint);
    }

    private JsonObject getJsonData(String npcName) {
        JsonObject abiphone = Constants.ABIPHONE;
        if (abiphone == null) {
            return null;
        }
        JsonObject contacts = abiphone.getAsJsonObject();
        for (Map.Entry<String, JsonElement> entry : contacts.entrySet()) {
            String repoName = entry.getKey();
            if (!repoName.equals(npcName)) continue;
            return entry.getValue().getAsJsonObject();
        }
        return null;
    }

    public void resetMarker() {
        this.selectedWaypointName = "";
    }
}

