/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.events.ButtonExclusionZoneEvent;
import io.github.moulberry.notenoughupdates.mixins.AccessorGuiContainer;
import io.github.moulberry.notenoughupdates.util.Rectangle;
import io.github.moulberry.notenoughupdates.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class AuctionProfit {
    public static final ResourceLocation auctionProfitImage = new ResourceLocation("notenoughupdates:auction_profit.png");

    @SubscribeEvent
    public void onButtonExclusionZones(ButtonExclusionZoneEvent event) {
        if (AuctionProfit.inAuctionPage()) {
            event.blockArea(new Rectangle(event.getGuiBaseRect().getRight(), event.getGuiBaseRect().getTop(), 132, 56), ButtonExclusionZoneEvent.PushDirection.TOWARDS_RIGHT);
        }
    }

    @SubscribeEvent
    public void onDrawBackground(GuiScreenEvent.BackgroundDrawnEvent event) {
        if (!AuctionProfit.inAuctionPage()) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        Container inventoryContainer = minecraft.field_71439_g.field_71070_bA;
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiChest)) {
            return;
        }
        GuiScreen gui = event.gui;
        int xSize = ((AccessorGuiContainer)gui).getXSize();
        int guiLeft = ((AccessorGuiContainer)gui).getGuiLeft();
        int guiTop = ((AccessorGuiContainer)gui).getGuiTop();
        minecraft.func_110434_K().func_110577_a(auctionProfitImage);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        Utils.drawTexturedRect(guiLeft + xSize + 4, guiTop, 180.0f, 101.0f, 0.0f, 0.703125f, 0.0f, 0.39453125f, 9728);
        double coinsToCollect = 0.0;
        double coinsIfAllSold = 0.0;
        int expiredAuctions = 0;
        int unclaimedAuctions = 0;
        for (ItemStack itemStack : inventoryContainer.func_75138_a()) {
            NBTTagCompound display;
            NBTTagCompound tag;
            boolean isBin = false;
            if (itemStack == null || !itemStack.func_77942_o() || (tag = itemStack.func_77978_p()) == null || !(display = tag.func_74775_l("display")).func_150297_b("Lore", 9)) continue;
            NBTTagList lore = itemStack.func_77978_p().func_74775_l("display").func_150295_c("Lore", 8);
            double coinsToCheck = 0.0;
            for (int i = 0; i < lore.func_74745_c(); ++i) {
                String textWithoutFormattingCodes;
                double coins;
                double coins2;
                String coinsString;
                String s;
                String line = lore.func_150307_f(i);
                if (line.contains("\u00a77Buy it now")) {
                    isBin = true;
                    s = line.split("\u00a77Buy it now: ")[1];
                    coinsString = s.split("coins")[0];
                    coins2 = AuctionProfit.tryParse(EnumChatFormatting.func_110646_a((String)coinsString.trim()));
                    if (coins2 != 0.0) {
                        coinsToCheck += coins2;
                    }
                }
                if (line.contains("\u00a77Top bid: ") && (coins = AuctionProfit.tryParse(textWithoutFormattingCodes = EnumChatFormatting.func_110646_a((String)(coinsString = (s = line.split("\u00a77Top bid: ")[1]).split("coins")[0]).trim())).doubleValue()) != 0.0) {
                    coinsToCheck += coins;
                }
                if (line.contains("\u00a77Sold for: ") && (coins2 = AuctionProfit.tryParse(EnumChatFormatting.func_110646_a((String)(coinsString = (s = line.split("\u00a77Sold for: ")[1]).split("coins")[0]).trim())).doubleValue()) != 0.0) {
                    coins2 = this.removeTax(coins2);
                    coinsToCollect += coins2;
                }
                if (line.contains("\u00a77Status: \u00a7aSold!") || line.contains("\u00a77Status: \u00a7aEnded!")) {
                    if (coinsToCheck != 0.0) {
                        coinsToCheck = this.removeTax(coinsToCheck);
                        coinsToCollect += coinsToCheck;
                        coinsToCheck = 0.0;
                    }
                    ++unclaimedAuctions;
                } else if (line.contains("\u00a77Status: \u00a7cExpired!")) {
                    ++expiredAuctions;
                }
                if (!isBin || !line.contains("\u00a77Ends in") || coinsToCheck == 0.0) continue;
                coinsIfAllSold += coinsToCheck;
                coinsToCheck = 0.0;
            }
        }
        int a = guiLeft + xSize + 4;
        String unclaimedAuctionsStr = EnumChatFormatting.DARK_GREEN.toString() + unclaimedAuctions + EnumChatFormatting.BOLD + EnumChatFormatting.DARK_GRAY + " Unclaimed auctions";
        String expiredAuctionsStr = EnumChatFormatting.RED.toString() + expiredAuctions + EnumChatFormatting.BOLD + EnumChatFormatting.DARK_GRAY + " Expired auctions";
        FontRenderer fontRendererObj = minecraft.field_71466_p;
        fontRendererObj.func_175065_a(unclaimedAuctionsStr, (float)(a + 6), (float)(guiTop + 6), -1, false);
        fontRendererObj.func_175065_a(expiredAuctionsStr, (float)(a + 6), (float)(guiTop + 16), -1, false);
        String coinsToCollectStr = EnumChatFormatting.BOLD + EnumChatFormatting.DARK_GRAY.toString() + "Coins to collect: " + EnumChatFormatting.RESET + EnumChatFormatting.DARK_GREEN + "" + StringUtils.shortNumberFormat(coinsToCollect);
        String valueIfSoldStr = EnumChatFormatting.BOLD + EnumChatFormatting.DARK_GRAY.toString() + "Value if all sold: " + EnumChatFormatting.RESET + EnumChatFormatting.DARK_GREEN + "" + StringUtils.shortNumberFormat(coinsIfAllSold);
        fontRendererObj.func_175065_a(coinsToCollectStr, (float)(a + 6), (float)(guiTop + 32), -1, false);
        fontRendererObj.func_175065_a(valueIfSoldStr, (float)(a + 6), (float)(guiTop + 42), -1, false);
    }

    private double removeTax(double coins) {
        if (coins < 1.0E7) {
            return coins / 1.01;
        }
        if (coins < 1.0E8) {
            return coins / 1.02;
        }
        return coins / 1.025;
    }

    public static Double tryParse(String s) {
        try {
            return Double.parseDouble(s.replace(",", ""));
        }
        catch (NumberFormatException exception) {
            return 0.0;
        }
    }

    public static boolean inAuctionPage() {
        if (!NotEnoughUpdates.INSTANCE.config.ahTweaks.enableAhSellValue || !NotEnoughUpdates.INSTANCE.isOnSkyblock()) {
            return false;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft == null || minecraft.field_71439_g == null) {
            return false;
        }
        Container inventoryContainer = minecraft.field_71439_g.field_71070_bA;
        if (!(inventoryContainer instanceof ContainerChest)) {
            return false;
        }
        ContainerChest containerChest = (ContainerChest)inventoryContainer;
        return containerChest.func_85151_d().func_145748_c_().func_150260_c().equalsIgnoreCase("Manage Auctions");
    }
}

