/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.Line;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.core.util.Vec3Comparable;
import io.github.moulberry.notenoughupdates.events.SpawnParticleEvent;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.options.customtypes.NEUDebugFlag;
import io.github.moulberry.notenoughupdates.util.NEUDebugLogger;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.TabListUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CrystalWishingCompassSolver {
    private static final CrystalWishingCompassSolver INSTANCE = new CrystalWishingCompassSolver();
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static boolean isSkytilsPresent = false;
    private static final ArrayDeque<ParticleData> seenParticles = new ArrayDeque();
    private static final AxisAlignedBB NUCLEUS_BB = new AxisAlignedBB(462.0, 63.0, 461.0, 564.0, 181.0, 565.0);
    private static final AxisAlignedBB HOLLOWS_BB = new AxisAlignedBB(201.0, 30.0, 201.0, 824.0, 189.0, 824.0);
    private static final AxisAlignedBB PRECURSOR_REMNANTS_BB = new AxisAlignedBB(512.0, 63.0, 512.0, 824.0, 189.0, 824.0);
    private static final AxisAlignedBB MITHRIL_DEPOSITS_BB = new AxisAlignedBB(512.0, 63.0, 201.0, 824.0, 189.0, 513.0);
    private static final AxisAlignedBB GOBLIN_HOLDOUT_BB = new AxisAlignedBB(201.0, 63.0, 512.0, 513.0, 189.0, 824.0);
    private static final AxisAlignedBB JUNGLE_BB = new AxisAlignedBB(201.0, 63.0, 201.0, 513.0, 189.0, 513.0);
    private static final AxisAlignedBB MAGMA_FIELDS_BB = new AxisAlignedBB(201.0, 30.0, 201.0, 824.0, 64.0, 824.0);
    private static final AxisAlignedBB PRECURSOR_CITY_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 107.0, 122.0, 107.0);
    private static final AxisAlignedBB GOBLIN_KING_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 59.0, 53.0, 56.0);
    private static final AxisAlignedBB GOBLIN_QUEEN_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 108.0, 114.0, 108.0);
    private static final AxisAlignedBB JUNGLE_TEMPLE_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 108.0, 120.0, 108.0);
    private static final AxisAlignedBB ODAWA_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 53.0, 46.0, 54.0);
    private static final AxisAlignedBB MINES_OF_DIVAN_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 108.0, 125.0, 108.0);
    private static final AxisAlignedBB KHAZAD_DUM_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 110.0, 46.0, 108.0);
    private static final Vec3Comparable JUNGLE_DOOR_OFFSET_FROM_CRYSTAL = new Vec3Comparable(-57.0, 36.0, -21.0);
    private static final double MAX_DISTANCE_BETWEEN_PARTICLES = 0.6;
    private static final double MAX_DISTANCE_FROM_USE_TO_FIRST_PARTICLE = 9.0;
    private static final double MINIMUM_DISTANCE_SQ_BETWEEN_COMPASSES = 64.0;
    public static final long ALL_PARTICLES_MAX_MILLIS = 5000L;
    public LongSupplier currentTimeMillis = System::currentTimeMillis;
    public BooleanSupplier kingsScentPresent = this::isKingsScentPresent;
    public BooleanSupplier keyInInventory = this::isKeyInInventory;
    public CrystalEnumSetSupplier foundCrystals = this::getFoundCrystals;
    private SolverState solverState;
    private Compass firstCompass;
    private Compass secondCompass;
    private Line solutionIntersectionLine;
    private EnumSet<CompassTarget> possibleTargets;
    private Vec3Comparable solution;
    private Vec3Comparable originalSolution;
    private EnumSet<CompassTarget> solutionPossibleTargets;

    public static CrystalWishingCompassSolver getInstance() {
        return INSTANCE;
    }

    public SolverState getSolverState() {
        return this.solverState;
    }

    public Vec3i getSolutionCoords() {
        return new Vec3i(this.solution.field_72450_a, this.solution.field_72448_b, this.solution.field_72449_c);
    }

    public EnumSet<CompassTarget> getPossibleTargets() {
        return this.possibleTargets;
    }

    public static HollowsZone getZoneForCoords(BlockPos blockPos) {
        return CrystalWishingCompassSolver.getZoneForCoords(new Vec3Comparable(blockPos));
    }

    public static HollowsZone getZoneForCoords(Vec3Comparable coords) {
        if (NUCLEUS_BB.func_72318_a((Vec3)coords)) {
            return HollowsZone.CRYSTAL_NUCLEUS;
        }
        if (JUNGLE_BB.func_72318_a((Vec3)coords)) {
            return HollowsZone.JUNGLE;
        }
        if (MITHRIL_DEPOSITS_BB.func_72318_a((Vec3)coords)) {
            return HollowsZone.MITHRIL_DEPOSITS;
        }
        if (GOBLIN_HOLDOUT_BB.func_72318_a((Vec3)coords)) {
            return HollowsZone.GOBLIN_HOLDOUT;
        }
        if (PRECURSOR_REMNANTS_BB.func_72318_a((Vec3)coords)) {
            return HollowsZone.PRECURSOR_REMNANTS;
        }
        if (MAGMA_FIELDS_BB.func_72318_a((Vec3)coords)) {
            return HollowsZone.MAGMA_FIELDS;
        }
        throw new IllegalArgumentException("Coordinates do not fall in known zone: " + coords.toString());
    }

    private void resetForNewTarget() {
        NEUDebugLogger.log(NEUDebugFlag.WISHING, "Resetting for new target");
        this.solverState = SolverState.NOT_STARTED;
        this.firstCompass = null;
        this.secondCompass = null;
        this.solutionIntersectionLine = null;
        this.possibleTargets = null;
        this.solution = null;
        this.originalSolution = null;
        this.solutionPossibleTargets = null;
    }

    public void initWorld() {
        this.resetForNewTarget();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Unload event) {
        this.initWorld();
        isSkytilsPresent = Loader.isModLoaded((String)"skytils");
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!NotEnoughUpdates.INSTANCE.config.mining.wishingCompassSolver || SBInfo.getInstance().getLocation() == null || !SBInfo.getInstance().getLocation().equals("crystal_hollows") || event.entityPlayer != CrystalWishingCompassSolver.mc.field_71439_g || event.action != PlayerInteractEvent.Action.RIGHT_CLICK_AIR && event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack heldItem = event.entityPlayer.func_70694_bm();
        if (heldItem == null || heldItem.func_77973_b() != Items.field_151144_bL) {
            return;
        }
        String heldInternalName = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(heldItem);
        if (heldInternalName == null || !heldInternalName.equals("WISHING_COMPASS")) {
            return;
        }
        BlockPos playerPos = CrystalWishingCompassSolver.mc.field_71439_g.func_180425_c().getImmutable();
        try {
            HandleCompassResult result2 = this.handleCompassUse(playerPos);
            switch (result2) {
                case SUCCESS: {
                    return;
                }
                case STILL_PROCESSING_PRIOR_USE: {
                    Utils.addChatMessage(EnumChatFormatting.YELLOW + "[NEU] Wait a little longer before using the wishing compass again.");
                    event.setCanceled(true);
                    break;
                }
                case LOCATION_TOO_CLOSE: {
                    Utils.addChatMessage(EnumChatFormatting.YELLOW + "[NEU] Move a little further before using the wishing compass again.");
                    event.setCanceled(true);
                    break;
                }
                case POSSIBLE_TARGETS_CHANGED: {
                    Utils.addChatMessage(EnumChatFormatting.YELLOW + "[NEU] Possible wishing compass targets have changed. Solver has been reset.");
                    event.setCanceled(true);
                    break;
                }
                case NO_PARTICLES_FOR_PREVIOUS_COMPASS: {
                    Utils.addChatMessage(EnumChatFormatting.YELLOW + "[NEU] No particles detected for prior compass use. Need another position to solve.");
                    break;
                }
                case PLAYER_IN_NUCLEUS: {
                    Utils.addChatMessage(EnumChatFormatting.YELLOW + "[NEU] Wishing compass must be used outside the nucleus for accurate results.");
                    event.setCanceled(true);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected wishing compass solver state: \n" + this.getDiagnosticMessage());
                }
            }
        }
        catch (Exception e2) {
            Utils.addChatMessage(EnumChatFormatting.RED + "[NEU] Error processing wishing compass action - see log for details");
            e2.printStackTrace();
            event.setCanceled(true);
            this.solverState = SolverState.FAILED_EXCEPTION;
        }
    }

    public HandleCompassResult handleCompassUse(BlockPos playerPos) {
        long lastCompassUsedMillis = 0L;
        switch (this.solverState) {
            case PROCESSING_SECOND_USE: {
                if (this.secondCompass != null) {
                    lastCompassUsedMillis = this.secondCompass.whenUsedMillis;
                }
            }
            case PROCESSING_FIRST_USE: {
                if (lastCompassUsedMillis == 0L && this.firstCompass != null) {
                    lastCompassUsedMillis = this.firstCompass.whenUsedMillis;
                }
                if (lastCompassUsedMillis != 0L && this.currentTimeMillis.getAsLong() > lastCompassUsedMillis + 5000L) {
                    return HandleCompassResult.NO_PARTICLES_FOR_PREVIOUS_COMPASS;
                }
                return HandleCompassResult.STILL_PROCESSING_PRIOR_USE;
            }
            case SOLVED: 
            case FAILED_EXCEPTION: 
            case FAILED_TIMEOUT_NO_REPEATING: 
            case FAILED_TIMEOUT_NO_PARTICLES: 
            case FAILED_INTERSECTION_CALCULATION: 
            case FAILED_INVALID_SOLUTION: {
                this.resetForNewTarget();
            }
            case NOT_STARTED: {
                if (NUCLEUS_BB.func_72318_a((Vec3)new Vec3Comparable(playerPos.func_177958_n(), playerPos.func_177956_o(), playerPos.func_177952_p()))) {
                    return HandleCompassResult.PLAYER_IN_NUCLEUS;
                }
                this.firstCompass = new Compass(playerPos, this.currentTimeMillis.getAsLong());
                seenParticles.clear();
                this.solverState = SolverState.PROCESSING_FIRST_USE;
                this.possibleTargets = this.calculatePossibleTargets(playerPos);
                return HandleCompassResult.SUCCESS;
            }
            case NEED_SECOND_COMPASS: {
                if (this.firstCompass.whereUsed.func_177951_i((Vec3i)playerPos) < 64.0) {
                    return HandleCompassResult.LOCATION_TOO_CLOSE;
                }
                HollowsZone firstCompassZone = CrystalWishingCompassSolver.getZoneForCoords(this.firstCompass.whereUsed);
                HollowsZone playerZone = CrystalWishingCompassSolver.getZoneForCoords(playerPos);
                if (!this.possibleTargets.equals(this.calculatePossibleTargets(playerPos)) || firstCompassZone != playerZone) {
                    this.resetForNewTarget();
                    return HandleCompassResult.POSSIBLE_TARGETS_CHANGED;
                }
                this.secondCompass = new Compass(playerPos, this.currentTimeMillis.getAsLong());
                this.solverState = SolverState.PROCESSING_SECOND_USE;
                return HandleCompassResult.SUCCESS;
            }
        }
        throw new IllegalStateException("Unexpected compass state");
    }

    @SubscribeEvent
    public void onSpawnParticle(SpawnParticleEvent event) {
        EnumParticleTypes particleType = event.getParticleTypes();
        double x = event.getXCoord();
        double y = event.getYCoord();
        double z = event.getZCoord();
        if (!NotEnoughUpdates.INSTANCE.config.mining.wishingCompassSolver || particleType != EnumParticleTypes.VILLAGER_HAPPY || !"crystal_hollows".equals(SBInfo.getInstance().getLocation())) {
            return;
        }
        if (this.firstCompass != null && !this.solverState.equals((Object)SolverState.SOLVED) && System.currentTimeMillis() < this.firstCompass.whenUsedMillis + 120000L) {
            seenParticles.add(new ParticleData(new Vec3Comparable(x, y, z), System.currentTimeMillis()));
        }
        try {
            SolverState originalSolverState = this.solverState;
            this.solveUsingParticle(x, y, z, this.currentTimeMillis.getAsLong());
            if (this.solverState != originalSolverState) {
                switch (this.solverState) {
                    case SOLVED: {
                        this.showSolution();
                        break;
                    }
                    case FAILED_EXCEPTION: {
                        Utils.addChatMessage(EnumChatFormatting.RED + "[NEU] Unable to determine wishing compass target.");
                        this.logDiagnosticData(false);
                        break;
                    }
                    case FAILED_TIMEOUT_NO_REPEATING: {
                        Utils.addChatMessage(EnumChatFormatting.RED + "[NEU] Timed out waiting for repeat set of compass particles.");
                        this.logDiagnosticData(false);
                        break;
                    }
                    case FAILED_TIMEOUT_NO_PARTICLES: {
                        Utils.addChatMessage(EnumChatFormatting.RED + "[NEU] Timed out waiting for compass particles.");
                        this.logDiagnosticData(false);
                        break;
                    }
                    case FAILED_INTERSECTION_CALCULATION: {
                        Utils.addChatMessage(EnumChatFormatting.RED + "[NEU] Unable to determine intersection of wishing compasses.");
                        this.logDiagnosticData(false);
                        break;
                    }
                    case FAILED_INVALID_SOLUTION: {
                        Utils.addChatMessage(EnumChatFormatting.RED + "[NEU] Failed to find solution.");
                        this.logDiagnosticData(false);
                        break;
                    }
                    case NEED_SECOND_COMPASS: {
                        Utils.addChatMessage(EnumChatFormatting.YELLOW + "[NEU] Need another position to determine wishing compass target.");
                    }
                }
            }
        }
        catch (Exception e2) {
            Utils.addChatMessage(EnumChatFormatting.RED + "[NEU] Exception while calculating wishing compass solution - see log for details");
            e2.printStackTrace();
        }
    }

    public void solveUsingParticle(double x, double y, double z, long currentTimeMillis) {
        Compass currentCompass;
        switch (this.solverState) {
            case PROCESSING_FIRST_USE: {
                currentCompass = this.firstCompass;
                break;
            }
            case PROCESSING_SECOND_USE: {
                currentCompass = this.secondCompass;
                break;
            }
            default: {
                return;
            }
        }
        currentCompass.processParticle(x, y, z, currentTimeMillis);
        switch (currentCompass.compassState) {
            case FAILED_TIMEOUT_NO_PARTICLES: {
                this.solverState = SolverState.FAILED_TIMEOUT_NO_PARTICLES;
                return;
            }
            case FAILED_TIMEOUT_NO_REPEATING: {
                this.solverState = SolverState.FAILED_TIMEOUT_NO_REPEATING;
                return;
            }
            case WAITING_FOR_FIRST_PARTICLE: 
            case COMPUTING_LAST_PARTICLE: {
                return;
            }
            case COMPLETED: {
                if (this.solverState == SolverState.NEED_SECOND_COMPASS) {
                    return;
                }
                if (this.solverState != SolverState.PROCESSING_FIRST_USE) break;
                this.solverState = SolverState.NEED_SECOND_COMPASS;
                return;
            }
        }
        this.solutionIntersectionLine = this.firstCompass.line.getIntersectionLineSegment(this.secondCompass.line);
        if (this.solutionIntersectionLine == null) {
            this.solverState = SolverState.FAILED_INTERSECTION_CALCULATION;
            return;
        }
        this.solution = new Vec3Comparable(this.solutionIntersectionLine.getMidpoint());
        Vec3Comparable firstDirection = this.firstCompass.getDirection();
        Vec3Comparable firstSolutionDirection = this.firstCompass.getDirectionTo(this.solution);
        Vec3Comparable secondDirection = this.secondCompass.getDirection();
        Vec3Comparable secondSolutionDirection = this.secondCompass.getDirectionTo(this.solution);
        if (!(firstDirection.signumEquals(firstSolutionDirection) && secondDirection.signumEquals(secondSolutionDirection) && HOLLOWS_BB.func_72318_a((Vec3)this.solution))) {
            this.solverState = SolverState.FAILED_INVALID_SOLUTION;
            return;
        }
        this.solutionPossibleTargets = CrystalWishingCompassSolver.getSolutionTargets(CrystalWishingCompassSolver.getZoneForCoords(this.firstCompass.whereUsed), this.foundCrystals.getAsCrystalEnumSet(), this.possibleTargets, this.solution);
        if (this.solutionPossibleTargets.size() == 1 && this.solutionPossibleTargets.contains((Object)CompassTarget.JUNGLE_TEMPLE)) {
            this.originalSolution = this.solution;
            this.solution = this.solution.add(JUNGLE_DOOR_OFFSET_FROM_CRYSTAL);
        }
        this.solverState = SolverState.SOLVED;
    }

    private boolean isKeyInInventory() {
        for (ItemStack item : CrystalWishingCompassSolver.mc.field_71439_g.field_71071_by.field_70462_a) {
            if (item == null || !item.func_82833_r().contains("Jungle Key")) continue;
            return true;
        }
        return false;
    }

    private boolean isKingsScentPresent() {
        if (SBInfo.getInstance().footer.func_150260_c().contains("King's Scent I")) {
            return true;
        }
        for (String name : TabListUtils.getTabList()) {
            if (!StringUtils.cleanColour(name).contains("King's Scent I")) continue;
            return true;
        }
        return false;
    }

    private EnumSet<Crystal> getFoundCrystals() {
        EnumSet<Crystal> foundCrystals = EnumSet.noneOf(Crystal.class);
        NEUConfig.HiddenProfileSpecific perProfileConfig = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (perProfileConfig == null) {
            return foundCrystals;
        }
        HashMap<String, Integer> crystals = perProfileConfig.crystals;
        for (String crystalName : crystals.keySet()) {
            Integer crystalState = crystals.get(crystalName);
            if (crystalState == null || crystalState <= 0) continue;
            foundCrystals.add(Crystal.valueOf(crystalName.toUpperCase(Locale.US).replace("\u0130", "I")));
        }
        return foundCrystals;
    }

    public static EnumSet<CompassTarget> getSolutionTargets(HollowsZone compassUsedZone, EnumSet<Crystal> foundCrystals, EnumSet<CompassTarget> possibleTargets, Vec3Comparable solution) {
        Object solutionPossibleTargets = possibleTargets.clone();
        HollowsZone solutionZone = CrystalWishingCompassSolver.getZoneForCoords(solution);
        if (solutionZone == HollowsZone.CRYSTAL_NUCLEUS) {
            return solutionPossibleTargets;
        }
        ((AbstractCollection)solutionPossibleTargets).remove((Object)CompassTarget.CRYSTAL_NUCLEUS);
        if (((AbstractCollection)solutionPossibleTargets).contains((Object)CompassTarget.BAL) && solution.field_72448_b > 75.0) {
            ((AbstractCollection)solutionPossibleTargets).remove((Object)CompassTarget.BAL);
        }
        if (((AbstractCollection)solutionPossibleTargets).contains((Object)CompassTarget.GOBLIN_KING) && solution.field_72448_b < 82.0 || solution.field_72448_b > 168.0) {
            ((AbstractCollection)solutionPossibleTargets).remove((Object)CompassTarget.GOBLIN_KING);
        }
        if (((AbstractCollection)solutionPossibleTargets).contains((Object)CompassTarget.GOBLIN_QUEEN) && (solution.field_72448_b < 125.0 || solution.field_72448_b > 140.0)) {
            ((AbstractCollection)solutionPossibleTargets).remove((Object)CompassTarget.GOBLIN_QUEEN);
        }
        if (((AbstractCollection)solutionPossibleTargets).contains((Object)CompassTarget.JUNGLE_TEMPLE) && (solution.field_72448_b < 72.0 || solution.field_72448_b > 81.0)) {
            ((AbstractCollection)solutionPossibleTargets).remove((Object)CompassTarget.JUNGLE_TEMPLE);
        }
        if (((AbstractCollection)solutionPossibleTargets).contains((Object)CompassTarget.ODAWA) && (solution.field_72448_b < 73.0 || solution.field_72448_b > 155.0)) {
            ((AbstractCollection)solutionPossibleTargets).remove((Object)CompassTarget.ODAWA);
        }
        if (((AbstractCollection)solutionPossibleTargets).contains((Object)CompassTarget.PRECURSOR_CITY) && (solution.field_72448_b < 121.0 || solution.field_72448_b > 130.0)) {
            ((AbstractCollection)solutionPossibleTargets).remove((Object)CompassTarget.PRECURSOR_CITY);
        }
        if (((AbstractCollection)solutionPossibleTargets).contains((Object)CompassTarget.MINES_OF_DIVAN) && (solution.field_72448_b < 97.0 || solution.field_72448_b > 102.0)) {
            ((AbstractCollection)solutionPossibleTargets).remove((Object)CompassTarget.MINES_OF_DIVAN);
        }
        if (((AbstractCollection)solutionPossibleTargets).contains((Object)CompassTarget.GOBLIN_KING) && (solution.field_72450_a > CrystalWishingCompassSolver.GOBLIN_HOLDOUT_BB.field_72336_d + CrystalWishingCompassSolver.GOBLIN_KING_BB.field_72336_d || solution.field_72449_c < CrystalWishingCompassSolver.GOBLIN_HOLDOUT_BB.field_72339_c - CrystalWishingCompassSolver.GOBLIN_KING_BB.field_72334_f)) {
            ((AbstractCollection)solutionPossibleTargets).remove((Object)CompassTarget.GOBLIN_KING);
        }
        if (((AbstractCollection)solutionPossibleTargets).contains((Object)CompassTarget.GOBLIN_QUEEN) && (solution.field_72450_a > CrystalWishingCompassSolver.GOBLIN_HOLDOUT_BB.field_72336_d + CrystalWishingCompassSolver.GOBLIN_QUEEN_BB.field_72336_d || solution.field_72449_c < CrystalWishingCompassSolver.GOBLIN_HOLDOUT_BB.field_72339_c - CrystalWishingCompassSolver.GOBLIN_QUEEN_BB.field_72334_f)) {
            ((AbstractCollection)solutionPossibleTargets).remove((Object)CompassTarget.GOBLIN_QUEEN);
        }
        if (((AbstractCollection)solutionPossibleTargets).contains((Object)CompassTarget.JUNGLE_TEMPLE) && (solution.field_72450_a > CrystalWishingCompassSolver.JUNGLE_BB.field_72336_d + CrystalWishingCompassSolver.JUNGLE_TEMPLE_BB.field_72336_d || solution.field_72449_c > CrystalWishingCompassSolver.JUNGLE_BB.field_72334_f + CrystalWishingCompassSolver.JUNGLE_TEMPLE_BB.field_72334_f)) {
            ((AbstractCollection)solutionPossibleTargets).remove((Object)CompassTarget.JUNGLE_TEMPLE);
        }
        if (((AbstractCollection)solutionPossibleTargets).contains((Object)CompassTarget.ODAWA) && (solution.field_72450_a > CrystalWishingCompassSolver.JUNGLE_BB.field_72336_d + CrystalWishingCompassSolver.ODAWA_BB.field_72336_d || solution.field_72449_c > CrystalWishingCompassSolver.JUNGLE_BB.field_72334_f + CrystalWishingCompassSolver.ODAWA_BB.field_72334_f)) {
            ((AbstractCollection)solutionPossibleTargets).remove((Object)CompassTarget.ODAWA);
        }
        if (((AbstractCollection)solutionPossibleTargets).contains((Object)CompassTarget.PRECURSOR_CITY) && (solution.field_72450_a < CrystalWishingCompassSolver.PRECURSOR_REMNANTS_BB.field_72340_a - CrystalWishingCompassSolver.PRECURSOR_CITY_BB.field_72336_d || solution.field_72449_c < CrystalWishingCompassSolver.PRECURSOR_REMNANTS_BB.field_72339_c - CrystalWishingCompassSolver.PRECURSOR_CITY_BB.field_72334_f)) {
            ((AbstractCollection)solutionPossibleTargets).remove((Object)CompassTarget.PRECURSOR_CITY);
        }
        if (((AbstractCollection)solutionPossibleTargets).contains((Object)CompassTarget.MINES_OF_DIVAN) && (solution.field_72450_a < CrystalWishingCompassSolver.MITHRIL_DEPOSITS_BB.field_72340_a - CrystalWishingCompassSolver.MINES_OF_DIVAN_BB.field_72336_d || solution.field_72449_c > CrystalWishingCompassSolver.MITHRIL_DEPOSITS_BB.field_72334_f + CrystalWishingCompassSolver.MINES_OF_DIVAN_BB.field_72334_f)) {
            ((AbstractCollection)solutionPossibleTargets).remove((Object)CompassTarget.MINES_OF_DIVAN);
        }
        if (((AbstractCollection)solutionPossibleTargets).contains((Object)CompassTarget.JUNGLE_TEMPLE) && ((AbstractCollection)solutionPossibleTargets).contains((Object)CompassTarget.BAL) && !foundCrystals.contains((Object)Crystal.AMETHYST) && compassUsedZone == HollowsZone.JUNGLE) {
            ((AbstractCollection)solutionPossibleTargets).remove((Object)CompassTarget.BAL);
        }
        return solutionPossibleTargets;
    }

    private EnumSet<CompassTarget> calculatePossibleTargets(BlockPos playerPos) {
        EnumSet<CompassTarget> candidateTargets = EnumSet.of(CompassTarget.CRYSTAL_NUCLEUS);
        EnumSet<Crystal> foundCrystals = this.foundCrystals.getAsCrystalEnumSet();
        block7: for (Crystal crystal : Crystal.values()) {
            if (foundCrystals.contains((Object)crystal)) continue;
            switch (crystal) {
                case JADE: {
                    candidateTargets.add(CompassTarget.MINES_OF_DIVAN);
                    continue block7;
                }
                case AMBER: {
                    candidateTargets.add(this.kingsScentPresent.getAsBoolean() ? CompassTarget.GOBLIN_QUEEN : CompassTarget.GOBLIN_KING);
                    continue block7;
                }
                case TOPAZ: {
                    candidateTargets.add(CompassTarget.BAL);
                    continue block7;
                }
                case AMETHYST: {
                    candidateTargets.add(this.keyInInventory.getAsBoolean() ? CompassTarget.JUNGLE_TEMPLE : CompassTarget.ODAWA);
                    continue block7;
                }
                case SAPPHIRE: {
                    candidateTargets.add(CompassTarget.PRECURSOR_CITY);
                }
            }
        }
        return candidateTargets;
    }

    private String getFriendlyNameForCompassTarget(CompassTarget compassTarget) {
        switch (compassTarget) {
            case BAL: {
                return EnumChatFormatting.RED + "Bal";
            }
            case ODAWA: {
                return EnumChatFormatting.GREEN + "Odawa";
            }
            case JUNGLE_TEMPLE: {
                return EnumChatFormatting.AQUA + "the " + EnumChatFormatting.GREEN + "Jungle Temple";
            }
            case GOBLIN_KING: {
                return EnumChatFormatting.GOLD + "King Yolkar";
            }
            case GOBLIN_QUEEN: {
                return EnumChatFormatting.AQUA + "the " + EnumChatFormatting.YELLOW + "Goblin Queen";
            }
            case PRECURSOR_CITY: {
                return EnumChatFormatting.AQUA + "the " + EnumChatFormatting.WHITE + "Precursor City";
            }
            case MINES_OF_DIVAN: {
                return EnumChatFormatting.AQUA + "the " + EnumChatFormatting.BLUE + "Mines of Divan";
            }
        }
        return EnumChatFormatting.WHITE + "an undetermined location";
    }

    private String getNameForCompassTarget(CompassTarget compassTarget) {
        boolean useSkytilsNames = NotEnoughUpdates.INSTANCE.config.mining.wishingCompassWaypointNames == 1;
        switch (compassTarget) {
            case BAL: {
                return useSkytilsNames ? "internal_bal" : "Bal";
            }
            case ODAWA: {
                return "Odawa";
            }
            case JUNGLE_TEMPLE: {
                return useSkytilsNames ? "internal_temple" : "Temple";
            }
            case GOBLIN_KING: {
                return useSkytilsNames ? "internal_king" : "King";
            }
            case GOBLIN_QUEEN: {
                return useSkytilsNames ? "internal_den" : "Queen";
            }
            case PRECURSOR_CITY: {
                return useSkytilsNames ? "internal_city" : "City";
            }
            case MINES_OF_DIVAN: {
                return useSkytilsNames ? "internal_mines" : "Mines";
            }
        }
        return "WishingTarget";
    }

    private String getSolutionCoordsText() {
        return this.solution == null ? "" : String.format("%.0f %.0f %.0f", this.solution.field_72450_a, this.solution.field_72448_b, this.solution.field_72449_c);
    }

    private String getWishingCompassDestinationsMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(EnumChatFormatting.YELLOW);
        sb.append("[NEU] ");
        sb.append(EnumChatFormatting.AQUA);
        sb.append("Wishing compass points to ");
        int index = 1;
        for (CompassTarget target : this.solutionPossibleTargets) {
            if (index > 1) {
                sb.append(EnumChatFormatting.AQUA);
                if (index == this.solutionPossibleTargets.size()) {
                    sb.append(" or ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append(this.getFriendlyNameForCompassTarget(target));
            ++index;
        }
        sb.append(EnumChatFormatting.AQUA);
        sb.append(" (");
        sb.append(this.getSolutionCoordsText());
        sb.append(")");
        return sb.toString();
    }

    private void showSolution() {
        if (this.solution == null) {
            return;
        }
        if (NUCLEUS_BB.func_72318_a((Vec3)this.solution)) {
            Utils.addChatMessage(EnumChatFormatting.YELLOW + "[NEU] " + EnumChatFormatting.AQUA + "Wishing compass target is the Crystal Nucleus");
            return;
        }
        String destinationMessage = this.getWishingCompassDestinationsMessage();
        if (!isSkytilsPresent) {
            Utils.addChatMessage(destinationMessage);
            return;
        }
        String targetNameForSkytils = this.solutionPossibleTargets.size() == 1 ? this.getNameForCompassTarget((CompassTarget)((Object)this.solutionPossibleTargets.iterator().next())) : "WishingTarget";
        String skytilsCommand = String.format("/sthw add %s %s", this.getSolutionCoordsText(), targetNameForSkytils);
        if (NotEnoughUpdates.INSTANCE.config.mining.wishingCompassAutocreateKnownWaypoints && this.solutionPossibleTargets.size() == 1) {
            Utils.addChatMessage(destinationMessage);
            int commandResult = ClientCommandHandler.instance.func_71556_a((ICommandSender)CrystalWishingCompassSolver.mc.field_71439_g, skytilsCommand);
            if (commandResult == 1) {
                return;
            }
            Utils.addChatMessage(EnumChatFormatting.RED + "[NEU] Failed to automatically run /sthw");
        }
        destinationMessage = destinationMessage + EnumChatFormatting.YELLOW + " [Add Skytils Waypoint]";
        ChatComponentText chatMessage = new ChatComponentText(destinationMessage);
        chatMessage.func_150255_a(Utils.createClickStyle(ClickEvent.Action.RUN_COMMAND, skytilsCommand, EnumChatFormatting.YELLOW + "Set waypoint for wishing target"));
        CrystalWishingCompassSolver.mc.field_71439_g.func_145747_a((IChatComponent)chatMessage);
    }

    private String getDiagnosticMessage() {
        StringBuilder diagsMessage = new StringBuilder();
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Solver State: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(this.solverState.name());
        diagsMessage.append("\n");
        if (this.firstCompass == null) {
            diagsMessage.append(EnumChatFormatting.AQUA);
            diagsMessage.append("First Compass: ");
            diagsMessage.append(EnumChatFormatting.WHITE);
            diagsMessage.append("<NONE>");
            diagsMessage.append("\n");
        } else {
            this.firstCompass.appendCompassDiagnostics(diagsMessage, "First Compass");
        }
        if (this.secondCompass == null) {
            diagsMessage.append(EnumChatFormatting.AQUA);
            diagsMessage.append("Second Compass: ");
            diagsMessage.append(EnumChatFormatting.WHITE);
            diagsMessage.append("<NONE>");
            diagsMessage.append("\n");
        } else {
            this.secondCompass.appendCompassDiagnostics(diagsMessage, "Second Compass");
        }
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Intersection Line: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(this.solutionIntersectionLine == null ? "<NONE>" : this.solutionIntersectionLine);
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Jungle Key in Inventory: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(this.isKeyInInventory());
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("King's Scent Present: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(this.isKingsScentPresent());
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("First Compass Targets: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(this.possibleTargets == null ? "<NONE>" : this.possibleTargets.toString());
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Current Calculated Targets: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(this.calculatePossibleTargets(CrystalWishingCompassSolver.mc.field_71439_g.func_180425_c()));
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Found Crystals: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(this.getFoundCrystals());
        diagsMessage.append("\n");
        if (this.originalSolution != null) {
            diagsMessage.append(EnumChatFormatting.AQUA);
            diagsMessage.append("Original Solution: ");
            diagsMessage.append(EnumChatFormatting.WHITE);
            diagsMessage.append(this.originalSolution);
            diagsMessage.append("\n");
        }
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Solution: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(this.solution == null ? "<NONE>" : this.solution.toString());
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Solution Targets: ");
        diagsMessage.append(EnumChatFormatting.WHITE);
        diagsMessage.append(this.solutionPossibleTargets == null ? "<NONE>" : this.solutionPossibleTargets.toString());
        diagsMessage.append("\n");
        diagsMessage.append(EnumChatFormatting.AQUA);
        diagsMessage.append("Seen particles:\n");
        for (ParticleData particleData : seenParticles) {
            diagsMessage.append(EnumChatFormatting.WHITE);
            diagsMessage.append(particleData);
            diagsMessage.append("\n");
        }
        return diagsMessage.toString();
    }

    public void logDiagnosticData(boolean outputAlways) {
        if (!SBInfo.getInstance().checkForSkyblockLocation()) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.config.mining.wishingCompassSolver) {
            Utils.addChatMessage(EnumChatFormatting.RED + "[NEU] Wishing Compass Solver is not enabled.");
            return;
        }
        boolean wishingDebugFlagSet = NEUDebugFlag.WISHING.isSet();
        if (outputAlways || wishingDebugFlagSet) {
            NEUDebugLogger.logAlways(this.getDiagnosticMessage());
        }
    }

    private static class ParticleData {
        Vec3Comparable particleLocation;
        long systemTime;

        public ParticleData(Vec3Comparable particleLocation, long systemTime) {
            this.particleLocation = particleLocation;
            this.systemTime = systemTime;
        }

        public String toString() {
            return "Location: " + this.particleLocation.toString() + ", systemTime: " + this.systemTime;
        }
    }

    static class Compass {
        public CompassState compassState;
        public Line line = null;
        private final BlockPos whereUsed;
        private final long whenUsedMillis;
        private Vec3Comparable firstParticle = null;
        private Vec3Comparable previousParticle = null;
        private Vec3Comparable lastParticle = null;
        private final ArrayList<ProcessedParticle> processedParticles;

        Compass(BlockPos whereUsed, long whenUsedMillis) {
            this.whereUsed = whereUsed;
            this.whenUsedMillis = whenUsedMillis;
            this.compassState = CompassState.WAITING_FOR_FIRST_PARTICLE;
            this.processedParticles = new ArrayList();
        }

        public Vec3Comparable getDirection() {
            if (this.firstParticle == null || this.lastParticle == null) {
                return null;
            }
            return new Vec3Comparable(this.firstParticle.subtractReverse(this.lastParticle).normalize());
        }

        public Vec3Comparable getDirectionTo(Vec3Comparable target) {
            if (this.firstParticle == null || target == null) {
                return null;
            }
            return new Vec3Comparable(this.firstParticle.subtractReverse(target).normalize());
        }

        public double particleSpread() {
            if (this.firstParticle == null || this.lastParticle == null) {
                return 0.0;
            }
            return this.firstParticle.func_72438_d(this.lastParticle);
        }

        public void processParticle(double x, double y, double z, long particleTimeMillis) {
            if (this.compassState == CompassState.FAILED_TIMEOUT_NO_REPEATING || this.compassState == CompassState.FAILED_TIMEOUT_NO_PARTICLES || this.compassState == CompassState.COMPLETED) {
                throw new UnsupportedOperationException("processParticle should not be called in a failed or completed state");
            }
            if (particleTimeMillis - this.whenUsedMillis > 5000L) {
                this.compassState = CompassState.FAILED_TIMEOUT_NO_REPEATING;
                return;
            }
            Vec3Comparable currentParticle = new Vec3Comparable(x, y, z);
            if (this.compassState == CompassState.WAITING_FOR_FIRST_PARTICLE) {
                Vec3Comparable vec3Comparable = new Vec3Comparable(this.whereUsed);
                if (currentParticle.func_72438_d(vec3Comparable) < 9.0) {
                    this.processedParticles.add(new ProcessedParticle(currentParticle, particleTimeMillis));
                    this.firstParticle = currentParticle;
                    this.previousParticle = currentParticle;
                    this.compassState = CompassState.COMPUTING_LAST_PARTICLE;
                }
                return;
            }
            if (currentParticle.func_72438_d(this.previousParticle) <= 0.6) {
                this.processedParticles.add(new ProcessedParticle(currentParticle, particleTimeMillis));
                this.previousParticle = currentParticle;
                return;
            }
            if (currentParticle.func_72438_d(this.firstParticle) > 0.6) {
                return;
            }
            this.processedParticles.add(new ProcessedParticle(currentParticle, particleTimeMillis));
            this.lastParticle = this.previousParticle;
            this.line = new Line(this.firstParticle, this.lastParticle);
            this.compassState = CompassState.COMPLETED;
        }

        public void appendCompassDiagnostics(StringBuilder diagsMessage, String compassName) {
            diagsMessage.append(EnumChatFormatting.AQUA);
            diagsMessage.append("Compass State: ");
            diagsMessage.append(EnumChatFormatting.WHITE);
            diagsMessage.append(this.compassState.name());
            diagsMessage.append("\n");
            diagsMessage.append(EnumChatFormatting.AQUA);
            diagsMessage.append(compassName);
            diagsMessage.append(" Used Millis: ");
            diagsMessage.append(EnumChatFormatting.WHITE);
            diagsMessage.append(this.whenUsedMillis);
            diagsMessage.append("\n");
            diagsMessage.append(EnumChatFormatting.AQUA);
            diagsMessage.append(compassName);
            diagsMessage.append(" Used Position: ");
            diagsMessage.append(EnumChatFormatting.WHITE);
            diagsMessage.append(this.whereUsed == null ? "<NONE>" : this.whereUsed.toString());
            diagsMessage.append("\n");
            diagsMessage.append(EnumChatFormatting.AQUA);
            diagsMessage.append(compassName);
            diagsMessage.append(" All Seen Particles: \n");
            diagsMessage.append(EnumChatFormatting.WHITE);
            for (ProcessedParticle particle : this.processedParticles) {
                diagsMessage.append(particle.toString());
                diagsMessage.append("\n");
            }
            diagsMessage.append(EnumChatFormatting.AQUA);
            diagsMessage.append(compassName);
            diagsMessage.append(" Particle Spread: ");
            diagsMessage.append(EnumChatFormatting.WHITE);
            diagsMessage.append(this.particleSpread());
            diagsMessage.append("\n");
            diagsMessage.append(EnumChatFormatting.AQUA);
            diagsMessage.append(compassName);
            diagsMessage.append(" Compass Line: ");
            diagsMessage.append(EnumChatFormatting.WHITE);
            diagsMessage.append(this.line == null ? "<NONE>" : this.line.toString());
            diagsMessage.append("\n");
        }

        static class ProcessedParticle {
            Vec3Comparable coords;
            long particleTimeMillis;

            ProcessedParticle(Vec3Comparable coords, long particleTimeMillis) {
                this.coords = coords;
                this.particleTimeMillis = particleTimeMillis;
            }

            public String toString() {
                return this.coords.toString() + " " + this.particleTimeMillis;
            }
        }
    }

    static enum HandleCompassResult {
        SUCCESS,
        LOCATION_TOO_CLOSE,
        STILL_PROCESSING_PRIOR_USE,
        POSSIBLE_TARGETS_CHANGED,
        NO_PARTICLES_FOR_PREVIOUS_COMPASS,
        PLAYER_IN_NUCLEUS;

    }

    static enum CompassState {
        WAITING_FOR_FIRST_PARTICLE,
        COMPUTING_LAST_PARTICLE,
        COMPLETED,
        FAILED_TIMEOUT_NO_REPEATING,
        FAILED_TIMEOUT_NO_PARTICLES;

    }

    public static interface CrystalEnumSetSupplier {
        public EnumSet<Crystal> getAsCrystalEnumSet();
    }

    static enum HollowsZone {
        CRYSTAL_NUCLEUS,
        JUNGLE,
        MITHRIL_DEPOSITS,
        GOBLIN_HOLDOUT,
        PRECURSOR_REMNANTS,
        MAGMA_FIELDS;

    }

    static enum Crystal {
        AMBER,
        AMETHYST,
        JADE,
        SAPPHIRE,
        TOPAZ;

    }

    static enum CompassTarget {
        GOBLIN_QUEEN,
        GOBLIN_KING,
        BAL,
        JUNGLE_TEMPLE,
        ODAWA,
        PRECURSOR_CITY,
        MINES_OF_DIVAN,
        CRYSTAL_NUCLEUS;

    }

    static enum SolverState {
        NOT_STARTED,
        PROCESSING_FIRST_USE,
        NEED_SECOND_COMPASS,
        PROCESSING_SECOND_USE,
        SOLVED,
        FAILED_EXCEPTION,
        FAILED_TIMEOUT_NO_REPEATING,
        FAILED_TIMEOUT_NO_PARTICLES,
        FAILED_INTERSECTION_CALCULATION,
        FAILED_INVALID_SOLUTION;

    }
}

