/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.events.SlotClickEvent;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;

public class EnchantingSolvers {
    public static SolverType currentSolver = SolverType.NONE;
    private static final NBTTagCompound enchTag = new NBTTagCompound(){
        {
            this.func_74782_a("ench", (NBTBase)new NBTTagList());
        }
    };
    private static boolean addToChronomatron = false;
    private static boolean chronomatronStartSeq = false;
    private static final List<String> chronomatronOrder = new ArrayList<String>();
    private static int chronomatronReplayIndex = 0;
    private static int lastChronomatronSize = 0;
    private static long millisLastClick = 0L;
    private static final Map<Integer, UltrasequencerItem> ultraSequencerOrder = new HashMap<Integer, UltrasequencerItem>();
    private static int ultrasequencerReplayIndex = 0;
    private static final Map<Integer, ItemStack> superpairStacks = new HashMap<Integer, ItemStack>();
    private static int lastSlotClicked = -1;
    private static final HashSet<Integer> successfulMatches = new HashSet();
    private static final HashSet<Integer> possibleMatches = new HashSet();
    private static final HashSet<Integer> powerupMatches = new HashSet();

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        chronomatronOrder.clear();
        currentSolver = SolverType.NONE;
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return;
        }
        String openChestName = Utils.getOpenChestName();
        if (!openChestName.contains("Stakes")) {
            if (openChestName.startsWith("Chronomatron")) {
                currentSolver = SolverType.CHRONOMATRON;
            } else if (openChestName.startsWith("Ultrasequencer")) {
                currentSolver = SolverType.ULTRASEQUENCER;
            } else if (openChestName.startsWith("Superpairs")) {
                currentSolver = SolverType.SUPERPAIRS;
            }
        }
    }

    public static ItemStack overrideStack(IInventory inventory, int slotIndex, ItemStack stack) {
        if (!NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enableEnchantingSolvers) {
            return null;
        }
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return null;
        }
        if (stack != null && stack.func_82833_r() != null && Minecraft.func_71410_x().field_71462_r instanceof GuiChest) {
            GuiChest chest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
            ContainerChest container = (ContainerChest)chest.field_147002_h;
            IInventory lower2 = container.func_85151_d();
            if (lower2 != inventory) {
                return null;
            }
            String displayName = stack.func_82833_r();
            if (currentSolver == SolverType.CHRONOMATRON) {
                boolean yepClock;
                ItemStack timerStack = lower2.func_70301_a(lower2.func_70302_i_() - 5);
                if (timerStack == null) {
                    return null;
                }
                boolean bl = yepClock = timerStack.func_77973_b() == Items.field_151113_aN;
                if (yepClock && addToChronomatron && chronomatronOrder.size() >= lastChronomatronSize + 1 && chronomatronReplayIndex < chronomatronOrder.size()) {
                    String chronomatronCurrent = chronomatronOrder.get(chronomatronReplayIndex);
                    if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150399_cn) || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150406_ce)) {
                        String chronomatronNext;
                        boolean lastSame;
                        long currentTime = System.currentTimeMillis();
                        boolean bl2 = lastSame = chronomatronReplayIndex > 0 && chronomatronCurrent.equals(chronomatronOrder.get(chronomatronReplayIndex - 1));
                        if (chronomatronCurrent.equals(displayName)) {
                            if (!lastSame || currentTime - millisLastClick > 300L) {
                                ItemStack retStack = new ItemStack(Item.func_150898_a((Block)Blocks.field_150406_ce), 1, stack.func_77952_i());
                                retStack.func_77982_d(enchTag);
                                retStack.func_151001_c(stack.func_82833_r());
                                return retStack;
                            }
                            ItemStack retStack = new ItemStack(Item.func_150898_a((Block)Blocks.field_150399_cn), 1, stack.func_77952_i());
                            retStack.func_151001_c(stack.func_82833_r());
                            return retStack;
                        }
                        if (chronomatronReplayIndex + 1 < chronomatronOrder.size() && NotEnoughUpdates.INSTANCE.config.enchantingSolvers.showNextClick && (chronomatronNext = chronomatronOrder.get(chronomatronReplayIndex + 1)).equals(displayName)) {
                            ItemStack retStack = new ItemStack(Item.func_150898_a((Block)Blocks.field_150399_cn), 1, stack.func_77952_i());
                            retStack.func_151001_c(stack.func_82833_r());
                            return retStack;
                        }
                        ItemStack retStack = new ItemStack(Item.func_150898_a((Block)Blocks.field_150399_cn), 1, 8);
                        retStack.func_151001_c(stack.func_82833_r());
                        return retStack;
                    }
                }
            } else if (currentSolver == SolverType.ULTRASEQUENCER) {
                boolean yepClock;
                ItemStack timerStack = lower2.func_70301_a(lower2.func_70302_i_() - 5);
                if (timerStack == null) {
                    return null;
                }
                boolean bl = yepClock = timerStack.func_77973_b() == Items.field_151113_aN;
                if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co) && stack.func_77952_i() != 15 && yepClock) {
                    for (int solveIndex : ultraSequencerOrder.keySet()) {
                        UltrasequencerItem item = ultraSequencerOrder.get(solveIndex);
                        if (item.containerIndex != slotIndex) continue;
                        ItemStack newStack = item.stack;
                        if (solveIndex == ultrasequencerReplayIndex) {
                            newStack.func_77982_d(enchTag);
                        } else {
                            newStack.func_77982_d(null);
                        }
                        return newStack;
                    }
                    ItemStack retStack = new ItemStack(Item.func_150898_a((Block)Blocks.field_150397_co), 1, 15);
                    retStack.func_151001_c(stack.func_82833_r());
                    return retStack;
                }
            } else if (currentSolver == SolverType.SUPERPAIRS && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150399_cn) && superpairStacks.containsKey(slotIndex)) {
                return superpairStacks.get(slotIndex);
            }
        }
        return null;
    }

    public static boolean onStackRender(ItemStack stack, IInventory inventory, int slotIndex, int x, int y) {
        if (!NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enableEnchantingSolvers) {
            return false;
        }
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return false;
        }
        if (stack != null && stack.func_82833_r() != null && Minecraft.func_71410_x().field_71462_r instanceof GuiChest) {
            GuiChest chest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
            ContainerChest container = (ContainerChest)chest.field_147002_h;
            IInventory lower2 = container.func_85151_d();
            if (lower2 != inventory) {
                return false;
            }
            if (currentSolver == SolverType.ULTRASEQUENCER) {
                boolean yepClock;
                ItemStack timerStack = lower2.func_70301_a(lower2.func_70302_i_() - 5);
                if (timerStack == null) {
                    return false;
                }
                boolean bl = yepClock = timerStack.func_77973_b() == Items.field_151113_aN;
                if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co) && stack.func_77952_i() != 15 && yepClock) {
                    for (int solveIndex : ultraSequencerOrder.keySet()) {
                        UltrasequencerItem item = ultraSequencerOrder.get(solveIndex);
                        if (item.containerIndex != slotIndex) continue;
                        int meta = 0;
                        if (solveIndex == ultrasequencerReplayIndex) {
                            meta = NotEnoughUpdates.INSTANCE.config.enchantingSolvers.seqNext;
                        } else if (solveIndex == ultrasequencerReplayIndex + 1) {
                            meta = NotEnoughUpdates.INSTANCE.config.enchantingSolvers.seqUpcoming;
                        }
                        if (meta > 0) {
                            Utils.drawItemStack(new ItemStack(Item.func_150898_a((Block)Blocks.field_150397_co), 1, meta - 1), x, y);
                        }
                        if (!NotEnoughUpdates.INSTANCE.config.enchantingSolvers.seqNumbers || solveIndex < ultrasequencerReplayIndex) continue;
                        int w = Minecraft.func_71410_x().field_71466_p.func_78256_a(solveIndex + 1 + "");
                        GlStateManager.func_179097_i();
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179140_f();
                        Utils.drawStringScaled(solveIndex + 1 + "", (float)x + 8.5f - (float)w / 2.0f, (float)y + 8.5f - 4.0f, true, -4144960, 1.0f);
                        return true;
                    }
                }
            } else if (currentSolver == SolverType.SUPERPAIRS) {
                int meta = 0;
                if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150399_cn) && superpairStacks.containsKey(slotIndex)) {
                    meta = possibleMatches.contains(slotIndex) ? NotEnoughUpdates.INSTANCE.config.enchantingSolvers.supPossible : NotEnoughUpdates.INSTANCE.config.enchantingSolvers.supUnmatched;
                } else if (powerupMatches.contains(slotIndex)) {
                    meta = NotEnoughUpdates.INSTANCE.config.enchantingSolvers.supPower;
                } else if (successfulMatches.contains(slotIndex)) {
                    meta = NotEnoughUpdates.INSTANCE.config.enchantingSolvers.supMatched;
                }
                if (meta > 0) {
                    Utils.drawItemStack(new ItemStack(Item.func_150898_a((Block)Blocks.field_150397_co), 1, meta - 1), x, y);
                }
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onStackClick(SlotClickEvent event) {
        boolean yepClock;
        ItemStack timerStack;
        if (!NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enableEnchantingSolvers || !NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return;
        }
        ItemStack stack = event.slot.func_75211_c();
        if (stack == null || stack.func_82833_r() == null) {
            return;
        }
        String displayName = stack.func_82833_r();
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiChest)) {
            return;
        }
        GuiChest chest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
        ContainerChest container = (ContainerChest)chest.field_147002_h;
        IInventory lower2 = container.func_85151_d();
        if (currentSolver == SolverType.CHRONOMATRON) {
            timerStack = lower2.func_70301_a(lower2.func_70302_i_() - 5);
            if (timerStack == null) {
                return;
            }
            boolean bl = yepClock = timerStack.func_77973_b() == Items.field_151113_aN;
            if (timerStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150426_aN) || yepClock && (!addToChronomatron || chronomatronOrder.size() < lastChronomatronSize + 1)) {
                event.setCanceled(true);
                return;
            }
            if (yepClock) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - millisLastClick < 150L) {
                    event.setCanceled(true);
                    return;
                }
                if (chronomatronReplayIndex < chronomatronOrder.size()) {
                    String chronomatronCurrent = chronomatronOrder.get(chronomatronReplayIndex);
                    if ((!NotEnoughUpdates.INSTANCE.config.enchantingSolvers.preventMisclicks1 || chronomatronCurrent.equals(displayName) || Keyboard.getEventKey() == 42) && stack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150397_co) && event.slotId != 4 && event.slotId != 49) {
                        ++chronomatronReplayIndex;
                        millisLastClick = currentTime;
                        event.usePickblockInstead();
                        return;
                    }
                }
                event.setCanceled(true);
                return;
            }
        }
        if (currentSolver == SolverType.ULTRASEQUENCER) {
            timerStack = lower2.func_70301_a(lower2.func_70302_i_() - 5);
            if (timerStack == null) {
                return;
            }
            boolean bl = yepClock = timerStack.func_77973_b() == Items.field_151113_aN;
            if (yepClock) {
                UltrasequencerItem current = ultraSequencerOrder.get(ultrasequencerReplayIndex);
                long currentTime = System.currentTimeMillis();
                if (current == null) {
                    event.setCanceled(true);
                    return;
                }
                if (!(currentTime - millisLastClick <= 150L || NotEnoughUpdates.INSTANCE.config.enchantingSolvers.preventMisclicks1 && current.containerIndex != event.slotId && Keyboard.getEventKey() != 42 || event.slotId >= 45 || event.slotId <= 8)) {
                    ++ultrasequencerReplayIndex;
                    millisLastClick = currentTime;
                    event.usePickblockInstead();
                    return;
                }
            }
            event.setCanceled(true);
        } else if (currentSolver == SolverType.SUPERPAIRS) {
            lastSlotClicked = event.slotId;
        }
    }

    public static void processInventoryContents(boolean fromTick) {
        if (currentSolver != SolverType.CHRONOMATRON && !fromTick) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.config.enchantingSolvers.enableEnchantingSolvers) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiChest) {
            ItemStack timerStack;
            GuiChest chest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
            ContainerChest container = (ContainerChest)chest.field_147002_h;
            IInventory lower2 = container.func_85151_d();
            if (currentSolver == SolverType.CHRONOMATRON) {
                boolean yepClock;
                timerStack = lower2.func_70301_a(lower2.func_70302_i_() - 5);
                if (timerStack == null) {
                    return;
                }
                String stainedHardenedClayName = null;
                for (int index = 0; index < lower2.func_70302_i_(); ++index) {
                    ItemStack stack = lower2.func_70301_a(index);
                    if (stack == null || stack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150406_ce) || stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("ench")) continue;
                    if (stainedHardenedClayName != null && !stack.func_82833_r().equals(stainedHardenedClayName)) {
                        return;
                    }
                    stainedHardenedClayName = stack.func_82833_r();
                }
                boolean bl = yepClock = timerStack.func_77973_b() == Items.field_151113_aN;
                if (timerStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150426_aN) || yepClock && (!addToChronomatron || chronomatronOrder.size() < lastChronomatronSize + 1)) {
                    if (chronomatronStartSeq) {
                        chronomatronStartSeq = false;
                        addToChronomatron = false;
                        lastChronomatronSize = chronomatronOrder.size();
                        chronomatronOrder.clear();
                    }
                    if (stainedHardenedClayName != null) {
                        if (addToChronomatron) {
                            chronomatronOrder.add(stainedHardenedClayName);
                        }
                        addToChronomatron = false;
                    } else {
                        addToChronomatron = true;
                        chronomatronReplayIndex = 0;
                    }
                } else if (yepClock) {
                    chronomatronStartSeq = true;
                }
            } else {
                chronomatronStartSeq = true;
                addToChronomatron = true;
            }
            if (currentSolver == SolverType.ULTRASEQUENCER) {
                timerStack = lower2.func_70301_a(lower2.func_70302_i_() - 5);
                if (timerStack == null) {
                    return;
                }
                if (timerStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150426_aN)) {
                    ultrasequencerReplayIndex = 0;
                }
                for (int index = 0; index < lower2.func_70302_i_(); ++index) {
                    ItemStack stack = lower2.func_70301_a(index);
                    if (stack == null || stack.func_77973_b() != Items.field_151100_aR) continue;
                    if (ultraSequencerOrder.containsKey(stack.field_77994_a - 1)) {
                        UltrasequencerItem ultrasequencerItem = ultraSequencerOrder.get(stack.field_77994_a - 1);
                        ultrasequencerItem.containerIndex = index;
                        ultrasequencerItem.stack = stack;
                        continue;
                    }
                    ultraSequencerOrder.put(stack.field_77994_a - 1, new UltrasequencerItem(stack, index));
                }
            } else {
                ultraSequencerOrder.clear();
            }
            if (currentSolver == SolverType.SUPERPAIRS) {
                successfulMatches.clear();
                possibleMatches.clear();
                powerupMatches.clear();
                block2: for (int index = 0; index < lower2.func_70302_i_(); ++index) {
                    ItemStack stack = lower2.func_70301_a(index);
                    if (stack == null) continue;
                    if (stack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150399_cn) && stack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150397_co)) {
                        boolean oddMatches;
                        NBTTagCompound display;
                        superpairStacks.put(index, stack);
                        NBTTagCompound tag = stack.func_77978_p();
                        if (tag != null && (display = tag.func_74775_l("display")).func_150297_b("Lore", 9)) {
                            NBTTagList list = display.func_150295_c("Lore", 8);
                            for (int i = 0; i < list.func_74745_c(); ++i) {
                                if (!list.func_150307_f(i).toLowerCase(Locale.ROOT).contains("powerup")) continue;
                                powerupMatches.add(index);
                                continue block2;
                            }
                        }
                        int numMatches = 0;
                        for (int index2 = 0; index2 < lower2.func_70302_i_(); ++index2) {
                            ItemStack stack2 = lower2.func_70301_a(index2);
                            if (stack2 == null || !stack2.func_82833_r().equals(stack.func_82833_r()) || stack.func_77973_b() != stack2.func_77973_b() || stack.func_77952_i() != stack2.func_77952_i()) continue;
                            ++numMatches;
                        }
                        boolean bl = oddMatches = numMatches % 2 == 1;
                        if (oddMatches && index == lastSlotClicked || successfulMatches.contains(index)) continue;
                        for (int index2 = 0; index2 < lower2.func_70302_i_(); ++index2) {
                            ItemStack stack2;
                            if (index == index2 || oddMatches && index2 == lastSlotClicked || (stack2 = lower2.func_70301_a(index2)) == null || !stack2.func_82833_r().equals(stack.func_82833_r()) || stack.func_77973_b() != stack2.func_77973_b() || stack.func_77952_i() != stack2.func_77952_i()) continue;
                            successfulMatches.add(index);
                            successfulMatches.add(index2);
                        }
                        continue;
                    }
                    if (!superpairStacks.containsKey(index) || superpairStacks.get(index) == null || possibleMatches.contains(index)) continue;
                    ItemStack stack1 = superpairStacks.get(index);
                    for (int index2 = 0; index2 < lower2.func_70302_i_(); ++index2) {
                        if (index == index2 || !superpairStacks.containsKey(index2) || superpairStacks.get(index2) == null) continue;
                        ItemStack stack2 = superpairStacks.get(index2);
                        if (!stack1.func_82833_r().equals(stack2.func_82833_r()) || stack1.func_77973_b() != stack2.func_77973_b() || stack1.func_77952_i() != stack2.func_77952_i()) continue;
                        possibleMatches.add(index);
                        possibleMatches.add(index2);
                    }
                }
            } else {
                superpairStacks.clear();
                successfulMatches.clear();
                powerupMatches.clear();
                lastSlotClicked = -1;
            }
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        String internal;
        if (NotEnoughUpdates.INSTANCE.config.enchantingSolvers.hideTooltips && (currentSolver == SolverType.CHRONOMATRON || currentSolver == SolverType.ULTRASEQUENCER) && (internal = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(event.itemStack)) == null && event.toolTip.size() > 0 && !((String)event.toolTip.get(0)).trim().replaceAll("\\(#.+\\)$", "").trim().contains(" ")) {
            event.toolTip.clear();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiChest)) {
            currentSolver = SolverType.NONE;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EnchantingSolvers.processInventoryContents(true);
    }

    public static boolean disableButtons() {
        return currentSolver != SolverType.NONE && NotEnoughUpdates.INSTANCE.config.enchantingSolvers.hideButtons;
    }

    private static class UltrasequencerItem {
        ItemStack stack;
        int containerIndex;

        public UltrasequencerItem(ItemStack stack, int containerIndex) {
            this.stack = stack;
            this.containerIndex = containerIndex;
        }
    }

    public static enum SolverType {
        NONE,
        CHRONOMATRON,
        ULTRASEQUENCER,
        SUPERPAIRS;

    }
}

