/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import io.github.moulberry.notenoughupdates.deps.com.mojang.brigadier.context.CommandContext;
import io.github.moulberry.notenoughupdates.events.RegisterBrigadierCommandEvent;
import io.github.moulberry.notenoughupdates.events.RepositoryReloadEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.AbiphoneContactHelper;
import io.github.moulberry.notenoughupdates.miscfeatures.customblockzones.LocationChangeEvent;
import io.github.moulberry.notenoughupdates.miscgui.GuiNavigation;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.util.JsonUtils;
import io.github.moulberry.notenoughupdates.util.NotificationHandler;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import io.github.moulberry.notenoughupdates.util.brigadier.DslKt;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Vec3i;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;

public class Navigation {
    private List<Teleporter> teleporters = new ArrayList<Teleporter>();
    private Map<String, String> areaNames = new HashMap<String, String>();
    private Map<String, WarpPoint> warps = new HashMap<String, WarpPoint>();
    private Map<String, JsonObject> waypoints = new HashMap<String, JsonObject>();
    private final NotEnoughUpdates neu;
    private JsonObject currentlyTrackedWaypoint = null;
    private BlockPos position = null;
    private String island = null;
    private String displayName = null;
    private String internalname = null;
    private String warpAgainTo = null;
    private Instant lastWarpAttemptedTime = null;
    private String lastWarpAttempted;
    private Instant warpAgainTiming = null;
    private Teleporter nextTeleporter = null;

    public Map<String, JsonObject> getWaypoints() {
        return this.waypoints;
    }

    public Navigation(NotEnoughUpdates notEnoughUpdates) {
        this.neu = notEnoughUpdates;
    }

    public boolean isValidWaypoint(JsonObject object) {
        return object != null && object.has("x") && object.has("y") && object.has("z") && object.has("island") && object.has("displayname") && object.has("internalname");
    }

    public void trackWaypoint(String trackNow) {
        if (trackNow == null) {
            this.trackWaypoint((JsonObject)null);
        } else {
            JsonObject jsonObject = this.waypoints.get(trackNow);
            if (jsonObject == null) {
                this.showError("Could not track waypoint " + trackNow + ". This is likely due to an outdated or broken repository.", true);
                return;
            }
            this.trackWaypoint(jsonObject);
        }
    }

    public void trackWaypoint(JsonObject trackNow) {
        if (trackNow != null && !this.isValidWaypoint(trackNow)) {
            this.showError("Could not track waypoint. This is likely due to an outdated or broken repository.", true);
            return;
        }
        if (!this.neu.config.hidden.hasOpenedWaypointMenu) {
            NotificationHandler.displayNotification(Arrays.asList("You just tracked a waypoint.", "Press [N] to open the waypoint menu to untrack it", "or to find other waypoints to track.", "Press [X] to close this message."), true, false);
        }
        this.currentlyTrackedWaypoint = trackNow;
        this.updateData();
    }

    @SubscribeEvent
    public void onRepositoryReload(RepositoryReloadEvent event) {
        JsonObject obj = Utils.getConstant("islands", this.neu.manager.gson);
        List<Teleporter> teleporters = JsonUtils.getJsonArrayOrEmpty(obj, "teleporters", jsonElement -> {
            JsonObject teleporterObj = jsonElement.getAsJsonObject();
            return new Teleporter(teleporterObj.get("x").getAsDouble(), teleporterObj.get("y").getAsDouble(), teleporterObj.get("z").getAsDouble(), teleporterObj.get("from").getAsString(), teleporterObj.get("to").getAsString());
        });
        for (Teleporter teleporter : teleporters) {
            if (!teleporter.from.equals(teleporter.to)) continue;
            this.showError("Found self referencing teleporter: " + teleporter.from, true);
        }
        this.teleporters = teleporters;
        this.waypoints = NotEnoughUpdates.INSTANCE.manager.getItemInformation().values().stream().filter(this::isValidWaypoint).collect(Collectors.toMap(it -> it.get("internalname").getAsString(), it -> it));
        this.areaNames = JsonUtils.transformJsonObjectToMap(obj.getAsJsonObject("area_names"), JsonElement::getAsString);
        this.warps = JsonUtils.getJsonArrayOrEmpty(obj, "island_warps", jsonElement -> {
            JsonObject warpObject = jsonElement.getAsJsonObject();
            return new WarpPoint(warpObject.get("x").getAsDouble(), warpObject.get("y").getAsDouble(), warpObject.get("z").getAsDouble(), warpObject.get("warp").getAsString(), warpObject.get("mode").getAsString());
        }).stream().collect(Collectors.toMap(it -> it.warpName, it -> it));
    }

    @SubscribeEvent
    public void onKeybindPressed(InputEvent.KeyInputEvent event) {
        int key;
        if (!Keyboard.getEventKeyState()) {
            return;
        }
        int n = key = Keyboard.getEventKey() == 0 ? Keyboard.getEventCharacter() + 256 : Keyboard.getEventKey();
        if (this.neu.config.misc.keybindWaypoint == key) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                if (this.currentlyTrackedWaypoint != null) {
                    this.useWarpCommand();
                }
            } else {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiNavigation());
            }
        }
    }

    public Map<String, WarpPoint> getWarps() {
        return this.warps;
    }

    @SubscribeEvent
    public void onChatMessage(ClientChatReceivedEvent event) {
        if (event.type == 2) {
            return;
        }
        if (StringUtils.cleanColour(event.message.func_150260_c()).startsWith("\u00a7r\u00a7eYou may now fast travel to")) {
            this.getNonUnlockedWarpScrolls().clear();
            return;
        }
        if (!"\u00a7r\u00a7cYou haven't unlocked this fast travel destination!\u00a7r".equals(event.message.func_150254_d())) {
            return;
        }
        Instant lwa = this.lastWarpAttemptedTime;
        if (lwa == null) {
            return;
        }
        if (Duration.between(lwa, Instant.now()).compareTo(Duration.ofSeconds(1L)) > 0) {
            return;
        }
        this.lastWarpAttemptedTime = null;
        this.getNonUnlockedWarpScrolls().add(this.lastWarpAttempted);
        Utils.addChatMessage("\u00a7e[NEU] This warp has been marked as non available.");
        Utils.addChatMessage("\u00a7e[NEU] Try navigating to that same position again to check if you have another warp available on that island.");
        Utils.addChatMessage("\u00a7e[NEU] To reset, type /neuclearwarps");
    }

    @SubscribeEvent
    public void onCommands(RegisterBrigadierCommandEvent event) {
        event.command("neuclearwarps", builder -> DslKt.thenExecute(builder, (Function1<? super CommandContext<ICommandSender>, Unit>)((Function1)context -> {
            this.getNonUnlockedWarpScrolls().clear();
            DslKt.reply(context, "Reset all blocked warps.");
            return Unit.INSTANCE;
        })));
    }

    private Set<String> getNonUnlockedWarpScrolls() {
        NEUConfig.HiddenProfileSpecific profileSpecific = this.neu.config.getProfileSpecific();
        if (profileSpecific == null) {
            return new HashSet<String>();
        }
        return profileSpecific.nonUnlockedWarpScrolls;
    }

    public WarpPoint getClosestWarp(String mode, Vec3i position, boolean checkAvailable) {
        double minDistance = -1.0;
        Set<String> nonUnlockedWarpScrolls = this.getNonUnlockedWarpScrolls();
        WarpPoint minWarp = null;
        for (WarpPoint value : this.warps.values()) {
            double distance;
            if (!value.modeName.equals(mode) || checkAvailable && nonUnlockedWarpScrolls.contains(value.warpName) || !((distance = value.blockPos.func_177951_i(position)) < minDistance) && minWarp != null) continue;
            minDistance = distance;
            minWarp = value;
        }
        return minWarp;
    }

    public void useWarpCommand() {
        EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
        if (this.currentlyTrackedWaypoint == null || thePlayer == null) {
            return;
        }
        WarpPoint closestWarp = this.getClosestWarp(this.island, (Vec3i)this.position, true);
        if (closestWarp == null) {
            this.showError("Could not find an unlocked warp that could be used.", false);
            return;
        }
        if (!this.island.equals(SBInfo.getInstance().mode)) {
            this.warpAgainTiming = Instant.now();
            this.warpAgainTo = closestWarp.warpName;
        } else if (thePlayer.func_174818_b(this.position) < closestWarp.blockPos.func_177951_i((Vec3i)this.position)) {
            this.showError("You are already on the same island and nearer than the closest unlocked warp scroll.", false);
            return;
        }
        this.lastWarpAttemptedTime = Instant.now();
        this.lastWarpAttempted = closestWarp.warpName;
        thePlayer.func_71165_d("/warp " + closestWarp.warpName);
    }

    @SubscribeEvent
    public void onTeleportDone(EntityJoinWorldEvent event) {
        if (this.neu.config.misc.warpTwice && event.entity == Minecraft.func_71410_x().field_71439_g && this.warpAgainTo != null && this.warpAgainTiming != null && this.warpAgainTiming.plusSeconds(1L).isAfter(Instant.now())) {
            this.warpAgainTiming = null;
            String savedWarpAgain = this.warpAgainTo;
            this.warpAgainTo = null;
            Minecraft.func_71410_x().field_71439_g.func_71165_d("/warp " + savedWarpAgain);
        }
    }

    public String getNameForAreaMode(String mode) {
        return this.areaNames.get(mode);
    }

    public String getNameForAreaModeOrUnknown(String mode) {
        return this.areaNames.getOrDefault(mode, "Unknown");
    }

    public void untrackWaypoint() {
        this.trackWaypoint((JsonObject)null);
    }

    public JsonObject getTrackedWaypoint() {
        return this.currentlyTrackedWaypoint;
    }

    public String getIsland() {
        return this.island;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public String getInternalname() {
        return this.internalname;
    }

    private void updateData() {
        if (this.currentlyTrackedWaypoint == null) {
            this.position = null;
            this.island = null;
            this.displayName = null;
            this.nextTeleporter = null;
            this.internalname = null;
            return;
        }
        this.position = new BlockPos(this.currentlyTrackedWaypoint.get("x").getAsDouble(), this.currentlyTrackedWaypoint.get("y").getAsDouble(), this.currentlyTrackedWaypoint.get("z").getAsDouble());
        this.internalname = this.currentlyTrackedWaypoint.get("internalname").getAsString();
        this.island = this.currentlyTrackedWaypoint.get("island").getAsString();
        this.displayName = this.currentlyTrackedWaypoint.get("displayname").getAsString();
        this.recalculateNextTeleporter(SBInfo.getInstance().mode);
    }

    @SubscribeEvent
    public void onLocationChange(LocationChangeEvent event) {
        this.recalculateNextTeleporter(event.newLocation);
    }

    public Teleporter recalculateNextTeleporter(String from) {
        String to = this.island;
        if (from == null || to == null) {
            return null;
        }
        List<Teleporter> nextTeleporter = this.findNextTeleporter0(from, to, new HashSet<String>());
        this.nextTeleporter = nextTeleporter == null || nextTeleporter.isEmpty() ? null : nextTeleporter.get(0);
        return this.nextTeleporter;
    }

    private List<Teleporter> findNextTeleporter0(String from, String to, Set<String> visited) {
        if (from.equals(to)) {
            return new ArrayList<Teleporter>();
        }
        if (visited.contains(from)) {
            return null;
        }
        visited.add(from);
        int minPathLength = 0;
        List<Teleporter> minPath = null;
        for (Teleporter teleporter : this.teleporters) {
            List<Teleporter> nextTeleporter0;
            if (!teleporter.from.equals(from) || (nextTeleporter0 = this.findNextTeleporter0(teleporter.to, to, visited)) == null || minPath != null && nextTeleporter0.size() >= minPathLength) continue;
            minPathLength = nextTeleporter0.size();
            nextTeleporter0.add(0, teleporter);
            minPath = nextTeleporter0;
        }
        visited.remove(from);
        return minPath;
    }

    private void showError(String message, boolean log2) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            Utils.addChatMessage(EnumChatFormatting.DARK_RED + "[NEU-Waypoint] " + message);
        }
        if (log2) {
            new RuntimeException("[NEU-Waypoint] " + message).printStackTrace();
        }
    }

    @SubscribeEvent
    public void onEvent(TickEvent.ClientTickEvent event) {
        EntityPlayerSP thePlayer;
        if (event.phase == TickEvent.Phase.END && this.currentlyTrackedWaypoint != null && NotEnoughUpdates.INSTANCE.config.misc.untrackCloseWaypoints && this.island.equals(SBInfo.getInstance().mode) && (thePlayer = Minecraft.func_71410_x().field_71439_g) != null && thePlayer.func_174818_b(this.position) < 16.0) {
            this.untrackWaypoint();
            AbiphoneContactHelper.getInstance().resetMarker();
        }
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        if (this.currentlyTrackedWaypoint != null) {
            if (this.island.equals(SBInfo.getInstance().mode)) {
                RenderUtils.renderWayPoint(this.displayName, (Vec3i)this.position, event.partialTicks);
            } else if (this.nextTeleporter != null) {
                String to = this.nextTeleporter.to;
                String toName = this.getNameForAreaModeOrUnknown(to);
                RenderUtils.renderWayPoint(Arrays.asList("Teleporter to " + toName, "(towards " + this.displayName + "\u00a7r)"), (Vec3i)new BlockPos(this.nextTeleporter.x, this.nextTeleporter.y, this.nextTeleporter.z), event.partialTicks);
            }
        }
    }

    public static class Teleporter {
        public final double x;
        public final double y;
        public final double z;
        public final String from;
        public final String to;

        public Teleporter(double x, double y, double z, String from, String to) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.from = from;
            this.to = to;
        }
    }

    public static class WarpPoint {
        public final BlockPos blockPos;
        public final String warpName;
        public final String modeName;

        public WarpPoint(double x, double y, double z, String warpName, String modeName) {
            this.blockPos = new BlockPos(x, y, z);
            this.warpName = warpName;
            this.modeName = modeName;
        }
    }
}

