/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.ConfigUtil;
import io.github.moulberry.notenoughupdates.miscgui.StorageOverlay;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.File;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.play.client.C0EPacketClickWindow;
import net.minecraft.network.play.server.S2DPacketOpenWindow;
import net.minecraft.network.play.server.S2EPacketCloseWindow;
import net.minecraft.network.play.server.S2FPacketSetSlot;
import net.minecraft.network.play.server.S30PacketWindowItems;

public class StorageManager {
    private static final StorageManager INSTANCE = new StorageManager();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)ItemStack.class), new ItemStackSerializer()).registerTypeAdapter((Type)((Object)ItemStack.class), new ItemStackDeserializer()).create();
    private static final Pattern JSON_FIX_REGEX = Pattern.compile("\"([^,:]+)\":");
    private final AtomicInteger searchId = new AtomicInteger(0);
    public static int MAX_ENDER_CHEST_PAGES = 9;
    public static final ItemStack LOCKED_ENDERCHEST_STACK = Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150397_co), "\u00a7cLocked Page", 14, "\u00a77Unlock more Ender Chest", "\u00a77pages in the community", "\u00a77shop!");
    public StorageConfig storageConfig = new StorageConfig();
    private int currentStoragePage = -1;
    public boolean onStorageMenu = false;
    private String lastSearch = "";
    private boolean[] storagePresent = null;
    public long storageOpenSwitchMillis = 0L;
    private final ItemStack[] missingBackpackStacks = new ItemStack[18];
    private boolean shouldRenderStorageOverlayCached = false;
    private static final Pattern WINDOW_REGEX = Pattern.compile(".+ Backpack (?:\u2726 )?\\(Slot #(\\d+)\\)");
    private static final Pattern ECHEST_WINDOW_REGEX = Pattern.compile("Ender Chest \\((\\d+)/(\\d+)\\)");
    public boolean isStorageOpen = false;

    private static JsonObject nbtToJson(NBTTagCompound NBTTagCompound2) {
        return (JsonObject)StorageManager.loadJson((NBTBase)NBTTagCompound2);
    }

    private static void fixPetInfo(ItemStack src) {
        if (src.func_77978_p() == null || !src.func_77978_p().func_74764_b("ExtraAttributes") || !src.func_77978_p().func_74775_l("ExtraAttributes").func_74764_b("petInfo")) {
            return;
        }
        PetInfo oldPetInfo = GSON.fromJson(src.func_77978_p().func_74775_l("ExtraAttributes").func_74779_i("petInfo"), PetInfo.class);
        src.func_77978_p().func_74775_l("ExtraAttributes").func_82580_o("petInfo");
        try {
            src.func_77978_p().func_74775_l("ExtraAttributes").func_74782_a("petInfo", (NBTBase)JsonToNBT.func_180713_a((String)oldPetInfo.toString()));
        }
        catch (NullPointerException | NBTException throwable) {
            // empty catch block
        }
    }

    private static JsonElement loadJson(NBTBase tag) {
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)tag;
            JsonObject jsonObject = new JsonObject();
            for (String key : compoundTag.func_150296_c()) {
                jsonObject.add(key, StorageManager.loadJson(compoundTag.func_74781_a(key)));
            }
            return jsonObject;
        }
        if (tag instanceof NBTTagList) {
            NBTTagList listTag = (NBTTagList)tag;
            JsonArray jsonArray = new JsonArray();
            for (int i = 0; i < listTag.func_74745_c(); ++i) {
                jsonArray.add(StorageManager.loadJson(listTag.func_179238_g(i)));
            }
            return jsonArray;
        }
        if (tag instanceof NBTTagIntArray) {
            NBTTagIntArray listTag = (NBTTagIntArray)tag;
            int[] arr = listTag.func_150302_c();
            JsonArray jsonArray = new JsonArray();
            for (int j : arr) {
                jsonArray.add(new JsonPrimitive(j));
            }
            return jsonArray;
        }
        if (tag instanceof NBTTagByteArray) {
            NBTTagByteArray listTag = (NBTTagByteArray)tag;
            byte[] arr = listTag.func_150292_c();
            JsonArray jsonArray = new JsonArray();
            for (byte b : arr) {
                jsonArray.add(new JsonPrimitive(b));
            }
            return jsonArray;
        }
        if (tag instanceof NBTTagShort) {
            return new JsonPrimitive(((NBTTagShort)tag).func_150289_e());
        }
        if (tag instanceof NBTTagInt) {
            return new JsonPrimitive(((NBTTagInt)tag).func_150287_d());
        }
        if (tag instanceof NBTTagLong) {
            return new JsonPrimitive(((NBTTagLong)tag).func_150291_c());
        }
        if (tag instanceof NBTTagFloat) {
            return new JsonPrimitive(Float.valueOf(((NBTTagFloat)tag).func_150288_h()));
        }
        if (tag instanceof NBTTagDouble) {
            return new JsonPrimitive(((NBTTagDouble)tag).func_150286_g());
        }
        if (tag instanceof NBTTagByte) {
            return new JsonPrimitive(((NBTTagByte)tag).func_150290_f());
        }
        if (tag instanceof NBTTagString) {
            return new JsonPrimitive(((NBTTagString)tag).func_150285_a_());
        }
        return new JsonPrimitive("Broken_Json_Deserialize_Tag");
    }

    public static StorageManager getInstance() {
        return INSTANCE;
    }

    public void loadConfig(File file) {
        this.storageConfig = ConfigUtil.loadConfig(StorageConfig.class, file, GSON, true);
        if (this.storageConfig == null) {
            this.storageConfig = new StorageConfig();
        }
    }

    public void saveConfig(File file) {
        ConfigUtil.saveConfig(this.storageConfig, file, GSON, true);
    }

    public ItemStack getMissingBackpackStack(int storageId) {
        ItemStack stack;
        if (this.missingBackpackStacks[storageId] != null) {
            return this.missingBackpackStacks[storageId];
        }
        this.missingBackpackStacks[storageId] = stack = Utils.createItemStack(Item.func_150898_a((Block)Blocks.field_150397_co), "\u00a7eEmpty Backpack Slot " + (storageId + 1), 12, storageId + 1, "", "\u00a7eLeft-click a backpack", "\u00a7eitem on this slot to place", "\u00a7eit!");
        return stack;
    }

    public boolean shouldRenderStorageOverlay(String containerName) {
        this.isStorageOpen = false;
        if (!NotEnoughUpdates.INSTANCE.config.storageGUI.enableStorageGUI3) {
            this.shouldRenderStorageOverlayCached = false;
            return false;
        }
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            this.shouldRenderStorageOverlayCached = false;
            return false;
        }
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiChest)) {
            this.shouldRenderStorageOverlayCached = false;
            return false;
        }
        if (this.getCurrentWindowId() != -1 && this.getCurrentPageId() != -1) {
            this.shouldRenderStorageOverlayCached = true;
            this.isStorageOpen = true;
            return true;
        }
        this.isStorageOpen = this.shouldRenderStorageOverlayCached = containerName != null && containerName.trim().equals("Storage");
        return this.shouldRenderStorageOverlayCached;
    }

    public boolean shouldRenderStorageOverlayFast() {
        return this.shouldRenderStorageOverlayCached;
    }

    private StoragePage[] getPagesForProfile() {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return null;
        }
        if (SBInfo.getInstance().currentProfile == null) {
            return null;
        }
        return this.storageConfig.pages.computeIfAbsent(SBInfo.getInstance().currentProfile, k -> new StoragePage[27]);
    }

    public StoragePage getPage(int pageIndex, boolean createPage) {
        if (pageIndex == -1) {
            return null;
        }
        StoragePage[] pages = this.getPagesForProfile();
        if (pages == null) {
            return null;
        }
        if (createPage && pages[pageIndex] == null) {
            pages[pageIndex] = new StoragePage();
        }
        return pages[pageIndex];
    }

    public void removePage(int pageIndex) {
        if (pageIndex == -1) {
            return;
        }
        StoragePage[] pages = this.getPagesForProfile();
        if (pages == null) {
            return;
        }
        pages[pageIndex] = null;
    }

    public StoragePage getCurrentPage() {
        return this.getPage(this.getCurrentPageId(), true);
    }

    private void setItemSlot(int index, ItemStack item) {
        StoragePage page = this.getCurrentPage();
        if (page != null) {
            page.items[index] = item;
        }
    }

    public int getCurrentPageId() {
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiChest)) {
            this.currentStoragePage = -1;
            return -1;
        }
        return this.currentStoragePage;
    }

    public int getCurrentWindowId() {
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiChest)) {
            this.currentStoragePage = -1;
            return -1;
        }
        GuiChest chest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
        return chest.field_147002_h.field_75152_c;
    }

    public void sendToPage(int page) {
        if (System.currentTimeMillis() - this.storageOpenSwitchMillis < 100L) {
            return;
        }
        if (this.getCurrentPageId() == page) {
            return;
        }
        if (page < MAX_ENDER_CHEST_PAGES) {
            NotEnoughUpdates.INSTANCE.sendChatMessage("/enderchest " + (page + 1));
        } else {
            NotEnoughUpdates.INSTANCE.sendChatMessage("/backpack " + (page + 1 - MAX_ENDER_CHEST_PAGES));
        }
        this.storageOpenSwitchMillis = System.currentTimeMillis();
    }

    public int getDisplayIdForStorageId(int storageId) {
        if (storageId < 0) {
            return -1;
        }
        for (Map.Entry<Integer, Integer> entry : this.storageConfig.displayToStorageIdMap.entrySet()) {
            if (entry.getValue() != storageId) continue;
            return entry.getKey();
        }
        return -1;
    }

    public int getDisplayIdForStorageIdRender(int storageId) {
        if (storageId < 0) {
            return -1;
        }
        for (Map.Entry<Integer, Integer> entry : this.storageConfig.displayToStorageIdMapRender.entrySet()) {
            if (entry.getValue() != storageId) continue;
            return entry.getKey();
        }
        return -1;
    }

    public void openWindowPacket(S2DPacketOpenWindow packet) {
        this.shouldRenderStorageOverlayCached = false;
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return;
        }
        String windowTitle = Utils.cleanColour(packet.func_179840_c().func_150260_c());
        Matcher matcher = WINDOW_REGEX.matcher(windowTitle);
        Matcher matcherEchest = ECHEST_WINDOW_REGEX.matcher(windowTitle);
        this.currentStoragePage = -1;
        this.onStorageMenu = false;
        if (windowTitle.trim().equals("Storage")) {
            this.onStorageMenu = true;
        } else if (matcher.matches()) {
            int page = Integer.parseInt(matcher.group(1));
            if (page > 0 && page <= 18) {
                StoragePage spage;
                this.currentStoragePage = page - 1 + MAX_ENDER_CHEST_PAGES;
                int displayId = this.getDisplayIdForStorageId(this.currentStoragePage);
                if (displayId >= 0) {
                    StorageOverlay.getInstance().scrollToStorage(displayId, false);
                }
                if ((spage = this.getCurrentPage()) != null) {
                    spage.rows = packet.func_148898_f() / 9 - 1;
                }
            }
        } else if (matcherEchest.matches()) {
            int page = Integer.parseInt(matcherEchest.group(1));
            if (page > 0 && page <= 9) {
                StoragePage spage;
                this.currentStoragePage = page - 1;
                int displayId = this.getDisplayIdForStorageId(this.currentStoragePage);
                if (displayId >= 0) {
                    StorageOverlay.getInstance().scrollToStorage(displayId, false);
                }
                if ((spage = this.getCurrentPage()) != null) {
                    spage.rows = packet.func_148898_f() / 9 - 1;
                }
            }
        } else {
            StorageOverlay.getInstance().clearSearch();
            return;
        }
        StorageOverlay.getInstance().fastRenderCheck();
    }

    public void closeWindowPacket(S2EPacketCloseWindow packet) {
        this.shouldRenderStorageOverlayCached = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSlotPacket(S2FPacketSetSlot packet) {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return;
        }
        if (this.getCurrentWindowId() == -1 || this.getCurrentWindowId() != packet.func_149175_c()) {
            return;
        }
        if (this.getCurrentPageId() != -1) {
            StoragePage page = this.getCurrentPage();
            int slot = packet.func_149173_d();
            if (page != null && slot >= 9 && slot < 9 + page.rows * 9) {
                this.setItemSlot(packet.func_149173_d() - 9, packet.func_149174_e());
            }
        } else if (this.onStorageMenu) {
            StoragePage page;
            int i;
            int displayIndex;
            HashMap<Integer, Integer> hashMap;
            boolean changed;
            int index;
            if (this.storagePresent == null) {
                this.storagePresent = new boolean[27];
            }
            int slot = packet.func_149173_d();
            ItemStack stack = packet.func_149174_e();
            if (slot >= 9 && slot < 18) {
                index = slot - 9;
                changed = false;
                if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co) && stack.func_77960_j() == 14 || stack.func_77973_b() == Items.field_151100_aR && stack.func_77960_j() == 8) {
                    if (this.storagePresent[index]) {
                        changed = true;
                    }
                    this.storagePresent[index] = false;
                    this.removePage(index);
                } else {
                    if (!this.storagePresent[index]) {
                        changed = true;
                    }
                    this.storagePresent[index] = true;
                    this.getPage((int)index, (boolean)true).backpackDisplayStack = stack;
                }
                if (changed) {
                    hashMap = this.storageConfig.displayToStorageIdMap;
                    synchronized (hashMap) {
                        this.storageConfig.displayToStorageIdMap.clear();
                        this.storageConfig.displayToStorageIdMapRender.clear();
                        displayIndex = 0;
                        for (i = 0; i < this.storagePresent.length; ++i) {
                            if (!this.storagePresent[i]) continue;
                            this.storageConfig.displayToStorageIdMap.put(displayIndex, i);
                            if (this.lastSearch != null && !this.lastSearch.isEmpty()) {
                                page = this.getPage(i, false);
                                if (page == null) continue;
                                this.updateSearchForPage(this.lastSearch, page);
                                if (!page.matchesSearch) continue;
                                this.storageConfig.displayToStorageIdMapRender.put(displayIndex++, i);
                                continue;
                            }
                            this.storageConfig.displayToStorageIdMapRender.put(displayIndex++, i);
                        }
                    }
                }
            }
            if (slot >= 27 && slot < 45) {
                index = (slot - 27) % 9 + (slot - 27) / 9 * 9 + MAX_ENDER_CHEST_PAGES;
                changed = false;
                if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co) || stack.func_77973_b() == Items.field_151100_aR && stack.func_77960_j() == 8) {
                    if (this.storagePresent[index]) {
                        changed = true;
                    }
                    this.storagePresent[index] = false;
                    this.removePage(index);
                } else {
                    if (!this.storagePresent[index]) {
                        changed = true;
                    }
                    this.storagePresent[index] = true;
                    this.getPage((int)index, (boolean)true).backpackDisplayStack = stack;
                }
                if (changed) {
                    hashMap = this.storageConfig.displayToStorageIdMap;
                    synchronized (hashMap) {
                        this.storageConfig.displayToStorageIdMap.clear();
                        this.storageConfig.displayToStorageIdMapRender.clear();
                        displayIndex = 0;
                        for (i = 0; i < this.storagePresent.length; ++i) {
                            if (!this.storagePresent[i]) continue;
                            this.storageConfig.displayToStorageIdMap.put(displayIndex, i);
                            if (this.lastSearch != null && !this.lastSearch.isEmpty()) {
                                page = this.getPage(i, false);
                                if (page == null) continue;
                                this.updateSearchForPage(this.lastSearch, page);
                                if (!page.matchesSearch) continue;
                                this.storageConfig.displayToStorageIdMapRender.put(displayIndex++, i);
                                continue;
                            }
                            this.storageConfig.displayToStorageIdMapRender.put(displayIndex++, i);
                        }
                    }
                }
            }
        }
    }

    public void updateSearchForPage(String searchStr, StoragePage page) {
        if (page == null) {
            return;
        }
        if (page.rows <= 0) {
            page.matchesSearch = true;
            return;
        }
        if (page.searchedId > this.searchId.get()) {
            page.searchedId = -1;
            return;
        }
        if (page.searchedId == this.searchId.get()) {
            return;
        }
        page.searchedId = this.searchId.get();
        if (searchStr == null || searchStr.trim().isEmpty()) {
            page.matchesSearch = true;
            return;
        }
        for (ItemStack stack : page.items) {
            if (stack == null || !NotEnoughUpdates.INSTANCE.manager.doesStackMatchSearch(stack, searchStr)) continue;
            page.matchesSearch = true;
            return;
        }
        page.matchesSearch = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchDisplay(String searchStr) {
        if (this.storagePresent == null) {
            return;
        }
        HashMap<Integer, Integer> hashMap = this.storageConfig.displayToStorageIdMapRender;
        synchronized (hashMap) {
            this.storageConfig.displayToStorageIdMapRender.clear();
            this.lastSearch = searchStr;
            int sid = this.searchId.incrementAndGet();
            int displayIndex = 0;
            for (int i = 0; i < this.storagePresent.length; ++i) {
                StoragePage page;
                if (!this.storagePresent[i] || (page = this.getPage(i, false)) == null) continue;
                if (page.rows > 0) {
                    this.updateSearchForPage(searchStr, page);
                    if (!page.matchesSearch) continue;
                    this.storageConfig.displayToStorageIdMapRender.put(displayIndex++, i);
                    continue;
                }
                this.storageConfig.displayToStorageIdMapRender.put(displayIndex++, i);
                page.matchesSearch = true;
                page.searchedId = sid;
            }
        }
    }

    public void setItemsPacket(S30PacketWindowItems packet) {
        StoragePage page;
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return;
        }
        if (this.getCurrentWindowId() == -1 || this.getCurrentWindowId() != packet.func_148911_c()) {
            return;
        }
        if (this.getCurrentPageId() != -1 && (page = this.getPage(this.getCurrentPageId(), false)) != null) {
            int max2 = Math.min(page.rows * 9, packet.func_148910_d().length - 9);
            for (int i = 0; i < max2; ++i) {
                this.setItemSlot(i, packet.func_148910_d()[i + 9]);
            }
        }
    }

    public void clientSendWindowClick(C0EPacketClickWindow packet) {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return;
        }
        if (this.getCurrentWindowId() == -1 || this.getCurrentWindowId() != packet.func_149548_c()) {
            return;
        }
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiChest)) {
            return;
        }
        ContainerChest containerChest = (ContainerChest)((GuiChest)Minecraft.func_71410_x().field_71462_r).field_147002_h;
        if (this.getCurrentPageId() != -1) {
            StoragePage page = this.getCurrentPage();
            if (page == null) {
                return;
            }
            IInventory inv = containerChest.func_85151_d();
            int max2 = Math.min(9 + page.rows * 9, inv.func_70302_i_());
            for (int i = 9; i < max2; ++i) {
                this.setItemSlot(i - 9, inv.func_70301_a(i));
            }
        }
    }

    public static class StorageConfig {
        public HashMap<String, StoragePage[]> pages = new HashMap();
        public final HashMap<Integer, Integer> displayToStorageIdMap = new HashMap();
        public final HashMap<Integer, Integer> displayToStorageIdMapRender = new HashMap();
    }

    public static class StoragePage {
        public ItemStack[] items = new ItemStack[45];
        public ItemStack backpackDisplayStack;
        public String customTitle;
        public int rows = -1;
        public boolean[] shouldDarkenIfNotSelected = new boolean[45];
        public transient boolean matchesSearch;
        public transient int searchedId;
    }

    private static class PetInfo {
        String type;
        Boolean active;
        Double exp;
        String tier;
        Boolean hideInfo;
        Integer candyUsed;
        String uuid;
        Boolean hideRightClick;
        String heldItem;
        String skin;

        private PetInfo() {
        }

        private <T> void appendIfNotNull(StringBuilder builder, String key, T value) {
            if (value != null) {
                if (builder.indexOf("{") != builder.length() - 1) {
                    builder.append(",");
                }
                builder.append(key).append(":");
                if (value instanceof String) {
                    builder.append("\"").append(value).append("\"");
                } else {
                    builder.append(value);
                }
            }
        }

        public String toString() {
            StringBuilder object = new StringBuilder();
            object.append("{");
            this.appendIfNotNull(object, "type", this.type);
            this.appendIfNotNull(object, "active", this.active);
            this.appendIfNotNull(object, "exp", this.exp);
            this.appendIfNotNull(object, "tier", this.tier);
            this.appendIfNotNull(object, "hideInfo", this.hideInfo);
            this.appendIfNotNull(object, "candyUsed", this.candyUsed);
            this.appendIfNotNull(object, "uuid", this.uuid);
            this.appendIfNotNull(object, "hideRightClick", this.hideRightClick);
            this.appendIfNotNull(object, "heldItem", this.heldItem);
            this.appendIfNotNull(object, "skin", this.skin);
            object.append("}");
            return object.toString();
        }
    }

    public static class ItemStackDeserializer
    implements JsonDeserializer<ItemStack> {
        @Override
        public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                JsonObject object = json.getAsJsonObject();
                NBTTagCompound tag = JsonToNBT.func_180713_a((String)JSON_FIX_REGEX.matcher(object.toString()).replaceAll("$1:"));
                Item item = tag.func_150297_b("id", 8) ? Item.func_111206_d((String)tag.func_74779_i("id")) : Item.func_150899_d((int)tag.func_74765_d("id"));
                if (item == null) {
                    return null;
                }
                int stackSize = tag.func_74762_e("Count");
                int damage = tag.func_74762_e("Damage");
                ItemStack stack = new ItemStack(item, stackSize, damage);
                if (tag.func_74764_b("tag")) {
                    NBTTagCompound itemTag = tag.func_74775_l("tag");
                    stack.func_77982_d(itemTag);
                }
                return stack;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return null;
            }
        }
    }

    public static class ItemStackSerializer
    implements JsonSerializer<ItemStack> {
        @Override
        public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
            StorageManager.fixPetInfo(src);
            NBTTagCompound tag = src.serializeNBT();
            return StorageManager.nbtToJson(tag);
        }
    }
}

