/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL14;

public class WitherCloakChanger {
    public static boolean isCloakActive = false;
    public static long lastCreeperRender = 0L;
    public static long lastDeactivate = System.currentTimeMillis();
    private static final ResourceLocation witherCloakShield = new ResourceLocation("notenoughupdates:wither_cloak_shield.png");

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChatMessage(ClientChatReceivedEvent event) {
        if (!NotEnoughUpdates.INSTANCE.isOnSkyblock()) {
            return;
        }
        if (event.message.func_150260_c().startsWith("Creeper Veil ")) {
            if (isCloakActive && !event.message.func_150260_c().equals("Creeper Veil Activated!")) {
                isCloakActive = false;
                lastDeactivate = System.currentTimeMillis();
            } else {
                isCloakActive = true;
            }
        } else if (event.message.func_150260_c().startsWith("Not enough mana! Creeper Veil De-activated!")) {
            isCloakActive = false;
            lastDeactivate = System.currentTimeMillis();
        }
    }

    @SubscribeEvent
    public void onWorldChange(WorldEvent.Unload event) {
        isCloakActive = false;
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        if (isCloakActive && System.currentTimeMillis() - lastCreeperRender >= 2000L) {
            isCloakActive = false;
            lastDeactivate = System.currentTimeMillis();
            lastCreeperRender = 0L;
            return;
        }
        if (!(NotEnoughUpdates.INSTANCE.isOnSkyblock() && isCloakActive && NotEnoughUpdates.INSTANCE.config.itemOverlays.customWitherCloakToggle)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        double shieldWidth = 0.8;
        double shieldHeight = 2.0;
        double accuracy = 4.0;
        for (int i = 0; i < NotEnoughUpdates.INSTANCE.config.itemOverlays.customWitherCloakCount; ++i) {
            double angle = (double)((int)((double)(System.currentTimeMillis() / 30L) * NotEnoughUpdates.INSTANCE.config.itemOverlays.customWitherCloakSpeed * -0.5 * 4.0 % 1440.0)) / 4.0;
            angle += 360.0 / (double)NotEnoughUpdates.INSTANCE.config.itemOverlays.customWitherCloakCount * (double)i;
            double posX = mc.field_71439_g.field_70165_t - 0.4;
            double posY = mc.field_71439_g.field_70163_u;
            double posZ = mc.field_71439_g.field_70161_v + (double)NotEnoughUpdates.INSTANCE.config.itemOverlays.customWitherCloakDistance;
            Vec3 topLeft = WitherCloakChanger.rotateAboutOrigin(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70161_v, angle %= 360.0, new Vec3(posX, posY + 2.0, posZ));
            Vec3 topRight = WitherCloakChanger.rotateAboutOrigin(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70161_v, angle, new Vec3(posX + 0.8, posY + 2.0, posZ));
            Vec3 bottomRight = WitherCloakChanger.rotateAboutOrigin(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70161_v, angle, new Vec3(posX + 0.8, posY, posZ));
            Vec3 bottomLeft = WitherCloakChanger.rotateAboutOrigin(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70161_v, angle, new Vec3(posX, posY, posZ));
            RenderUtils.drawFilledQuadWithTexture(topLeft, topRight, bottomRight, bottomLeft, 1.0f, witherCloakShield);
        }
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
    }

    private static Vec3 rotateAboutOrigin(double originX, double originZ, double angle, Vec3 point) {
        double a = angle * Math.PI / 180.0;
        double newX = originX + (Math.cos(a) * (point.field_72450_a - originX) + Math.sin(a) * (point.field_72449_c - originZ));
        double newZ = originZ + (-Math.sin(a) * (point.field_72450_a - originX) + Math.cos(a) * (point.field_72449_c - originZ));
        return new Vec3(newX, point.field_72448_b, newZ);
    }
}

