/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.customblockzones;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscfeatures.customblockzones.CustomBiomes;
import io.github.moulberry.notenoughupdates.miscfeatures.customblockzones.IslandZoneSubdivider;
import io.github.moulberry.notenoughupdates.miscfeatures.customblockzones.SpecialBlockZone;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.ChunkCoordIntPair;

public class DwarvenMinesTextures
implements IslandZoneSubdivider {
    private Set<ChunkCoordIntPair> ignoredChunks = null;
    private final Map<ChunkCoordIntPair, Map<ChunkCoordIntPair, IgnoreColumn>> loadedChunkData = new HashMap<ChunkCoordIntPair, Map<ChunkCoordIntPair, IgnoreColumn>>();
    private boolean error = false;

    private IBlockState getBlock(BlockPos pos) {
        return Minecraft.func_71410_x().field_71441_e.func_180495_p(pos);
    }

    private boolean isDoubleSlab(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150334_T;
    }

    private Reader getUTF8Resource(ResourceLocation location) throws IOException {
        return new BufferedReader(new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(location).func_110527_b(), StandardCharsets.UTF_8));
    }

    private void loadIgnoredChunks() {
        this.ignoredChunks = new HashSet<ChunkCoordIntPair>();
        try (Reader reader = this.getUTF8Resource(new ResourceLocation("notenoughupdates:dwarven_data/all.json"));){
            JsonObject json = NotEnoughUpdates.INSTANCE.manager.gson.fromJson(reader, JsonObject.class);
            for (Map.Entry<String, JsonElement> entry : json.entrySet()) {
                String coord = entry.getKey();
                String[] split = coord.split("_");
                int left = Integer.parseInt(split[0]);
                int right = Integer.parseInt(split[1]);
                this.ignoredChunks.add(new ChunkCoordIntPair(left, right));
            }
        }
        catch (IOException e2) {
            this.ignoredChunks = null;
            this.error = true;
            System.out.println("NEU failed to load dwarven mines ignore chunks: ");
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ChunkCoordIntPair> getIgnoredChunks() {
        if (this.ignoredChunks == null) {
            DwarvenMinesTextures dwarvenMinesTextures = this;
            synchronized (dwarvenMinesTextures) {
                if (this.ignoredChunks != null) {
                    return this.ignoredChunks;
                }
                this.loadIgnoredChunks();
            }
        }
        return this.ignoredChunks;
    }

    private IgnoreColumn parseIgnoreColumn(JsonElement element) {
        JsonArray arr;
        if (element.isJsonPrimitive()) {
            JsonPrimitive prim = element.getAsJsonPrimitive();
            if (prim.isBoolean()) {
                return new IgnoreColumn(true, 0, 0);
            }
            if (prim.isNumber()) {
                int y = prim.getAsInt();
                return new IgnoreColumn(false, y, y);
            }
        }
        if (element.isJsonArray() && (arr = element.getAsJsonArray()).size() == 2) {
            int min2 = arr.get(0).getAsInt();
            int max2 = arr.get(1).getAsInt();
            return new IgnoreColumn(false, min2, max2);
        }
        return null;
    }

    private Map<ChunkCoordIntPair, IgnoreColumn> loadChunkData(ChunkCoordIntPair pair) {
        HashMap<ChunkCoordIntPair, IgnoreColumn> map2 = new HashMap<ChunkCoordIntPair, IgnoreColumn>();
        try {
            ResourceLocation loc = new ResourceLocation("notenoughupdates:dwarven_data/" + pair.field_77276_a + "_" + pair.field_77275_b + ".json");
            try (Reader reader = this.getUTF8Resource(loc);){
                JsonObject json = NotEnoughUpdates.INSTANCE.manager.gson.fromJson(reader, JsonObject.class);
                for (Map.Entry<String, JsonElement> entry : json.entrySet()) {
                    String coord = entry.getKey();
                    String[] split = coord.split(":");
                    int left = Integer.parseInt(split[0]);
                    int right = Integer.parseInt(split[1]);
                    IgnoreColumn ignore = this.parseIgnoreColumn(entry.getValue());
                    if (ignore == null) continue;
                    ChunkCoordIntPair offset = new ChunkCoordIntPair(left, right);
                    map2.put(offset, ignore);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ChunkCoordIntPair, IgnoreColumn> getChunkData(ChunkCoordIntPair chunkCoordinates) {
        DwarvenMinesTextures dwarvenMinesTextures = this;
        synchronized (dwarvenMinesTextures) {
            return this.loadedChunkData.computeIfAbsent(chunkCoordinates, this::loadChunkData);
        }
    }

    @Override
    public SpecialBlockZone getSpecialZoneForBlock(String location, BlockPos pos) {
        ChunkCoordIntPair subChunkCoordinates;
        IgnoreColumn ignore;
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(130.0, -50.0, 185.0, -130.0, 180.0, 480.0);
        if (axisAlignedBB.func_72318_a(new Vec3((Vec3i)pos))) {
            return SpecialBlockZone.GLACITE_TUNNELS;
        }
        if (this.error) {
            return null;
        }
        IBlockState block = this.getBlock(pos);
        boolean isTitanium = CustomBiomes.isTitanium(block);
        boolean isMithril = CustomBiomes.isMithril(block);
        if (isTitanium) {
            for (EnumFacing direction : EnumFacing.values()) {
                if (!this.isDoubleSlab(this.getBlock(pos.func_177972_a(direction)))) continue;
                return SpecialBlockZone.DWARVEN_MINES_NON_MITHRIL;
            }
        }
        if (!isMithril && !isTitanium) {
            return SpecialBlockZone.DWARVEN_MINES_NON_MITHRIL;
        }
        Set<ChunkCoordIntPair> ignoredChunks = this.getIgnoredChunks();
        if (ignoredChunks == null) {
            return null;
        }
        ChunkCoordIntPair pair = new ChunkCoordIntPair(MathHelper.func_76141_d((float)((float)pos.func_177958_n() / 16.0f)), MathHelper.func_76141_d((float)((float)pos.func_177952_p() / 16.0f)));
        if (ignoredChunks.contains(pair)) {
            return SpecialBlockZone.DWARVEN_MINES_NON_MITHRIL;
        }
        if (isTitanium) {
            return SpecialBlockZone.DWARVEN_MINES_MITHRIL;
        }
        Map<ChunkCoordIntPair, IgnoreColumn> chunkData = this.getChunkData(pair);
        if (chunkData == null || this.error) {
            return null;
        }
        int modX = pos.func_177958_n() % 16;
        int modZ = pos.func_177952_p() % 16;
        if (modX < 0) {
            modX += 16;
        }
        if (modZ < 0) {
            modZ += 16;
        }
        if ((ignore = chunkData.get(subChunkCoordinates = new ChunkCoordIntPair(modX, modZ))) != null) {
            if (ignore.always) {
                return SpecialBlockZone.DWARVEN_MINES_NON_MITHRIL;
            }
            int y = pos.func_177956_o();
            if (ignore.minY <= y && y <= ignore.maxY) {
                return SpecialBlockZone.DWARVEN_MINES_NON_MITHRIL;
            }
        }
        return SpecialBlockZone.DWARVEN_MINES_MITHRIL;
    }

    private static class IgnoreColumn {
        boolean always;
        int minY;
        int maxY;

        public IgnoreColumn(boolean always, int minY, int maxY) {
            this.always = always;
            this.minY = minY;
            this.maxY = maxY;
        }
    }
}

