/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.item.enchants;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscgui.GuiEnchantColour;
import io.github.moulberry.notenoughupdates.util.LRUCache;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.util.EnumChatFormatting;

public final class EnchantMatcher {
    public static final String GROUP_ENCHANT_NAME = "enchantName";
    public static final String GROUP_LEVEL = "level";
    private static final String romanNumerals = "(I|II|III|IV|V|VI|VII|VIII|IX|X|XI|XII|XIII|XIV|XV|XVI|XVII|XVIII|XIX|XX)";
    private static final Supplier<String> validColors = Suppliers.memoize(() -> "0123456789abcdefzZ");
    public static LRUCache<String, Optional<EnchantMatcher>> fromSaveFormatMemoized = LRUCache.memoize(EnchantMatcher::fromSaveFormat, () -> NotEnoughUpdates.INSTANCE.config.hidden.enchantColours.size() + 1);
    private final Pattern patternWithLevels;
    private final int compareWith;
    private final String formatting;
    private final char compareUsing;

    @Deprecated
    public static Optional<EnchantMatcher> fromSaveFormat(String saveFormat) {
        Pattern patternWithLevels;
        int compareWith;
        List colourOps = GuiEnchantColour.splitter.splitToList((CharSequence)saveFormat);
        String enchantName = GuiEnchantColour.getColourOpIndex(colourOps, 0);
        String comparator = GuiEnchantColour.getColourOpIndex(colourOps, 1);
        String comparison = GuiEnchantColour.getColourOpIndex(colourOps, 2);
        String colourCode = GuiEnchantColour.getColourOpIndex(colourOps, 3);
        String modifier = GuiEnchantColour.getColourOpIndex(colourOps, 4);
        int intModifier = GuiEnchantColour.getIntModifier(modifier);
        if (comparator.length() != 1 || colourCode.length() != 1 || comparison.isEmpty() || enchantName.isEmpty()) {
            return Optional.empty();
        }
        if (!">=<".contains(comparator)) {
            return Optional.empty();
        }
        try {
            compareWith = Integer.parseInt(comparison);
        }
        catch (NumberFormatException e2) {
            return Optional.empty();
        }
        if (!((String)validColors.get()).contains(colourCode)) {
            return Optional.empty();
        }
        try {
            patternWithLevels = Pattern.compile("(\u00a7b|\u00a79|\u00a7([b9l])\u00a7d\u00a7l)(?<enchantName>" + enchantName + ") (?<" + GROUP_LEVEL + ">\\d+|" + romanNumerals + ")(?:(?:\u00a79)?,|(?: \u00a78(?:,?[0-9]+)*)?$)");
        }
        catch (PatternSyntaxException e3) {
            NotEnoughUpdates.LOGGER.warn("Invalid pattern constructed for enchant matching", (Throwable)e3);
            return Optional.empty();
        }
        String formatting = "\u00a7" + colourCode;
        if ((intModifier & GuiEnchantColour.BOLD_MODIFIER) != 0) {
            formatting = formatting + EnumChatFormatting.BOLD;
        }
        if ((intModifier & GuiEnchantColour.ITALIC_MODIFIER) != 0) {
            formatting = formatting + EnumChatFormatting.ITALIC;
        }
        if ((intModifier & GuiEnchantColour.UNDERLINE_MODIFIER) != 0) {
            formatting = formatting + EnumChatFormatting.UNDERLINE;
        }
        if ((intModifier & GuiEnchantColour.OBFUSCATED_MODIFIER) != 0) {
            formatting = formatting + EnumChatFormatting.OBFUSCATED;
        }
        if ((intModifier & GuiEnchantColour.STRIKETHROUGH_MODIFIER) != 0) {
            formatting = formatting + EnumChatFormatting.STRIKETHROUGH;
        }
        return Optional.of(new EnchantMatcher(patternWithLevels, compareWith, formatting, comparator.charAt(0)));
    }

    public boolean doesLevelMatch(int level) {
        switch (this.compareUsing) {
            case '>': {
                return level > this.compareWith;
            }
            case '=': {
                return level == this.compareWith;
            }
            case '<': {
                return level < this.compareWith;
            }
        }
        return false;
    }

    public EnchantMatcher(Pattern patternWithLevels, int compareWith, String formatting, char compareUsing) {
        this.patternWithLevels = patternWithLevels;
        this.compareWith = compareWith;
        this.formatting = formatting;
        this.compareUsing = compareUsing;
    }

    public Pattern getPatternWithLevels() {
        return this.patternWithLevels;
    }

    public int getCompareWith() {
        return this.compareWith;
    }

    public String getFormatting() {
        return this.formatting;
    }

    public char getCompareUsing() {
        return this.compareUsing;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnchantMatcher)) {
            return false;
        }
        EnchantMatcher other = (EnchantMatcher)o;
        if (this.getCompareWith() != other.getCompareWith()) {
            return false;
        }
        if (this.getCompareUsing() != other.getCompareUsing()) {
            return false;
        }
        Pattern this$patternWithLevels = this.getPatternWithLevels();
        Pattern other$patternWithLevels = other.getPatternWithLevels();
        if (this$patternWithLevels == null ? other$patternWithLevels != null : !this$patternWithLevels.equals(other$patternWithLevels)) {
            return false;
        }
        String this$formatting = this.getFormatting();
        String other$formatting = other.getFormatting();
        return !(this$formatting == null ? other$formatting != null : !this$formatting.equals(other$formatting));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + this.getCompareWith();
        result2 = result2 * 59 + this.getCompareUsing();
        Pattern $patternWithLevels = this.getPatternWithLevels();
        result2 = result2 * 59 + ($patternWithLevels == null ? 43 : $patternWithLevels.hashCode());
        String $formatting = this.getFormatting();
        result2 = result2 * 59 + ($formatting == null ? 43 : $formatting.hashCode());
        return result2;
    }

    public String toString() {
        return "EnchantMatcher(patternWithLevels=" + this.getPatternWithLevels() + ", compareWith=" + this.getCompareWith() + ", formatting=" + this.getFormatting() + ", compareUsing=" + this.getCompareUsing() + ")";
    }
}

