/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.BackgroundBlur;
import io.github.moulberry.notenoughupdates.events.RepositoryReloadEvent;
import io.github.moulberry.notenoughupdates.util.GuiTextures;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.JsonUtils;
import io.github.moulberry.notenoughupdates.util.SkyBlockTime;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class CalendarOverlay {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("notenoughupdates:calendar/background.png");
    private static final ResourceLocation DISPLAYBAR = new ResourceLocation("notenoughupdates:calendar/displaybar.png");
    private static final ResourceLocation TOAST = new ResourceLocation("notenoughupdates:calendar/toast.png");
    private static JsonObject farmingEventTypes = null;
    private static boolean enabled = false;
    private boolean isTimerRendered = false;
    long thunderStormEpoch = 1692826500000L;
    long oringoEpoch = 1583153700000L;
    long oringoInterval = 223200000L;
    long rainInterval = 3600000L;
    long thunderFrequency = 3L;
    long rainDuration = 1200000L;
    List<Pair<Long, SBEvent>> externalEvents = new ArrayList<Pair<Long, SBEvent>>();
    private int guiLeft = -1;
    private int guiTop = -1;
    private int xSize = 168;
    private int ySize = 170;
    private static final Pattern CALENDAR_PATTERN = Pattern.compile("((?:Early |Late )?(?:Spring|Summer|Fall|Winter)), Year ([0-9]+)");
    private int jingleIndex = -1;
    private final TreeMap<Long, Set<SBEvent>> eventMap = new TreeMap();
    private List<String> jfFavouriteSelect = null;
    private int jfFavouriteSelectIndex = 0;
    private int jfFavouriteSelectX = 0;
    private int jfFavouriteSelectY = 0;
    List<Tuple<Long, SBEvent>> specialEvents = new ArrayList<Tuple<Long, SBEvent>>();
    private boolean drawTimerForeground = false;
    private static long spookyStart = 0L;
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long DA_OFFSET = 3300000L;
    private static final long JF_OFFSET = 900000L;
    private static final ItemStack DA_STACK;
    private static final ItemStack JF_STACK;
    private static final ItemStack STAR_CULT_STACK;
    private static final long SKYBLOCK_START = 1559829300000L;
    String[] oringoPets = new String[]{"\u00a76Elephant", "\u00a76Giraffe", "\u00a76Blue Whale", "\u00a76Tiger", "\u00a76Lion", "\u00a76Monkey"};

    public static void setEnabled(boolean enabled) {
        CalendarOverlay.enabled = enabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public long getTimeOffset(String time) {
        long offset = 0L;
        StringBuilder numS = new StringBuilder();
        block8: for (int timeIndex = 0; timeIndex < time.length(); ++timeIndex) {
            char c = time.charAt(timeIndex);
            if (c >= '0' && c <= '9') {
                numS.append(c);
                continue;
            }
            try {
                int num = Integer.parseInt(numS.toString());
                switch (c) {
                    case 'd': {
                        offset += (long)num * 86400000L;
                        continue block8;
                    }
                    case 'h': {
                        offset += (long)num * 3600000L;
                        continue block8;
                    }
                    case 'm': {
                        offset += (long)num * 60000L;
                        continue block8;
                    }
                    case 's': {
                        offset += (long)num * 1000L;
                        continue block8;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            numS = new StringBuilder();
        }
        return offset;
    }

    public void handleJinglePlayer() {
        if (this.jingleIndex == 0) {
            if (NotEnoughUpdates.INSTANCE.config.calendar.eventNotificationSounds) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147673_a((ResourceLocation)new ResourceLocation("notenoughupdates:calendar_notif_jingle")));
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147673_a((ResourceLocation)new ResourceLocation("notenoughupdates:calendar_notif_in")));
            }
            this.jingleIndex = -300;
        } else if (this.jingleIndex >= 1) {
            if (NotEnoughUpdates.INSTANCE.config.calendar.eventNotificationSounds) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147673_a((ResourceLocation)new ResourceLocation("notenoughupdates:calendar_notif_in")));
            }
            this.jingleIndex = -300;
        } else if (this.jingleIndex < -1) {
            ++this.jingleIndex;
        }
        if (this.jingleIndex == -130 && NotEnoughUpdates.INSTANCE.config.calendar.eventNotificationSounds) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147673_a((ResourceLocation)new ResourceLocation("notenoughupdates:calendar_notif_out")));
        }
    }

    public Set<SBEvent> getEventsAt(long timestamp) {
        return this.eventMap.computeIfAbsent(timestamp, k -> new TreeSet());
    }

    JsonObject getFarmingEventTypes() {
        if (farmingEventTypes == null && (farmingEventTypes = NotEnoughUpdates.INSTANCE.manager.getJsonFromFile(new File(NotEnoughUpdates.INSTANCE.manager.configLocation, "farmingEventTypes.json"))) == null) {
            farmingEventTypes = new JsonObject();
        }
        return farmingEventTypes;
    }

    public void fillRepeatingEvents(int nextHours) {
        long currentTime = System.currentTimeMillis();
        long floorHour = currentTime / 3600000L * 3600000L;
        for (int i = 0; i < nextHours; ++i) {
            long daEvent = floorHour + (long)i * 3600000L + 3300000L;
            long jfEvent = floorHour + (long)i * 3600000L + 900000L;
            if (daEvent > currentTime) {
                this.getEventsAt(daEvent).add(new SBEvent("dark_auction", EnumChatFormatting.DARK_PURPLE + "Dark Auction", false, DA_STACK, null, 300000L));
            }
            if (jfEvent <= currentTime) continue;
            SBEvent jf = new SBEvent("jacob_farming", EnumChatFormatting.YELLOW + "Jacob's Farming Contest", false, JF_STACK, null, 1200000L);
            if (farmingEventTypes != null && farmingEventTypes.has("" + jfEvent) && farmingEventTypes.get("" + jfEvent).isJsonArray()) {
                JsonArray arr = farmingEventTypes.get("" + jfEvent).getAsJsonArray();
                jf.desc = new ArrayList<String>();
                for (JsonElement e2 : arr) {
                    jf.desc.add(EnumChatFormatting.YELLOW + "\u25cb " + e2.getAsString());
                    jf.id = jf.id + ":" + e2.getAsString();
                }
            }
            this.getEventsAt(jfEvent).add(jf);
        }
    }

    public void populateDefaultEvents() {
        if (this.eventMap.size() <= 20) {
            this.fillRepeatingEvents(25 - this.eventMap.size());
            this.fillSpecialMayors(4);
            this.fillWeather();
            this.fillRepoMandatedEvents();
            this.fillStarCult();
        }
    }

    public void fillRepoMandatedEvents() {
        for (Pair<Long, SBEvent> externalEvent : this.externalEvents) {
            this.addEvent(SkyBlockTime.Companion.fromInstant(Instant.ofEpochMilli((Long)externalEvent.component1())), (SBEvent)externalEvent.component2());
        }
    }

    public void fillStarCult() {
        SkyBlockTime now = SkyBlockTime.now();
        long STAR_CULT_DURATION = 360000L;
        ArrayList<SkyBlockTime> allTimes = new ArrayList<SkyBlockTime>();
        allTimes.add(new SkyBlockTime(now.getYear() - 1, 12, 28, 0, 0, 0));
        for (int i = 1; i <= 12; ++i) {
            for (int d = 7; d < 30; d += 7) {
                allTimes.add(new SkyBlockTime(now.getYear(), i, d, 0, 0, 0));
            }
        }
        for (SkyBlockTime allTime : allTimes) {
            this.addEvent(allTime, new SBEvent("starcult", "\u00a73Cult of the Fallen Star", false, STAR_CULT_STACK, Arrays.asList("\u00a73The Cult of the Fallen Star meets then.", "\u00a73Attending may give a reward.", "\u00a73You can find them near the Star in the Dwarven Mines."), STAR_CULT_DURATION, true));
        }
    }

    private void fillWeather() {
        long currentTime = System.currentTimeMillis();
        long timeSinceLastThunderStart = (currentTime - this.thunderStormEpoch) % (this.rainInterval * this.thunderFrequency);
        long lastThunderStart = currentTime - timeSinceLastThunderStart;
        for (int i = 0; i < 11; ++i) {
            long eventTimer = lastThunderStart + this.rainInterval * (long)i;
            if ((long)i % this.thunderFrequency == 0L) {
                this.addEvent(SkyBlockTime.Companion.fromInstant(Instant.ofEpochMilli(eventTimer)), new SBEvent("spiders_den_thunder", "\u00a79Spider's Den Thunder", true, new ItemStack(Blocks.field_180399_cE), Arrays.asList("\u00a7aIt will rain in the Spider's Den", "\u00a7aand Toxic Rain Slimes will spawn"), this.rainDuration, true));
                continue;
            }
            this.addEvent(SkyBlockTime.Companion.fromInstant(Instant.ofEpochMilli(eventTimer)), new SBEvent("spiders_den_rain", "\u00a79Spider's Den Rain", false, new ItemStack(Items.field_151123_aH), Arrays.asList("\u00a7aIt will rain in the Spider's Den", "\u00a7aand Rain Slimes will spawn"), this.rainDuration, true));
        }
    }

    public String getZooPet(long startTime) {
        long time = startTime - this.oringoEpoch;
        return "\u00a77Pet available: " + this.oringoPets[(int)(time / this.oringoInterval % 6L)];
    }

    @SubscribeEvent
    public void tick(RepositoryReloadEvent event) {
        JsonObject calendarJson = NotEnoughUpdates.INSTANCE.manager.getJsonFromFile(new File(event.getRepositoryRoot(), "constants/calendar.json"));
        if (calendarJson == null) {
            return;
        }
        if (calendarJson.has("thunderEpochStart")) {
            this.thunderStormEpoch = calendarJson.get("thunderEpochStart").getAsLong();
        }
        if (calendarJson.has("rainInterval")) {
            this.rainInterval = calendarJson.get("rainInterval").getAsLong();
        }
        if (calendarJson.has("thunderFrequency")) {
            this.thunderFrequency = calendarJson.get("thunderFrequency").getAsLong();
        }
        if (calendarJson.has("rainDuration")) {
            this.rainDuration = calendarJson.get("rainDuration").getAsLong();
        }
        if (calendarJson.has("external")) {
            ArrayList<Pair<Long, SBEvent>> externalEvents = new ArrayList<Pair<Long, SBEvent>>();
            for (JsonElement external : calendarJson.getAsJsonArray("external")) {
                if (!(external instanceof JsonObject)) continue;
                SBEvent sbEvent = new SBEvent(Utils.getElementAsString(Utils.getElement(external, "id"), "external"), Utils.getElementAsString(Utils.getElement(external, "display"), "\u00a7aExternal Event"), Utils.getElementAsBool(Utils.getElement(external, "special"), false), NotEnoughUpdates.INSTANCE.manager.createItem(Utils.getElementAsString(Utils.getElement(external, "itemStack"), "painting")), JsonUtils.getJsonArrayOrEmpty((JsonObject)external, "description", it -> Utils.getElementAsString(it, "")), Utils.getElementAsInt(Utils.getElement(external, "duration"), -1), true);
                long start = Utils.getElementAsLong(Utils.getElement(external, "start"), 0L);
                externalEvents.add((Pair<Long, SBEvent>)new Pair((Object)start, (Object)sbEvent));
            }
            this.externalEvents = externalEvents;
        }
        this.eventMap.clear();
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        this.handleJinglePlayer();
        this.getFarmingEventTypes();
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiChest)) {
            this.jfFavouriteSelect = null;
            this.populateDefaultEvents();
            return;
        }
        GuiChest eventGui = (GuiChest)Minecraft.func_71410_x().field_71462_r;
        ContainerChest cc = (ContainerChest)eventGui.field_147002_h;
        String containerName = cc.func_85151_d().func_145748_c_().func_150260_c();
        Matcher matcher = CALENDAR_PATTERN.matcher(Utils.cleanColour(containerName));
        if (farmingEventTypes != null && matcher.matches()) {
            this.scrapeMonthlyCalendar(matcher, cc);
        }
        if (!enabled) {
            this.jfFavouriteSelect = null;
            this.populateDefaultEvents();
            return;
        }
        if (!containerName.trim().equals("Calendar and Events")) {
            CalendarOverlay.setEnabled(false);
            return;
        }
        this.eventMap.clear();
        this.populateDefaultEvents();
        this.scrapeOverviewPage(cc);
    }

    public void addEvent(SkyBlockTime time, SBEvent event) {
        if (time.toInstant().isBefore(Instant.now()) && time.toInstant().plus(event.lastsFor, ChronoUnit.MILLIS).isBefore(Instant.now())) {
            return;
        }
        this.getEventsAt(time.toMillis()).add(event);
    }

    private void fillSpecialMayors(int cycles) {
        int currentYear = SkyBlockTime.now().getYear();
        int baseYear = currentYear - currentYear % 24;
        int scorpiusOffset = 0;
        int derpyOffset = 8;
        int jerryOffset = 16;
        for (int i = 0; i < cycles; ++i) {
            int thisBaseYear = baseYear + i * 24 + 1;
            this.addEvent(new SkyBlockTime(thisBaseYear + scorpiusOffset, 3, 27, 0, 0, 0), new SBEvent("special_mayor:scorpius", "\u00a7dScorpius' Candidacy", true, Utils.createSkull("Scorpius", "ba2cd37d-a0e4-4dc5-b15c-d79ee1051aae", "ewogICJ0aW1lc3RhbXAiIDogMTU5Nzc4MTc1NzIxOSwKICAicHJvZmlsZUlkIiA6ICI0MWQzYWJjMmQ3NDk0MDBjOTA5MGQ1NDM0ZDAzODMxYiIsCiAgInByb2ZpbGVOYW1lIiA6ICJNZWdha2xvb24iLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOGYyNmZhMGM0NzUzNmU3OGUzMzcyNTdkODk4YWY4YjFlYmM4N2MwODk0NTAzMzc1MjM0MDM1ZmYyYzdlZjhmMCIKICAgIH0KICB9Cn0"), Arrays.asList("\u00a7eScorpius becomes a special Mayor candidate"), -1L, true));
            this.addEvent(new SkyBlockTime(thisBaseYear + derpyOffset, 3, 27, 0, 0, 0), new SBEvent("special_mayor:derpy", "\u00a7dDerpy's Candidacy", true, Utils.createSkull("Derpy", "ab36a707-96d3-3db1-ab36-a70796d3adb1", "e3RleHR1cmVzOntTS0lOOnt1cmw6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjQ1MGQxMjY5Mjg4NmM0N2IwNzhhMzhmNGQ0OTJhY2ZlNjEyMTZlMmQwMjM3YWI4MjQzMzQwOWIzMDQ2YjQ2NCJ9fX0"), Arrays.asList("\u00a7eDerpy becomes a special Mayor candidate"), -1L, true));
            this.addEvent(new SkyBlockTime(thisBaseYear + jerryOffset, 3, 27, 0, 0, 0), new SBEvent("special_mayor:jerry", "\u00a7dJerry's Candidacy", true, Utils.createSkull("Jerry", "0a9e8efb-9191-4c81-80f5-e27ca5433156", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODIyZDhlNzUxYzhmMmZkNGM4OTQyYzQ0YmRiMmY1Y2E0ZDhhZThlNTc1ZWQzZWIzNGMxOGE4NmU5M2IifX19"), Arrays.asList("\u00a7eJerry becomes a special Mayor candidate"), -1L, true));
        }
    }

    private void scrapeOverviewPage(ContainerChest cc) {
        long currentTime = System.currentTimeMillis();
        String lastsForText = EnumChatFormatting.GRAY + "Event lasts for " + EnumChatFormatting.YELLOW;
        String startsInText = EnumChatFormatting.GRAY + "Starts in: " + EnumChatFormatting.YELLOW;
        for (int i = 0; i < 21; ++i) {
            String first;
            List<String> lore;
            int itemIndex = 10 + i + i / 7 * 2;
            ItemStack item = cc.func_85151_d().func_70301_a(itemIndex);
            if (item == null || (lore = ItemUtils.getLore(item)).isEmpty() || !(first = lore.get(0)).startsWith(startsInText)) continue;
            boolean zoo = false;
            if (item.func_82837_s()) {
                zoo = item.func_82833_r().equals("\u00a7aTraveling Zoo");
            }
            String time = Utils.cleanColour(first.substring(startsInText.length()));
            long eventTime = currentTime + this.getTimeOffset(time);
            long lastsFor = -1L;
            ArrayList<String> desc = new ArrayList<String>();
            boolean foundBreak = false;
            for (String line : lore) {
                if (foundBreak) {
                    desc.add(line);
                    continue;
                }
                if (line.startsWith(lastsForText)) {
                    String lastsForS = Utils.cleanColour(line.substring(lastsForText.length()));
                    lastsFor = this.getTimeOffset(lastsForS);
                }
                if (!Utils.cleanColour(line).trim().isEmpty()) continue;
                foundBreak = true;
            }
            if (zoo) {
                desc.add("");
                desc.add(this.getZooPet(eventTime));
            }
            this.getEventsAt(eventTime).add(new SBEvent(CalendarOverlay.getIdForDisplayName(item.func_82833_r()), item.func_82833_r(), true, item, desc, lastsFor));
        }
    }

    private void scrapeMonthlyCalendar(Matcher matcher, ContainerChest cc) {
        try {
            int year = Integer.parseInt(matcher.group(2));
            String month = matcher.group(1);
            boolean changed = false;
            for (int i = 0; i < 31; ++i) {
                SkyBlockTime sbt;
                ItemStack item = cc.func_85151_d().func_70301_a(1 + i % 7 + i / 7 * 9);
                if (item == null || (sbt = SkyBlockTime.Companion.fromDayMonthYear(i + 1, month, year)) == null) continue;
                JsonArray array = new JsonArray();
                for (String line : ItemUtils.getLore(item)) {
                    if (!line.startsWith("\u00a7e\u25cb") && !line.startsWith("\u00a76\u2618")) continue;
                    array.add(new JsonPrimitive(Utils.cleanColour(line.substring(4))));
                }
                if (array.size() != 3) continue;
                String prop = String.valueOf(sbt.toMillis());
                changed |= !farmingEventTypes.has(prop) || !farmingEventTypes.get(prop).isJsonArray() || farmingEventTypes.get(prop).getAsJsonArray().equals(array);
                farmingEventTypes.add(prop, array);
            }
            if (changed) {
                File f = new File(NotEnoughUpdates.INSTANCE.manager.configLocation, "farmingEventTypes.json");
                NotEnoughUpdates.INSTANCE.manager.writeJson(farmingEventTypes, f);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onGuiDraw(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiChest)) {
            return;
        }
        if (!enabled) {
            return;
        }
        GuiChest eventGui = (GuiChest)Minecraft.func_71410_x().field_71462_r;
        ContainerChest cc = (ContainerChest)eventGui.field_147002_h;
        String containerName = cc.func_85151_d().func_145748_c_().func_150260_c();
        if (!containerName.trim().equals("Calendar and Events")) {
            CalendarOverlay.setEnabled(false);
            return;
        }
        event.setCanceled(true);
        ArrayList<String> tooltipToDisplay = null;
        int mouseX = event.mouseX;
        int mouseY = event.mouseY;
        long currentTime = System.currentTimeMillis();
        this.xSize = 168;
        this.ySize = 170;
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        this.guiLeft = (width - this.xSize) / 2;
        this.guiTop = (height - this.ySize) / 2;
        Utils.drawGradientRect(0, 0, width, height, -1072689136, -804253680);
        this.renderBlurredBackground(10.0f, width, height, this.guiLeft + 3, this.guiTop + 3, 162, 14);
        this.renderBlurredBackground(10.0f, width, height, this.guiLeft + 3, this.guiTop + 26, 14, 141);
        this.renderBlurredBackground(10.0f, width, height, this.guiLeft + 151, this.guiTop + 26, 14, 141);
        this.renderBlurredBackground(10.0f, width, height, this.guiLeft + 26, this.guiTop + 26, 116, 141);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
        Utils.drawTexturedRect(this.guiLeft, this.guiTop, this.xSize, this.ySize, 9728);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)10.0f);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        fr.func_78276_b("Daily", this.guiLeft + 29, this.guiTop + 30, -22016);
        int specialLen = fr.func_78256_a("Special");
        fr.func_78276_b("Special", this.guiLeft + 139 - specialLen, this.guiTop + 30, -22016);
        ItemStack mayorStack = cc.func_85151_d().func_70301_a(37);
        if (mayorStack != null) {
            String mayor = mayorStack.func_82833_r();
            float verticalHeight = Utils.getVerticalHeight(mayor);
            Utils.drawStringVertical(mayor, this.guiLeft + 8, (float)(this.guiTop + 96) - verticalHeight / 2.0f, false, -1);
        }
        String calendar = EnumChatFormatting.GREEN + "Calendar";
        float calendarHeight = Utils.getVerticalHeight(calendar);
        Utils.drawStringVertical(calendar, this.guiLeft + this.xSize - 12, (float)(this.guiTop + 60) - calendarHeight / 2.0f, false, -1);
        String rewards = EnumChatFormatting.GOLD + "Rewards";
        float rewardsHeight = Utils.getVerticalHeight(rewards);
        Utils.drawStringVertical(rewards, this.guiLeft + this.xSize - 12, (float)(this.guiTop + 132) - rewardsHeight / 2.0f, false, -1);
        if (mouseY >= this.guiTop + 26 && mouseY <= this.guiTop + 26 + 141) {
            if (mouseX >= this.guiLeft + 3 && mouseX <= this.guiLeft + 3 + 14) {
                if (mayorStack != null) {
                    tooltipToDisplay = mayorStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
                }
            } else if (mouseX >= this.guiLeft + 151 && mouseX <= this.guiLeft + 151 + 14) {
                if (mouseY <= this.guiTop + 26 + 70) {
                    ItemStack calendarStack = cc.func_85151_d().func_70301_a(41);
                    if (calendarStack != null) {
                        tooltipToDisplay = calendarStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
                    }
                } else {
                    ItemStack rewardsStack = cc.func_85151_d().func_70301_a(36);
                    if (rewardsStack != null) {
                        tooltipToDisplay = rewardsStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
                    }
                }
            }
        }
        long timeUntilNext = 0L;
        SBEvent nextEvent = null;
        long timeUntilFirst = 0L;
        SBEvent firstEvent = null;
        ArrayList<String> eventFavourites = NotEnoughUpdates.INSTANCE.config.hidden.eventFavourites;
        int index = 0;
        block0: for (Map.Entry<Long, Set<SBEvent>> sbEvents : this.eventMap.entrySet()) {
            for (SBEvent sbEvent : sbEvents.getValue()) {
                long timeUntilMillis = sbEvents.getKey() - currentTime;
                int x = this.guiLeft + 29 + 17 * (index % 3);
                int y = this.guiTop + 44 + 17 * (index / 3);
                if (sbEvent.id.equals("spooky_festival") && sbEvents.getKey() > currentTime - 3600000L && (sbEvents.getKey() < spookyStart || spookyStart == 0L)) {
                    spookyStart = sbEvents.getKey();
                }
                if (index >= 21) {
                    if (nextEvent != null) continue block0;
                    if (eventFavourites.isEmpty()) {
                        nextEvent = sbEvent;
                        timeUntilNext = timeUntilMillis;
                        continue;
                    }
                    if (!eventFavourites.contains(sbEvent.id)) continue;
                    nextEvent = sbEvent;
                    timeUntilNext = timeUntilMillis;
                    continue;
                }
                if (firstEvent == null) {
                    firstEvent = sbEvent;
                    timeUntilFirst = timeUntilMillis;
                }
                String[] split = sbEvent.id.split(":");
                boolean containsId = false;
                for (int i = 1; i < split.length; ++i) {
                    if (!eventFavourites.contains(split[0] + ":" + split[i])) continue;
                    containsId = true;
                    break;
                }
                if (eventFavourites.isEmpty()) {
                    if (nextEvent == null) {
                        nextEvent = sbEvent;
                        timeUntilNext = timeUntilMillis;
                    }
                } else if (eventFavourites.contains(split[0]) || containsId) {
                    if (nextEvent == null) {
                        nextEvent = sbEvent;
                        timeUntilNext = timeUntilMillis;
                    }
                    GlStateManager.func_179132_a((boolean)false);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2.0f);
                    Gui.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)-805322935);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0f);
                    GlStateManager.func_179132_a((boolean)true);
                }
                Utils.drawItemStackWithText(sbEvent.stack, x, y, "" + (index + 1));
                if (mouseX >= x && mouseX <= x + 16 && mouseY >= y && mouseY <= y + 16) {
                    tooltipToDisplay = Utils.createList(sbEvent.display, EnumChatFormatting.GRAY + "Starts in: " + EnumChatFormatting.YELLOW + this.prettyTime(timeUntilMillis, false));
                    if (!this.prettyTime(timeUntilMillis, false).equals("Now!")) {
                        this.addCountdownCalculatorToTooltip(timeUntilMillis, tooltipToDisplay);
                    }
                    if (sbEvent.lastsFor >= 0L) {
                        tooltipToDisplay.add(EnumChatFormatting.GRAY + "Lasts for: " + EnumChatFormatting.YELLOW + this.prettyTime(sbEvent.lastsFor, true));
                        if (!this.prettyTime(timeUntilMillis, false).equals("Now!")) {
                            this.addCountdownCalculatorToTooltip(sbEvent.lastsFor + timeUntilMillis, tooltipToDisplay);
                        }
                        if (timeUntilMillis < 0L) {
                            tooltipToDisplay.add(EnumChatFormatting.GRAY + "Time left: " + EnumChatFormatting.YELLOW + this.prettyTime(sbEvent.lastsFor + timeUntilMillis, true));
                            if (this.prettyTime(timeUntilMillis, false).equals("Now!")) {
                                this.addCountdownCalculatorToTooltip(sbEvent.lastsFor + timeUntilMillis, tooltipToDisplay);
                            }
                        }
                    }
                    if (sbEvent.desc != null) {
                        tooltipToDisplay.add("");
                        tooltipToDisplay.addAll(sbEvent.desc);
                    }
                }
                ++index;
            }
        }
        this.specialEvents = this.eventMap.entrySet().stream().flatMap(pair -> ((Set)pair.getValue()).stream().map(it -> new Tuple(pair.getKey(), it))).filter(it -> ((SBEvent)it.func_76340_b()).isSpecial).limit(21L).collect(Collectors.toList());
        for (int i = 0; i < 21 && i < this.specialEvents.size(); ++i) {
            Tuple<Long, SBEvent> pair2 = this.specialEvents.get(i);
            SBEvent sbEvent = (SBEvent)pair2.func_76340_b();
            ItemStack stack = sbEvent.getStack();
            if (stack == null) continue;
            int x = this.guiLeft + 89 + 17 * (i % 3);
            int y = this.guiTop + 44 + 17 * (i / 3);
            if (eventFavourites.contains(sbEvent.id)) {
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2.0f);
                Gui.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)-805322935);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0f);
                GlStateManager.func_179132_a((boolean)true);
            }
            Utils.drawItemStackWithText(stack, x, y, "" + (i + 1));
            if (mouseX < x || mouseX > x + 16 || mouseY < y || mouseY > y + 16) continue;
            tooltipToDisplay = new ArrayList();
            tooltipToDisplay.add(sbEvent.display);
            tooltipToDisplay.addAll(sbEvent.desc);
            tooltipToDisplay.add(Utils.prettyTime(Duration.between(Instant.now(), Instant.ofEpochMilli((Long)pair2.func_76341_a()))));
            this.addCountdownCalculatorToTooltip(Duration.between(Instant.now(), Instant.ofEpochMilli((Long)pair2.func_76341_a())).toMillis(), tooltipToDisplay);
        }
        if (nextEvent == null) {
            nextEvent = firstEvent;
            timeUntilNext = timeUntilFirst;
        }
        if (nextEvent != null) {
            String nextS = EnumChatFormatting.YELLOW + "Next: ";
            int nextSLen = fr.func_78256_a(nextS);
            fr.func_175065_a(nextS, (float)(this.guiLeft + 8), (float)(this.guiTop + 6), -1, false);
            String until = " " + EnumChatFormatting.YELLOW + this.prettyTime(timeUntilNext, false);
            int untilLen = fr.func_78256_a(until);
            fr.func_175065_a(until, (float)(this.guiLeft + this.xSize - 8 - untilLen), (float)(this.guiTop + 6), -1, false);
            int eventTitleLen = this.xSize - 16 - untilLen - nextSLen;
            int displayWidth = fr.func_78256_a(nextEvent.display);
            int spaceLen = fr.func_78263_a(' ');
            if (displayWidth > eventTitleLen) {
                GL11.glEnable((int)3089);
                GL11.glScissor((int)((this.guiLeft + 8 + nextSLen) * scaledResolution.func_78325_e()), (int)0, (int)(eventTitleLen * scaledResolution.func_78325_e()), (int)Minecraft.func_71410_x().field_71440_d);
                fr.func_175065_a(nextEvent.display + " " + nextEvent.display, (float)(this.guiLeft + 8 + nextSLen) - (float)((double)currentTime / 50.0 % (double)(displayWidth + spaceLen)), (float)(this.guiTop + 6), -1, false);
                GL11.glDisable((int)3089);
            } else {
                fr.func_175065_a(nextEvent.display, (float)(this.guiLeft + 8 + nextSLen), (float)(this.guiTop + 6), -1, false);
            }
            if (mouseX > this.guiLeft && mouseX < this.guiLeft + 168 && mouseY > this.guiTop && mouseY < this.guiTop + 20) {
                tooltipToDisplay = Utils.createList(nextEvent.display, EnumChatFormatting.GRAY + "Starts in: " + EnumChatFormatting.YELLOW + this.prettyTime(timeUntilNext, false));
                if (!this.prettyTime(timeUntilNext, false).equals("Now!")) {
                    this.addCountdownCalculatorToTooltip(timeUntilNext, tooltipToDisplay);
                }
                if (nextEvent.lastsFor >= 0L) {
                    tooltipToDisplay.add(EnumChatFormatting.GRAY + "Lasts for: " + EnumChatFormatting.YELLOW + this.prettyTime(nextEvent.lastsFor, true));
                    if (!this.prettyTime(timeUntilNext, false).equals("Now!")) {
                        this.addCountdownCalculatorToTooltip(nextEvent.lastsFor + timeUntilNext, tooltipToDisplay);
                    }
                    if (timeUntilNext < 0L) {
                        tooltipToDisplay.add(EnumChatFormatting.GRAY + "Time left: " + EnumChatFormatting.YELLOW + this.prettyTime(nextEvent.lastsFor + timeUntilNext, true));
                        if (this.prettyTime(timeUntilNext, false).equals("Now!")) {
                            this.addCountdownCalculatorToTooltip(nextEvent.lastsFor + timeUntilNext, tooltipToDisplay);
                        }
                    }
                }
                if (nextEvent.desc != null) {
                    tooltipToDisplay.add("");
                    tooltipToDisplay.addAll(nextEvent.desc);
                }
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.help);
        Utils.drawTexturedRect(this.guiLeft + this.xSize - 18, this.guiTop + this.ySize + 2, 16.0f, 16.0f, 9729);
        if (mouseX >= this.guiLeft + this.xSize - 18 && mouseX < this.guiLeft + this.xSize - 2 && mouseY >= this.guiTop + this.ySize + 2 && mouseY <= this.guiTop + this.ySize + 18) {
            tooltipToDisplay = new ArrayList<String>();
            tooltipToDisplay.add(EnumChatFormatting.AQUA + "NEU Calendar Help");
            tooltipToDisplay.add(EnumChatFormatting.YELLOW + "This calendar displays various SkyBlock events");
            tooltipToDisplay.add(EnumChatFormatting.YELLOW + "'Daily' events are events that happen frequently");
            tooltipToDisplay.add(EnumChatFormatting.YELLOW + "'Special' events are events that happen infrequently");
            tooltipToDisplay.add(EnumChatFormatting.YELLOW + "");
            tooltipToDisplay.add(EnumChatFormatting.YELLOW + "The eventbar at the top will also show in your inventory");
            tooltipToDisplay.add(EnumChatFormatting.YELLOW + "");
            tooltipToDisplay.add(EnumChatFormatting.YELLOW + "Press 'F' on an event to mark it as a favourite");
            tooltipToDisplay.add(EnumChatFormatting.YELLOW + "Favourited events will show over normal events");
            tooltipToDisplay.add(EnumChatFormatting.YELLOW + "Favourited events will also give a notification when it");
            tooltipToDisplay.add(EnumChatFormatting.YELLOW + "is about to start and when it does start");
            tooltipToDisplay.add(EnumChatFormatting.YELLOW + "");
            tooltipToDisplay.add(EnumChatFormatting.DARK_GRAY + "In order to show crop types for Jacob's Farming");
            tooltipToDisplay.add(EnumChatFormatting.DARK_GRAY + "contest, visit the full SkyBlock calendar and go all");
            tooltipToDisplay.add(EnumChatFormatting.DARK_GRAY + "the way to the end of the SkyBlock year");
            Utils.drawHoveringText(tooltipToDisplay, mouseX, mouseY, width, height, -1);
            tooltipToDisplay = null;
        }
        if (this.jfFavouriteSelect != null) {
            int arrowLen = fr.func_78256_a("> ");
            int selectSizeX = 0;
            int selectStringIndex = 0;
            for (String s : this.jfFavouriteSelect) {
                int sWidth = fr.func_78256_a(s);
                if (selectStringIndex + 1 == this.jfFavouriteSelectIndex) {
                    sWidth += arrowLen;
                }
                if (sWidth > selectSizeX) {
                    selectSizeX = sWidth;
                }
                ++selectStringIndex;
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)19.0f);
            Gui.func_73734_a((int)(this.jfFavouriteSelectX + 2), (int)(this.jfFavouriteSelectY + 2), (int)(this.jfFavouriteSelectX + (selectSizeX += 10) + 2), (int)(this.jfFavouriteSelectY + 18 + this.jfFavouriteSelect.size() * 10 + 2), (int)-1610612736);
            GlStateManager.func_179143_c((int)513);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            Gui.func_73734_a((int)(this.jfFavouriteSelectX + 1), (int)(this.jfFavouriteSelectY + 1), (int)(this.jfFavouriteSelectX + selectSizeX - 1), (int)(this.jfFavouriteSelectY + 18 + this.jfFavouriteSelect.size() * 10 - 1), (int)-4144960);
            Gui.func_73734_a((int)this.jfFavouriteSelectX, (int)this.jfFavouriteSelectY, (int)(this.jfFavouriteSelectX + selectSizeX - 1), (int)(this.jfFavouriteSelectY + 18 + this.jfFavouriteSelect.size() * 10 - 1), (int)-986896);
            Gui.func_73734_a((int)this.jfFavouriteSelectX, (int)this.jfFavouriteSelectY, (int)(this.jfFavouriteSelectX + selectSizeX), (int)(this.jfFavouriteSelectY + 18 + this.jfFavouriteSelect.size() * 10), (int)-7303024);
            GlStateManager.func_179143_c((int)515);
            String all = (NotEnoughUpdates.INSTANCE.config.hidden.eventFavourites.contains("jacob_farming") ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.DARK_GRAY) + "All";
            if (this.jfFavouriteSelectIndex == 0) {
                fr.func_78276_b(EnumChatFormatting.BLACK + "> " + all, this.jfFavouriteSelectX + 5, this.jfFavouriteSelectY + 5, -16777216);
            } else {
                fr.func_78276_b(all, this.jfFavouriteSelectX + 5, this.jfFavouriteSelectY + 5, -16777216);
            }
            fr.func_78276_b(EnumChatFormatting.BLACK + "> ", this.jfFavouriteSelectX + 6, this.jfFavouriteSelectY + 10 * this.jfFavouriteSelectIndex + 5, -16777216);
            selectStringIndex = 0;
            for (String s : this.jfFavouriteSelect) {
                EnumChatFormatting colour = NotEnoughUpdates.INSTANCE.config.hidden.eventFavourites.contains("jacob_farming:" + s) ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.DARK_GRAY;
                s = (selectStringIndex + 1 == this.jfFavouriteSelectIndex ? EnumChatFormatting.BLACK + "> " : "") + colour + s;
                fr.func_78276_b(s, this.jfFavouriteSelectX + 5, this.jfFavouriteSelectY + 10 * selectStringIndex + 15, -16777216);
                ++selectStringIndex;
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-20.0f);
        } else if (tooltipToDisplay != null) {
            Utils.drawHoveringText((List<String>)tooltipToDisplay, mouseX, mouseY, width, height, -1);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-10.0f);
    }

    private static String getIdForDisplayName(String displayName) {
        return Utils.cleanColour(displayName).toLowerCase(Locale.ROOT).replaceAll("[0-9]+th", "").replaceAll("[0-9]+nd", "").replaceAll("[0-9]+rd", "").replaceAll("[0-9]+st", "").replaceAll("[^a-z ]", "").trim().replace(" ", "_");
    }

    @SubscribeEvent
    public void onGuiScreenMouse(GuiScreenEvent.MouseInputEvent.Pre event) {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
        int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
        if (!enabled) {
            if (Mouse.getEventButtonState() && NotEnoughUpdates.INSTANCE.config.calendar.showEventTimerInInventory && Minecraft.func_71410_x().field_71462_r instanceof GuiContainer) {
                this.xSize = 168;
                this.ySize = 20;
                this.guiLeft = (width - this.xSize) / 2;
                this.guiTop = 5;
                if (mouseX >= this.guiLeft && mouseX <= this.guiLeft + this.xSize && this.isTimerRendered && mouseY >= this.guiTop && mouseY <= this.guiTop + this.ySize) {
                    ClientCommandHandler.instance.func_71556_a((ICommandSender)Minecraft.func_71410_x().field_71439_g, "/neucalendar");
                }
            }
            return;
        }
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiChest)) {
            return;
        }
        GuiChest eventGui = (GuiChest)Minecraft.func_71410_x().field_71462_r;
        ContainerChest cc = (ContainerChest)eventGui.field_147002_h;
        String containerName = cc.func_85151_d().func_145748_c_().func_150260_c();
        if (!containerName.trim().equals("Calendar and Events")) {
            CalendarOverlay.setEnabled(false);
            return;
        }
        event.setCanceled(true);
        this.xSize = 168;
        this.ySize = 170;
        this.guiLeft = (width - this.xSize) / 2;
        this.guiTop = (height - this.ySize) / 2;
        if (Mouse.getEventButtonState()) {
            if (this.jfFavouriteSelect != null) {
                FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
                int arrowLen = fr.func_78256_a("> ");
                int selectSizeX = 0;
                int selectStringIndex = 0;
                for (String s : this.jfFavouriteSelect) {
                    int sWidth = fr.func_78256_a(s);
                    if (selectStringIndex + 1 == this.jfFavouriteSelectIndex) {
                        sWidth += arrowLen;
                    }
                    if (sWidth > selectSizeX) {
                        selectSizeX = sWidth;
                    }
                    ++selectStringIndex;
                }
                if (mouseX > this.jfFavouriteSelectX && mouseX < this.jfFavouriteSelectX + (selectSizeX += 10) && mouseY > this.jfFavouriteSelectY && mouseY < this.jfFavouriteSelectY + 18 + this.jfFavouriteSelect.size() * 10) {
                    this.jfFavouriteSelectIndex = Math.max(0, (mouseY - this.jfFavouriteSelectY - 5) / 10);
                    ArrayList<String> eventFavourites = NotEnoughUpdates.INSTANCE.config.hidden.eventFavourites;
                    String id = null;
                    if (this.jfFavouriteSelectIndex == 0) {
                        id = "jacob_farming";
                    } else if (this.jfFavouriteSelectIndex - 1 < this.jfFavouriteSelect.size()) {
                        id = "jacob_farming:" + this.jfFavouriteSelect.get(this.jfFavouriteSelectIndex - 1);
                    }
                    if (id != null) {
                        if (eventFavourites.contains(id)) {
                            eventFavourites.remove(id);
                        } else {
                            eventFavourites.add(id);
                        }
                    }
                } else {
                    this.jfFavouriteSelect = null;
                }
            }
            if (mouseY >= this.guiTop + 26 && mouseY <= this.guiTop + 26 + 141 && mouseX >= this.guiLeft + 151 && mouseX <= this.guiLeft + 151 + 14) {
                if (mouseY <= this.guiTop + 26 + 70) {
                    Minecraft.func_71410_x().field_71442_b.func_78753_a(cc.field_75152_c, 41, 2, 3, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                } else {
                    Minecraft.func_71410_x().field_71442_b.func_78753_a(cc.field_75152_c, 36, 2, 3, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                }
            }
        }
    }

    @SubscribeEvent
    public void onGuiScreenKeyboard(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (Keyboard.getEventKey() == 1) {
            if (this.jfFavouriteSelect != null) {
                this.jfFavouriteSelect = null;
                event.setCanceled(true);
            }
        } else {
            int keyPressed;
            if (!enabled) {
                return;
            }
            if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiChest)) {
                return;
            }
            GuiChest eventGui = (GuiChest)Minecraft.func_71410_x().field_71462_r;
            ContainerChest cc = (ContainerChest)eventGui.field_147002_h;
            String containerName = cc.func_85151_d().func_145748_c_().func_150260_c();
            if (!containerName.trim().equals("Calendar and Events")) {
                CalendarOverlay.setEnabled(false);
                return;
            }
            event.setCanceled(true);
            this.xSize = 168;
            this.ySize = 170;
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
            int width = scaledResolution.func_78326_a();
            int height = scaledResolution.func_78328_b();
            int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
            int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
            this.guiLeft = (width - this.xSize) / 2;
            this.guiTop = (height - this.ySize) / 2;
            int n = keyPressed = Keyboard.getEventKey() == 0 ? Keyboard.getEventCharacter() + 256 : Keyboard.getEventKey();
            if (Keyboard.getEventKeyState()) {
                if (this.jfFavouriteSelect != null) {
                    if (keyPressed == 208) {
                        ++this.jfFavouriteSelectIndex;
                        this.jfFavouriteSelectIndex %= this.jfFavouriteSelect.size() + 1;
                    } else if (keyPressed == 200) {
                        --this.jfFavouriteSelectIndex;
                        if (this.jfFavouriteSelectIndex < 0) {
                            this.jfFavouriteSelectIndex = this.jfFavouriteSelect.size();
                        }
                    } else if (keyPressed == 205 || keyPressed == 28) {
                        ArrayList<String> eventFavourites = NotEnoughUpdates.INSTANCE.config.hidden.eventFavourites;
                        String id = null;
                        if (this.jfFavouriteSelectIndex == 0) {
                            id = "jacob_farming";
                        } else if (this.jfFavouriteSelectIndex - 1 < this.jfFavouriteSelect.size()) {
                            id = "jacob_farming:" + this.jfFavouriteSelect.get(this.jfFavouriteSelectIndex - 1);
                        }
                        if (id != null) {
                            if (eventFavourites.contains(id)) {
                                eventFavourites.remove(id);
                            } else {
                                eventFavourites.add(id);
                            }
                        }
                    } else if (keyPressed == 203 || keyPressed == NotEnoughUpdates.INSTANCE.manager.keybindFavourite.func_151463_i()) {
                        this.jfFavouriteSelect = null;
                    }
                } else if (keyPressed == NotEnoughUpdates.INSTANCE.manager.keybindFavourite.func_151463_i()) {
                    String id = null;
                    int index = 0;
                    block0: for (Map.Entry<Long, Set<SBEvent>> sbEvents : this.eventMap.entrySet()) {
                        for (SBEvent sbEvent : sbEvents.getValue()) {
                            int x = this.guiLeft + 29 + 17 * (index % 3);
                            int y = this.guiTop + 44 + 17 * (index / 3);
                            if (mouseX >= x && mouseX <= x + 16 && mouseY >= y && mouseY <= y + 16) {
                                id = sbEvent.id;
                            }
                            if (++index < 21) continue;
                            break block0;
                        }
                    }
                    List<Tuple<Long, SBEvent>> specialEventsLocal = this.specialEvents;
                    for (int i = 0; specialEventsLocal != null && i < 21 && i < specialEventsLocal.size(); ++i) {
                        int x = this.guiLeft + 89 + 17 * (i % 3);
                        int y = this.guiTop + 44 + 17 * (i / 3);
                        if (mouseX < x || mouseX > x + 16 || mouseY < y || mouseY > y + 16) continue;
                        id = ((SBEvent)specialEventsLocal.get((int)i).func_76340_b()).id;
                    }
                    if (id != null) {
                        String[] split = id.split(":");
                        if (split.length > 1 && split[0].equals("jacob_farming")) {
                            this.jfFavouriteSelect = new ArrayList<String>();
                            for (int i = 1; i < split.length; ++i) {
                                this.jfFavouriteSelect.add(split[i]);
                            }
                            this.jfFavouriteSelectIndex = 0;
                            this.jfFavouriteSelectX = mouseX;
                            this.jfFavouriteSelectY = mouseY;
                        } else {
                            ArrayList<String> eventFavourites = NotEnoughUpdates.INSTANCE.config.hidden.eventFavourites;
                            if (eventFavourites.contains(id)) {
                                eventFavourites.remove(id);
                            } else {
                                eventFavourites.add(id);
                            }
                        }
                    }
                } else {
                    Minecraft.func_71410_x().func_152348_aa();
                }
            }
        }
    }

    public Optional<Pair<SBEvent, Long>> getNextFavouriteEvent(boolean orGetFirst) {
        this.populateDefaultEvents();
        long currentTime = System.currentTimeMillis();
        ArrayList<String> eventFavourites = NotEnoughUpdates.INSTANCE.config.hidden.eventFavourites;
        SBEvent nextAnyEvent = null;
        long timeUntilNextAny = 0L;
        for (Map.Entry<Long, Set<SBEvent>> sbEvents : this.eventMap.entrySet()) {
            for (SBEvent sbEvent : sbEvents.getValue()) {
                long timeUntilMillis = sbEvents.getKey() - currentTime;
                if (timeUntilMillis < -10000L) continue;
                if (nextAnyEvent == null) {
                    timeUntilNextAny = timeUntilMillis;
                    nextAnyEvent = sbEvent;
                }
                String[] split = sbEvent.id.split(":");
                boolean containsId = false;
                for (int i = 1; i < split.length; ++i) {
                    if (!eventFavourites.contains(split[0] + ":" + split[i])) continue;
                    containsId = true;
                    break;
                }
                if (!eventFavourites.isEmpty() && !eventFavourites.contains(split[0]) && !containsId) continue;
                return Optional.of(new Pair((Object)sbEvent, (Object)timeUntilMillis));
            }
        }
        if (orGetFirst && nextAnyEvent != null) {
            return Optional.of(new Pair(nextAnyEvent, (Object)timeUntilNextAny));
        }
        return Optional.empty();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onGuiDraw(RenderGameOverlayEvent.Post event) {
        if (NotEnoughUpdates.INSTANCE.config.calendar.eventNotifications && event.type == RenderGameOverlayEvent.ElementType.ALL) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)10.0f);
            if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiContainer) && NotEnoughUpdates.INSTANCE.isOnSkyblock()) {
                Optional<Pair<SBEvent, Long>> nextFavouriteEvent = this.getNextFavouriteEvent(false);
                nextFavouriteEvent.ifPresent(nextEvent -> this.renderToast((SBEvent)nextEvent.component1(), (Long)nextEvent.component2()));
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-10.0f);
            GlStateManager.func_179121_F();
        }
    }

    public boolean renderToast(SBEvent event, long timeUntil) {
        long delta;
        if (!NotEnoughUpdates.INSTANCE.config.calendar.eventNotifications) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - spookyStart > 0L && currentTime - spookyStart < 3600000L && NotEnoughUpdates.INSTANCE.config.calendar.spookyNightNotification && (delta = (currentTime - 1559829300000L) % 1200000L - 950000L - 10000L) < 500L && delta > -8500L) {
            event = new SBEvent("spooky_festival_7pm", "Spooky Festival 7pm", true, new ItemStack(Items.field_151103_aS), null);
            timeUntil = delta;
        }
        if (event.id.equals("dark_auction")) {
            timeUntil -= 30000L;
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int ySize = 32;
        int xSize = 160;
        int guiLeft = (width - xSize) / 2;
        int guiTop = 5;
        boolean preNotification = false;
        long preNotificationTime = 1000L * (long)NotEnoughUpdates.INSTANCE.config.calendar.startingSoonTime;
        if (preNotificationTime > 500L && timeUntil > 500L) {
            timeUntil -= preNotificationTime;
            preNotification = true;
        }
        if (timeUntil < 500L && timeUntil > -8500L) {
            if (this.jingleIndex == -1) {
                this.jingleIndex = preNotification ? 1 : 0;
            }
            float factor = 0.0f;
            if (timeUntil > 0L) {
                factor = (float)timeUntil / 500.0f;
            } else if (timeUntil < -8000L) {
                factor = -((float)(timeUntil + 8000L) / 500.0f);
            }
            factor = (float)((double)1.06f / (1.0 + Math.exp(-7.0f * (factor - 0.5f))) - (double)0.03f);
            float offset = (float)(-(ySize + 5)) * factor;
            float y = (float)guiTop + offset;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TOAST);
            Utils.drawTexturedRect(guiLeft, y, xSize, ySize, 9728);
            GlStateManager.func_179109_b((float)0.0f, (float)y, (float)0.0f);
            Utils.drawItemStack(event.stack, guiLeft + 6, 8);
            GlStateManager.func_179109_b((float)0.0f, (float)(-y), (float)0.0f);
            if (preNotification) {
                String starting = EnumChatFormatting.YELLOW + "Event Starting in " + this.prettyTime(preNotificationTime, true) + "!";
                int startingWidth = fr.func_78256_a(starting);
                fr.func_175065_a(starting, Math.max((float)(guiLeft + 23), (float)width / 2.0f - (float)startingWidth / 2.0f), y + 7.0f, -1, false);
            } else {
                Utils.drawStringCentered(EnumChatFormatting.YELLOW + "Event Starting Now!", (float)(width / 2), y + 11.0f, false, -1);
            }
            int displayWidth = fr.func_78256_a(event.display);
            fr.func_175065_a(event.display, Math.max((float)(guiLeft + 23), (float)width / 2.0f - (float)displayWidth / 2.0f), y + 17.0f, -1, false);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onGuiScreenDrawTimer(GuiScreenEvent.BackgroundDrawnEvent event) {
        if (!this.drawTimerForeground) {
            this.drawTimer();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
    }

    @SubscribeEvent
    public void onGuiScreenDrawTimer(GuiScreenEvent.DrawScreenEvent.Post event) {
        this.isTimerRendered = false;
        if (this.drawTimerForeground) {
            this.drawTimer();
        }
    }

    public void drawTimer() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)10.0f);
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiContainer && NotEnoughUpdates.INSTANCE.isOnSkyblock()) {
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
            int width = scaledResolution.func_78326_a();
            int height = scaledResolution.func_78328_b();
            int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
            int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
            long currentTime = System.currentTimeMillis();
            this.xSize = 168;
            this.ySize = 20;
            long timeUntilNext = 0L;
            SBEvent nextEvent = null;
            long timeUntilFirst = 0L;
            SBEvent firstEvent = null;
            ArrayList<SBEvent> nextFavourites = new ArrayList<SBEvent>();
            ArrayList<Long> nextFavouritesTime = new ArrayList<Long>();
            long timeUntilMayor = 0L;
            SBEvent nextMayorEvent = null;
            ArrayList<String> eventFavourites = NotEnoughUpdates.INSTANCE.config.hidden.eventFavourites;
            this.guiLeft = (width - this.xSize) / 2;
            this.guiTop = 5;
            this.populateDefaultEvents();
            block0: for (Map.Entry<Long, Set<SBEvent>> sbEvents : this.eventMap.entrySet()) {
                for (SBEvent sbEvent : sbEvents.getValue()) {
                    long timeUntilMillis = sbEvents.getKey() - currentTime;
                    if (timeUntilMillis < -10000L) continue;
                    if (sbEvent.id.equals("spooky_festival") && sbEvents.getKey() > currentTime - 3600000L && (sbEvents.getKey() < spookyStart || spookyStart == 0L)) {
                        spookyStart = sbEvents.getKey();
                    }
                    if (!(nextMayorEvent != null || sbEvent.id.split(":")[0].equals("jacob_farming") || sbEvent.id.equals("dark_auction") || sbEvent.isArtificial)) {
                        nextMayorEvent = sbEvent;
                        timeUntilMayor = timeUntilMillis;
                    }
                    if (firstEvent == null) {
                        firstEvent = sbEvent;
                        timeUntilFirst = timeUntilMillis;
                    }
                    String[] split = sbEvent.id.split(":");
                    boolean containsId = false;
                    for (int i = 1; i < split.length; ++i) {
                        if (!eventFavourites.contains(split[0] + ":" + split[i])) continue;
                        containsId = true;
                        break;
                    }
                    if (eventFavourites.isEmpty() || eventFavourites.contains(split[0]) || containsId) {
                        if (nextEvent == null) {
                            nextEvent = sbEvent;
                            timeUntilNext = timeUntilMillis;
                        }
                        if (nextFavourites.size() < 3) {
                            nextFavourites.add(sbEvent);
                            nextFavouritesTime.add(timeUntilMillis);
                        }
                    }
                    if (nextFavourites.size() < 3 || nextMayorEvent == null) continue;
                    break block0;
                }
            }
            if (nextEvent != null) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)50.0f);
                boolean toastRendered = this.renderToast(nextEvent, timeUntilNext);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-50.0f);
                if (!toastRendered && !enabled && NotEnoughUpdates.INSTANCE.config.calendar.showEventTimerInInventory) {
                    this.isTimerRendered = true;
                    ArrayList<String> tooltipToDisplay = null;
                    FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179106_n();
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179119_h();
                    this.renderBlurredBackground(10.0f, width, height, this.guiLeft + 3, this.guiTop + 3, this.xSize - 6, this.ySize - 6);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(DISPLAYBAR);
                    Utils.drawTexturedRect(this.guiLeft, this.guiTop, this.xSize, 20.0f, 9728);
                    String nextS = EnumChatFormatting.YELLOW + "Next: ";
                    int nextSLen = fr.func_78256_a(nextS);
                    fr.func_175065_a(nextS, (float)(this.guiLeft + 8), (float)(this.guiTop + 6), -1, false);
                    String until = " " + EnumChatFormatting.YELLOW + this.prettyTime(timeUntilNext, false);
                    int untilLen = fr.func_78256_a(until);
                    fr.func_175065_a(until, (float)(this.guiLeft + this.xSize - 8 - untilLen), (float)(this.guiTop + 6), -1, false);
                    int eventTitleLen = this.xSize - 16 - untilLen - nextSLen;
                    int displayWidth = fr.func_78256_a(nextEvent.display);
                    int spaceLen = fr.func_78263_a(' ');
                    if (displayWidth > eventTitleLen) {
                        GL11.glEnable((int)3089);
                        GL11.glScissor((int)((this.guiLeft + 8 + nextSLen) * scaledResolution.func_78325_e()), (int)0, (int)(eventTitleLen * scaledResolution.func_78325_e()), (int)Minecraft.func_71410_x().field_71440_d);
                        fr.func_175065_a(nextEvent.display + " " + nextEvent.display, (float)(this.guiLeft + 8 + nextSLen) - (float)((double)currentTime / 50.0 % (double)(displayWidth + spaceLen)), (float)(this.guiTop + 6), -1, false);
                        GL11.glDisable((int)3089);
                    } else if (this.guiLeft + this.xSize - 8 - untilLen > (width + displayWidth) / 2) {
                        Utils.drawStringCentered(nextEvent.display, (float)width / 2.0f, (float)(this.guiTop + 10), false, -1);
                    } else {
                        fr.func_175065_a(nextEvent.display, (float)(this.guiLeft + 8 + nextSLen), (float)(this.guiTop + 6), -1, false);
                    }
                    if (mouseX > this.guiLeft && mouseX < this.guiLeft + 168 && mouseY > this.guiTop && mouseY < this.guiTop + 20) {
                        tooltipToDisplay = new ArrayList<String>();
                        for (int i = 0; i < nextFavourites.size(); ++i) {
                            SBEvent sbEvent = (SBEvent)nextFavourites.get(i);
                            long timeUntil = (Long)nextFavouritesTime.get(i);
                            tooltipToDisplay.add(sbEvent.display);
                            tooltipToDisplay.add(EnumChatFormatting.GRAY + "Starts in: " + EnumChatFormatting.YELLOW + this.prettyTime(timeUntil, false));
                            if (!this.prettyTime(timeUntil, false).equals("Now!")) {
                                this.addCountdownCalculatorToTooltip(timeUntil, tooltipToDisplay);
                            }
                            if (sbEvent.lastsFor >= 0L) {
                                tooltipToDisplay.add(EnumChatFormatting.GRAY + "Lasts for: " + EnumChatFormatting.YELLOW + this.prettyTime(sbEvent.lastsFor, true));
                                if (!this.prettyTime(timeUntilNext, false).equals("Now!")) {
                                    this.addCountdownCalculatorToTooltip(sbEvent.lastsFor + timeUntil, tooltipToDisplay);
                                }
                                if (timeUntil < 0L) {
                                    tooltipToDisplay.add(EnumChatFormatting.GRAY + "Time left: " + EnumChatFormatting.YELLOW + this.prettyTime(sbEvent.lastsFor + timeUntil, true));
                                    if (this.prettyTime(timeUntil, false).equals("Now!")) {
                                        this.addCountdownCalculatorToTooltip(sbEvent.lastsFor + timeUntil, tooltipToDisplay);
                                    }
                                }
                            }
                            if (sbEvent.id.split(":")[0].equals("jacob_farming") && sbEvent.desc != null) {
                                tooltipToDisplay.addAll(sbEvent.desc);
                            }
                            if (nextMayorEvent == null && i >= nextFavourites.size() - 1) continue;
                            tooltipToDisplay.add("");
                        }
                        if (nextMayorEvent != null) {
                            tooltipToDisplay.add(EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.BOLD + "Next Mayor:");
                            tooltipToDisplay.add(nextMayorEvent.display);
                            tooltipToDisplay.add(EnumChatFormatting.GRAY + "Starts in: " + EnumChatFormatting.YELLOW + this.prettyTime(timeUntilMayor, false));
                            this.addCountdownCalculatorToTooltip(timeUntilMayor, tooltipToDisplay);
                            if (nextMayorEvent.lastsFor >= 0L) {
                                tooltipToDisplay.add(EnumChatFormatting.GRAY + "Lasts for: " + EnumChatFormatting.YELLOW + this.prettyTime(nextMayorEvent.lastsFor, true));
                                this.addCountdownCalculatorToTooltip(nextMayorEvent.lastsFor + timeUntilMayor, tooltipToDisplay);
                            }
                        }
                    }
                    this.drawTimerForeground = false;
                    if (tooltipToDisplay != null) {
                        this.drawTimerForeground = true;
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
                        Utils.drawHoveringText(tooltipToDisplay, mouseX, Math.max(17, mouseY), width, height, -1);
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-100.0f);
                    }
                }
            } else if (!enabled && NotEnoughUpdates.INSTANCE.config.calendar.showEventTimerInInventory) {
                FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179106_n();
                GlStateManager.func_179140_f();
                GlStateManager.func_179119_h();
                this.renderBlurredBackground(10.0f, width, height, this.guiLeft + 3, this.guiTop + 3, this.xSize - 6, this.ySize - 6);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(DISPLAYBAR);
                Utils.drawTexturedRect(this.guiLeft, this.guiTop, this.xSize, 20.0f, 9728);
                String nextS = EnumChatFormatting.RED + "Open calendar to see events";
                fr.func_175065_a(nextS, (float)(this.guiLeft + 8), (float)(this.guiTop + 6), -1, false);
            }
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-10.0f);
        GlStateManager.func_179121_F();
    }

    private void renderBlurredBackground(float blurStrength, int screenWidth, int screenHeight, int x, int y, int blurWidth, int blurHeight) {
        BackgroundBlur.renderBlurredBackground(blurStrength, screenWidth, screenHeight, x, y, blurWidth, blurHeight);
        Gui.func_73734_a((int)x, (int)y, (int)(x + blurWidth), (int)(y + blurHeight), (int)-938471408);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private String prettyTime(long millis, boolean trimmed) {
        long seconds = millis / 1000L % 60L;
        long minutes = millis / 1000L / 60L % 60L;
        long hours = millis / 1000L / 60L / 60L % 24L;
        long days = millis / 1000L / 60L / 60L / 24L;
        String endsIn = "";
        endsIn = millis < 0L ? endsIn + "Now!" : (minutes == 0L && hours == 0L && days == 0L ? endsIn + seconds + "s" : (hours == 0L && days == 0L ? (trimmed && seconds == 0L ? endsIn + minutes + "m" : endsIn + minutes + "m" + seconds + "s") : (days == 0L ? (hours <= 6L ? (trimmed && seconds == 0L ? (minutes == 0L ? endsIn + hours + "h" : endsIn + hours + "h" + minutes + "m") : endsIn + hours + "h" + minutes + "m" + seconds + "s") : endsIn + hours + "h") : endsIn + days + "d" + hours + "h")));
        return endsIn;
    }

    private List<String> addCountdownCalculatorToTooltip(long millis, List<String> tooltipToModify) {
        if (NotEnoughUpdates.INSTANCE.config.misc.showWhenCountdownEnds == 1 || NotEnoughUpdates.INSTANCE.config.misc.showWhenCountdownEnds == 2) {
            String formatString = "EEEE, MMM d h:mm a";
            if (NotEnoughUpdates.INSTANCE.config.misc.showWhenCountdownEnds == 2) {
                formatString = "EEEE, MMM d HH:mm";
            }
            DateTimeFormatter useFormatter = DateTimeFormatter.ofPattern(formatString);
            if (NotEnoughUpdates.INSTANCE.config.misc.useEnglishCountdown) {
                useFormatter = useFormatter.withLocale(Locale.ENGLISH);
            }
            tooltipToModify.add("\u00a7b" + useFormatter.format(ZonedDateTime.now().plusSeconds(millis / 1000L)));
        }
        return tooltipToModify;
    }

    static {
        STAR_CULT_STACK = Utils.createItemStack(Items.field_151156_bN, "Cult of the Fallen Star", "NEU Calendar Item");
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("event_id", "dark_auction");
        DA_STACK = new ItemStack(Items.field_151130_bT);
        DA_STACK.func_77982_d(tag);
        tag.func_74778_a("event_id", "jacob_farming");
        JF_STACK = new ItemStack(Items.field_151015_O);
        JF_STACK.func_77982_d(tag);
    }

    private static class SBEvent
    implements Comparable<SBEvent> {
        String id;
        String display;
        ItemStack stack;
        List<String> desc;
        long lastsFor;
        boolean isSpecial;
        boolean isArtificial;

        public SBEvent(String id, String display, boolean isSpecial, ItemStack stack, List<String> desc) {
            this(id, display, isSpecial, stack, desc, -1L);
        }

        public SBEvent(String id, String display, boolean isSpecial, ItemStack stack, List<String> desc, long lastsFor) {
            this(id, display, isSpecial, stack, desc, lastsFor, false);
        }

        public SBEvent(String id, String display, boolean isSpecial, ItemStack stack, List<String> desc, long lastsFor, boolean isArtificial) {
            this.id = id;
            this.isSpecial = isSpecial;
            this.isArtificial = isArtificial;
            this.display = display;
            this.stack = stack;
            this.desc = desc;
            this.lastsFor = lastsFor;
        }

        public ItemStack getStack() {
            if (this.stack != null) {
                NBTTagCompound tag = ItemUtils.getOrCreateTag(this.stack);
                tag.func_74778_a("event_id", this.id);
            }
            return this.stack;
        }

        @Override
        public int compareTo(@NotNull SBEvent o) {
            int i = this.id.compareTo(o.id);
            if (i != 0) {
                return i;
            }
            i = this.display.compareTo(o.display);
            if (i != 0) {
                return i;
            }
            i = Long.compare(this.lastsFor, o.lastsFor);
            if (i != 0) {
                return i;
            }
            i = Boolean.compare(this.isSpecial, o.isSpecial);
            if (i != 0) {
                return i;
            }
            i = Boolean.compare(this.isArtificial, o.isArtificial);
            if (i != 0) {
                return i;
            }
            return 0;
        }
    }
}

