/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.GlScissorStack;
import io.github.moulberry.notenoughupdates.core.GuiElementTextField;
import io.github.moulberry.notenoughupdates.core.util.lerp.LerpingInteger;
import io.github.moulberry.notenoughupdates.miscgui.GuiEnchantColour;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.overlays.EquipmentOverlay;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public class GuiInvButtonEditor
extends GuiScreen {
    private static final ResourceLocation INVENTORY = new ResourceLocation("minecraft:textures/gui/container/inventory.png");
    private static final ResourceLocation EDITOR = new ResourceLocation("notenoughupdates:invbuttons/editor.png");
    private static final ResourceLocation EXTRA_ICONS_JSON = new ResourceLocation("notenoughupdates:invbuttons/extraicons.json");
    private static final ResourceLocation PRESETS_JSON = new ResourceLocation("notenoughupdates:invbuttons/presets.json");
    private static final String sharePrefix = "NEUBUTTONS/";
    private final int xSize = 176;
    private final int ySize = 166;
    private int guiLeft;
    private int guiTop;
    private static final int BACKGROUND_TYPES = 5;
    private static final int ICON_TYPES = 3;
    private int iconTypeIndex = 0;
    private final int editorXSize = 150;
    private final int editorYSize = 204;
    private int editorLeft;
    private int editorTop;
    private final GuiElementTextField commandTextField = new GuiElementTextField("", 136, 16, 32);
    private final GuiElementTextField iconTextField = new GuiElementTextField("", 136, 16, 32);
    private static final HashSet<String> prioritisedIcons = new HashSet<String>(){
        {
            this.add("WORKBENCH");
            this.add("LEATHER_CHESTPLATE");
            this.add("CHEST");
            this.add("BONE");
            this.add("ENDER_CHEST");
            this.add("GOLD_BARDING");
            this.add("COMPASS");
            this.add("GOLD_BLOCK");
            this.add("EMPTY_MAP");
            this.add("RAW_FISH");
            this.add("FISHING_ROD");
            this.add("EMERALD");
            this.add("IRON_SWORD");
            this.add("POTION");
            this.add("NETHER_STAR");
            this.add("PAINTING");
            this.add("COMMAND");
            this.add("BOOK");
        }
    };
    private static HashMap<String, String> extraIcons = null;
    private static final HashMap<String, String> skullIcons = new HashMap<String, String>(){
        {
            this.put("personal bank", "skull:e36e94f6c34a35465fce4a90f2e25976389eb9709a12273574ff70fd4daa6852");
            this.put("skyblock hub", "skull:d7cc6687423d0570d556ac53e0676cb563bbdd9717cd8269bdebed6f6d4e7bf8");
            this.put("private island", "skull:c9c8881e42915a9d29bb61a16fb26d059913204d265df5b439b3d792acd56");
            this.put("castle", "skull:f4559d75464b2e40a518e4de8e6cf3085f0a3ca0b1b7012614c4cd96fed60378");
            this.put("sirius shack", "skull:7ab83858ebc8ee85c3e54ab13aabfcc1ef2ad446d6a900e471c3f33b78906a5b");
            this.put("crypts", "skull:25d2f31ba162fe6272e831aed17f53213db6fa1c4cbe4fc827f3963cc98b9");
            this.put("spiders den", "skull:c754318a3376f470e481dfcd6c83a59aa690ad4b4dd7577fdad1c2ef08d8aee6");
            this.put("top of the nest", "skull:9d7e3b19ac4f3dee9c5677c135333b9d35a7f568b63d1ef4ada4b068b5a25");
            this.put("the end", "skull:7840b87d52271d2a755dedc82877e0ed3df67dcc42ea479ec146176b02779a5");
            this.put("the end dragons nest", "skull:a1cd6d2d03f135e7c6b5d6cdae1b3a68743db4eb749faf7341e9fb347aa283b");
            this.put("the park", "skull:a221f813dacee0fef8c59f76894dbb26415478d9ddfc44c2e708a6d3b7549b");
            this.put("the park jungle", "skull:79ca3540621c1c79c32bf42438708ff1f5f7d0af9b14a074731107edfeb691c");
            this.put("the park howling cave", "skull:1832d53997b451635c9cf9004b0f22bb3d99ab5a093942b5b5f6bb4e4de47065");
            this.put("gold mines", "skull:73bc965d579c3c6039f0a17eb7c2e6faf538c7a5de8e60ec7a719360d0a857a9");
            this.put("deep caverns", "skull:569a1f114151b4521373f34bc14c2963a5011cdc25a6554c48c708cd96ebfc");
            this.put("the barn", "skull:4d3a6bd98ac1833c664c4909ff8d2dc62ce887bdcf3cc5b3848651ae5af6b");
            this.put("mushroom desert", "skull:6b20b23c1aa2be0270f016b4c90d6ee6b8330a17cfef87869d6ad60b2ffbf3b5");
            this.put("dungeon hub", "skull:9b56895b9659896ad647f58599238af532d46db9c1b0389b8bbeb70999dab33d");
            this.put("dwarven mines", "skull:51539dddf9ed255ece6348193cd75012c82c93aec381f05572cecf7379711b3b");
            this.put("hotm heart of the mountain", "skull:86f06eaa3004aeed09b3d5b45d976de584e691c0e9cade133635de93d23b9edb");
            this.put("bazaar dude", "skull:c232e3820897429157619b0ee099fec0628f602fff12b695de54aef11d923ad7");
            this.put("museum", "skull:438cf3f8e54afc3b3f91d20a49f324dca1486007fe545399055524c17941f4dc");
            this.put("crystal hollows", "skull:21dbe30b027acbceb612563bd877cd7ebb719ea6ed1399027dcee58bb9049d4a");
            this.put("dwarven forge", "skull:5cbd9f5ec1ed007259996491e69ff649a3106cf920227b1bb3a71ee7a89863f");
            this.put("forgotton skull", "skull:6becc645f129c8bc2faa4d8145481fab11ad2ee75749d628dcd999aa94e7");
            this.put("crystal nucleus", "skull:34d42f9c461cee1997b67bf3610c6411bf852b9e5db607bbf626527cfb42912c");
            this.put("void sepulture", "skull:eb07594e2df273921a77c101d0bfdfa1115abed5b9b2029eb496ceba9bdbb4b3");
            this.put("crimson isle", "skull:c3687e25c632bce8aa61e0d64c24e694c3eea629ea944f4cf30dcfb4fbce071");
            this.put("trapper den", "skull:6102f82148461ced1f7b62e326eb2db3a94a33cba81d4281452af4d8aeca4991");
            this.put("arachne sanctuary", "skull:35e248da2e108f09813a6b848a0fcef111300978180eda41d3d1a7a8e4dba3c3");
            this.put("garden", "skull:f4880d2c1e7b86e87522e20882656f45bafd42f94932b2c5e0d6ecaa490cb4c");
            this.put("winter", "skull:6dd663136cafa11806fdbca6b596afd85166b4ec02142c8d5ac8941d89ab7");
            this.put("wizard tower", "skull:838564e28aba98301dbda5fafd86d1da4e2eaeef12ea94dcf440b883e559311c");
            this.put("dwarven mines base camp", "skull:2461ec3bd654f62ca9a393a32629e21b4e497c877d3f3380bcf2db0e20fc0244");
        }
    };
    private static LinkedHashMap<String, List<NEUConfig.InventoryButton>> presets = null;
    private static final Comparator<String> prioritisingComparator = (o1, o2) -> {
        boolean c1 = prioritisedIcons.contains(o1);
        boolean c2 = prioritisedIcons.contains(o2);
        if (c1 && !c2) {
            return -1;
        }
        if (!c1 && c2) {
            return 1;
        }
        return o1.compareTo((String)o2);
    };
    private final List<String> searchedIcons = new ArrayList<String>();
    private final LerpingInteger itemScroll = new LerpingInteger(0, 100);
    private NEUConfig.InventoryButton editingButton = null;
    private static final HashMap<String, ItemStack> skullMap = new HashMap();
    private final ExecutorService searchES = Executors.newSingleThreadExecutor();
    private final AtomicInteger searchId = new AtomicInteger(0);

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    public GuiInvButtonEditor() {
        GuiInvButtonEditor.reloadExtraIcons();
        GuiInvButtonEditor.reloadPresets();
    }

    private static void reloadExtraIcons() {
        extraIcons = new HashMap();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(EXTRA_ICONS_JSON).func_110527_b(), StandardCharsets.UTF_8));){
            JsonObject json = NotEnoughUpdates.INSTANCE.manager.gson.fromJson((Reader)reader, JsonObject.class);
            for (Map.Entry<String, JsonElement> entry : json.entrySet()) {
                if (!entry.getValue().isJsonPrimitive()) continue;
                extraIcons.put(entry.getKey(), "extra:" + entry.getValue().getAsString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void reloadPresets() {
        presets = new LinkedHashMap();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(PRESETS_JSON).func_110527_b(), StandardCharsets.UTF_8));){
            JsonObject json = NotEnoughUpdates.INSTANCE.manager.gson.fromJson((Reader)reader, JsonObject.class);
            for (Map.Entry<String, JsonElement> entry : json.entrySet()) {
                if (!entry.getValue().isJsonArray()) continue;
                JsonArray arr = entry.getValue().getAsJsonArray();
                ArrayList<NEUConfig.InventoryButton> buttons = new ArrayList<NEUConfig.InventoryButton>();
                for (int i = 0; i < arr.size(); ++i) {
                    JsonObject o = arr.get(i).getAsJsonObject();
                    NEUConfig.InventoryButton button = NotEnoughUpdates.INSTANCE.manager.gson.fromJson((JsonElement)o, NEUConfig.InventoryButton.class);
                    buttons.add(button);
                }
                presets.put(entry.getKey(), buttons);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderIcon(String icon, int x, int y) {
        if (extraIcons == null) {
            GuiInvButtonEditor.reloadExtraIcons();
        }
        if (icon.startsWith("extra:")) {
            String name = icon.substring("extra:".length());
            ResourceLocation resourceLocation = new ResourceLocation("notenoughupdates:invbuttons/extraicons/" + name + ".png");
            Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocation);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(x, y, 16.0f, 16.0f, 9728);
        } else {
            ItemStack stack = GuiInvButtonEditor.getStack(icon);
            float scale = 1.0f;
            if (icon.startsWith("skull:")) {
                scale = 1.2f;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(x + 8), (float)(y + 8), (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            GlStateManager.func_179109_b((float)-8.0f, (float)-8.0f, (float)0.0f);
            Utils.drawItemStack(stack, 0, 0);
            GlStateManager.func_179121_F();
        }
    }

    public static ItemStack getStack(String icon) {
        if (icon.startsWith("extra:")) {
            return null;
        }
        if (icon.startsWith("skull:")) {
            String link = icon.substring("skull:".length());
            if (skullMap.containsKey(link)) {
                return skullMap.get(link);
            }
            ItemStack render = new ItemStack(Items.field_151144_bL, 1, 3);
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagCompound skullOwner = new NBTTagCompound();
            NBTTagCompound properties = new NBTTagCompound();
            NBTTagList textures = new NBTTagList();
            NBTTagCompound textures_0 = new NBTTagCompound();
            String uuid = UUID.nameUUIDFromBytes(link.getBytes()).toString();
            skullOwner.func_74778_a("Id", uuid);
            skullOwner.func_74778_a("Name", uuid);
            String display = "{\"textures\":{\"SKIN\":{\"url\":\"http://textures.minecraft.net/texture/" + link + "\"}}}";
            String displayB64 = Base64.getEncoder().encodeToString(display.getBytes());
            textures_0.func_74778_a("Value", displayB64);
            textures.func_74742_a((NBTBase)textures_0);
            properties.func_74782_a("textures", (NBTBase)textures);
            skullOwner.func_74782_a("Properties", (NBTBase)properties);
            nbt.func_74782_a("SkullOwner", (NBTBase)skullOwner);
            render.func_77982_d(nbt);
            skullMap.put(link, render);
            return render;
        }
        return NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(icon));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        super.func_146276_q_();
        this.guiLeft = this.field_146294_l / 2 - 88;
        this.guiTop = this.field_146295_m / 2 - 83;
        GlStateManager.func_179126_j();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(INVENTORY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(this.guiLeft, this.guiTop, 176.0f, 166.0f, 0.0f, 0.6875f, 0.0f, 0.6484375f, 9728);
        if (NotEnoughUpdates.INSTANCE.config.customArmour.enableArmourHud) {
            EquipmentOverlay.INSTANCE.renderPreviewArmorHud();
        }
        if (NotEnoughUpdates.INSTANCE.config.petOverlay.petInvDisplay) {
            EquipmentOverlay.INSTANCE.renderPreviewPetInvHud();
        }
        for (NEUConfig.InventoryButton inventoryButton : NotEnoughUpdates.INSTANCE.config.hidden.inventoryButtons) {
            int x = this.guiLeft + inventoryButton.x;
            int y = this.guiTop + inventoryButton.y;
            if (inventoryButton.anchorRight) {
                x += 176;
            }
            if (inventoryButton.anchorBottom) {
                y += 166;
            }
            if (NotEnoughUpdates.INSTANCE.config.customArmour.enableArmourHud && x < this.guiLeft + 176 - 150 && x > this.guiLeft + 176 - 200 && y > this.guiTop && y < this.guiTop + 84) {
                x -= 25;
            }
            if (NotEnoughUpdates.INSTANCE.config.petOverlay.petInvDisplay && x < this.guiLeft + 176 - 150 && x > this.guiLeft + 176 - 200 && y > this.guiTop + 60 && y < this.guiTop + 120) {
                x -= 25;
            }
            if (inventoryButton.isActive()) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(EDITOR);
            Utils.drawTexturedRect(x, y, 18.0f, 18.0f, (float)(inventoryButton.backgroundIndex * 18) / 256.0f, (float)(inventoryButton.backgroundIndex * 18 + 18) / 256.0f, 0.0703125f, 0.140625f, 9728);
            if (inventoryButton.isActive()) {
                if (inventoryButton.icon == null || inventoryButton.icon.trim().isEmpty()) continue;
                GlStateManager.func_179126_j();
                GuiInvButtonEditor.renderIcon(inventoryButton.icon, x + 1, y + 1);
                continue;
            }
            this.field_146289_q.func_78276_b("+", x + 6, y + 5, -3355444);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiEnchantColour.custom_ench_colour);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(this.guiLeft - 88 - 2 - 22 - (NotEnoughUpdates.INSTANCE.config.customArmour.enableArmourHud ? 25 : 0), this.guiTop + 2, 88.0f, 20.0f, 0.29493088f, 0.70046085f, 0.61538464f, 0.8717949f, 9728);
        Utils.drawTexturedRect(this.guiLeft - 88 - 2 - 22 - (NotEnoughUpdates.INSTANCE.config.customArmour.enableArmourHud ? 25 : 0), this.guiTop + 2 + 24, 88.0f, 20.0f, 0.29493088f, 0.70046085f, 0.61538464f, 0.8717949f, 9728);
        Utils.drawStringCenteredScaledMaxWidth("Load preset", this.guiLeft - 44 - 2 - 22 - (NotEnoughUpdates.INSTANCE.config.customArmour.enableArmourHud ? 25 : 0), this.guiTop + 8, false, 86, 0x404040);
        Utils.drawStringCenteredScaledMaxWidth("from Clipboard", this.guiLeft - 44 - 2 - 22 - (NotEnoughUpdates.INSTANCE.config.customArmour.enableArmourHud ? 25 : 0), this.guiTop + 16, false, 86, 0x404040);
        Utils.drawStringCenteredScaledMaxWidth("Save preset", this.guiLeft - 44 - 2 - 22 - (NotEnoughUpdates.INSTANCE.config.customArmour.enableArmourHud ? 25 : 0), this.guiTop + 8 + 24, false, 86, 0x404040);
        Utils.drawStringCenteredScaledMaxWidth("to Clipboard", this.guiLeft - 44 - 2 - 22 - (NotEnoughUpdates.INSTANCE.config.customArmour.enableArmourHud ? 25 : 0), this.guiTop + 16 + 24, false, 86, 0x404040);
        if (!this.validShareContents()) {
            Gui.func_73734_a((int)(this.guiLeft - 88 - 2 - 22 - (NotEnoughUpdates.INSTANCE.config.customArmour.enableArmourHud ? 25 : 0)), (int)(this.guiTop + 2), (int)(this.guiLeft - 2 - 22 - (NotEnoughUpdates.INSTANCE.config.customArmour.enableArmourHud ? 25 : 0)), (int)(this.guiTop + 2 + 20), (int)Integer.MIN_VALUE);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (presets != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(EDITOR);
            Utils.drawTexturedRect(this.guiLeft + 176 + 22, this.guiTop, 80.0f, 166.0f, 0.5859375f, 0.8984375f, 0.16015625f, 0.80859375f, 9728);
            Utils.drawStringCenteredScaledMaxWidth("\u00a7nPresets", this.guiLeft + 176 + 22 + 40, this.guiTop + 10, false, 70, -6250336);
            int index = 0;
            for (String presetName : presets.keySet()) {
                Utils.drawStringCenteredScaledMaxWidth(presetName, this.guiLeft + 176 + 22 + 40, this.guiTop + 25 + 10 * index++, false, 70, -7303024);
            }
        }
        if (this.editingButton != null) {
            void var5_11;
            int x = this.guiLeft + this.editingButton.x;
            int n = this.guiTop + this.editingButton.y;
            if (this.editingButton.anchorRight) {
                x += 176;
            }
            if (this.editingButton.anchorBottom) {
                var5_11 += 166;
            }
            if (NotEnoughUpdates.INSTANCE.config.customArmour.enableArmourHud && x < this.guiLeft + 176 - 150 && x > this.guiLeft + 176 - 200 && var5_11 > this.guiTop && var5_11 < this.guiTop + 84) {
                x -= 25;
            }
            if (NotEnoughUpdates.INSTANCE.config.petOverlay.petInvDisplay && x < this.guiLeft + 176 - 150 && x > this.guiLeft + 176 - 200 && var5_11 > this.guiTop + 60 && var5_11 < this.guiTop + 120) {
                x -= 25;
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
            this.editorLeft = x + 8 - 75;
            this.editorTop = var5_11 + 18 + 2;
            boolean showArrow = true;
            if (this.editorTop + 204 + 5 > this.field_146295_m) {
                this.editorTop = this.field_146295_m - 204 - 5;
                showArrow = false;
            }
            if (this.editorLeft < 5) {
                this.editorLeft = 5;
                showArrow = false;
            }
            if (this.editorLeft + 150 + 5 > this.field_146294_l) {
                this.editorLeft = this.field_146294_l - 150 - 5;
                showArrow = false;
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(EDITOR);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Utils.drawTexturedRect(this.editorLeft, this.editorTop, 150.0f, 204.0f, 0.0f, 0.5859375f, 0.16015625f, 0.95703125f, 9728);
            if (showArrow) {
                Utils.drawTexturedRect(x + 8 - 3, (float)(var5_11 + 18), 10.0f, 5.0f, 0.0f, 0.0234375f, 0.140625f, 0.16015625f, 9728);
            }
            this.field_146289_q.func_175065_a("Command", (float)(this.editorLeft + 7), (float)(this.editorTop + 7), -6250336, false);
            this.commandTextField.setSize(136, 16);
            this.commandTextField.setText(this.commandTextField.getText().replaceAll("^ +", ""));
            if (this.commandTextField.getText().startsWith("/")) {
                this.commandTextField.setPrependText("");
            } else {
                this.commandTextField.setPrependText("\u00a77/\u00a7r");
            }
            this.commandTextField.render(this.editorLeft + 7, this.editorTop + 19);
            this.field_146289_q.func_175065_a("Background", (float)(this.editorLeft + 7), (float)(this.editorTop + 40), -6250336, false);
            for (int i = 0; i < 5; ++i) {
                if (i == this.editingButton.backgroundIndex) {
                    Gui.func_73734_a((int)(this.editorLeft + 7 + 20 * i - 1), (int)(this.editorTop + 50 - 1), (int)(this.editorLeft + 7 + 20 * i + 19), (int)(this.editorTop + 50 + 19), (int)-16776961);
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(EDITOR);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(this.editorLeft + 7 + 20 * i, this.editorTop + 50, 18.0f, 18.0f, (float)(i * 18) / 256.0f, (float)(i * 18 + 18) / 256.0f, 0.0f, 0.0703125f, 9728);
            }
            this.field_146289_q.func_175065_a("Icon Type", (float)(this.editorLeft + 7), (float)(this.editorTop + 50 + 24), -6250336, false);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(EDITOR);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float uMin = 0.0703125f;
            float uMax = 0.140625f;
            float vMin = 0.0f;
            float vMax = 0.0703125f;
            for (int i = 0; i < 3; ++i) {
                boolean flip = this.iconTypeIndex == i;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(EDITOR);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Utils.drawTexturedRect(this.editorLeft + 7 + 20 * i, this.editorTop + 50 + 34, 18.0f, 18.0f, flip ? uMax : uMin, flip ? uMin : uMax, flip ? vMax : vMin, flip ? vMin : vMax, 9728);
                ItemStack stack = null;
                if (i == 0) {
                    stack = new ItemStack(Items.field_151048_u);
                } else if (i == 1) {
                    stack = GuiInvButtonEditor.getStack("skull:c9c8881e42915a9d29bb61a16fb26d059913204d265df5b439b3d792acd56");
                } else if (i == 2) {
                    stack = new ItemStack(Items.field_151058_ca);
                }
                if (stack == null) continue;
                Utils.drawItemStack(stack, this.editorLeft + 8 + 20 * i, this.editorTop + 50 + 35);
            }
            this.field_146289_q.func_175065_a("Icon Selector", (float)(this.editorLeft + 7), (float)(this.editorTop + 50 + 55), -6250336, false);
            this.iconTextField.render(this.editorLeft + 7, this.editorTop + 50 + 65);
            GlStateManager.func_179126_j();
            this.itemScroll.tick();
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
            GlScissorStack.push(0, this.editorTop + 136, this.field_146294_l, this.editorTop + 196, scaledResolution);
            List<String> list = this.searchedIcons;
            synchronized (list) {
                int scrollY;
                int scrollBarHeight;
                if (this.iconTextField.getText().trim().isEmpty() && this.searchedIcons.isEmpty()) {
                    this.searchedIcons.addAll(NotEnoughUpdates.INSTANCE.manager.getItemInformation().keySet());
                    this.searchedIcons.sort(prioritisingComparator);
                }
                int max2 = (this.searchedIcons.size() - 1) / 6 * 20 - 40;
                int scroll = this.itemScroll.getValue();
                if (scroll > max2) {
                    scroll = max2;
                }
                if ((scrollBarHeight = (int)Math.ceil(162.0f / (float)(this.searchedIcons.size() - 18))) < 0) {
                    scrollBarHeight = 54;
                }
                if (scrollBarHeight < 2) {
                    scrollBarHeight = 2;
                }
                if ((scrollY = (int)Math.floor(54.0f * ((float)scroll / 20.0f / ((float)(this.searchedIcons.size() - 18) / 6.0f)))) + scrollBarHeight > 54) {
                    scrollY = 54 - scrollBarHeight;
                }
                Gui.func_73734_a((int)(this.editorLeft + 137), (int)(this.editorTop + 139 + scrollY), (int)(this.editorLeft + 139), (int)(this.editorTop + 139 + scrollY + scrollBarHeight), (int)-14671840);
                int endIndex = this.searchedIcons.size();
                int startIndex = scroll / 20 * 6;
                if (startIndex < 0) {
                    startIndex = 0;
                }
                if (endIndex > startIndex + 24) {
                    endIndex = startIndex + 24;
                }
                for (int i = startIndex; i < endIndex; ++i) {
                    String iconS = this.searchedIcons.get(i);
                    int iconX = this.editorLeft + 12 + (i - startIndex) % 6 * 20;
                    int iconY = this.editorTop + 137 + (i - startIndex) / 6 * 20 - this.itemScroll.getValue() % 20;
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(EDITOR);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Utils.drawTexturedRect(iconX, iconY, 18.0f, 18.0f, 0.0703125f, 0.140625f, 0.0f, 0.0703125f, 9728);
                    GuiInvButtonEditor.renderIcon(iconS, iconX + 1, iconY + 1);
                }
            }
            GlScissorStack.pop(scaledResolution);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
        }
    }

    public void func_146274_d() throws IOException {
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0) {
            if ((scroll = -scroll) > 1) {
                scroll = 8;
            }
            if (scroll < -1) {
                scroll = -8;
            }
            int delta = Math.abs(this.itemScroll.getTarget() - this.itemScroll.getValue());
            float acc = delta / 20 + 1;
            scroll = (int)((float)scroll * acc);
            int max2 = (this.searchedIcons.size() - 1) / 6 * 20 - 40;
            int newTarget = this.itemScroll.getTarget() + scroll;
            if (newTarget > max2) {
                newTarget = max2;
            }
            if (newTarget < 0) {
                newTarget = 0;
            }
            this.itemScroll.setTarget(newTarget);
            this.itemScroll.resetTimer();
        }
        super.func_146274_d();
    }

    private boolean validShareContents() {
        String base64 = Utils.getClipboard();
        if (base64 == null) {
            return false;
        }
        if (base64.length() <= sharePrefix.length()) {
            return false;
        }
        base64 = base64.trim();
        try {
            return new String(Base64.getDecoder().decode(base64)).startsWith(sharePrefix);
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.editingButton != null && mouseX >= this.editorLeft && mouseX <= this.editorLeft + 150 && mouseY >= this.editorTop & mouseY <= this.editorTop + 204) {
            int i2;
            if (mouseX >= this.editorLeft + 7 && mouseX <= this.editorLeft + 7 + this.commandTextField.getWidth() && mouseY >= this.editorTop + 12 && mouseY <= this.editorTop + 12 + this.commandTextField.getHeight()) {
                this.commandTextField.mouseClicked(mouseX, mouseY, mouseButton);
                this.iconTextField.unfocus();
                this.editingButton.command = this.commandTextField.getText();
                return;
            }
            if (mouseX >= this.editorLeft + 7 && mouseX <= this.editorLeft + 7 + this.iconTextField.getWidth() && mouseY >= this.editorTop + 50 + 65 && mouseY <= this.editorTop + 50 + 65 + this.iconTextField.getHeight()) {
                this.iconTextField.mouseClicked(mouseX, mouseY, mouseButton);
                if (mouseButton == 1) {
                    this.search();
                }
                this.commandTextField.unfocus();
                return;
            }
            if (mouseY >= this.editorTop + 50 && mouseY <= this.editorTop + 50 + 18) {
                for (i2 = 0; i2 < 5; ++i2) {
                    if (mouseX < this.editorLeft + 7 + 20 * i2 || mouseX > this.editorLeft + 7 + 20 * i2 + 18) continue;
                    this.editingButton.backgroundIndex = i2;
                    return;
                }
            }
            for (i2 = 0; i2 < 3; ++i2) {
                if (mouseX < this.editorLeft + 7 + 20 * i2 || mouseX > this.editorLeft + 7 + 20 * i2 + 18 || mouseY < this.editorTop + 50 + 34 || mouseY > this.editorTop + 50 + 34 + 18) continue;
                if (this.iconTypeIndex != i2) {
                    this.iconTypeIndex = i2;
                    this.search();
                }
                return;
            }
            if (mouseX > this.editorLeft + 8 && mouseX < this.editorLeft + 150 - 16 && mouseY > this.editorTop + 136 && mouseY < this.editorTop + 196) {
                List<String> i2 = this.searchedIcons;
                synchronized (i2) {
                    int max2 = (this.searchedIcons.size() - 1) / 6 * 20 - 40;
                    int scroll = this.itemScroll.getValue();
                    if (scroll > max2) {
                        scroll = max2;
                    }
                    int endIndex = this.searchedIcons.size();
                    int startIndex = scroll / 20 * 6;
                    if (startIndex < 0) {
                        startIndex = 0;
                    }
                    if (endIndex > startIndex + 24) {
                        endIndex = startIndex + 24;
                    }
                    for (int i3 = startIndex; i3 < endIndex; ++i3) {
                        String iconS = this.searchedIcons.get(i3);
                        int x = this.editorLeft + 12 + (i3 - startIndex) % 6 * 20;
                        int y = this.editorTop + 137 + (i3 - startIndex) / 6 * 20 - this.itemScroll.getValue() % 20;
                        if (mouseX < x || mouseX > x + 18 || mouseY < y || mouseY > y + 18) continue;
                        this.editingButton.icon = iconS;
                        return;
                    }
                }
            }
            return;
        }
        for (NEUConfig.InventoryButton button : NotEnoughUpdates.INSTANCE.config.hidden.inventoryButtons) {
            int x = this.guiLeft + button.x;
            int y = this.guiTop + button.y;
            if (button.anchorRight) {
                x += 176;
            }
            if (button.anchorBottom) {
                y += 166;
            }
            if (NotEnoughUpdates.INSTANCE.config.customArmour.enableArmourHud && x < this.guiLeft + 176 - 150 && x > this.guiLeft + 176 - 200 && y > this.guiTop && y < this.guiTop + 84) {
                x -= 25;
            }
            if (NotEnoughUpdates.INSTANCE.config.petOverlay.petInvDisplay && x < this.guiLeft + 176 - 150 && x > this.guiLeft + 176 - 200 && y > this.guiTop + 60 && y < this.guiTop + 120) {
                x -= 25;
            }
            if (mouseX < x || mouseY < y || mouseX > x + 18 || mouseY > y + 18) continue;
            if (this.editingButton == button) {
                this.editingButton = null;
            } else {
                this.editingButton = button;
                this.commandTextField.setText(this.editingButton.command);
            }
            return;
        }
        if (mouseX > this.guiLeft - 2 - 88 - 22 && mouseX < this.guiLeft - 2 - 22) {
            if (mouseY > this.guiTop + 2 && mouseY < this.guiTop + 22) {
                JsonArray presetArray;
                String jsonString;
                String base64 = Utils.getClipboard();
                if (base64 == null) {
                    return;
                }
                if (base64.length() <= sharePrefix.length()) {
                    return;
                }
                base64 = base64.trim();
                try {
                    jsonString = new String(Base64.getDecoder().decode(base64));
                    if (!jsonString.startsWith(sharePrefix)) {
                        return;
                    }
                    jsonString = jsonString.substring(sharePrefix.length());
                }
                catch (IllegalArgumentException e2) {
                    return;
                }
                try {
                    presetArray = new JsonParser().parse(jsonString).getAsJsonArray();
                }
                catch (JsonParseException | IllegalStateException e3) {
                    return;
                }
                ArrayList<NEUConfig.InventoryButton> buttons = new ArrayList<NEUConfig.InventoryButton>();
                System.out.println(presetArray.size());
                try {
                    for (int i = 0; i < presetArray.size(); ++i) {
                        JsonElement shittyO = presetArray.get(i);
                        JsonElement lessShittyO = new JsonParser().parse(shittyO.getAsString());
                        if (!lessShittyO.isJsonObject()) continue;
                        JsonObject o = lessShittyO.getAsJsonObject();
                        NEUConfig.InventoryButton button = NotEnoughUpdates.INSTANCE.manager.gson.fromJson((JsonElement)o, NEUConfig.InventoryButton.class);
                        buttons.add(button);
                    }
                    NotEnoughUpdates.INSTANCE.config.hidden.inventoryButtons = buttons;
                    return;
                }
                catch (JsonParseException | ClassCastException | IllegalStateException e4) {
                    return;
                }
            }
            if (mouseY > this.guiTop + 26 && mouseY < this.guiTop + 26 + 20) {
                List<NEUConfig.InventoryButton> result2 = NotEnoughUpdates.INSTANCE.config.hidden.inventoryButtons;
                JsonArray jsonArray = new JsonArray();
                for (NEUConfig.InventoryButton inventoryButton : result2) {
                    jsonArray.add(new JsonPrimitive(NotEnoughUpdates.INSTANCE.manager.gson.toJson((Object)inventoryButton, (Type)((Object)NEUConfig.InventoryButton.class))));
                }
                String base64String = Base64.getEncoder().encodeToString((sharePrefix + jsonArray).getBytes(StandardCharsets.UTF_8));
                Utils.copyToClipboard(base64String);
                return;
            }
        }
        if (this.editingButton == null) {
            int index = 0;
            for (List<NEUConfig.InventoryButton> buttons : presets.values()) {
                if (mouseX >= this.guiLeft + 176 + 22 && mouseX <= this.guiLeft + 176 + 22 + 80 && mouseY >= this.guiTop + 21 + 10 * index && mouseY <= this.guiTop + 21 + 10 * index + 10) {
                    NotEnoughUpdates.INSTANCE.config.hidden.inventoryButtons = buttons;
                    return;
                }
                ++index;
            }
        }
        this.editingButton = null;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (this.editingButton != null && this.commandTextField.getFocus()) {
            this.commandTextField.keyTyped(typedChar, keyCode);
            this.editingButton.command = this.commandTextField.getText();
        } else if (this.editingButton != null && this.iconTextField.getFocus()) {
            String old = this.iconTextField.getText().trim();
            this.iconTextField.keyTyped(typedChar, keyCode);
            String newText = this.iconTextField.getText().trim();
            if (!old.equalsIgnoreCase(newText)) {
                this.search();
            }
        }
    }

    public void func_146281_b() {
        NotEnoughUpdates.INSTANCE.saveConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search() {
        int thisSearchId = this.searchId.incrementAndGet();
        String searchString = this.iconTextField.getText();
        if (this.iconTypeIndex == 0) {
            if (searchString.trim().isEmpty()) {
                List<String> list = this.searchedIcons;
                synchronized (list) {
                    this.searchedIcons.clear();
                    ArrayList<String> unsorted = new ArrayList<String>(NotEnoughUpdates.INSTANCE.manager.getItemInformation().keySet());
                    unsorted.sort(prioritisingComparator);
                    this.searchedIcons.addAll(unsorted);
                }
                return;
            }
            this.searchES.submit(() -> {
                if (thisSearchId != this.searchId.get()) {
                    return;
                }
                ArrayList<String> title = new ArrayList<String>(NotEnoughUpdates.INSTANCE.manager.search("title:" + searchString.trim()));
                if (thisSearchId != this.searchId.get()) {
                    return;
                }
                if (!searchString.trim().contains(" ")) {
                    StringBuilder sb = new StringBuilder();
                    for (char c : searchString.toCharArray()) {
                        sb.append(c).append(" ");
                    }
                    title.addAll(NotEnoughUpdates.INSTANCE.manager.search("title:" + sb.toString().trim()));
                }
                if (thisSearchId != this.searchId.get()) {
                    return;
                }
                ArrayList<String> desc = new ArrayList<String>(NotEnoughUpdates.INSTANCE.manager.search("desc:" + searchString.trim()));
                desc.removeAll(title);
                if (thisSearchId != this.searchId.get()) {
                    return;
                }
                title.sort(prioritisingComparator);
                desc.sort(prioritisingComparator);
                if (thisSearchId != this.searchId.get()) {
                    return;
                }
                List<String> list = this.searchedIcons;
                synchronized (list) {
                    this.searchedIcons.clear();
                    this.searchedIcons.addAll(title);
                    this.searchedIcons.addAll(desc);
                }
            });
        } else {
            if (this.iconTypeIndex == 1) {
                if (searchString.trim().isEmpty()) {
                    this.searchedIcons.clear();
                    this.searchedIcons.addAll(skullIcons.values());
                    return;
                }
                List<String> list = this.searchedIcons;
                synchronized (list) {
                    this.searchedIcons.clear();
                    for (Map.Entry<String, String> entry : skullIcons.entrySet()) {
                        if (!NotEnoughUpdates.INSTANCE.manager.searchString(entry.getKey(), searchString)) continue;
                        this.searchedIcons.add(entry.getValue());
                    }
                }
            }
            if (this.iconTypeIndex == 2) {
                if (searchString.trim().isEmpty()) {
                    this.searchedIcons.clear();
                    this.searchedIcons.addAll(extraIcons.values());
                    return;
                }
                List<String> list = this.searchedIcons;
                synchronized (list) {
                    this.searchedIcons.clear();
                    for (Map.Entry<String, String> entry : extraIcons.entrySet()) {
                        if (!NotEnoughUpdates.INSTANCE.manager.searchString(entry.getKey(), searchString)) continue;
                        this.searchedIcons.add(entry.getValue());
                    }
                }
            }
        }
    }
}

