/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.KeybindHelper;
import io.github.moulberry.notenoughupdates.miscfeatures.StorageManager;
import io.github.moulberry.notenoughupdates.miscgui.StorageOverlay;
import io.github.moulberry.notenoughupdates.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class InventoryStorageSelector {
    private static final InventoryStorageSelector INSTANCE = new InventoryStorageSelector();
    private static final ResourceLocation ICONS = new ResourceLocation("notenoughupdates:storage_gui/hotbar_icons.png");
    private static final ResourceLocation STORAGE_PANE_CTM_TEXTURE = new ResourceLocation("notenoughupdates:storage_gui/storage_gui_pane_ctm.png");
    public boolean isOverridingSlot = false;

    public static InventoryStorageSelector getInstance() {
        return INSTANCE;
    }

    public boolean isSlotSelected() {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard() || !NotEnoughUpdates.INSTANCE.config.storageGUI.showInvBackpack) {
            this.isOverridingSlot = false;
            return false;
        }
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return false;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            this.isOverridingSlot = false;
            return false;
        }
        if (Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c != 0) {
            this.isOverridingSlot = false;
            return false;
        }
        return this.isOverridingSlot;
    }

    @SubscribeEvent
    public void onMousePress(MouseEvent event) {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard() || !NotEnoughUpdates.INSTANCE.config.storageGUI.showInvBackpack) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r == null && this.isSlotSelected()) {
            int useKeycode = Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151463_i() + 100;
            int attackKeycode = Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151463_i() + 100;
            if (Mouse.getEventButton() == useKeycode || Mouse.getEventButton() == attackKeycode) {
                if (Mouse.getEventButtonState() && Mouse.getEventButton() != NotEnoughUpdates.INSTANCE.config.storageGUI.backpackScrollKey + 100) {
                    this.sendToPage(NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex);
                }
                event.setCanceled(true);
            }
        }
    }

    private void sendToPage(int displayId) {
        if (!StorageManager.getInstance().storageConfig.displayToStorageIdMap.containsKey(displayId)) {
            return;
        }
        if (this.getPage(NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex) == null) {
            NotEnoughUpdates.INSTANCE.sendChatMessage("/storage");
        } else {
            int index = StorageManager.getInstance().storageConfig.displayToStorageIdMap.get(NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex);
            StorageManager.getInstance().sendToPage(index);
        }
    }

    @SubscribeEvent
    public void onKeyPress(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x().field_71474_y.field_151456_ac[0].func_151470_d()) {
            this.isOverridingSlot = false;
        }
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard() || !NotEnoughUpdates.INSTANCE.config.storageGUI.showInvBackpack) {
            return;
        }
        if (KeybindHelper.isKeyPressed(NotEnoughUpdates.INSTANCE.config.storageGUI.backpackHotkey)) {
            Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c = 0;
            this.isOverridingSlot = true;
        }
        if (NotEnoughUpdates.INSTANCE.config.storageGUI.arrowKeyBackpacks) {
            int max2;
            if (KeybindHelper.isKeyPressed(NotEnoughUpdates.INSTANCE.config.storageGUI.arrowLeftKey)) {
                --NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex;
                max2 = StorageManager.getInstance().storageConfig.displayToStorageIdMap.size() - 1;
                if (NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex > max2) {
                    NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex = max2;
                }
                if (NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex < 0) {
                    NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex = 0;
                }
            } else if (KeybindHelper.isKeyPressed(NotEnoughUpdates.INSTANCE.config.storageGUI.arrowRightKey)) {
                ++NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex;
                max2 = StorageManager.getInstance().storageConfig.displayToStorageIdMap.size() - 1;
                if (NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex > max2) {
                    NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex = max2;
                }
                if (NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex < 0) {
                    NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex = 0;
                }
            } else if (KeybindHelper.isKeyPressed(NotEnoughUpdates.INSTANCE.config.storageGUI.arrowDownKey)) {
                this.sendToPage(NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex);
            }
        }
        if (this.isSlotSelected()) {
            KeyBinding attack = Minecraft.func_71410_x().field_71474_y.field_74312_F;
            KeyBinding use = Minecraft.func_71410_x().field_71474_y.field_74313_G;
            if (attack.func_151468_f() || attack.func_151470_d()) {
                if (attack.func_151463_i() != NotEnoughUpdates.INSTANCE.config.storageGUI.backpackScrollKey) {
                    this.sendToPage(NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex);
                }
                KeyBinding.func_74510_a((int)attack.func_151463_i(), (boolean)false);
                while (attack.func_151468_f()) {
                }
            }
            if (use.func_151468_f() || use.func_151470_d()) {
                if (attack.func_151463_i() != NotEnoughUpdates.INSTANCE.config.storageGUI.backpackScrollKey) {
                    this.sendToPage(NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex);
                }
                KeyBinding.func_74510_a((int)use.func_151463_i(), (boolean)false);
                while (use.func_151468_f()) {
                }
            }
        }
    }

    public int onScroll(int direction, int resultantSlot) {
        boolean allowScroll;
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard() || !NotEnoughUpdates.INSTANCE.config.storageGUI.showInvBackpack) {
            return resultantSlot;
        }
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return resultantSlot;
        }
        int keyCode = NotEnoughUpdates.INSTANCE.config.storageGUI.backpackScrollKey;
        if (this.isOverridingSlot && KeybindHelper.isKeyDown(keyCode)) {
            NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex -= direction;
            int max2 = StorageManager.getInstance().storageConfig.displayToStorageIdMap.size() - 1;
            if (NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex > max2) {
                NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex = max2;
            }
            if (NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex < 0) {
                NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex = 0;
            }
            return 0;
        }
        boolean bl = NotEnoughUpdates.INSTANCE.config.storageGUI.scrollToBackpack2 == 0 ? KeybindHelper.isKeyDown(NotEnoughUpdates.INSTANCE.config.storageGUI.backpackScrollKey) : (allowScroll = NotEnoughUpdates.INSTANCE.config.storageGUI.scrollToBackpack2 == 1);
        if (allowScroll && resultantSlot == 0 && direction == -1 && !this.isOverridingSlot) {
            this.isOverridingSlot = true;
            Minecraft.func_71410_x().func_175597_ag().func_78444_b();
            return 0;
        }
        if (resultantSlot == 1 && direction == -1 && this.isOverridingSlot) {
            this.isOverridingSlot = false;
            Minecraft.func_71410_x().func_175597_ag().func_78444_b();
            return 0;
        }
        if (allowScroll && resultantSlot == 8 && direction == 1 && !this.isOverridingSlot) {
            this.isOverridingSlot = true;
            Minecraft.func_71410_x().func_175597_ag().func_78444_b();
            return 0;
        }
        return resultantSlot;
    }

    private StorageManager.StoragePage getPage(int selectedIndex) {
        if (!StorageManager.getInstance().storageConfig.displayToStorageIdMap.containsKey(selectedIndex)) {
            return null;
        }
        int index = StorageManager.getInstance().storageConfig.displayToStorageIdMap.get(selectedIndex);
        return StorageManager.getInstance().getPage(index, false);
    }

    public ItemStack getNamedHeldItemOverride() {
        StorageManager.StoragePage page = this.getPage(NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex);
        if (page != null && page.backpackDisplayStack != null) {
            return page.backpackDisplayStack;
        }
        return new ItemStack(Item.func_150898_a((Block)Blocks.field_150486_ae));
    }

    public ItemStack getHeldItemOverride() {
        return this.getHeldItemOverride(NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex);
    }

    public ItemStack getHeldItemOverride(int selectedIndex) {
        StorageManager.StoragePage page = this.getPage(selectedIndex);
        if (page != null) {
            ItemStack stack = page.backpackDisplayStack;
            if (stack == null || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co)) {
                return new ItemStack(Item.func_150898_a((Block)Blocks.field_150477_bB));
            }
            return stack;
        }
        return new ItemStack(Item.func_150898_a((Block)Blocks.field_150486_ae));
    }

    public void render(ScaledResolution scaledResolution, float partialTicks) {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard() || !NotEnoughUpdates.INSTANCE.config.storageGUI.showInvBackpack) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        int max2 = StorageManager.getInstance().storageConfig.displayToStorageIdMap.size() - 1;
        if (NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex > max2) {
            NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex = max2;
        }
        if (NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex < 0) {
            NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex = 0;
        }
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        int centerX = width / 2;
        int offset = 113;
        if (NotEnoughUpdates.INSTANCE.config.storageGUI.backpackHotbarSide == 1) {
            offset *= -1;
        }
        ItemStack held = this.getHeldItemOverride();
        int left = centerX - offset - 12;
        int top = scaledResolution.func_78328_b() - 22;
        if (NotEnoughUpdates.INSTANCE.config.storageGUI.showInvBackpackPreview && this.isSlotSelected()) {
            StorageManager.StoragePage page = this.getPage(NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex);
            if (page != null && page.rows > 0) {
                int rows = page.rows;
                ResourceLocation storagePreviewTexture = StorageOverlay.STORAGE_PREVIEW_TEXTURES[NotEnoughUpdates.INSTANCE.config.storageGUI.displayStyle];
                int startX = centerX - 86;
                int startY = height - 80 - (10 + 18 * rows);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
                GL11.glDepthMask((boolean)false);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(storagePreviewTexture);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)NotEnoughUpdates.INSTANCE.config.storageGUI.backpackOpacity / 100.0f));
                Utils.drawTexturedRect(startX, startY, 176.0f, 7.0f, 0.0f, 1.0f, 0.0f, 0.21875f, 9728);
                for (int i = 0; i < rows; ++i) {
                    Utils.drawTexturedRect(startX, startY + 7 + 18 * i, 176.0f, 18.0f, 0.0f, 1.0f, 0.21875f, 0.78125f, 9728);
                }
                Utils.drawTexturedRect(startX, startY + 7 + 18 * rows, 176.0f, 7.0f, 0.0f, 1.0f, 0.78125f, 1.0f, 9728);
                GL11.glDepthMask((boolean)true);
                int[] isPaneCache = new int[rows * 9];
                int[] ctmIndexCache = new int[rows * 9];
                for (int i = 0; i < rows * 9; ++i) {
                    ItemStack stack = page.items[i];
                    if (stack == null) continue;
                    int itemX = startX + 8 + 18 * (i % 9);
                    int itemY = startY + 8 + 18 * (i / 9);
                    int paneType = StorageOverlay.getPaneType(stack, i, isPaneCache);
                    if (paneType > 0) {
                        GlStateManager.func_179118_c();
                        Gui.func_73734_a((int)(itemX - 1), (int)(itemY - 1), (int)(itemX + 17), (int)(itemY + 17), (int)0x1000000);
                        GlStateManager.func_179141_d();
                        int ctmIndex = StorageOverlay.getCTMIndex(page, i, isPaneCache, ctmIndexCache);
                        int startCTMX = ctmIndex % 12 * 19;
                        int startCTMY = ctmIndex / 12 * 19;
                        ctmIndexCache[i] = ctmIndex;
                        if (paneType != 17) {
                            int rgb = StorageOverlay.getRGBFromPane(paneType - 1);
                            int a = rgb >> 24 & 0xFF;
                            int r = rgb >> 16 & 0xFF;
                            int g = rgb >> 8 & 0xFF;
                            int b = rgb & 0xFF;
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(STORAGE_PANE_CTM_TEXTURE);
                            GlStateManager.func_179131_c((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
                            Utils.drawTexturedRect(itemX - 1, itemY - 1, 18.0f, 18.0f, (float)startCTMX / 227.0f, (float)(startCTMX + 18) / 227.0f, (float)startCTMY / 75.0f, (float)(startCTMY + 18) / 75.0f, 9728);
                            RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
                            itemRender.func_180453_a(Minecraft.func_71410_x().field_71466_p, stack, itemX, itemY, null);
                            GlStateManager.func_179140_f();
                        }
                        page.shouldDarkenIfNotSelected[i] = false;
                        continue;
                    }
                    int upIndex = i - 9;
                    int leftIndex = i % 9 > 0 ? i - 1 : -1;
                    int rightIndex = i % 9 < 8 ? i + 1 : -1;
                    int downIndex = i + 9;
                    int[] indexArr = new int[]{rightIndex, downIndex, leftIndex, upIndex};
                    for (int j = 0; j < 4; ++j) {
                        boolean vertical;
                        int ctmIndex;
                        int type2;
                        int index = indexArr[j];
                        int n = type2 = index >= 0 && index < isPaneCache.length ? StorageOverlay.getPaneType(page.items[index], index, isPaneCache) : -1;
                        if (type2 <= 0 || (ctmIndex = StorageOverlay.getCTMIndex(page, index, isPaneCache, ctmIndexCache)) < 0) continue;
                        boolean horizontal = ctmIndex == 1 || ctmIndex == 2 || ctmIndex == 3;
                        boolean bl = vertical = ctmIndex == 12 || ctmIndex == 24 || ctmIndex == 36;
                        boolean renderConnection = i % 9 == 0 && index % 9 == 0 || i % 9 == 8 && index % 9 == 8 ? horizontal || vertical : (index == leftIndex || index == rightIndex ? horizontal : vertical);
                        if (!renderConnection) continue;
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(STORAGE_PANE_CTM_TEXTURE);
                        int rgb = StorageOverlay.getRGBFromPane(type2 - 1);
                        int a = rgb >> 24 & 0xFF;
                        int r = rgb >> 16 & 0xFF;
                        int g = rgb >> 8 & 0xFF;
                        int b = rgb & 0xFF;
                        GlStateManager.func_179131_c((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179109_b((float)(itemX - 1 + 9), (float)(itemY - 1 + 9), (float)10.0f);
                        GlStateManager.func_179114_b((float)(j * 90), (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179141_d();
                        GlStateManager.func_179140_f();
                        boolean horzFlip = false;
                        boolean vertFlip = false;
                        if (index == leftIndex) {
                            vertFlip = true;
                        } else if (index == downIndex) {
                            vertFlip = true;
                        }
                        Utils.drawTexturedRect(0.0f, -9.0f, 8.0f, 18.0f, !horzFlip ? 0.92070484f : 0.9647577f, horzFlip ? 1.0f : 0.95594716f, !vertFlip ? 0.76f : 1.0f, vertFlip ? 0.76f : 1.0f, 9728);
                        Utils.drawTexturedRect(8.0f, -9.0f, 10.0f, 18.0f, !horzFlip ? 0.95594716f : 0.92070484f, horzFlip ? 0.9647577f : 1.0f, !vertFlip ? 0.76f : 1.0f, vertFlip ? 0.76f : 1.0f, 9728);
                        GlStateManager.func_179121_F();
                    }
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)20.0f);
                    Utils.drawItemStack(stack, itemX, itemY);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-20.0f);
                }
                String pageTitle = page.customTitle != null && !page.customTitle.isEmpty() ? page.customTitle : this.getNamedHeldItemOverride().func_82833_r();
                Utils.drawItemStack(held, centerX - 8, startY - 8);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
                Utils.drawStringCentered(pageTitle, centerX, height - 76, true, -65536);
                int keyCode = NotEnoughUpdates.INSTANCE.config.storageGUI.backpackScrollKey;
                if (KeybindHelper.isKeyValid(keyCode) && !KeybindHelper.isKeyDown(keyCode)) {
                    String keyName = KeybindHelper.getKeyName(keyCode);
                    Utils.drawStringCentered("[" + keyName + "] Scroll Backpacks", centerX, startY - 10, true, -13447886);
                }
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-200.0f);
            } else if (page == null) {
                Utils.drawStringCentered("Run /storage to enable this feature!", centerX, height - 80, true, -65536);
            } else {
                Utils.drawStringCentered("Right-click to load items", centerX, height - 80, true, -65536);
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ICONS);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawTexturedRect(left + 1, top, 22.0f, 22.0f, 0.0f, 0.34375f, 0.0f, 0.34375f, 9728);
        if (this.isSlotSelected()) {
            Utils.drawTexturedRect(left, top - 1, 24.0f, 22.0f, 0.0f, 0.375f, 0.34375f, 0.6875f, 9728);
        }
        int index = 1;
        if (StorageManager.getInstance().storageConfig.displayToStorageIdMap.containsKey(NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex)) {
            int displayIndex = StorageManager.getInstance().storageConfig.displayToStorageIdMap.get(NotEnoughUpdates.INSTANCE.config.storageGUI.selectedIndex);
            index = displayIndex < 9 ? displayIndex + 1 : displayIndex - 8;
        }
        Utils.drawItemStackWithText(held, left + 4, top + 3, "" + index);
        GlStateManager.func_179147_l();
    }
}

