/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscfeatures.PetInfoOverlay;
import io.github.moulberry.notenoughupdates.mixins.AccessorGuiContainer;
import io.github.moulberry.notenoughupdates.util.PetLeveling;
import io.github.moulberry.notenoughupdates.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class KatSitterOverlay {
    public KatSitterOverlay() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onGuiDrawn(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!(event.gui instanceof GuiChest)) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.config.petOverlay.showKatSitting) {
            return;
        }
        GuiChest gui = (GuiChest)event.gui;
        ContainerChest container = (ContainerChest)gui.field_147002_h;
        if (!"Pet Sitter".equals(container.func_85151_d().func_145748_c_().func_150260_c())) {
            return;
        }
        Slot slot = container.func_75139_a(13);
        if (slot == null || !slot.func_75216_d() || slot.func_75211_c() == null) {
            return;
        }
        ItemStack item = slot.func_75211_c();
        NBTTagCompound tagCompound = item.func_77978_p();
        if (tagCompound == null || !tagCompound.func_150297_b("ExtraAttributes", 10)) {
            return;
        }
        NBTTagCompound extra = tagCompound.func_74775_l("ExtraAttributes");
        if (!(extra != null && extra.func_150297_b("id", 8) && "PET".equals(extra.func_74779_i("id")) && extra.func_150297_b("petInfo", 8))) {
            return;
        }
        JsonObject petInfo = NotEnoughUpdates.INSTANCE.manager.gson.fromJson(extra.func_74779_i("petInfo"), JsonObject.class);
        if (!(petInfo != null && petInfo.has("exp") && petInfo.has("tier") && petInfo.has("type"))) {
            return;
        }
        String petId = petInfo.get("type").getAsString();
        double xp = petInfo.get("exp").getAsDouble();
        PetInfoOverlay.Rarity rarity = PetInfoOverlay.Rarity.valueOf(petInfo.get("tier").getAsString());
        Slot katSlot = container.func_75139_a(22);
        PetInfoOverlay.Rarity upgradedRarity = rarity.nextRarity();
        boolean nextRarityPresent = katSlot.func_75211_c() != null && katSlot.func_75211_c().func_77973_b() != Item.func_150898_a((Block)Blocks.field_180401_cv) && upgradedRarity != null;
        this.renderPetInformation(PetLeveling.getPetLevelingForPet(petId, rarity).getPetLevel(xp).getCurrentLevel(), nextRarityPresent ? Integer.valueOf(PetLeveling.getPetLevelingForPet(petId, rarity).getPetLevel(xp).getCurrentLevel()) : null, gui);
    }

    public void renderPetInformation(int currentLevel, Integer upgradedLevel, GuiChest gui) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String currentText = "Current pet level: " + currentLevel;
        int currentWidth = font.func_78256_a(currentText);
        String upgradedText = "Upgraded pet level: " + upgradedLevel;
        int upgradedWidth = font.func_78256_a(upgradedText);
        int left = ((AccessorGuiContainer)gui).getGuiLeft() - 30 - (upgradedLevel == null ? Math.max(upgradedWidth, currentWidth) : currentWidth);
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Utils.drawStringScaled(currentText, left, ((AccessorGuiContainer)gui).getGuiTop() + 25, false, 16766720, 1.0f);
        if (upgradedLevel != null) {
            Utils.drawStringScaled(upgradedText, left, ((AccessorGuiContainer)gui).getGuiTop() + 45, false, 16766720, 1.0f);
        }
    }
}

