/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.events.ButtonExclusionZoneEvent;
import io.github.moulberry.notenoughupdates.events.RepositoryReloadEvent;
import io.github.moulberry.notenoughupdates.mixins.AccessorGuiContainer;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.Rectangle;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class TrophyRewardOverlay {
    private static TrophyRewardOverlay instance = null;
    private final Map<String, Integer> data = new HashMap<String, Integer>();
    private boolean reloadNeeded = true;
    public static final ResourceLocation trophyProfitImage = new ResourceLocation("notenoughupdates:trophy_profit.png");

    public static TrophyRewardOverlay getInstance() {
        if (instance == null) {
            instance = new TrophyRewardOverlay();
        }
        return instance;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRepoReload(RepositoryReloadEvent event) {
        this.reloadNeeded = true;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemTooltipLow(ItemTooltipEvent event) {
        if (!TrophyRewardOverlay.inTrophyFishingInventory()) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.config.fishing.trophyRewardTooltips) {
            return;
        }
        ItemStack itemStack = event.itemStack;
        if (itemStack == null) {
            return;
        }
        if (!"\u00a7aFillet Trophy Fish".equals(itemStack.func_82833_r())) {
            return;
        }
        if (ItemUtils.getLore(itemStack).contains("\u00a78Sacks")) {
            return;
        }
        event.toolTip.add(2, this.getToolTip());
        event.toolTip.add(2, "");
    }

    private String getToolTip() {
        List<String> line = this.createText();
        if (line.size() == 1) {
            return line.get(0);
        }
        return line.get(1);
    }

    @SubscribeEvent
    public void onButtonExclusionZones(ButtonExclusionZoneEvent event) {
        if (TrophyRewardOverlay.inTrophyFishingInventory() && NotEnoughUpdates.INSTANCE.config.fishing.trophyRewardOverlay) {
            event.blockArea(new Rectangle(event.getGuiBaseRect().getRight(), event.getGuiBaseRect().getTop(), 165, 128), ButtonExclusionZoneEvent.PushDirection.TOWARDS_RIGHT);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawBackground(GuiScreenEvent.BackgroundDrawnEvent event) {
        if (!TrophyRewardOverlay.inTrophyFishingInventory()) {
            return;
        }
        if (!NotEnoughUpdates.INSTANCE.config.fishing.trophyRewardOverlay) {
            return;
        }
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (!(screen instanceof GuiChest)) {
            return;
        }
        GuiScreen gui = event.gui;
        int xSize = ((AccessorGuiContainer)gui).getXSize();
        int guiLeft = ((AccessorGuiContainer)gui).getGuiLeft();
        int guiTop = ((AccessorGuiContainer)gui).getGuiTop();
        List<String> list = this.createText();
        int removed = 0;
        if (list.size() > 11) {
            while (list.size() > 10) {
                ++removed;
                list.remove(9);
            }
            list.add("\u00a78And " + removed + " more..");
        }
        this.renderBasicOverlay(event, guiLeft + xSize + 3, guiTop, list);
    }

    private void load() {
        this.data.clear();
        JsonObject jsonObject = Constants.TROPHYFISH;
        if (jsonObject == null) {
            return;
        }
        String[] tiers = new String[]{"_BRONZE", "_SILVER", "_GOLD", "_DIAMOND"};
        for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
            String name = entry.getKey();
            int i = 0;
            for (JsonElement element : entry.getValue().getAsJsonArray()) {
                int price = element.getAsInt();
                this.data.put(name + tiers[i], price);
                ++i;
            }
        }
    }

    private List<String> createText() {
        if (this.reloadNeeded) {
            this.load();
            this.reloadNeeded = false;
        }
        ArrayList<String> texts = new ArrayList<String>();
        if (this.data.isEmpty()) {
            texts.add("\u00a7cNo data in Repo found!");
            return texts;
        }
        HashMap<String, Integer> totalAmount = new HashMap<String, Integer>();
        HashMap<String, Integer> totalExchange = new HashMap<String, Integer>();
        this.readInventory(totalAmount, totalExchange);
        int total = totalExchange.values().stream().mapToInt(value -> value).sum();
        texts.add("Trophy Fish Exchange");
        texts.add("Magma Fish: \u00a7e" + total);
        for (Map.Entry<String, Integer> entry : TrophyRewardOverlay.sortByValueReverse(totalExchange).entrySet()) {
            String name = entry.getKey();
            int amount = (Integer)totalAmount.get(name);
            String[] split = name.split(" ");
            String rarity = split[split.length - 1];
            if ((name = name.substring(0, name.length() - rarity.length() - 1)).length() > 20) {
                name = name.substring(0, 18) + "..";
            }
            String rarityColor = rarity.replace("\u00a7l", "").substring(0, 2);
            texts.add(String.format("%s%dx \u00a7r%s\u00a7f: \u00a7e%d", rarityColor, amount, name, entry.getValue()));
        }
        return texts;
    }

    private void readInventory(Map<String, Integer> totalAmount, Map<String, Integer> totalExchange) {
        if (Minecraft.func_71410_x().field_71439_g.field_71070_bA instanceof ContainerChest) {
            for (Slot slot : Minecraft.func_71410_x().field_71439_g.field_71070_bA.field_75151_b) {
                String internalId;
                ItemStack stack;
                if (!slot.func_75216_d() || (stack = slot.func_75211_c()) == null || !this.data.containsKey(internalId = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(stack))) continue;
                String displayName = stack.func_82833_r();
                int stackSize = stack.field_77994_a;
                int amount = totalAmount.getOrDefault(displayName, 0) + stackSize;
                totalAmount.put(displayName, amount);
                int exchangeRate = this.data.get(internalId);
                int exchangeValue = totalExchange.getOrDefault(displayName, 0) + exchangeRate * stackSize;
                totalExchange.put(displayName, exchangeValue);
            }
        }
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map2) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map2.entrySet());
        list.sort(Map.Entry.comparingByValue());
        LinkedHashMap result2 = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result2.put(entry.getKey(), entry.getValue());
        }
        return result2;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValueReverse(Map<K, V> map2) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map2.entrySet());
        list.sort(Map.Entry.comparingByValue());
        Collections.reverse(list);
        LinkedHashMap result2 = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result2.put(entry.getKey(), entry.getValue());
        }
        return result2;
    }

    private void renderBasicOverlay(GuiScreenEvent.BackgroundDrawnEvent event, int x, int y, List<String> texts) {
        GuiScreen gui = event.gui;
        int xSize = ((AccessorGuiContainer)gui).getXSize();
        int guiLeft = ((AccessorGuiContainer)gui).getGuiLeft();
        int guiTop = ((AccessorGuiContainer)gui).getGuiTop();
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(trophyProfitImage);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        Utils.drawTexturedRect(guiLeft + xSize + 4, guiTop, 158.0f, 128.0f, 0.0f, 1.0f, 0.0f, 1.0f, 9728);
        int a = guiLeft + xSize + 4;
        FontRenderer fontRendererObj = minecraft.field_71466_p;
        int i = 0;
        for (String text : texts) {
            fontRendererObj.func_175065_a("\u00a78" + text, (float)(a + 10), (float)(guiTop + 6 + i), -1, false);
            if ((i += 10) != 20) continue;
            break;
        }
        i = 25;
        int index = 0;
        for (String text : texts) {
            if (index > 1) {
                fontRendererObj.func_175065_a(text, (float)(a + 10), (float)(guiTop + 6 + i), -1, false);
                i += 10;
                continue;
            }
            ++index;
        }
    }

    public static boolean inTrophyFishingInventory() {
        if (!NotEnoughUpdates.INSTANCE.isOnSkyblock()) {
            return false;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft == null || minecraft.field_71439_g == null) {
            return false;
        }
        Container inventoryContainer = minecraft.field_71439_g.field_71070_bA;
        if (!(inventoryContainer instanceof ContainerChest)) {
            return false;
        }
        ContainerChest containerChest = (ContainerChest)inventoryContainer;
        return containerChest.func_85151_d().func_145748_c_().func_150260_c().equalsIgnoreCase("Trophy Fishing");
    }
}

