/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.minionhelper.render;

import com.google.common.collect.ArrayListMultimap;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.ApiData;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.Minion;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.MinionHelperManager;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.render.MinionHelperOverlay;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.render.renderables.OverviewLine;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.render.renderables.OverviewText;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.requirements.CollectionRequirement;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.requirements.MinionRequirement;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.requirements.ReputationRequirement;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.sources.CraftingSource;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.sources.MinionSource;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.sources.NpcSource;
import io.github.moulberry.notenoughupdates.mixins.AccessorGuiContainer;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import org.lwjgl.input.Mouse;

public class MinionHelperOverlayHover {
    private final MinionHelperOverlay overlay;
    private final MinionHelperManager manager;

    public MinionHelperOverlayHover(MinionHelperOverlay overlay, MinionHelperManager manager) {
        this.overlay = overlay;
        this.manager = manager;
    }

    void renderHover(LinkedHashMap<String, OverviewLine> renderMap) {
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiChest)) {
            return;
        }
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int scaledWidth = scaledresolution.func_78326_a();
        int scaledHeight = scaledresolution.func_78328_b();
        int mouseX = Mouse.getX() * scaledWidth / Minecraft.func_71410_x().field_71443_c;
        int mouseY = scaledHeight - Mouse.getY() * scaledHeight / Minecraft.func_71410_x().field_71440_d - 1;
        OverviewLine mouseObject = this.overlay.getObjectOverMouse(renderMap);
        if (mouseObject != null) {
            Utils.drawHoveringText(this.getTooltip(mouseObject), mouseX, mouseY, scaledWidth, scaledHeight, -1);
        }
        this.renderButtons();
    }

    private void renderButtons() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (!(gui instanceof GuiChest)) {
            return;
        }
        int xSize = ((AccessorGuiContainer)gui).getXSize();
        int guiLeft = ((AccessorGuiContainer)gui).getGuiLeft();
        int guiTop = ((AccessorGuiContainer)gui).getGuiTop();
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int scaledWidth = scaledresolution.func_78326_a();
        int scaledHeight = scaledresolution.func_78328_b();
        int mouseX = Mouse.getX() * scaledWidth / Minecraft.func_71410_x().field_71443_c;
        int mouseY = scaledHeight - Mouse.getY() * scaledHeight / Minecraft.func_71410_x().field_71440_d - 1;
        int x = guiLeft + xSize + 4 + 149 - 3;
        int y = guiTop + 109 - 3;
        if (mouseX > x && mouseX < x + 16 && mouseY > y && mouseY < y + 16) {
            this.renderFilterButton(scaledWidth, scaledHeight, mouseX, mouseY);
        }
        x = guiLeft + xSize + 4 + 149 - 3 - 16 - 3;
        y = guiTop + 109 - 3;
        if (mouseX > x && mouseX < x + 16 && mouseY > y && mouseY < y + 16) {
            this.renderBuyPriceButton(scaledWidth, scaledHeight, mouseX, mouseY);
        }
    }

    private void renderFilterButton(int scaledWidth, int scaledHeight, int mouseX, int mouseY) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.overlay.isFilterEnabled()) {
            list.add("\u00a7aFilter enabled");
            list.add("\u00a77Only show minions that can be");
            list.add("\u00a77crafted and meet requirements.");
        } else {
            list.add("\u00a7cFilter disabled");
            list.add("\u00a77Show all minions. \u00a7cRed ones \u00a77have");
            list.add("\u00a77missing requirements.");
        }
        list.add("");
        list.add("\u00a7eClick to toggle!");
        Utils.drawHoveringText(list, mouseX, mouseY, scaledWidth, scaledHeight, -1);
    }

    private void renderBuyPriceButton(int scaledWidth, int scaledHeight, int mouseX, int mouseY) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.overlay.isUseInstantBuyPrice()) {
            list.add("\u00a7bUse Instant Buy price");
            list.add("\u00a77Use the price to pay when");
            list.add("\u00a77buying the item right now.");
            list.add("\u00a77This will be more expensive!");
        } else {
            list.add("\u00a76Use Buy Offer price");
            list.add("\u00a77Use the price for creating an");
            list.add("\u00a77offer to buy the item cheaper.");
            list.add("\u00a77This can take longer!");
        }
        list.add("");
        list.add("\u00a7eClick to toggle!");
        Utils.drawHoveringText(list, mouseX, mouseY, scaledWidth, scaledHeight, -1);
    }

    private List<String> getTooltip(OverviewLine overviewLine) {
        ArrayList<String> lines = new ArrayList<String>();
        if (overviewLine instanceof OverviewText) {
            OverviewText overviewText = (OverviewText)overviewLine;
            lines.addAll(overviewText.getLines());
        } else if (overviewLine instanceof Minion) {
            Minion minion = (Minion)overviewLine;
            MinionSource minionSource = minion.getMinionSource();
            if (minion.getCustomSource() != null) {
                minionSource = minion.getCustomSource();
            }
            String displayName = minion.getDisplayName();
            lines.add("\u00a79" + displayName + " " + minion.getTier());
            List<MinionRequirement> requirements = this.manager.getRequirementsManager().getRequirements(minion);
            if (!requirements.isEmpty()) {
                for (MinionRequirement requirement : requirements) {
                    String result2 = this.getRequirementDescription(minion, requirement);
                    if (result2 == null) continue;
                    lines.add(result2);
                }
            } else {
                lines.add("\u00a7cNo requirements loaded!");
            }
            if (minionSource instanceof CraftingSource) {
                CraftingSource craftingSource = (CraftingSource)minionSource;
                lines.add("");
                String format2 = this.manager.getPriceCalculation().calculateUpgradeCostsFormat(minion, true);
                if (minion.getTier() == 1) {
                    lines.add("\u00a77Full crafting cost: " + format2);
                } else {
                    lines.add("\u00a77Upgrade cost: " + format2);
                }
                this.formatItems(lines, this.grabAllItems(craftingSource.getItems()));
            } else if (minionSource instanceof NpcSource) {
                NpcSource npcSource = (NpcSource)minionSource;
                String npcName = npcSource.getNpcName();
                lines.add("");
                lines.add("\u00a77Buy from: \u00a79" + npcName + " (NPC)");
                lines.add("");
                lines.add("\u00a77Cost: " + this.manager.getPriceCalculation().calculateUpgradeCostsFormat(minion, true));
                int coins = npcSource.getCoins();
                if (coins != 0) {
                    lines.add(" \u00a78- " + this.manager.getPriceCalculation().formatCoins(coins));
                }
                this.formatItems(lines, this.grabAllItems(npcSource.getItems()));
            }
            lines.add("");
            lines.add("\u00a7eClick to view recipe!");
            lines.add("\u00a7eCtrl-Click to open bazaar!");
        }
        return lines;
    }

    private String getRequirementDescription(Minion minion, MinionRequirement requirement) {
        boolean meetRequirement = this.manager.getRequirementsManager().meetRequirement(minion, requirement);
        String color = meetRequirement ? "\u00a7a" : "\u00a7c";
        String description = requirement.printDescription(color);
        if (requirement instanceof CollectionRequirement && this.manager.getApi().isCollectionApiDisabled()) {
            description = description + " \u00a7cAPI DISABLED! \u00a77";
        }
        if (!meetRequirement && requirement instanceof ReputationRequirement) {
            int having;
            ReputationRequirement reputationRequirement = (ReputationRequirement)requirement;
            String reputationType = reputationRequirement.getReputationType();
            ApiData apiData = this.manager.getApi().getApiData();
            if (reputationType.equals("BARBARIAN")) {
                having = apiData.getBarbariansReputation();
            } else if (reputationType.equals("MAGE")) {
                having = apiData.getMagesReputation();
            } else {
                Utils.addChatMessage("\u00a7c[NEU] Minion Helper: Unknown reputation type: '" + reputationType + "'");
                return null;
            }
            int need = reputationRequirement.getReputation();
            if (having < 0) {
                having = 0;
            }
            String reputationName = StringUtils.firstUpperLetter(reputationType.toLowerCase(Locale.ROOT));
            String havingFormat = Utils.formatNumberWithDots(having);
            String needFormat = Utils.formatNumberWithDots(need);
            description = "Reputation: \u00a7c" + havingFormat + "\u00a78/\u00a7c" + needFormat + " \u00a77" + reputationName + " Reputation";
        }
        return " \u00a78- \u00a77" + description;
    }

    private void formatItems(List<String> lines, Map<String, Integer> allItems) {
        for (Map.Entry<String, Integer> entry : allItems.entrySet()) {
            String internalName = entry.getKey();
            int amount = entry.getValue();
            if (internalName.equals("SKYBLOCK_PELT")) {
                int peltCount = this.manager.getApi().getApiData().getPeltCount();
                lines.add(" \u00a78- \u00a75" + peltCount + "\u00a78/\u00a75" + amount + " Pelts");
                continue;
            }
            if (internalName.equals("SKYBLOCK_NORTH_STAR")) {
                lines.add(" \u00a78- \u00a7a" + amount + "\u00a77x \u00a7dNorth Star");
                continue;
            }
            if (internalName.equals("AIR")) continue;
            String name = NotEnoughUpdates.INSTANCE.manager.getDisplayName(internalName);
            double price = this.manager.getPriceCalculation().getPrice(internalName);
            String priceFormat = this.manager.getPriceCalculation().formatCoins(price * (double)amount);
            lines.add(" \u00a78- \u00a7a" + amount + "\u00a77x \u00a7f" + name + " " + priceFormat);
        }
    }

    private Map<String, Integer> grabAllItems(ArrayListMultimap<String, Integer> multimap) {
        HashMap<String, Integer> allItems = new HashMap<String, Integer>();
        for (Map.Entry entry : multimap.entries()) {
            String name = (String)entry.getKey();
            int amount = (Integer)entry.getValue();
            amount = allItems.getOrDefault(name, 0) + amount;
            allItems.put(name, amount);
        }
        return allItems;
    }
}

