/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.minionhelper.requirements;

import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.requirements.MinionRequirement;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.Locale;

public class ReputationRequirement
extends MinionRequirement {
    private final String reputationType;
    private final int reputation;
    private final String description;

    public ReputationRequirement(String reputationType, int reputation) {
        this.reputationType = reputationType;
        this.reputation = reputation;
        String reputationName = StringUtils.firstUpperLetter(reputationType.toLowerCase(Locale.ROOT));
        this.description = Utils.formatNumberWithDots(reputation) + " \u00a77" + reputationName + " Reputation";
    }

    public int getReputation() {
        return this.reputation;
    }

    public String getReputationType() {
        return this.reputationType;
    }

    @Override
    public String printDescription(String color) {
        return "Reputation: " + color + this.description;
    }
}

