/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.pricegraph;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscgui.pricegraph.BzData;
import io.github.moulberry.notenoughupdates.miscgui.pricegraph.GraphDataProvider;
import io.github.moulberry.notenoughupdates.miscgui.pricegraph.ItemData;
import io.github.moulberry.notenoughupdates.miscgui.pricegraph.PriceObject;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010&\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\rH\u0002J$\u0010\u001d\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!\u0018\u00010\u001f0\u001e2\u0006\u0010\"\u001a\u00020\u0012H\u0016J\u0016\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u001aR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/github/moulberry/notenoughupdates/miscgui/pricegraph/LocalGraphDataProvider;", "Lio/github/moulberry/notenoughupdates/miscgui/pricegraph/GraphDataProvider;", "()V", "GSON", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "config", "Lio/github/moulberry/notenoughupdates/options/NEUConfig;", "fileLocked", "Ljava/util/concurrent/atomic/AtomicBoolean;", "format", "Ljava/text/SimpleDateFormat;", "priceDir", "Ljava/io/File;", "addOrUpdateItemPriceInfo", "", "item", "", "", "Lcom/google/gson/JsonElement;", "prices", "", "Lio/github/moulberry/notenoughupdates/miscgui/pricegraph/ItemData;", "timestamp", "", "bazaar", "", "load", "file", "loadData", "Ljava/util/concurrent/CompletableFuture;", "", "Ljava/time/Instant;", "Lio/github/moulberry/notenoughupdates/miscgui/pricegraph/PriceObject;", "itemId", "savePrices", "items", "Lcom/google/gson/JsonObject;", "NotEnoughUpdates"})
@SourceDebugExtension(value={"SMAP\nLocalGraphDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalGraphDataProvider.kt\nio/github/moulberry/notenoughupdates/miscgui/pricegraph/LocalGraphDataProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,193:1\n3792#2:194\n4307#2,2:195\n1855#3,2:197\n1#4:199\n125#5:200\n152#5,3:201\n125#5:204\n152#5,3:205\n*S KotlinDebug\n*F\n+ 1 LocalGraphDataProvider.kt\nio/github/moulberry/notenoughupdates/miscgui/pricegraph/LocalGraphDataProvider\n*L\n101#1:194\n101#1:195,2\n101#1:197,2\n55#1:200\n55#1:201,3\n57#1:204\n57#1:205,3\n*E\n"})
public final class LocalGraphDataProvider
implements GraphDataProvider {
    @NotNull
    public static final LocalGraphDataProvider INSTANCE = new LocalGraphDataProvider();
    @NotNull
    private static final File priceDir = new File("config/notenoughupdates/prices");
    private static final Gson GSON = new GsonBuilder().create();
    @NotNull
    private static final SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy");
    private static final NEUConfig config = NotEnoughUpdates.INSTANCE.config;
    @NotNull
    private static final AtomicBoolean fileLocked = new AtomicBoolean(false);

    private LocalGraphDataProvider() {
    }

    @Override
    @NotNull
    public CompletableFuture<Map<Instant, PriceObject>> loadData(@NotNull String itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        CompletableFuture<Map<Instant, PriceObject>> completableFuture = CompletableFuture.supplyAsync(() -> LocalGraphDataProvider.loadData$lambda$4(itemId));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync {\n          \u2026yAsync response\n        }");
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, ItemData> load(File file) {
        Type type2 = new TypeToken<Map<String, ItemData>>(){}.getType();
        if (file.exists()) {
            try {
                Closeable closeable = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(file)), StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    BufferedReader reader = (BufferedReader)closeable;
                    boolean bl = false;
                    Map map2 = (Map)GSON.fromJson((Reader)reader, type2);
                    return map2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e2) {
                System.out.println((Object)("Deleting " + file.getName() + " because it is probably corrupted."));
                file.delete();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void savePrices(@NotNull JsonObject items2, boolean bazaar) {
        Intrinsics.checkNotNullParameter((Object)items2, (String)"items");
        try {
            Map<String, ItemData> tempPrices;
            if (!priceDir.exists() && !priceDir.mkdir()) {
                return;
            }
            File[] files = priceDir.listFiles();
            long dataRetentionTime = System.currentTimeMillis() - (long)LocalGraphDataProvider.config.ahGraph.dataRetention * 86400000L;
            if (files != null) {
                Iterator $this$filterTo$iv$iv;
                File[] $this$filter$iv = files;
                boolean $i$f$filter = false;
                File[] fileArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!(Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"gz") && it.lastModified() < dataRetentionTime)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    it.delete();
                }
            }
            if (!LocalGraphDataProvider.config.ahGraph.graphEnabled || LocalGraphDataProvider.config.ahGraph.dataSource != 1) {
                return;
            }
            if (fileLocked.get()) {
                while (fileLocked.get()) {
                    Thread.sleep(100L);
                }
            }
            fileLocked.set(true);
            Date date = new Date();
            long epochSecond = date.toInstant().getEpochSecond();
            File file = new File(priceDir, "prices_" + format.format(date) + ".gz");
            Map<String, ItemData> prices = null;
            Map<String, ItemData> map2 = this.load(file);
            if (map2 == null) {
                map2 = prices = (Map<String, ItemData>)new LinkedHashMap();
            }
            if (file.exists() && (tempPrices = this.load(file)) != null) {
                prices = tempPrices;
            }
            for (Map.Entry<String, JsonElement> item : items2.entrySet()) {
                Intrinsics.checkNotNullExpressionValue(item, (String)"item");
                this.addOrUpdateItemPriceInfo(item, prices, epochSecond, bazaar);
            }
            file.createNewFile();
            Closeable closeable = new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(file)), StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                BufferedWriter writer = (BufferedWriter)closeable;
                boolean bl = false;
                writer.write(GSON.toJson(prices));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            fileLocked.set(false);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            fileLocked.set(false);
        }
    }

    private final void addOrUpdateItemPriceInfo(Map.Entry<String, ? extends JsonElement> item, Map<String, ItemData> prices, long timestamp, boolean bazaar) {
        String itemName = item.getKey();
        ItemData existingItemData = null;
        if (prices.containsKey(itemName)) {
            existingItemData = prices.get(itemName);
        }
        if (existingItemData != null) {
            if (existingItemData.isBz() && !bazaar) {
                return;
            }
            if (!existingItemData.isBz() && bazaar) {
                prices.remove(itemName);
                existingItemData = null;
            }
        }
        if (bazaar) {
            if (!item.getValue().getAsJsonObject().has("curr_buy") || !item.getValue().getAsJsonObject().has("curr_sell")) {
                return;
            }
            BzData bzData = new BzData(item.getValue().getAsJsonObject().get("curr_buy").getAsDouble(), item.getValue().getAsJsonObject().get("curr_sell").getAsDouble());
            if (existingItemData != null) {
                Map<Long, BzData> map2 = existingItemData.getBz();
                if (map2 != null) {
                    map2.put(timestamp, bzData);
                }
            } else {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)timestamp, (Object)bzData)};
                Map mapData = MapsKt.mutableMapOf((Pair[])pairArray);
                prices.put(item.getKey(), new ItemData(null, mapData, 1, null));
            }
        } else if (existingItemData != null) {
            ItemData itemData = prices.get(item.getKey());
            Intrinsics.checkNotNull((Object)itemData);
            Map<Long, Long> bzData = itemData.getAh();
            if (bzData != null) {
                bzData.put(timestamp, item.getValue().getAsBigDecimal().longValue());
            }
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)timestamp, (Object)item.getValue().getAsLong())};
            Map mapData = MapsKt.mutableMapOf((Pair[])pairArray);
            prices.put(item.getKey(), new ItemData(mapData, null, 2, null));
        }
    }

    private static final boolean loadData$lambda$4$lambda$0(File file) {
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"gz");
    }

    private static final Map loadData$lambda$4$lambda$3(File $file, String $itemId) {
        List list;
        Map.Entry<Long, Object> it;
        Collection collection;
        Map.Entry<Long, Object> item$iv$iv;
        Iterator<Map.Entry<Long, Object>> iterator;
        Map<Long, Object> $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Map<Long, Object> $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$itemId, (String)"$itemId");
        Intrinsics.checkNotNullExpressionValue((Object)$file, (String)"file");
        Map<String, ItemData> map2 = INSTANCE.load($file);
        if (map2 == null || (map2 = map2.get($itemId)) == null) {
            return null;
        }
        Map<String, ItemData> data = map2;
        if (((ItemData)((Object)data)).isBz()) {
            Map<Long, BzData> map3 = ((ItemData)((Object)data)).getBz();
            if (map3 != null) {
                $this$map$iv = map3;
                $i$f$map = false;
                Map<Long, Object> map4 = $this$map$iv;
                destination$iv$iv = new ArrayList($this$map$iv.size());
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Long, Object> entry = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(TuplesKt.to((Object)Instant.ofEpochSecond(((Number)it.getKey()).longValue()), (Object)new PriceObject(((BzData)it.getValue()).getB(), ((BzData)it.getValue()).getS())));
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
        } else {
            Map<Long, Long> map5 = ((ItemData)((Object)data)).getAh();
            if (map5 != null) {
                $this$map$iv = map5;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList($this$map$iv.size());
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    it = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(TuplesKt.to((Object)Instant.ofEpochSecond(((Number)it.getKey()).longValue()), (Object)new PriceObject(((Number)it.getValue()).longValue(), null)));
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
        }
        List list2 = list;
        return list2 != null ? MapsKt.toMap((Iterable)list2) : null;
    }

    private static final Map loadData$lambda$4(String $itemId) {
        Intrinsics.checkNotNullParameter((Object)$itemId, (String)"$itemId");
        if (!priceDir.exists() || !priceDir.isDirectory()) {
            return null;
        }
        if (fileLocked.get()) {
            while (fileLocked.get()) {
                Thread.sleep(100L);
            }
        }
        Map response = new LinkedHashMap();
        List futures = new ArrayList();
        File[] fileArray = priceDir.listFiles(LocalGraphDataProvider::loadData$lambda$4$lambda$0);
        Intrinsics.checkNotNull((Object)fileArray);
        for (File file : fileArray) {
            CompletableFuture<Map> completableFuture = CompletableFuture.supplyAsync(() -> LocalGraphDataProvider.loadData$lambda$4$lambda$3(file, $itemId));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync {\n          \u2026toMap()\n                }");
            futures.add(completableFuture);
        }
        for (CompletableFuture future : futures) {
            Map result2 = (Map)future.get();
            if (result2 == null) continue;
            response.putAll(result2);
        }
        return response;
    }
}

